/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.payments;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.whispersystems.signalservice.api.payments.Currency;
import org.whispersystems.signalservice.api.payments.Formatter;
import org.whispersystems.signalservice.api.payments.FormatterOptions;
import org.whispersystems.signalservice.api.util.Uint64RangeException;
import org.whispersystems.signalservice.api.util.Uint64Util;

public abstract class Money {
    public static MobileCoin mobileCoin(BigDecimal amount) {
        return Money.picoMobileCoin(amount.movePointRight(12).toBigIntegerExact());
    }

    public static MobileCoin picoMobileCoin(BigInteger picoMobileCoin) {
        return picoMobileCoin.signum() == 0 ? MobileCoin.ZERO : new MobileCoin(picoMobileCoin);
    }

    public static MobileCoin picoMobileCoin(long picoMobileCoinUint64) {
        return Money.picoMobileCoin(Uint64Util.uint64ToBigInteger(picoMobileCoinUint64));
    }

    public static Money parse(String serialized) throws ParseException {
        if (serialized == null) {
            throw new ParseException();
        }
        String[] split = serialized.split(":");
        if (split.length != 2) {
            throw new ParseException();
        }
        if (MobileCoin.CURRENCY.getCurrencyCode().equals(split[0])) {
            return Money.picoMobileCoin(new BigInteger(split[1]));
        }
        throw new ParseException();
    }

    public static Money parseOrThrow(String serialized) {
        try {
            return Money.parse(serialized);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public abstract boolean isPositive();

    public abstract boolean isNegative();

    public abstract boolean isEqualOrLessThanZero();

    public abstract Money negate();

    public abstract Money abs();

    public abstract Money add(Money var1);

    public abstract Money subtract(Money var1);

    public abstract Currency getCurrency();

    public abstract String serializeAmountString();

    public MobileCoin requireMobileCoin() {
        throw new AssertionError();
    }

    public final String serialize() {
        return this.getCurrency().getCurrencyCode() + ":" + this.serializeAmountString();
    }

    public abstract Money toZero();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.serialize();
    }

    public abstract String toString(Formatter var1);

    public final String toString(FormatterOptions formatterOptions) {
        Formatter formatter = this.getCurrency().getFormatter(formatterOptions);
        return this.toString(formatter);
    }

    public static final class MobileCoin
    extends Money {
        public static final Comparator<MobileCoin> ASCENDING = (x, y) -> x.amount.compareTo(y.amount);
        public static final Comparator<MobileCoin> DESCENDING = (x, y) -> y.amount.compareTo(x.amount);
        public static final MobileCoin ZERO = new MobileCoin(BigInteger.ZERO);
        public static final MobileCoin MAX_VALUE;
        private static final int PRECISION = 12;
        public static final Currency CURRENCY;
        private final BigInteger amount;
        private final BigDecimal amountDecimal;

        private MobileCoin(BigInteger amount) {
            this.amount = amount;
            this.amountDecimal = new BigDecimal(amount).movePointLeft(12).stripTrailingZeros();
        }

        public static MobileCoin sum(Collection<MobileCoin> values) {
            switch (values.size()) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return values.iterator().next();
                }
            }
            BigInteger result2 = MobileCoin.ZERO.amount;
            for (MobileCoin value : values) {
                result2 = result2.add(value.amount);
            }
            return Money.picoMobileCoin(result2);
        }

        @Override
        public boolean isPositive() {
            return this.amount.signum() == 1;
        }

        @Override
        public boolean isNegative() {
            return this.amount.signum() == -1;
        }

        @Override
        public boolean isEqualOrLessThanZero() {
            return this.amount != null && this.amount.compareTo(BigInteger.ZERO) <= 0;
        }

        @Override
        public MobileCoin negate() {
            return new MobileCoin(this.amount.negate());
        }

        @Override
        public MobileCoin abs() {
            if (this.amount.signum() == -1) {
                return this.negate();
            }
            return this;
        }

        @Override
        public Money add(Money other) {
            return new MobileCoin(this.amount.add(other.requireMobileCoin().amount));
        }

        @Override
        public Money subtract(Money other) {
            return new MobileCoin(this.amount.subtract(other.requireMobileCoin().amount));
        }

        @Override
        public Currency getCurrency() {
            return CURRENCY;
        }

        @Override
        public MobileCoin requireMobileCoin() {
            return this;
        }

        @Override
        public Money toZero() {
            return ZERO;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof MobileCoin && this.amount.equals(((MobileCoin)o).amount);
        }

        @Override
        public int hashCode() {
            return this.amount.hashCode();
        }

        @Override
        public String serializeAmountString() {
            return this.toPicoMobBigInteger().toString();
        }

        public String getAmountDecimalString() {
            return this.amountDecimal.toString();
        }

        public boolean greaterThan(MobileCoin other) {
            return this.amount.compareTo(other.amount) > 0;
        }

        public boolean lessThan(MobileCoin other) {
            return this.amount.compareTo(other.amount) < 0;
        }

        @Deprecated
        public double toDouble() {
            return this.amountDecimal.doubleValue();
        }

        public BigDecimal toBigDecimal() {
            return this.amountDecimal;
        }

        public BigInteger toPicoMobBigInteger() {
            return this.amount;
        }

        public long toPicoMobUint64() throws Uint64RangeException {
            return Uint64Util.bigIntegerToUInt64(this.amount);
        }

        @Override
        public String toString(Formatter formatter) {
            return formatter.format(this.amountDecimal);
        }

        static {
            byte[] bytes = new byte[8];
            Arrays.fill(bytes, (byte)-1);
            BigInteger max64Bit = new BigInteger(1, bytes);
            MAX_VALUE = Money.picoMobileCoin(max64Bit);
            CURRENCY = Currency.fromCodeAndPrecision("MOB", 12);
        }
    }

    public static final class ParseException
    extends Exception {
        private ParseException() {
        }
    }
}

