/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.signal.libsignal.net.ChatServiceException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.internal.ServiceResponse;

public abstract class ServiceResponseProcessor<T> {
    protected final ServiceResponse<T> response;

    public ServiceResponseProcessor(ServiceResponse<T> response) {
        this.response = response;
    }

    public ServiceResponse<T> getResponse() {
        return this.response;
    }

    public T getResult() {
        Preconditions.checkArgument(this.response.getResult().isPresent());
        return this.response.getResult().get();
    }

    public T getResultOrThrow() throws IOException {
        if (this.hasResult()) {
            return this.getResult();
        }
        Throwable error = this.getError();
        if (error instanceof IOException) {
            throw (IOException)error;
        }
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        if (error instanceof InterruptedException || error instanceof TimeoutException || error instanceof ChatServiceException) {
            throw new IOException(error);
        }
        throw new IllegalStateException("Unexpected error type for response processor", error);
    }

    public boolean hasResult() {
        return this.response.getResult().isPresent();
    }

    protected Throwable getError() {
        return OptionalUtil.or(this.response.getApplicationError(), this.response.getExecutionError()).orElse(null);
    }

    protected boolean authorizationFailed() {
        return this.response.getStatus() == 401 || this.response.getStatus() == 403;
    }

    protected boolean notFound() {
        return this.response.getStatus() == 404;
    }

    protected boolean mismatchedDevices() {
        return this.response.getStatus() == 409;
    }

    protected boolean staleDevices() {
        return this.response.getStatus() == 410;
    }

    protected boolean deviceLimitedExceeded() {
        return this.response.getStatus() == 411;
    }

    protected boolean rateLimit() {
        return this.response.getStatus() == 413 || this.response.getStatus() == 429;
    }

    protected boolean expectationFailed() {
        return this.response.getStatus() == 417;
    }

    protected boolean registrationLock() {
        return this.response.getStatus() == 423;
    }

    protected boolean proofRequired() {
        return this.response.getStatus() == 428;
    }

    protected boolean deprecatedVersion() {
        return this.response.getStatus() == 499;
    }

    protected boolean serverRejected() {
        return this.response.getStatus() == 508;
    }

    protected boolean notSuccessful() {
        return this.response.getStatus() != 200 && this.response.getStatus() != 202 && this.response.getStatus() != 204;
    }

    protected boolean genericIoError() {
        Throwable error = this.getError();
        if (error instanceof NonSuccessfulResponseCodeException) {
            return false;
        }
        return error instanceof IOException || error instanceof TimeoutException || error instanceof InterruptedException;
    }

    public static final class DefaultProcessor<T>
    extends ServiceResponseProcessor<T> {
        public DefaultProcessor(ServiceResponse<T> response) {
            super(response);
        }
    }
}

