/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.internal;

import org.signal.libsignal.protocol.logging.Log;

public class FilterExceptions {
    private static AssertionError reportUnexpectedException(Exception e) {
        String message = "Unexpected checked exception " + e.getClass();
        Log.e("libsignal", message, e);
        return new AssertionError(message, e);
    }

    public static <R> R filterExceptions(ThrowingNativeOperation<R> f) {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static int filterExceptions(ThrowingNativeIntOperation f) {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static long filterExceptions(ThrowingNativeLongOperation f) {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static void filterExceptions(ThrowingNativeVoidOperation f) {
        try {
            f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <R, E extends Exception> R filterExceptions(Class<E> e1, ThrowingNativeOperation<R> f) throws E {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <E extends Exception> long filterExceptions(Class<E> e1, ThrowingNativeLongOperation f) throws E {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <E extends Exception> void filterExceptions(Class<E> e1, ThrowingNativeVoidOperation f) throws E {
        try {
            f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <R, E1 extends Exception, E2 extends Exception> R filterExceptions(Class<E1> e1, Class<E2> e2, ThrowingNativeOperation<R> f) throws E1, E2 {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <E1 extends Exception, E2 extends Exception> void filterExceptions(Class<E1> e1, Class<E2> e2, ThrowingNativeVoidOperation f) throws E1, E2 {
        try {
            f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <E1 extends Exception, E2 extends Exception, E3 extends Exception> long filterExceptions(Class<E1> e1, Class<E2> e2, Class<E3> e3, ThrowingNativeLongOperation f) throws E1, E2, E3 {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            if (e3.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <R, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception> R filterExceptions(Class<E1> e1, Class<E2> e2, Class<E3> e3, Class<E4> e4, ThrowingNativeOperation<R> f) throws E1, E2, E3, E4 {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            if (e3.isInstance(e)) {
                throw e;
            }
            if (e4.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception> long filterExceptions(Class<E1> e1, Class<E2> e2, Class<E3> e3, Class<E4> e4, ThrowingNativeLongOperation f) throws E1, E2, E3, E4 {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            if (e3.isInstance(e)) {
                throw e;
            }
            if (e4.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    public static <R, E1 extends Exception, E2 extends Exception, E3 extends Exception, E4 extends Exception, E5 extends Exception> R filterExceptions(Class<E1> e1, Class<E2> e2, Class<E3> e3, Class<E4> e4, Class<E5> e5, ThrowingNativeOperation<R> f) throws E1, E2, E3, E4, E5 {
        try {
            return f.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e1.isInstance(e)) {
                throw e;
            }
            if (e2.isInstance(e)) {
                throw e;
            }
            if (e3.isInstance(e)) {
                throw e;
            }
            if (e4.isInstance(e)) {
                throw e;
            }
            if (e5.isInstance(e)) {
                throw e;
            }
            throw FilterExceptions.reportUnexpectedException(e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingNativeOperation<R> {
        public R run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingNativeIntOperation {
        public int run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingNativeLongOperation {
        public long run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingNativeVoidOperation {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingLongConsumer {
        public void accept(long var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingLongFunction<R> {
        public R apply(long var1) throws Exception;
    }
}

