/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.kem.KEMKeyPair;

public class KyberPreKeyRecord
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.KyberPreKeyRecord_Destroy(nativeHandle);
    }

    public KyberPreKeyRecord(int id, long timestamp, KEMKeyPair keyPair, byte[] signature) {
        super(keyPair.guardedMap(keyPairHandle -> Native.KyberPreKeyRecord_New(id, timestamp, keyPairHandle, signature)));
    }

    public KyberPreKeyRecord(byte[] serialized) throws InvalidMessageException {
        super(FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.KyberPreKeyRecord_Deserialize(serialized)));
    }

    public int getId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberPreKeyRecord_GetId));
    }

    public long getTimestamp() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberPreKeyRecord_GetTimestamp));
    }

    public KEMKeyPair getKeyPair() throws InvalidKeyException {
        return new KEMKeyPair(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> this.guardedMapChecked(Native::KyberPreKeyRecord_GetKeyPair)));
    }

    public byte[] getSignature() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberPreKeyRecord_GetSignature));
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberPreKeyRecord_GetSerialized));
    }
}

