/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.svr2;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class PinHash
extends NativeHandleGuard.SimpleOwner {
    private PinHash(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.PinHash_Destroy(nativeHandle);
    }

    public static PinHash svr1(byte[] normalizedPin, byte[] salt) {
        return new PinHash(FilterExceptions.filterExceptions(() -> Native.PinHash_FromSalt(normalizedPin, salt)));
    }

    public static PinHash svr2(byte[] normalizedPin, String username, byte[] mrenclave) {
        return new PinHash(FilterExceptions.filterExceptions(() -> Native.PinHash_FromUsernameMrenclave(normalizedPin, username, mrenclave)));
    }

    public byte[] encryptionKey() {
        return this.guardedMap(Native::PinHash_EncryptionKey);
    }

    public byte[] accessKey() {
        return this.guardedMap(Native::PinHash_AccessKey);
    }
}

