/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.SequenceExtent;

public class Closure
implements Sequence {
    protected Expression expression;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected SequenceIterator inputIterator;

    public static Sequence make(Expression expression, XPathContext context, int ref) throws XPathException {
        Sequence v = context.getConfiguration().makeClosure(expression, ref, context);
        if (v instanceof Closure) {
            Closure c = (Closure)v;
            c.expression = expression;
            c.savedXPathContext = context.newContext();
            c.savedXPathContext.setOriginatingConstructType(2063);
            c.saveContext(expression, context);
            return c;
        }
        return v;
    }

    public void saveContext(Expression expression, XPathContext context) throws XPathException {
        FocusIterator currentIterator;
        if ((expression.getDependencies() & 0x80) != 0) {
            StackFrame localStackFrame = context.getStackFrame();
            Sequence[] local = localStackFrame.getStackFrameValues();
            int[] slotsUsed = expression.getSlotsUsed();
            if (local != null) {
                SlotManager stackFrameMap = localStackFrame.getStackFrameMap();
                Sequence[] savedStackFrame = new Sequence[stackFrameMap.getNumberOfVariables()];
                for (int i : slotsUsed) {
                    if (local[i] instanceof Closure) {
                        int cdepth = ((Closure)local[i]).depth;
                        if (cdepth >= 10) {
                            local[i] = SequenceExtent.makeSequenceExtent(((Closure)local[i]).iterate());
                        } else if (cdepth + 1 > this.depth) {
                            this.depth = cdepth + 1;
                        }
                    }
                    savedStackFrame[i] = local[i];
                }
                this.savedXPathContext.setStackFrame(stackFrameMap, savedStackFrame);
            }
        }
        if ((currentIterator = context.getCurrentIterator()) != null) {
            Item contextItem = currentIterator.current();
            ManualIterator single = new ManualIterator(contextItem);
            this.savedXPathContext.setCurrentIterator(single);
        }
        this.savedXPathContext.setReceiver(null);
    }

    public Item head() throws XPathException {
        return this.iterate().next();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public XPathContextMajor getSavedXPathContext() {
        return this.savedXPathContext;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setSavedXPathContext(XPathContextMajor savedXPathContext) {
        this.savedXPathContext = savedXPathContext;
    }

    public SequenceIterator iterate() throws XPathException {
        if (this.inputIterator == null) {
            SequenceIterator in;
            this.inputIterator = in = this.expression.iterate(this.savedXPathContext);
            return this.inputIterator;
        }
        return this.inputIterator.getAnother();
    }

    public void process(XPathContext context) throws XPathException {
        if (this.expression == null) {
            Item item;
            SequenceReceiver out = context.getReceiver();
            while ((item = this.inputIterator.next()) != null) {
                out.append(item, 0, 2);
            }
            this.inputIterator = this.inputIterator.getAnother();
        } else {
            XPathContextMajor c2 = this.savedXPathContext.newContext();
            SequenceReceiver out = context.getReceiver();
            c2.setReceiver(out);
            c2.setTemporaryOutputState(206);
            this.expression.process(c2);
        }
    }

    public GroundedValue reduce() throws XPathException {
        return SequenceExtent.makeSequenceExtent(this.iterate());
    }
}

