/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtForExpression;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"isChildOfForLoop", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "getOperationToken", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lcom/intellij/psi/tree/IElementType;", "fir2ir"})
public final class Fir2IrVisitorKt {
    public static final boolean isChildOfForLoop(@NotNull KtSourceElement $this$isChildOfForLoop) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isChildOfForLoop, "<this>");
        if ($this$isChildOfForLoop instanceof KtPsiSourceElement) {
            bl = ((KtPsiSourceElement)$this$isChildOfForLoop).getPsi().getParent() instanceof KtForExpression;
        } else {
            LighterASTNode lighterASTNode = $this$isChildOfForLoop.getTreeStructure().getParent($this$isChildOfForLoop.getLighterASTNode());
            bl = Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtNodeTypes.FOR);
        }
        return bl;
    }

    @Nullable
    public static final IElementType getOperationToken(@NotNull KtSourceElement $this$operationToken) {
        Object object;
        Intrinsics.checkNotNullParameter($this$operationToken, "<this>");
        boolean bl = Intrinsics.areEqual($this$operationToken.getElementType(), KtNodeTypes.BINARY_EXPRESSION);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if ($this$operationToken instanceof KtPsiSourceElement) {
            PsiElement psiElement = ((KtPsiSourceElement)$this$operationToken).getPsi();
            KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
            object = ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null;
        } else {
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$operationToken.getTreeStructure();
            LighterASTNode lighterASTNode = $this$operationToken.getLighterASTNode();
            IElementType iElementType = KtNodeTypes.OPERATION_REFERENCE;
            Intrinsics.checkNotNullExpressionValue(iElementType, "OPERATION_REFERENCE");
            object = LightTreePositioningStrategiesKt.findChildByType(flyweightCapableTreeStructure, lighterASTNode, iElementType);
            if (object == null || (object = object.getTokenType()) == null) {
                throw new IllegalStateException(("No operation reference for binary expression: " + $this$operationToken.getLighterASTNode()).toString());
            }
        }
        return object;
    }
}

