#ifndef VULKAN_WIN32_H_
#define VULKAN_WIN32_H_ 1

#ifdef __cplusplus
extern "C" {
#endif

/*
** Copyright (c) 2015-2018 The Khronos Group Inc.
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

/*
** This header is generated from the Khronos Vulkan XML API Registry.
**
*/

#define VK_KHR_win32_surface 1
#define VK_KHR_WIN32_SURFACE_SPEC_VERSION 6
#define VK_KHR_WIN32_SURFACE_EXTENSION_NAME "VK_KHR_win32_surface"

typedef VkFlags VkWin32SurfaceCreateFlagsKHR;

typedef struct VkWin32SurfaceCreateInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkWin32SurfaceCreateFlagsKHR flags;
	HINSTANCE hinstance;
	HWND hwnd;
} VkWin32SurfaceCreateInfoKHR;

typedef VkResult(VKAPI_PTR *PFN_vkCreateWin32SurfaceKHR)(VkInstance instance,
														 const VkWin32SurfaceCreateInfoKHR *pCreateInfo,
														 const VkAllocationCallbacks *pAllocator,
														 VkSurfaceKHR *pSurface);
typedef VkBool32(VKAPI_PTR *PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR)(VkPhysicalDevice physicalDevice,
																				uint32_t queueFamilyIndex);

#ifndef VK_NO_PROTOTYPES
VKAPI_ATTR VkResult VKAPI_CALL vkCreateWin32SurfaceKHR(VkInstance instance,
													   const VkWin32SurfaceCreateInfoKHR *pCreateInfo,
													   const VkAllocationCallbacks *pAllocator, VkSurfaceKHR *pSurface);

VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice,
																			  uint32_t queueFamilyIndex);
#endif

#define VK_KHR_external_memory_win32 1
#define VK_KHR_EXTERNAL_MEMORY_WIN32_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME "VK_KHR_external_memory_win32"

typedef struct VkImportMemoryWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkExternalMemoryHandleTypeFlagBits handleType;
	HANDLE handle;
	LPCWSTR name;
} VkImportMemoryWin32HandleInfoKHR;

typedef struct VkExportMemoryWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	const SECURITY_ATTRIBUTES *pAttributes;
	DWORD dwAccess;
	LPCWSTR name;
} VkExportMemoryWin32HandleInfoKHR;

typedef struct VkMemoryWin32HandlePropertiesKHR {
	VkStructureType sType;
	void *pNext;
	uint32_t memoryTypeBits;
} VkMemoryWin32HandlePropertiesKHR;

typedef struct VkMemoryGetWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkDeviceMemory memory;
	VkExternalMemoryHandleTypeFlagBits handleType;
} VkMemoryGetWin32HandleInfoKHR;

typedef VkResult(VKAPI_PTR *PFN_vkGetMemoryWin32HandleKHR)(VkDevice device,
														   const VkMemoryGetWin32HandleInfoKHR *pGetWin32HandleInfo,
														   HANDLE *pHandle);
typedef VkResult(VKAPI_PTR *PFN_vkGetMemoryWin32HandlePropertiesKHR)(
	VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle,
	VkMemoryWin32HandlePropertiesKHR *pMemoryWin32HandleProperties);

#ifndef VK_NO_PROTOTYPES
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryWin32HandleKHR(VkDevice device,
														 const VkMemoryGetWin32HandleInfoKHR *pGetWin32HandleInfo,
														 HANDLE *pHandle);

VKAPI_ATTR VkResult VKAPI_CALL
vkGetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle,
									VkMemoryWin32HandlePropertiesKHR *pMemoryWin32HandleProperties);
#endif

#define VK_KHR_win32_keyed_mutex 1
#define VK_KHR_WIN32_KEYED_MUTEX_SPEC_VERSION 1
#define VK_KHR_WIN32_KEYED_MUTEX_EXTENSION_NAME "VK_KHR_win32_keyed_mutex"

typedef struct VkWin32KeyedMutexAcquireReleaseInfoKHR {
	VkStructureType sType;
	const void *pNext;
	uint32_t acquireCount;
	const VkDeviceMemory *pAcquireSyncs;
	const uint64_t *pAcquireKeys;
	const uint32_t *pAcquireTimeouts;
	uint32_t releaseCount;
	const VkDeviceMemory *pReleaseSyncs;
	const uint64_t *pReleaseKeys;
} VkWin32KeyedMutexAcquireReleaseInfoKHR;

#define VK_KHR_external_semaphore_win32 1
#define VK_KHR_EXTERNAL_SEMAPHORE_WIN32_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME "VK_KHR_external_semaphore_win32"

typedef struct VkImportSemaphoreWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkSemaphore semaphore;
	VkSemaphoreImportFlags flags;
	VkExternalSemaphoreHandleTypeFlagBits handleType;
	HANDLE handle;
	LPCWSTR name;
} VkImportSemaphoreWin32HandleInfoKHR;

typedef struct VkExportSemaphoreWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	const SECURITY_ATTRIBUTES *pAttributes;
	DWORD dwAccess;
	LPCWSTR name;
} VkExportSemaphoreWin32HandleInfoKHR;

typedef struct VkD3D12FenceSubmitInfoKHR {
	VkStructureType sType;
	const void *pNext;
	uint32_t waitSemaphoreValuesCount;
	const uint64_t *pWaitSemaphoreValues;
	uint32_t signalSemaphoreValuesCount;
	const uint64_t *pSignalSemaphoreValues;
} VkD3D12FenceSubmitInfoKHR;

typedef struct VkSemaphoreGetWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkSemaphore semaphore;
	VkExternalSemaphoreHandleTypeFlagBits handleType;
} VkSemaphoreGetWin32HandleInfoKHR;

typedef VkResult(VKAPI_PTR *PFN_vkImportSemaphoreWin32HandleKHR)(
	VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR *pImportSemaphoreWin32HandleInfo);
typedef VkResult(VKAPI_PTR *PFN_vkGetSemaphoreWin32HandleKHR)(
	VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR *pGetWin32HandleInfo, HANDLE *pHandle);

#ifndef VK_NO_PROTOTYPES
VKAPI_ATTR VkResult VKAPI_CALL vkImportSemaphoreWin32HandleKHR(
	VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR *pImportSemaphoreWin32HandleInfo);

VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreWin32HandleKHR(VkDevice device,
															const VkSemaphoreGetWin32HandleInfoKHR *pGetWin32HandleInfo,
															HANDLE *pHandle);
#endif

#define VK_KHR_external_fence_win32 1
#define VK_KHR_EXTERNAL_FENCE_WIN32_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_FENCE_WIN32_EXTENSION_NAME "VK_KHR_external_fence_win32"

typedef struct VkImportFenceWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkFence fence;
	VkFenceImportFlags flags;
	VkExternalFenceHandleTypeFlagBits handleType;
	HANDLE handle;
	LPCWSTR name;
} VkImportFenceWin32HandleInfoKHR;

typedef struct VkExportFenceWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	const SECURITY_ATTRIBUTES *pAttributes;
	DWORD dwAccess;
	LPCWSTR name;
} VkExportFenceWin32HandleInfoKHR;

typedef struct VkFenceGetWin32HandleInfoKHR {
	VkStructureType sType;
	const void *pNext;
	VkFence fence;
	VkExternalFenceHandleTypeFlagBits handleType;
} VkFenceGetWin32HandleInfoKHR;

typedef VkResult(VKAPI_PTR *PFN_vkImportFenceWin32HandleKHR)(
	VkDevice device, const VkImportFenceWin32HandleInfoKHR *pImportFenceWin32HandleInfo);
typedef VkResult(VKAPI_PTR *PFN_vkGetFenceWin32HandleKHR)(VkDevice device,
														  const VkFenceGetWin32HandleInfoKHR *pGetWin32HandleInfo,
														  HANDLE *pHandle);

#ifndef VK_NO_PROTOTYPES
VKAPI_ATTR VkResult VKAPI_CALL
vkImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR *pImportFenceWin32HandleInfo);

VKAPI_ATTR VkResult VKAPI_CALL vkGetFenceWin32HandleKHR(VkDevice device,
														const VkFenceGetWin32HandleInfoKHR *pGetWin32HandleInfo,
														HANDLE *pHandle);
#endif

#define VK_NV_external_memory_win32 1
#define VK_NV_EXTERNAL_MEMORY_WIN32_SPEC_VERSION 1
#define VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME "VK_NV_external_memory_win32"

typedef struct VkImportMemoryWin32HandleInfoNV {
	VkStructureType sType;
	const void *pNext;
	VkExternalMemoryHandleTypeFlagsNV handleType;
	HANDLE handle;
} VkImportMemoryWin32HandleInfoNV;

typedef struct VkExportMemoryWin32HandleInfoNV {
	VkStructureType sType;
	const void *pNext;
	const SECURITY_ATTRIBUTES *pAttributes;
	DWORD dwAccess;
} VkExportMemoryWin32HandleInfoNV;

typedef VkResult(VKAPI_PTR *PFN_vkGetMemoryWin32HandleNV)(VkDevice device, VkDeviceMemory memory,
														  VkExternalMemoryHandleTypeFlagsNV handleType,
														  HANDLE *pHandle);

#ifndef VK_NO_PROTOTYPES
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory,
														VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE *pHandle);
#endif

#define VK_NV_win32_keyed_mutex 1
#define VK_NV_WIN32_KEYED_MUTEX_SPEC_VERSION 1
#define VK_NV_WIN32_KEYED_MUTEX_EXTENSION_NAME "VK_NV_win32_keyed_mutex"

typedef struct VkWin32KeyedMutexAcquireReleaseInfoNV {
	VkStructureType sType;
	const void *pNext;
	uint32_t acquireCount;
	const VkDeviceMemory *pAcquireSyncs;
	const uint64_t *pAcquireKeys;
	const uint32_t *pAcquireTimeoutMilliseconds;
	uint32_t releaseCount;
	const VkDeviceMemory *pReleaseSyncs;
	const uint64_t *pReleaseKeys;
} VkWin32KeyedMutexAcquireReleaseInfoNV;

#ifdef __cplusplus
}
#endif

#endif
