// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectcases

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetField = "BatchGetField"

// BatchGetFieldRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetField operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetField for more information on using the BatchGetField
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetFieldRequest method.
//	req, resp := client.BatchGetFieldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchGetField
func (c *ConnectCases) BatchGetFieldRequest(input *BatchGetFieldInput) (req *request.Request, output *BatchGetFieldOutput) {
	op := &request.Operation{
		Name:       opBatchGetField,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/fields-batch",
	}

	if input == nil {
		input = &BatchGetFieldInput{}
	}

	output = &BatchGetFieldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetField API operation for Amazon Connect Cases.
//
// Returns the description for the list of fields in the request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation BatchGetField for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchGetField
func (c *ConnectCases) BatchGetField(input *BatchGetFieldInput) (*BatchGetFieldOutput, error) {
	req, out := c.BatchGetFieldRequest(input)
	return out, req.Send()
}

// BatchGetFieldWithContext is the same as BatchGetField with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetField for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) BatchGetFieldWithContext(ctx aws.Context, input *BatchGetFieldInput, opts ...request.Option) (*BatchGetFieldOutput, error) {
	req, out := c.BatchGetFieldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutFieldOptions = "BatchPutFieldOptions"

// BatchPutFieldOptionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutFieldOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutFieldOptions for more information on using the BatchPutFieldOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchPutFieldOptionsRequest method.
//	req, resp := client.BatchPutFieldOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchPutFieldOptions
func (c *ConnectCases) BatchPutFieldOptionsRequest(input *BatchPutFieldOptionsInput) (req *request.Request, output *BatchPutFieldOptionsOutput) {
	op := &request.Operation{
		Name:       opBatchPutFieldOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/fields/{fieldId}/options",
	}

	if input == nil {
		input = &BatchPutFieldOptionsInput{}
	}

	output = &BatchPutFieldOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutFieldOptions API operation for Amazon Connect Cases.
//
// Creates and updates a set of field options for a single select field in a
// Cases domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation BatchPutFieldOptions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchPutFieldOptions
func (c *ConnectCases) BatchPutFieldOptions(input *BatchPutFieldOptionsInput) (*BatchPutFieldOptionsOutput, error) {
	req, out := c.BatchPutFieldOptionsRequest(input)
	return out, req.Send()
}

// BatchPutFieldOptionsWithContext is the same as BatchPutFieldOptions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutFieldOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) BatchPutFieldOptionsWithContext(ctx aws.Context, input *BatchPutFieldOptionsInput, opts ...request.Option) (*BatchPutFieldOptionsOutput, error) {
	req, out := c.BatchPutFieldOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCase = "CreateCase"

// CreateCaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCase for more information on using the CreateCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCaseRequest method.
//	req, resp := client.CreateCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateCase
func (c *ConnectCases) CreateCaseRequest(input *CreateCaseInput) (req *request.Request, output *CreateCaseOutput) {
	op := &request.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/cases",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	output = &CreateCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCase API operation for Amazon Connect Cases.
//
// Creates a case in the specified Cases domain. Case system and custom fields
// are taken as an array id/value pairs with a declared data types.
//
// The following fields are required when creating a case:
//
//	<ul> <li> <p> <code>customer_id</code> - You must provide the full customer
//	profile ARN in this format: <code>arn:aws:profile:your AWS Region:your
//	AWS account ID:domains/profiles domain name/profiles/profile ID</code>
//	</p> </li> <li> <p> <code>title</code> </p> </li> </ul> </note>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateCase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateCase
func (c *ConnectCases) CreateCase(input *CreateCaseInput) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	return out, req.Send()
}

// CreateCaseWithContext is the same as CreateCase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateCaseWithContext(ctx aws.Context, input *CreateCaseInput, opts ...request.Option) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateDomain
func (c *ConnectCases) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/domains",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Connect Cases.
//
// Creates a domain, which is a container for all case data, such as cases,
// fields, templates and layouts. Each Amazon Connect instance can be associated
// with only one Cases domain.
//
// This will not associate your connect instance to Cases domain. Instead, use
// the Amazon Connect CreateIntegrationAssociation (https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html)
// API. You need specific IAM permissions to successfully associate the Cases
// domain. For more information, see Onboard to Cases (https://docs.aws.amazon.com/connect/latest/adminguide/required-permissions-iam-cases.html#onboard-cases-iam).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateDomain
func (c *ConnectCases) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateField = "CreateField"

// CreateFieldRequest generates a "aws/request.Request" representing the
// client's request for the CreateField operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateField for more information on using the CreateField
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFieldRequest method.
//	req, resp := client.CreateFieldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateField
func (c *ConnectCases) CreateFieldRequest(input *CreateFieldInput) (req *request.Request, output *CreateFieldOutput) {
	op := &request.Operation{
		Name:       opCreateField,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/fields",
	}

	if input == nil {
		input = &CreateFieldInput{}
	}

	output = &CreateFieldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateField API operation for Amazon Connect Cases.
//
// Creates a field in the Cases domain. This field is used to define the case
// object model (that is, defines what data can be captured on cases) in a Cases
// domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateField for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateField
func (c *ConnectCases) CreateField(input *CreateFieldInput) (*CreateFieldOutput, error) {
	req, out := c.CreateFieldRequest(input)
	return out, req.Send()
}

// CreateFieldWithContext is the same as CreateField with the addition of
// the ability to pass a context and additional request options.
//
// See CreateField for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateFieldWithContext(ctx aws.Context, input *CreateFieldInput, opts ...request.Option) (*CreateFieldOutput, error) {
	req, out := c.CreateFieldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLayout = "CreateLayout"

// CreateLayoutRequest generates a "aws/request.Request" representing the
// client's request for the CreateLayout operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLayout for more information on using the CreateLayout
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLayoutRequest method.
//	req, resp := client.CreateLayoutRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateLayout
func (c *ConnectCases) CreateLayoutRequest(input *CreateLayoutInput) (req *request.Request, output *CreateLayoutOutput) {
	op := &request.Operation{
		Name:       opCreateLayout,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/layouts",
	}

	if input == nil {
		input = &CreateLayoutInput{}
	}

	output = &CreateLayoutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLayout API operation for Amazon Connect Cases.
//
// Creates a layout in the Cases domain. Layouts define the following configuration
// in the top section and More Info tab of the Cases user interface:
//
//   - Fields to display to the users
//
//   - Field ordering
//
// Title and Status fields cannot be part of layouts since they are not configurable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateLayout for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateLayout
func (c *ConnectCases) CreateLayout(input *CreateLayoutInput) (*CreateLayoutOutput, error) {
	req, out := c.CreateLayoutRequest(input)
	return out, req.Send()
}

// CreateLayoutWithContext is the same as CreateLayout with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLayout for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateLayoutWithContext(ctx aws.Context, input *CreateLayoutInput, opts ...request.Option) (*CreateLayoutOutput, error) {
	req, out := c.CreateLayoutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelatedItem = "CreateRelatedItem"

// CreateRelatedItemRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelatedItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelatedItem for more information on using the CreateRelatedItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRelatedItemRequest method.
//	req, resp := client.CreateRelatedItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateRelatedItem
func (c *ConnectCases) CreateRelatedItemRequest(input *CreateRelatedItemInput) (req *request.Request, output *CreateRelatedItemOutput) {
	op := &request.Operation{
		Name:       opCreateRelatedItem,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/cases/{caseId}/related-items/",
	}

	if input == nil {
		input = &CreateRelatedItemInput{}
	}

	output = &CreateRelatedItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelatedItem API operation for Amazon Connect Cases.
//
// Creates a related item (comments, tasks, and contacts) and associates it
// with a case.
//
// A Related Item is a resource that is associated with a case. It may or may
// not have an external identifier linking it to an external resource (for example,
// a contactArn). All Related Items have their own internal identifier, the
// relatedItemArn. Examples of related items include comments and contacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateRelatedItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateRelatedItem
func (c *ConnectCases) CreateRelatedItem(input *CreateRelatedItemInput) (*CreateRelatedItemOutput, error) {
	req, out := c.CreateRelatedItemRequest(input)
	return out, req.Send()
}

// CreateRelatedItemWithContext is the same as CreateRelatedItem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelatedItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateRelatedItemWithContext(ctx aws.Context, input *CreateRelatedItemInput, opts ...request.Option) (*CreateRelatedItemOutput, error) {
	req, out := c.CreateRelatedItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateTemplate
func (c *ConnectCases) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/templates",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for Amazon Connect Cases.
//
// Creates a template in the Cases domain. This template is used to define the
// case object model (that is, to define what data can be captured on cases)
// in a Cases domain. A template must have a unique name within a domain, and
// it must reference existing field IDs and layout IDs. Additionally, multiple
// fields with same IDs are not allowed within the same Template. A template
// can be either Active or Inactive, as indicated by its status. Inactive templates
// cannot be used to create cases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateTemplate
func (c *ConnectCases) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/DeleteDomain
func (c *ConnectCases) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{domainId}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomain API operation for Amazon Connect Cases.
//
// Deletes a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/DeleteDomain
func (c *ConnectCases) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCase = "GetCase"

// GetCaseRequest generates a "aws/request.Request" representing the
// client's request for the GetCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCase for more information on using the GetCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCaseRequest method.
//	req, resp := client.GetCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase
func (c *ConnectCases) GetCaseRequest(input *GetCaseInput) (req *request.Request, output *GetCaseOutput) {
	op := &request.Operation{
		Name:       opGetCase,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/cases/{caseId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCaseInput{}
	}

	output = &GetCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCase API operation for Amazon Connect Cases.
//
// Returns information about a specific case if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation GetCase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase
func (c *ConnectCases) GetCase(input *GetCaseInput) (*GetCaseOutput, error) {
	req, out := c.GetCaseRequest(input)
	return out, req.Send()
}

// GetCaseWithContext is the same as GetCase with the addition of
// the ability to pass a context and additional request options.
//
// See GetCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetCaseWithContext(ctx aws.Context, input *GetCaseInput, opts ...request.Option) (*GetCaseOutput, error) {
	req, out := c.GetCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCasePages iterates over the pages of a GetCase operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCase method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetCase operation.
//	pageNum := 0
//	err := client.GetCasePages(params,
//	    func(page *connectcases.GetCaseOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) GetCasePages(input *GetCaseInput, fn func(*GetCaseOutput, bool) bool) error {
	return c.GetCasePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCasePagesWithContext same as GetCasePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetCasePagesWithContext(ctx aws.Context, input *GetCaseInput, fn func(*GetCaseOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCaseInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCaseRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCaseOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCaseEventConfiguration = "GetCaseEventConfiguration"

// GetCaseEventConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetCaseEventConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCaseEventConfiguration for more information on using the GetCaseEventConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCaseEventConfigurationRequest method.
//	req, resp := client.GetCaseEventConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCaseEventConfiguration
func (c *ConnectCases) GetCaseEventConfigurationRequest(input *GetCaseEventConfigurationInput) (req *request.Request, output *GetCaseEventConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetCaseEventConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/case-event-configuration",
	}

	if input == nil {
		input = &GetCaseEventConfigurationInput{}
	}

	output = &GetCaseEventConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCaseEventConfiguration API operation for Amazon Connect Cases.
//
// Returns the case event publishing configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation GetCaseEventConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCaseEventConfiguration
func (c *ConnectCases) GetCaseEventConfiguration(input *GetCaseEventConfigurationInput) (*GetCaseEventConfigurationOutput, error) {
	req, out := c.GetCaseEventConfigurationRequest(input)
	return out, req.Send()
}

// GetCaseEventConfigurationWithContext is the same as GetCaseEventConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetCaseEventConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetCaseEventConfigurationWithContext(ctx aws.Context, input *GetCaseEventConfigurationInput, opts ...request.Option) (*GetCaseEventConfigurationOutput, error) {
	req, out := c.GetCaseEventConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDomainRequest method.
//	req, resp := client.GetDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetDomain
func (c *ConnectCases) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Connect Cases.
//
// Returns information about a specific domain if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation GetDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetDomain
func (c *ConnectCases) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayout = "GetLayout"

// GetLayoutRequest generates a "aws/request.Request" representing the
// client's request for the GetLayout operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayout for more information on using the GetLayout
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLayoutRequest method.
//	req, resp := client.GetLayoutRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetLayout
func (c *ConnectCases) GetLayoutRequest(input *GetLayoutInput) (req *request.Request, output *GetLayoutOutput) {
	op := &request.Operation{
		Name:       opGetLayout,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/layouts/{layoutId}",
	}

	if input == nil {
		input = &GetLayoutInput{}
	}

	output = &GetLayoutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayout API operation for Amazon Connect Cases.
//
// Returns the details for the requested layout.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation GetLayout for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetLayout
func (c *ConnectCases) GetLayout(input *GetLayoutInput) (*GetLayoutOutput, error) {
	req, out := c.GetLayoutRequest(input)
	return out, req.Send()
}

// GetLayoutWithContext is the same as GetLayout with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayout for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetLayoutWithContext(ctx aws.Context, input *GetLayoutInput, opts ...request.Option) (*GetLayoutOutput, error) {
	req, out := c.GetLayoutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateRequest method.
//	req, resp := client.GetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetTemplate
func (c *ConnectCases) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/templates/{templateId}",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for Amazon Connect Cases.
//
// Returns the details for the requested template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation GetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetTemplate
func (c *ConnectCases) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCasesForContact = "ListCasesForContact"

// ListCasesForContactRequest generates a "aws/request.Request" representing the
// client's request for the ListCasesForContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCasesForContact for more information on using the ListCasesForContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCasesForContactRequest method.
//	req, resp := client.ListCasesForContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact
func (c *ConnectCases) ListCasesForContactRequest(input *ListCasesForContactInput) (req *request.Request, output *ListCasesForContactOutput) {
	op := &request.Operation{
		Name:       opListCasesForContact,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/list-cases-for-contact",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCasesForContactInput{}
	}

	output = &ListCasesForContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCasesForContact API operation for Amazon Connect Cases.
//
// Lists cases for a given contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListCasesForContact for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact
func (c *ConnectCases) ListCasesForContact(input *ListCasesForContactInput) (*ListCasesForContactOutput, error) {
	req, out := c.ListCasesForContactRequest(input)
	return out, req.Send()
}

// ListCasesForContactWithContext is the same as ListCasesForContact with the addition of
// the ability to pass a context and additional request options.
//
// See ListCasesForContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListCasesForContactWithContext(ctx aws.Context, input *ListCasesForContactInput, opts ...request.Option) (*ListCasesForContactOutput, error) {
	req, out := c.ListCasesForContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCasesForContactPages iterates over the pages of a ListCasesForContact operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCasesForContact method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCasesForContact operation.
//	pageNum := 0
//	err := client.ListCasesForContactPages(params,
//	    func(page *connectcases.ListCasesForContactOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListCasesForContactPages(input *ListCasesForContactInput, fn func(*ListCasesForContactOutput, bool) bool) error {
	return c.ListCasesForContactPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCasesForContactPagesWithContext same as ListCasesForContactPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListCasesForContactPagesWithContext(ctx aws.Context, input *ListCasesForContactInput, fn func(*ListCasesForContactOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCasesForContactInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCasesForContactRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCasesForContactOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains
func (c *ConnectCases) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/domains-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon Connect Cases.
//
// Lists all cases domains in the Amazon Web Services account. Each list item
// is a condensed summary object of the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains
func (c *ConnectCases) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomains operation.
//	pageNum := 0
//	err := client.ListDomainsPages(params,
//	    func(page *connectcases.ListDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFieldOptions = "ListFieldOptions"

// ListFieldOptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFieldOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFieldOptions for more information on using the ListFieldOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFieldOptionsRequest method.
//	req, resp := client.ListFieldOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions
func (c *ConnectCases) ListFieldOptionsRequest(input *ListFieldOptionsInput) (req *request.Request, output *ListFieldOptionsOutput) {
	op := &request.Operation{
		Name:       opListFieldOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/fields/{fieldId}/options-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFieldOptionsInput{}
	}

	output = &ListFieldOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFieldOptions API operation for Amazon Connect Cases.
//
// Lists all of the field options for a field identifier in the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListFieldOptions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions
func (c *ConnectCases) ListFieldOptions(input *ListFieldOptionsInput) (*ListFieldOptionsOutput, error) {
	req, out := c.ListFieldOptionsRequest(input)
	return out, req.Send()
}

// ListFieldOptionsWithContext is the same as ListFieldOptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFieldOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListFieldOptionsWithContext(ctx aws.Context, input *ListFieldOptionsInput, opts ...request.Option) (*ListFieldOptionsOutput, error) {
	req, out := c.ListFieldOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFieldOptionsPages iterates over the pages of a ListFieldOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFieldOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFieldOptions operation.
//	pageNum := 0
//	err := client.ListFieldOptionsPages(params,
//	    func(page *connectcases.ListFieldOptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListFieldOptionsPages(input *ListFieldOptionsInput, fn func(*ListFieldOptionsOutput, bool) bool) error {
	return c.ListFieldOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFieldOptionsPagesWithContext same as ListFieldOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListFieldOptionsPagesWithContext(ctx aws.Context, input *ListFieldOptionsInput, fn func(*ListFieldOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFieldOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFieldOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFieldOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFields = "ListFields"

// ListFieldsRequest generates a "aws/request.Request" representing the
// client's request for the ListFields operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFields for more information on using the ListFields
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFieldsRequest method.
//	req, resp := client.ListFieldsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields
func (c *ConnectCases) ListFieldsRequest(input *ListFieldsInput) (req *request.Request, output *ListFieldsOutput) {
	op := &request.Operation{
		Name:       opListFields,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/fields-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFieldsInput{}
	}

	output = &ListFieldsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFields API operation for Amazon Connect Cases.
//
// Lists all fields in a Cases domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListFields for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields
func (c *ConnectCases) ListFields(input *ListFieldsInput) (*ListFieldsOutput, error) {
	req, out := c.ListFieldsRequest(input)
	return out, req.Send()
}

// ListFieldsWithContext is the same as ListFields with the addition of
// the ability to pass a context and additional request options.
//
// See ListFields for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListFieldsWithContext(ctx aws.Context, input *ListFieldsInput, opts ...request.Option) (*ListFieldsOutput, error) {
	req, out := c.ListFieldsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFieldsPages iterates over the pages of a ListFields operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFields method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFields operation.
//	pageNum := 0
//	err := client.ListFieldsPages(params,
//	    func(page *connectcases.ListFieldsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListFieldsPages(input *ListFieldsInput, fn func(*ListFieldsOutput, bool) bool) error {
	return c.ListFieldsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFieldsPagesWithContext same as ListFieldsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListFieldsPagesWithContext(ctx aws.Context, input *ListFieldsInput, fn func(*ListFieldsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFieldsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFieldsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFieldsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLayouts = "ListLayouts"

// ListLayoutsRequest generates a "aws/request.Request" representing the
// client's request for the ListLayouts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLayouts for more information on using the ListLayouts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLayoutsRequest method.
//	req, resp := client.ListLayoutsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts
func (c *ConnectCases) ListLayoutsRequest(input *ListLayoutsInput) (req *request.Request, output *ListLayoutsOutput) {
	op := &request.Operation{
		Name:       opListLayouts,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/layouts-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLayoutsInput{}
	}

	output = &ListLayoutsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLayouts API operation for Amazon Connect Cases.
//
// Lists all layouts in the given cases domain. Each list item is a condensed
// summary object of the layout.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListLayouts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts
func (c *ConnectCases) ListLayouts(input *ListLayoutsInput) (*ListLayoutsOutput, error) {
	req, out := c.ListLayoutsRequest(input)
	return out, req.Send()
}

// ListLayoutsWithContext is the same as ListLayouts with the addition of
// the ability to pass a context and additional request options.
//
// See ListLayouts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListLayoutsWithContext(ctx aws.Context, input *ListLayoutsInput, opts ...request.Option) (*ListLayoutsOutput, error) {
	req, out := c.ListLayoutsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLayoutsPages iterates over the pages of a ListLayouts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLayouts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLayouts operation.
//	pageNum := 0
//	err := client.ListLayoutsPages(params,
//	    func(page *connectcases.ListLayoutsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListLayoutsPages(input *ListLayoutsInput, fn func(*ListLayoutsOutput, bool) bool) error {
	return c.ListLayoutsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLayoutsPagesWithContext same as ListLayoutsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListLayoutsPagesWithContext(ctx aws.Context, input *ListLayoutsInput, fn func(*ListLayoutsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLayoutsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLayoutsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLayoutsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTagsForResource
func (c *ConnectCases) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Cases.
//
// Lists tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTagsForResource
func (c *ConnectCases) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates
func (c *ConnectCases) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/templates-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon Connect Cases.
//
// Lists all of the templates in a Cases domain. Each list item is a condensed
// summary object of the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates
func (c *ConnectCases) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplates operation.
//	pageNum := 0
//	err := client.ListTemplatesPages(params,
//	    func(page *connectcases.ListTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutCaseEventConfiguration = "PutCaseEventConfiguration"

// PutCaseEventConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutCaseEventConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutCaseEventConfiguration for more information on using the PutCaseEventConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutCaseEventConfigurationRequest method.
//	req, resp := client.PutCaseEventConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/PutCaseEventConfiguration
func (c *ConnectCases) PutCaseEventConfigurationRequest(input *PutCaseEventConfigurationInput) (req *request.Request, output *PutCaseEventConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutCaseEventConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/case-event-configuration",
	}

	if input == nil {
		input = &PutCaseEventConfigurationInput{}
	}

	output = &PutCaseEventConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutCaseEventConfiguration API operation for Amazon Connect Cases.
//
// # API for adding case event publishing configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation PutCaseEventConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/PutCaseEventConfiguration
func (c *ConnectCases) PutCaseEventConfiguration(input *PutCaseEventConfigurationInput) (*PutCaseEventConfigurationOutput, error) {
	req, out := c.PutCaseEventConfigurationRequest(input)
	return out, req.Send()
}

// PutCaseEventConfigurationWithContext is the same as PutCaseEventConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutCaseEventConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) PutCaseEventConfigurationWithContext(ctx aws.Context, input *PutCaseEventConfigurationInput, opts ...request.Option) (*PutCaseEventConfigurationOutput, error) {
	req, out := c.PutCaseEventConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchCases = "SearchCases"

// SearchCasesRequest generates a "aws/request.Request" representing the
// client's request for the SearchCases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchCases for more information on using the SearchCases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchCasesRequest method.
//	req, resp := client.SearchCasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases
func (c *ConnectCases) SearchCasesRequest(input *SearchCasesInput) (req *request.Request, output *SearchCasesOutput) {
	op := &request.Operation{
		Name:       opSearchCases,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/cases-search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchCasesInput{}
	}

	output = &SearchCasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchCases API operation for Amazon Connect Cases.
//
// Searches for cases within their associated Cases domain. Search results are
// returned as a paginated list of abridged case documents.
//
// For customer_id you must provide the full customer profile ARN in this format:
// arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain
// name/profiles/profile ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation SearchCases for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases
func (c *ConnectCases) SearchCases(input *SearchCasesInput) (*SearchCasesOutput, error) {
	req, out := c.SearchCasesRequest(input)
	return out, req.Send()
}

// SearchCasesWithContext is the same as SearchCases with the addition of
// the ability to pass a context and additional request options.
//
// See SearchCases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) SearchCasesWithContext(ctx aws.Context, input *SearchCasesInput, opts ...request.Option) (*SearchCasesOutput, error) {
	req, out := c.SearchCasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchCasesPages iterates over the pages of a SearchCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchCases operation.
//	pageNum := 0
//	err := client.SearchCasesPages(params,
//	    func(page *connectcases.SearchCasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) SearchCasesPages(input *SearchCasesInput, fn func(*SearchCasesOutput, bool) bool) error {
	return c.SearchCasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchCasesPagesWithContext same as SearchCasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) SearchCasesPagesWithContext(ctx aws.Context, input *SearchCasesInput, fn func(*SearchCasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchCasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchCasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchCasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchRelatedItems = "SearchRelatedItems"

// SearchRelatedItemsRequest generates a "aws/request.Request" representing the
// client's request for the SearchRelatedItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchRelatedItems for more information on using the SearchRelatedItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchRelatedItemsRequest method.
//	req, resp := client.SearchRelatedItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems
func (c *ConnectCases) SearchRelatedItemsRequest(input *SearchRelatedItemsInput) (req *request.Request, output *SearchRelatedItemsOutput) {
	op := &request.Operation{
		Name:       opSearchRelatedItems,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{domainId}/cases/{caseId}/related-items-search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchRelatedItemsInput{}
	}

	output = &SearchRelatedItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchRelatedItems API operation for Amazon Connect Cases.
//
// Searches for related items that are associated with a case.
//
// If no filters are provided, this returns all related items associated with
// a case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation SearchRelatedItems for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems
func (c *ConnectCases) SearchRelatedItems(input *SearchRelatedItemsInput) (*SearchRelatedItemsOutput, error) {
	req, out := c.SearchRelatedItemsRequest(input)
	return out, req.Send()
}

// SearchRelatedItemsWithContext is the same as SearchRelatedItems with the addition of
// the ability to pass a context and additional request options.
//
// See SearchRelatedItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) SearchRelatedItemsWithContext(ctx aws.Context, input *SearchRelatedItemsInput, opts ...request.Option) (*SearchRelatedItemsOutput, error) {
	req, out := c.SearchRelatedItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchRelatedItemsPages iterates over the pages of a SearchRelatedItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchRelatedItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchRelatedItems operation.
//	pageNum := 0
//	err := client.SearchRelatedItemsPages(params,
//	    func(page *connectcases.SearchRelatedItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectCases) SearchRelatedItemsPages(input *SearchRelatedItemsInput, fn func(*SearchRelatedItemsOutput, bool) bool) error {
	return c.SearchRelatedItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchRelatedItemsPagesWithContext same as SearchRelatedItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) SearchRelatedItemsPagesWithContext(ctx aws.Context, input *SearchRelatedItemsInput, fn func(*SearchRelatedItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchRelatedItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRelatedItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchRelatedItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/TagResource
func (c *ConnectCases) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Cases.
//
// Adds tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/TagResource
func (c *ConnectCases) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UntagResource
func (c *ConnectCases) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Cases.
//
// Untags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UntagResource
func (c *ConnectCases) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCase = "UpdateCase"

// UpdateCaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCase for more information on using the UpdateCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCaseRequest method.
//	req, resp := client.UpdateCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateCase
func (c *ConnectCases) UpdateCaseRequest(input *UpdateCaseInput) (req *request.Request, output *UpdateCaseOutput) {
	op := &request.Operation{
		Name:       opUpdateCase,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/cases/{caseId}",
	}

	if input == nil {
		input = &UpdateCaseInput{}
	}

	output = &UpdateCaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCase API operation for Amazon Connect Cases.
//
// Updates the values of fields on a case. Fields to be updated are received
// as an array of id/value pairs identical to the CreateCase input .
//
// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation UpdateCase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateCase
func (c *ConnectCases) UpdateCase(input *UpdateCaseInput) (*UpdateCaseOutput, error) {
	req, out := c.UpdateCaseRequest(input)
	return out, req.Send()
}

// UpdateCaseWithContext is the same as UpdateCase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) UpdateCaseWithContext(ctx aws.Context, input *UpdateCaseInput, opts ...request.Option) (*UpdateCaseOutput, error) {
	req, out := c.UpdateCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateField = "UpdateField"

// UpdateFieldRequest generates a "aws/request.Request" representing the
// client's request for the UpdateField operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateField for more information on using the UpdateField
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFieldRequest method.
//	req, resp := client.UpdateFieldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateField
func (c *ConnectCases) UpdateFieldRequest(input *UpdateFieldInput) (req *request.Request, output *UpdateFieldOutput) {
	op := &request.Operation{
		Name:       opUpdateField,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/fields/{fieldId}",
	}

	if input == nil {
		input = &UpdateFieldInput{}
	}

	output = &UpdateFieldOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateField API operation for Amazon Connect Cases.
//
// Updates the properties of an existing field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation UpdateField for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateField
func (c *ConnectCases) UpdateField(input *UpdateFieldInput) (*UpdateFieldOutput, error) {
	req, out := c.UpdateFieldRequest(input)
	return out, req.Send()
}

// UpdateFieldWithContext is the same as UpdateField with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateField for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) UpdateFieldWithContext(ctx aws.Context, input *UpdateFieldInput, opts ...request.Option) (*UpdateFieldOutput, error) {
	req, out := c.UpdateFieldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLayout = "UpdateLayout"

// UpdateLayoutRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLayout operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLayout for more information on using the UpdateLayout
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLayoutRequest method.
//	req, resp := client.UpdateLayoutRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateLayout
func (c *ConnectCases) UpdateLayoutRequest(input *UpdateLayoutInput) (req *request.Request, output *UpdateLayoutOutput) {
	op := &request.Operation{
		Name:       opUpdateLayout,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/layouts/{layoutId}",
	}

	if input == nil {
		input = &UpdateLayoutInput{}
	}

	output = &UpdateLayoutOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLayout API operation for Amazon Connect Cases.
//
// Updates the attributes of an existing layout.
//
// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
//
// A ValidationException is returned when you add non-existent fieldIds to a
// layout.
//
// Title and Status fields cannot be part of layouts because they are not configurable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation UpdateLayout for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded. For a list of service quotas, see Amazon
//     Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     in the Amazon Connect Administrator Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateLayout
func (c *ConnectCases) UpdateLayout(input *UpdateLayoutInput) (*UpdateLayoutOutput, error) {
	req, out := c.UpdateLayoutRequest(input)
	return out, req.Send()
}

// UpdateLayoutWithContext is the same as UpdateLayout with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLayout for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) UpdateLayoutWithContext(ctx aws.Context, input *UpdateLayoutInput, opts ...request.Option) (*UpdateLayoutOutput, error) {
	req, out := c.UpdateLayoutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateTemplate
func (c *ConnectCases) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{domainId}/templates/{templateId}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTemplate API operation for Amazon Connect Cases.
//
// Updates the attributes of an existing template. The template attributes that
// can be modified include name, description, layoutConfiguration, requiredFields,
// and status. At least one of these attributes must not be null. If a null
// value is provided for a given attribute, that attribute is ignored and its
// current value is preserved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Cases's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     We couldn't process your request because of an issue with the server. Try
//     again later.
//
//   - ResourceNotFoundException
//     We couldn't find the requested resource. Check that your resources exists
//     and were created in the same Amazon Web Services Region as your request,
//     and try your request again.
//
//   - ValidationException
//     The request isn't valid. Check the syntax and try again.
//
//   - ThrottlingException
//     The rate has been exceeded for this API. Please try again after a few minutes.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateTemplate
func (c *ConnectCases) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectCases) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Content specific to BasicLayout type. It configures fields in the top panel
// and More Info tab of agent application.
type BasicLayout struct {
	_ struct{} `type:"structure"`

	// This represents sections in a tab of the page layout.
	MoreInfo *LayoutSections `locationName:"moreInfo" type:"structure"`

	// This represents sections in a panel of the page layout.
	TopPanel *LayoutSections `locationName:"topPanel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicLayout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicLayout) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BasicLayout) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BasicLayout"}
	if s.MoreInfo != nil {
		if err := s.MoreInfo.Validate(); err != nil {
			invalidParams.AddNested("MoreInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.TopPanel != nil {
		if err := s.TopPanel.Validate(); err != nil {
			invalidParams.AddNested("TopPanel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMoreInfo sets the MoreInfo field's value.
func (s *BasicLayout) SetMoreInfo(v *LayoutSections) *BasicLayout {
	s.MoreInfo = v
	return s
}

// SetTopPanel sets the TopPanel field's value.
func (s *BasicLayout) SetTopPanel(v *LayoutSections) *BasicLayout {
	s.TopPanel = v
	return s
}

type BatchGetFieldInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// A list of unique field identifiers.
	//
	// Fields is a required field
	Fields []*FieldIdentifier `locationName:"fields" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFieldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetFieldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetFieldInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil && len(s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *BatchGetFieldInput) SetDomainId(v string) *BatchGetFieldInput {
	s.DomainId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *BatchGetFieldInput) SetFields(v []*FieldIdentifier) *BatchGetFieldInput {
	s.Fields = v
	return s
}

type BatchGetFieldOutput struct {
	_ struct{} `type:"structure"`

	// A list of field errors.
	//
	// Errors is a required field
	Errors []*FieldError `locationName:"errors" type:"list" required:"true"`

	// A list of detailed field information.
	//
	// Fields is a required field
	Fields []*GetFieldResponse `locationName:"fields" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFieldOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetFieldOutput) SetErrors(v []*FieldError) *BatchGetFieldOutput {
	s.Errors = v
	return s
}

// SetFields sets the Fields field's value.
func (s *BatchGetFieldOutput) SetFields(v []*GetFieldResponse) *BatchGetFieldOutput {
	s.Fields = v
	return s
}

type BatchPutFieldOptionsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `location:"uri" locationName:"fieldId" min:"1" type:"string" required:"true"`

	// A list of FieldOption objects.
	//
	// Options is a required field
	Options []*FieldOption `locationName:"options" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutFieldOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutFieldOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutFieldOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutFieldOptionsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.Options == nil {
		invalidParams.Add(request.NewErrParamRequired("Options"))
	}
	if s.Options != nil {
		for i, v := range s.Options {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Options", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *BatchPutFieldOptionsInput) SetDomainId(v string) *BatchPutFieldOptionsInput {
	s.DomainId = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *BatchPutFieldOptionsInput) SetFieldId(v string) *BatchPutFieldOptionsInput {
	s.FieldId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *BatchPutFieldOptionsInput) SetOptions(v []*FieldOption) *BatchPutFieldOptionsInput {
	s.Options = v
	return s
}

type BatchPutFieldOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of field errors.
	Errors []*FieldOptionError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutFieldOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutFieldOptionsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchPutFieldOptionsOutput) SetErrors(v []*FieldOptionError) *BatchPutFieldOptionsOutput {
	s.Errors = v
	return s
}

// Details of what case data is published through the case event stream.
type CaseEventIncludedData struct {
	_ struct{} `type:"structure"`

	// List of field identifiers.
	//
	// Fields is a required field
	Fields []*FieldIdentifier `locationName:"fields" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseEventIncludedData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseEventIncludedData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaseEventIncludedData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaseEventIncludedData"}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFields sets the Fields field's value.
func (s *CaseEventIncludedData) SetFields(v []*FieldIdentifier) *CaseEventIncludedData {
	s.Fields = v
	return s
}

// A filter for cases. Only one value can be provided.
type CaseFilter struct {
	_ struct{} `type:"structure"`

	// Provides "and all" filtering.
	AndAll []*CaseFilter `locationName:"andAll" type:"list"`

	// A list of fields to filter on.
	Field *FieldFilter `locationName:"field" type:"structure"`

	// A filter for cases. Only one value can be provided.
	Not *CaseFilter `locationName:"not" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaseFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaseFilter"}
	if s.Field != nil {
		if err := s.Field.Validate(); err != nil {
			invalidParams.AddNested("Field", err.(request.ErrInvalidParams))
		}
	}
	if s.Not != nil {
		if err := s.Not.Validate(); err != nil {
			invalidParams.AddNested("Not", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAll sets the AndAll field's value.
func (s *CaseFilter) SetAndAll(v []*CaseFilter) *CaseFilter {
	s.AndAll = v
	return s
}

// SetField sets the Field field's value.
func (s *CaseFilter) SetField(v *FieldFilter) *CaseFilter {
	s.Field = v
	return s
}

// SetNot sets the Not field's value.
func (s *CaseFilter) SetNot(v *CaseFilter) *CaseFilter {
	s.Not = v
	return s
}

// Case summary information.
type CaseSummary struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `locationName:"caseId" min:"1" type:"string" required:"true"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaseSummary) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *CaseSummary) SetCaseId(v string) *CaseSummary {
	s.CaseId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CaseSummary) SetTemplateId(v string) *CaseSummary {
	s.TemplateId = &v
	return s
}

// Represents the content of a Comment to be returned to agents.
type CommentContent struct {
	_ struct{} `type:"structure"`

	// Text in the body of a Comment on a case.
	//
	// Body is a required field
	Body *string `locationName:"body" min:"1" type:"string" required:"true"`

	// Type of the text in the box of a Comment on a case.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true" enum:"CommentBodyTextType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommentContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommentContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommentContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommentContent"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Body != nil && len(*s.Body) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Body", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *CommentContent) SetBody(v string) *CommentContent {
	s.Body = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CommentContent) SetContentType(v string) *CommentContent {
	s.ContentType = &v
	return s
}

// A filter for related items of type Comment.
type CommentFilter struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommentFilter) GoString() string {
	return s.String()
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request. See the accompanying error message for details.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents an Amazon Connect contact object.
type Contact struct {
	_ struct{} `type:"structure"`

	// A unique identifier of a contact in Amazon Connect.
	//
	// ContactArn is a required field
	ContactArn *string `locationName:"contactArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Contact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Contact"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *Contact) SetContactArn(v string) *Contact {
	s.ContactArn = &v
	return s
}

// An object that represents a content of an Amazon Connect contact object.
type ContactContent struct {
	_ struct{} `type:"structure"`

	// A list of channels to filter on for related items of type Contact.
	//
	// Channel is a required field
	Channel *string `locationName:"channel" min:"1" type:"string" required:"true"`

	// The difference between the InitiationTimestamp and the DisconnectTimestamp
	// of the contact.
	//
	// ConnectedToSystemTime is a required field
	ConnectedToSystemTime *time.Time `locationName:"connectedToSystemTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A unique identifier of a contact in Amazon Connect.
	//
	// ContactArn is a required field
	ContactArn *string `locationName:"contactArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactContent) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *ContactContent) SetChannel(v string) *ContactContent {
	s.Channel = &v
	return s
}

// SetConnectedToSystemTime sets the ConnectedToSystemTime field's value.
func (s *ContactContent) SetConnectedToSystemTime(v time.Time) *ContactContent {
	s.ConnectedToSystemTime = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactContent) SetContactArn(v string) *ContactContent {
	s.ContactArn = &v
	return s
}

// A filter for related items of type Contact.
type ContactFilter struct {
	_ struct{} `type:"structure"`

	// A list of channels to filter on for related items of type Contact.
	Channel []*string `locationName:"channel" type:"list"`

	// A unique identifier of a contact in Amazon Connect.
	ContactArn *string `locationName:"contactArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactFilter"}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *ContactFilter) SetChannel(v []*string) *ContactFilter {
	s.Channel = v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactFilter) SetContactArn(v string) *ContactFilter {
	s.ContactArn = &v
	return s
}

type CreateCaseInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// An array of objects with field ID (matching ListFields/DescribeField) and
	// value union data.
	//
	// Fields is a required field
	Fields []*FieldValue `locationName:"fields" type:"list" required:"true"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCaseInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCaseInput) SetClientToken(v string) *CreateCaseInput {
	s.ClientToken = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateCaseInput) SetDomainId(v string) *CreateCaseInput {
	s.DomainId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *CreateCaseInput) SetFields(v []*FieldValue) *CreateCaseInput {
	s.Fields = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateCaseInput) SetTemplateId(v string) *CreateCaseInput {
	s.TemplateId = &v
	return s
}

type CreateCaseOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the case.
	//
	// CaseArn is a required field
	CaseArn *string `locationName:"caseArn" min:"1" type:"string" required:"true"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `locationName:"caseId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCaseOutput) GoString() string {
	return s.String()
}

// SetCaseArn sets the CaseArn field's value.
func (s *CreateCaseOutput) SetCaseArn(v string) *CreateCaseOutput {
	s.CaseArn = &v
	return s
}

// SetCaseId sets the CaseId field's value.
func (s *CreateCaseOutput) SetCaseId(v string) *CreateCaseOutput {
	s.CaseId = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name for your Cases domain. It must be unique for your Amazon Web Services
	// account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateDomainInput) SetName(v string) *CreateDomainInput {
	s.Name = &v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Cases domain.
	//
	// DomainArn is a required field
	DomainArn *string `locationName:"domainArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" min:"1" type:"string" required:"true"`

	// The status of the domain.
	//
	// DomainStatus is a required field
	DomainStatus *string `locationName:"domainStatus" type:"string" required:"true" enum:"DomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomainArn sets the DomainArn field's value.
func (s *CreateDomainOutput) SetDomainArn(v string) *CreateDomainOutput {
	s.DomainArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateDomainOutput) SetDomainId(v string) *CreateDomainOutput {
	s.DomainId = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateDomainOutput) SetDomainStatus(v string) *CreateDomainOutput {
	s.DomainStatus = &v
	return s
}

type CreateFieldInput struct {
	_ struct{} `type:"structure"`

	// The description of the field.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Defines the data type, some system constraints, and default display of the
	// field.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FieldType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFieldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFieldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFieldInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFieldInput) SetDescription(v string) *CreateFieldInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateFieldInput) SetDomainId(v string) *CreateFieldInput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFieldInput) SetName(v string) *CreateFieldInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateFieldInput) SetType(v string) *CreateFieldInput {
	s.Type = &v
	return s
}

type CreateFieldOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the field.
	//
	// FieldArn is a required field
	FieldArn *string `locationName:"fieldArn" min:"1" type:"string" required:"true"`

	// The unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `locationName:"fieldId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFieldOutput) GoString() string {
	return s.String()
}

// SetFieldArn sets the FieldArn field's value.
func (s *CreateFieldOutput) SetFieldArn(v string) *CreateFieldOutput {
	s.FieldArn = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *CreateFieldOutput) SetFieldId(v string) *CreateFieldOutput {
	s.FieldId = &v
	return s
}

type CreateLayoutInput struct {
	_ struct{} `type:"structure"`

	// Information about which fields will be present in the layout, and information
	// about the order of the fields.
	//
	// Content is a required field
	Content *LayoutContent `locationName:"content" type:"structure" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The name of the layout. It must be unique for the Cases domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLayoutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLayoutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLayoutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLayoutInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateLayoutInput) SetContent(v *LayoutContent) *CreateLayoutInput {
	s.Content = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateLayoutInput) SetDomainId(v string) *CreateLayoutInput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLayoutInput) SetName(v string) *CreateLayoutInput {
	s.Name = &v
	return s
}

type CreateLayoutOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created layout.
	//
	// LayoutArn is a required field
	LayoutArn *string `locationName:"layoutArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the layout.
	//
	// LayoutId is a required field
	LayoutId *string `locationName:"layoutId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLayoutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLayoutOutput) GoString() string {
	return s.String()
}

// SetLayoutArn sets the LayoutArn field's value.
func (s *CreateLayoutOutput) SetLayoutArn(v string) *CreateLayoutOutput {
	s.LayoutArn = &v
	return s
}

// SetLayoutId sets the LayoutId field's value.
func (s *CreateLayoutOutput) SetLayoutId(v string) *CreateLayoutOutput {
	s.LayoutId = &v
	return s
}

type CreateRelatedItemInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `location:"uri" locationName:"caseId" min:"1" type:"string" required:"true"`

	// The content of a related item to be created.
	//
	// Content is a required field
	Content *RelatedItemInputContent `locationName:"content" type:"structure" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The type of a related item.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RelatedItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelatedItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelatedItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelatedItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelatedItemInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.CaseId != nil && len(*s.CaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaseId", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseId sets the CaseId field's value.
func (s *CreateRelatedItemInput) SetCaseId(v string) *CreateRelatedItemInput {
	s.CaseId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateRelatedItemInput) SetContent(v *RelatedItemInputContent) *CreateRelatedItemInput {
	s.Content = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateRelatedItemInput) SetDomainId(v string) *CreateRelatedItemInput {
	s.DomainId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateRelatedItemInput) SetType(v string) *CreateRelatedItemInput {
	s.Type = &v
	return s
}

type CreateRelatedItemOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the related item.
	//
	// RelatedItemArn is a required field
	RelatedItemArn *string `locationName:"relatedItemArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the related item.
	//
	// RelatedItemId is a required field
	RelatedItemId *string `locationName:"relatedItemId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelatedItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelatedItemOutput) GoString() string {
	return s.String()
}

// SetRelatedItemArn sets the RelatedItemArn field's value.
func (s *CreateRelatedItemOutput) SetRelatedItemArn(v string) *CreateRelatedItemOutput {
	s.RelatedItemArn = &v
	return s
}

// SetRelatedItemId sets the RelatedItemId field's value.
func (s *CreateRelatedItemOutput) SetRelatedItemId(v string) *CreateRelatedItemOutput {
	s.RelatedItemId = &v
	return s
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the template.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// Configuration of layouts associated to the template.
	LayoutConfiguration *LayoutConfiguration `locationName:"layoutConfiguration" type:"structure"`

	// A name for the template. It must be unique per domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of fields that must contain a value for a case to be successfully
	// created with this template.
	RequiredFields []*RequiredField `locationName:"requiredFields" type:"list"`

	// The status of the template.
	Status *string `locationName:"status" type:"string" enum:"TemplateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.LayoutConfiguration != nil {
		if err := s.LayoutConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LayoutConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RequiredFields != nil {
		for i, v := range s.RequiredFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RequiredFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateTemplateInput) SetDescription(v string) *CreateTemplateInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateTemplateInput) SetDomainId(v string) *CreateTemplateInput {
	s.DomainId = &v
	return s
}

// SetLayoutConfiguration sets the LayoutConfiguration field's value.
func (s *CreateTemplateInput) SetLayoutConfiguration(v *LayoutConfiguration) *CreateTemplateInput {
	s.LayoutConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTemplateInput) SetName(v string) *CreateTemplateInput {
	s.Name = &v
	return s
}

// SetRequiredFields sets the RequiredFields field's value.
func (s *CreateTemplateInput) SetRequiredFields(v []*RequiredField) *CreateTemplateInput {
	s.RequiredFields = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateInput) SetStatus(v string) *CreateTemplateInput {
	s.Status = &v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created template.
	//
	// TemplateArn is a required field
	TemplateArn *string `locationName:"templateArn" min:"1" type:"string" required:"true"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateOutput) SetTemplateArn(v string) *CreateTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateOutput) SetTemplateId(v string) *CreateTemplateOutput {
	s.TemplateId = &v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteDomainInput) SetDomainId(v string) *DeleteDomainInput {
	s.DomainId = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// Object for the summarized details of the domain.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain.
	//
	// DomainArn is a required field
	DomainArn *string `locationName:"domainArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the domain.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" min:"1" type:"string" required:"true"`

	// The name of the domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetDomainArn sets the DomainArn field's value.
func (s *DomainSummary) SetDomainArn(v string) *DomainSummary {
	s.DomainArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DomainSummary) SetDomainId(v string) *DomainSummary {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainSummary) SetName(v string) *DomainSummary {
	s.Name = &v
	return s
}

// Configuration to enable EventBridge case event delivery and determine what
// data is delivered.
type EventBridgeConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the to broadcast case event data to the customer.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// Details of what case and related item data is published through the case
	// event stream.
	IncludedData *EventIncludedData `locationName:"includedData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventBridgeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventBridgeConfiguration"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.IncludedData != nil {
		if err := s.IncludedData.Validate(); err != nil {
			invalidParams.AddNested("IncludedData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EventBridgeConfiguration) SetEnabled(v bool) *EventBridgeConfiguration {
	s.Enabled = &v
	return s
}

// SetIncludedData sets the IncludedData field's value.
func (s *EventBridgeConfiguration) SetIncludedData(v *EventIncludedData) *EventBridgeConfiguration {
	s.IncludedData = v
	return s
}

// Details of what case and related item data is published through the case
// event stream.
type EventIncludedData struct {
	_ struct{} `type:"structure"`

	// Details of what case data is published through the case event stream.
	CaseData *CaseEventIncludedData `locationName:"caseData" type:"structure"`

	// Details of what related item data is published through the case event stream.
	RelatedItemData *RelatedItemEventIncludedData `locationName:"relatedItemData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIncludedData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIncludedData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventIncludedData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventIncludedData"}
	if s.CaseData != nil {
		if err := s.CaseData.Validate(); err != nil {
			invalidParams.AddNested("CaseData", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedItemData != nil {
		if err := s.RelatedItemData.Validate(); err != nil {
			invalidParams.AddNested("RelatedItemData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseData sets the CaseData field's value.
func (s *EventIncludedData) SetCaseData(v *CaseEventIncludedData) *EventIncludedData {
	s.CaseData = v
	return s
}

// SetRelatedItemData sets the RelatedItemData field's value.
func (s *EventIncludedData) SetRelatedItemData(v *RelatedItemEventIncludedData) *EventIncludedData {
	s.RelatedItemData = v
	return s
}

// Object for errors on fields.
type FieldError struct {
	_ struct{} `type:"structure"`

	// The error code from getting a field.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// The field identifier that caused the error.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The error message from getting a field.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FieldError) SetErrorCode(v string) *FieldError {
	s.ErrorCode = &v
	return s
}

// SetId sets the Id field's value.
func (s *FieldError) SetId(v string) *FieldError {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FieldError) SetMessage(v string) *FieldError {
	s.Message = &v
	return s
}

// A filter for fields. Only one value can be provided.
type FieldFilter struct {
	_ struct{} `type:"structure"`

	// Object containing field identifier and value information.
	Contains *FieldValue `locationName:"contains" type:"structure"`

	// Object containing field identifier and value information.
	EqualTo *FieldValue `locationName:"equalTo" type:"structure"`

	// Object containing field identifier and value information.
	GreaterThan *FieldValue `locationName:"greaterThan" type:"structure"`

	// Object containing field identifier and value information.
	GreaterThanOrEqualTo *FieldValue `locationName:"greaterThanOrEqualTo" type:"structure"`

	// Object containing field identifier and value information.
	LessThan *FieldValue `locationName:"lessThan" type:"structure"`

	// Object containing field identifier and value information.
	LessThanOrEqualTo *FieldValue `locationName:"lessThanOrEqualTo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldFilter"}
	if s.Contains != nil {
		if err := s.Contains.Validate(); err != nil {
			invalidParams.AddNested("Contains", err.(request.ErrInvalidParams))
		}
	}
	if s.EqualTo != nil {
		if err := s.EqualTo.Validate(); err != nil {
			invalidParams.AddNested("EqualTo", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEqualTo != nil {
		if err := s.GreaterThanOrEqualTo.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEqualTo", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThanOrEqualTo != nil {
		if err := s.LessThanOrEqualTo.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEqualTo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContains sets the Contains field's value.
func (s *FieldFilter) SetContains(v *FieldValue) *FieldFilter {
	s.Contains = v
	return s
}

// SetEqualTo sets the EqualTo field's value.
func (s *FieldFilter) SetEqualTo(v *FieldValue) *FieldFilter {
	s.EqualTo = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *FieldFilter) SetGreaterThan(v *FieldValue) *FieldFilter {
	s.GreaterThan = v
	return s
}

// SetGreaterThanOrEqualTo sets the GreaterThanOrEqualTo field's value.
func (s *FieldFilter) SetGreaterThanOrEqualTo(v *FieldValue) *FieldFilter {
	s.GreaterThanOrEqualTo = v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *FieldFilter) SetLessThan(v *FieldValue) *FieldFilter {
	s.LessThan = v
	return s
}

// SetLessThanOrEqualTo sets the LessThanOrEqualTo field's value.
func (s *FieldFilter) SetLessThanOrEqualTo(v *FieldValue) *FieldFilter {
	s.LessThanOrEqualTo = v
	return s
}

// Object for a group of fields and associated properties.
type FieldGroup struct {
	_ struct{} `type:"structure"`

	// Represents an ordered list containing field related information.
	//
	// Fields is a required field
	Fields []*FieldItem `locationName:"fields" type:"list" required:"true"`

	// Name of the field group.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldGroup"}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFields sets the Fields field's value.
func (s *FieldGroup) SetFields(v []*FieldItem) *FieldGroup {
	s.Fields = v
	return s
}

// SetName sets the Name field's value.
func (s *FieldGroup) SetName(v string) *FieldGroup {
	s.Name = &v
	return s
}

// Object for unique identifier of a field.
type FieldIdentifier struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a field.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldIdentifier"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *FieldIdentifier) SetId(v string) *FieldIdentifier {
	s.Id = &v
	return s
}

// Object for field related information.
type FieldItem struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a field.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldItem"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *FieldItem) SetId(v string) *FieldItem {
	s.Id = &v
	return s
}

// Object for field Options information.
type FieldOption struct {
	_ struct{} `type:"structure"`

	// Describes whether the FieldOption is active (displayed) or inactive.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// FieldOptionName has max length 100 and disallows trailing spaces.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// FieldOptionValue has max length 100 and must be alphanumeric with hyphens
	// and underscores.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldOption"}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *FieldOption) SetActive(v bool) *FieldOption {
	s.Active = &v
	return s
}

// SetName sets the Name field's value.
func (s *FieldOption) SetName(v string) *FieldOption {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FieldOption) SetValue(v string) *FieldOption {
	s.Value = &v
	return s
}

// Object for field Options errors.
type FieldOptionError struct {
	_ struct{} `type:"structure"`

	// Error code from creating or updating field option.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Error message from creating or updating field option.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field option value that caused the error.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldOptionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldOptionError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FieldOptionError) SetErrorCode(v string) *FieldOptionError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FieldOptionError) SetMessage(v string) *FieldOptionError {
	s.Message = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FieldOptionError) SetValue(v string) *FieldOptionError {
	s.Value = &v
	return s
}

// Object for the summarized details of the field.
type FieldSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the field.
	//
	// FieldArn is a required field
	FieldArn *string `locationName:"fieldArn" min:"1" type:"string" required:"true"`

	// The unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `locationName:"fieldId" min:"1" type:"string" required:"true"`

	// Name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The namespace of a field.
	//
	// Namespace is a required field
	Namespace *string `locationName:"namespace" type:"string" required:"true" enum:"FieldNamespace"`

	// The type of a field.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FieldType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSummary) GoString() string {
	return s.String()
}

// SetFieldArn sets the FieldArn field's value.
func (s *FieldSummary) SetFieldArn(v string) *FieldSummary {
	s.FieldArn = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *FieldSummary) SetFieldId(v string) *FieldSummary {
	s.FieldId = &v
	return s
}

// SetName sets the Name field's value.
func (s *FieldSummary) SetName(v string) *FieldSummary {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *FieldSummary) SetNamespace(v string) *FieldSummary {
	s.Namespace = &v
	return s
}

// SetType sets the Type field's value.
func (s *FieldSummary) SetType(v string) *FieldSummary {
	s.Type = &v
	return s
}

// Object for case field values.
type FieldValue struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a field.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Union of potential field value types.
	//
	// Value is a required field
	Value *FieldValueUnion `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldValue"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *FieldValue) SetId(v string) *FieldValue {
	s.Id = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FieldValue) SetValue(v *FieldValueUnion) *FieldValue {
	s.Value = v
	return s
}

// Object to store union of Field values.
type FieldValueUnion struct {
	_ struct{} `type:"structure"`

	// Can be either null, or have a Boolean value type. Only one value can be provided.
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// Can be either null, or have a Double number value type. Only one value can
	// be provided.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// String value type.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValueUnion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValueUnion) GoString() string {
	return s.String()
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *FieldValueUnion) SetBooleanValue(v bool) *FieldValueUnion {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *FieldValueUnion) SetDoubleValue(v float64) *FieldValueUnion {
	s.DoubleValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *FieldValueUnion) SetStringValue(v string) *FieldValueUnion {
	s.StringValue = &v
	return s
}

type GetCaseEventConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseEventConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseEventConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCaseEventConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCaseEventConfigurationInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *GetCaseEventConfigurationInput) SetDomainId(v string) *GetCaseEventConfigurationInput {
	s.DomainId = &v
	return s
}

type GetCaseEventConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Configuration to enable EventBridge case event delivery and determine what
	// data is delivered.
	//
	// EventBridge is a required field
	EventBridge *EventBridgeConfiguration `locationName:"eventBridge" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseEventConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseEventConfigurationOutput) GoString() string {
	return s.String()
}

// SetEventBridge sets the EventBridge field's value.
func (s *GetCaseEventConfigurationOutput) SetEventBridge(v *EventBridgeConfiguration) *GetCaseEventConfigurationOutput {
	s.EventBridge = v
	return s
}

type GetCaseInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `location:"uri" locationName:"caseId" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// A list of unique field identifiers.
	//
	// Fields is a required field
	Fields []*FieldIdentifier `locationName:"fields" min:"1" type:"list" required:"true"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCaseInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.CaseId != nil && len(*s.CaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaseId", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil && len(s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseId sets the CaseId field's value.
func (s *GetCaseInput) SetCaseId(v string) *GetCaseInput {
	s.CaseId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetCaseInput) SetDomainId(v string) *GetCaseInput {
	s.DomainId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetCaseInput) SetFields(v []*FieldIdentifier) *GetCaseInput {
	s.Fields = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCaseInput) SetNextToken(v string) *GetCaseInput {
	s.NextToken = &v
	return s
}

type GetCaseOutput struct {
	_ struct{} `type:"structure"`

	// A list of detailed field information.
	//
	// Fields is a required field
	Fields []*FieldValue `locationName:"fields" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCaseOutput) GoString() string {
	return s.String()
}

// SetFields sets the Fields field's value.
func (s *GetCaseOutput) SetFields(v []*FieldValue) *GetCaseOutput {
	s.Fields = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCaseOutput) SetNextToken(v string) *GetCaseOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCaseOutput) SetTags(v map[string]*string) *GetCaseOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetCaseOutput) SetTemplateId(v string) *GetCaseOutput {
	s.TemplateId = &v
	return s
}

type GetDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *GetDomainInput) SetDomainId(v string) *GetDomainInput {
	s.DomainId = &v
	return s
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the Cases domain was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the Cases domain.
	//
	// DomainArn is a required field
	DomainArn *string `locationName:"domainArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" min:"1" type:"string" required:"true"`

	// The status of the Cases domain.
	//
	// DomainStatus is a required field
	DomainStatus *string `locationName:"domainStatus" type:"string" required:"true" enum:"DomainStatus"`

	// The name of the Cases domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetDomainOutput) SetCreatedTime(v time.Time) *GetDomainOutput {
	s.CreatedTime = &v
	return s
}

// SetDomainArn sets the DomainArn field's value.
func (s *GetDomainOutput) SetDomainArn(v string) *GetDomainOutput {
	s.DomainArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetDomainOutput) SetDomainId(v string) *GetDomainOutput {
	s.DomainId = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *GetDomainOutput) SetDomainStatus(v string) *GetDomainOutput {
	s.DomainStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDomainOutput) SetName(v string) *GetDomainOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDomainOutput) SetTags(v map[string]*string) *GetDomainOutput {
	s.Tags = v
	return s
}

// Object to store detailed field information.
type GetFieldResponse struct {
	_ struct{} `type:"structure"`

	// Description of the field.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the field.
	//
	// FieldArn is a required field
	FieldArn *string `locationName:"fieldArn" min:"1" type:"string" required:"true"`

	// Unique identifier of the field.
	//
	// FieldId is a required field
	FieldId *string `locationName:"fieldId" min:"1" type:"string" required:"true"`

	// Name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Namespace of the field.
	//
	// Namespace is a required field
	Namespace *string `locationName:"namespace" type:"string" required:"true" enum:"FieldNamespace"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Type of the field.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FieldType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFieldResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFieldResponse) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetFieldResponse) SetDescription(v string) *GetFieldResponse {
	s.Description = &v
	return s
}

// SetFieldArn sets the FieldArn field's value.
func (s *GetFieldResponse) SetFieldArn(v string) *GetFieldResponse {
	s.FieldArn = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *GetFieldResponse) SetFieldId(v string) *GetFieldResponse {
	s.FieldId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFieldResponse) SetName(v string) *GetFieldResponse {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetFieldResponse) SetNamespace(v string) *GetFieldResponse {
	s.Namespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFieldResponse) SetTags(v map[string]*string) *GetFieldResponse {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetFieldResponse) SetType(v string) *GetFieldResponse {
	s.Type = &v
	return s
}

type GetLayoutInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The unique identifier of the layout.
	//
	// LayoutId is a required field
	LayoutId *string `location:"uri" locationName:"layoutId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLayoutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLayoutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayoutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayoutInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.LayoutId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayoutId"))
	}
	if s.LayoutId != nil && len(*s.LayoutId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayoutId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *GetLayoutInput) SetDomainId(v string) *GetLayoutInput {
	s.DomainId = &v
	return s
}

// SetLayoutId sets the LayoutId field's value.
func (s *GetLayoutInput) SetLayoutId(v string) *GetLayoutInput {
	s.LayoutId = &v
	return s
}

type GetLayoutOutput struct {
	_ struct{} `type:"structure"`

	// Information about which fields will be present in the layout, the order of
	// the fields, and read-only attribute of the field.
	//
	// Content is a required field
	Content *LayoutContent `locationName:"content" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the newly created layout.
	//
	// LayoutArn is a required field
	LayoutArn *string `locationName:"layoutArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the layout.
	//
	// LayoutId is a required field
	LayoutId *string `locationName:"layoutId" min:"1" type:"string" required:"true"`

	// The name of the layout. It must be unique.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLayoutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLayoutOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetLayoutOutput) SetContent(v *LayoutContent) *GetLayoutOutput {
	s.Content = v
	return s
}

// SetLayoutArn sets the LayoutArn field's value.
func (s *GetLayoutOutput) SetLayoutArn(v string) *GetLayoutOutput {
	s.LayoutArn = &v
	return s
}

// SetLayoutId sets the LayoutId field's value.
func (s *GetLayoutOutput) SetLayoutId(v string) *GetLayoutOutput {
	s.LayoutId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLayoutOutput) SetName(v string) *GetLayoutOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetLayoutOutput) SetTags(v map[string]*string) *GetLayoutOutput {
	s.Tags = v
	return s
}

type GetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *GetTemplateInput) SetDomainId(v string) *GetTemplateInput {
	s.DomainId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateInput) SetTemplateId(v string) *GetTemplateInput {
	s.TemplateId = &v
	return s
}

type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A brief description of the template.
	Description *string `locationName:"description" type:"string"`

	// Configuration of layouts associated to the template.
	LayoutConfiguration *LayoutConfiguration `locationName:"layoutConfiguration" type:"structure"`

	// The name of the template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of fields that must contain a value for a case to be successfully
	// created with this template.
	RequiredFields []*RequiredField `locationName:"requiredFields" type:"list"`

	// The status of the template.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateStatus"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the template.
	//
	// TemplateArn is a required field
	TemplateArn *string `locationName:"templateArn" min:"1" type:"string" required:"true"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetTemplateOutput) SetDescription(v string) *GetTemplateOutput {
	s.Description = &v
	return s
}

// SetLayoutConfiguration sets the LayoutConfiguration field's value.
func (s *GetTemplateOutput) SetLayoutConfiguration(v *LayoutConfiguration) *GetTemplateOutput {
	s.LayoutConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *GetTemplateOutput) SetName(v string) *GetTemplateOutput {
	s.Name = &v
	return s
}

// SetRequiredFields sets the RequiredFields field's value.
func (s *GetTemplateOutput) SetRequiredFields(v []*RequiredField) *GetTemplateOutput {
	s.RequiredFields = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTemplateOutput) SetStatus(v string) *GetTemplateOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTemplateOutput) SetTags(v map[string]*string) *GetTemplateOutput {
	s.Tags = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetTemplateOutput) SetTemplateArn(v string) *GetTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateOutput) SetTemplateId(v string) *GetTemplateOutput {
	s.TemplateId = &v
	return s
}

// We couldn't process your request because of an issue with the server. Try
// again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object to store configuration of layouts associated to the template.
type LayoutConfiguration struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a layout.
	DefaultLayout *string `locationName:"defaultLayout" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayoutConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayoutConfiguration"}
	if s.DefaultLayout != nil && len(*s.DefaultLayout) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultLayout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultLayout sets the DefaultLayout field's value.
func (s *LayoutConfiguration) SetDefaultLayout(v string) *LayoutConfiguration {
	s.DefaultLayout = &v
	return s
}

// Object to store union of different versions of layout content.
type LayoutContent struct {
	_ struct{} `type:"structure"`

	// Content specific to BasicLayout type. It configures fields in the top panel
	// and More Info tab of Cases user interface.
	Basic *BasicLayout `locationName:"basic" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayoutContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayoutContent"}
	if s.Basic != nil {
		if err := s.Basic.Validate(); err != nil {
			invalidParams.AddNested("Basic", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasic sets the Basic field's value.
func (s *LayoutContent) SetBasic(v *BasicLayout) *LayoutContent {
	s.Basic = v
	return s
}

// Ordered list containing different kinds of sections that can be added. A
// LayoutSections object can only contain one section.
type LayoutSections struct {
	_ struct{} `type:"structure"`

	// Ordered list containing different kinds of sections that can be added.
	Sections []*Section `locationName:"sections" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutSections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutSections) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayoutSections) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayoutSections"}
	if s.Sections != nil {
		for i, v := range s.Sections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sections", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSections sets the Sections field's value.
func (s *LayoutSections) SetSections(v []*Section) *LayoutSections {
	s.Sections = v
	return s
}

// Object for the summarized details of the layout.
type LayoutSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the layout.
	//
	// LayoutArn is a required field
	LayoutArn *string `locationName:"layoutArn" min:"1" type:"string" required:"true"`

	// The unique identifier for of the layout.
	//
	// LayoutId is a required field
	LayoutId *string `locationName:"layoutId" min:"1" type:"string" required:"true"`

	// The name of the layout.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutSummary) GoString() string {
	return s.String()
}

// SetLayoutArn sets the LayoutArn field's value.
func (s *LayoutSummary) SetLayoutArn(v string) *LayoutSummary {
	s.LayoutArn = &v
	return s
}

// SetLayoutId sets the LayoutId field's value.
func (s *LayoutSummary) SetLayoutId(v string) *LayoutSummary {
	s.LayoutId = &v
	return s
}

// SetName sets the Name field's value.
func (s *LayoutSummary) SetName(v string) *LayoutSummary {
	s.Name = &v
	return s
}

type ListCasesForContactInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of a contact in Amazon Connect.
	//
	// ContactArn is a required field
	ContactArn *string `locationName:"contactArn" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCasesForContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCasesForContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCasesForContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCasesForContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *ListCasesForContactInput) SetContactArn(v string) *ListCasesForContactInput {
	s.ContactArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *ListCasesForContactInput) SetDomainId(v string) *ListCasesForContactInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCasesForContactInput) SetMaxResults(v int64) *ListCasesForContactInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCasesForContactInput) SetNextToken(v string) *ListCasesForContactInput {
	s.NextToken = &v
	return s
}

type ListCasesForContactOutput struct {
	_ struct{} `type:"structure"`

	// A list of Case summary information.
	//
	// Cases is a required field
	Cases []*CaseSummary `locationName:"cases" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCasesForContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCasesForContactOutput) GoString() string {
	return s.String()
}

// SetCases sets the Cases field's value.
func (s *ListCasesForContactOutput) SetCases(v []*CaseSummary) *ListCasesForContactOutput {
	s.Cases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCasesForContactOutput) SetNextToken(v string) *ListCasesForContactOutput {
	s.NextToken = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The Cases domain.
	//
	// Domains is a required field
	Domains []*DomainSummary `locationName:"domains" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *ListDomainsOutput) SetDomains(v []*DomainSummary) *ListDomainsOutput {
	s.Domains = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListFieldOptionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `location:"uri" locationName:"fieldId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A list of FieldOption values to filter on for ListFieldOptions.
	Values []*string `location:"querystring" locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFieldOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFieldOptionsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListFieldOptionsInput) SetDomainId(v string) *ListFieldOptionsInput {
	s.DomainId = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *ListFieldOptionsInput) SetFieldId(v string) *ListFieldOptionsInput {
	s.FieldId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFieldOptionsInput) SetMaxResults(v int64) *ListFieldOptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFieldOptionsInput) SetNextToken(v string) *ListFieldOptionsInput {
	s.NextToken = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ListFieldOptionsInput) SetValues(v []*string) *ListFieldOptionsInput {
	s.Values = v
	return s
}

type ListFieldOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of FieldOption objects.
	//
	// Options is a required field
	Options []*FieldOption `locationName:"options" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldOptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListFieldOptionsOutput) SetNextToken(v string) *ListFieldOptionsOutput {
	s.NextToken = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *ListFieldOptionsOutput) SetOptions(v []*FieldOption) *ListFieldOptionsOutput {
	s.Options = v
	return s
}

type ListFieldsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFieldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFieldsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListFieldsInput) SetDomainId(v string) *ListFieldsInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFieldsInput) SetMaxResults(v int64) *ListFieldsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFieldsInput) SetNextToken(v string) *ListFieldsInput {
	s.NextToken = &v
	return s
}

type ListFieldsOutput struct {
	_ struct{} `type:"structure"`

	// List of detailed field information.
	//
	// Fields is a required field
	Fields []*FieldSummary `locationName:"fields" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFieldsOutput) GoString() string {
	return s.String()
}

// SetFields sets the Fields field's value.
func (s *ListFieldsOutput) SetFields(v []*FieldSummary) *ListFieldsOutput {
	s.Fields = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFieldsOutput) SetNextToken(v string) *ListFieldsOutput {
	s.NextToken = &v
	return s
}

type ListLayoutsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLayoutsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLayoutsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayoutsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLayoutsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListLayoutsInput) SetDomainId(v string) *ListLayoutsInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLayoutsInput) SetMaxResults(v int64) *ListLayoutsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLayoutsInput) SetNextToken(v string) *ListLayoutsInput {
	s.NextToken = &v
	return s
}

type ListLayoutsOutput struct {
	_ struct{} `type:"structure"`

	// The layouts for the domain.
	//
	// Layouts is a required field
	Layouts []*LayoutSummary `locationName:"layouts" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLayoutsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLayoutsOutput) GoString() string {
	return s.String()
}

// SetLayouts sets the Layouts field's value.
func (s *ListLayoutsOutput) SetLayouts(v []*LayoutSummary) *ListLayoutsOutput {
	s.Layouts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLayoutsOutput) SetNextToken(v string) *ListLayoutsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN)
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A list of status values to filter on.
	Status []*string `location:"querystring" locationName:"status" min:"1" type:"list" enum:"TemplateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplatesInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Status != nil && len(s.Status) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListTemplatesInput) SetDomainId(v string) *ListTemplatesInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplatesInput) SetMaxResults(v int64) *ListTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTemplatesInput) SetStatus(v []*string) *ListTemplatesInput {
	s.Status = v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of template summary objects.
	//
	// Templates is a required field
	Templates []*TemplateSummary `locationName:"templates" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesOutput) SetNextToken(v string) *ListTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplates sets the Templates field's value.
func (s *ListTemplatesOutput) SetTemplates(v []*TemplateSummary) *ListTemplatesOutput {
	s.Templates = v
	return s
}

type PutCaseEventConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// Configuration to enable EventBridge case event delivery and determine what
	// data is delivered.
	//
	// EventBridge is a required field
	EventBridge *EventBridgeConfiguration `locationName:"eventBridge" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCaseEventConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCaseEventConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCaseEventConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutCaseEventConfigurationInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.EventBridge == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBridge"))
	}
	if s.EventBridge != nil {
		if err := s.EventBridge.Validate(); err != nil {
			invalidParams.AddNested("EventBridge", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *PutCaseEventConfigurationInput) SetDomainId(v string) *PutCaseEventConfigurationInput {
	s.DomainId = &v
	return s
}

// SetEventBridge sets the EventBridge field's value.
func (s *PutCaseEventConfigurationInput) SetEventBridge(v *EventBridgeConfiguration) *PutCaseEventConfigurationInput {
	s.EventBridge = v
	return s
}

type PutCaseEventConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCaseEventConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCaseEventConfigurationOutput) GoString() string {
	return s.String()
}

// Represents the content of a particular type of related item.
type RelatedItemContent struct {
	_ struct{} `type:"structure"`

	// Represents the content of a comment to be returned to agents.
	Comment *CommentContent `locationName:"comment" type:"structure"`

	// Represents the content of a contact to be returned to agents.
	Contact *ContactContent `locationName:"contact" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemContent) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *RelatedItemContent) SetComment(v *CommentContent) *RelatedItemContent {
	s.Comment = v
	return s
}

// SetContact sets the Contact field's value.
func (s *RelatedItemContent) SetContact(v *ContactContent) *RelatedItemContent {
	s.Contact = v
	return s
}

// Details of what related item data is published through the case event stream.
type RelatedItemEventIncludedData struct {
	_ struct{} `type:"structure"`

	// Details of what related item data is published through the case event stream.
	//
	// IncludeContent is a required field
	IncludeContent *bool `locationName:"includeContent" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemEventIncludedData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemEventIncludedData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedItemEventIncludedData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedItemEventIncludedData"}
	if s.IncludeContent == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludeContent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeContent sets the IncludeContent field's value.
func (s *RelatedItemEventIncludedData) SetIncludeContent(v bool) *RelatedItemEventIncludedData {
	s.IncludeContent = &v
	return s
}

// Represents the content of a related item to be created.
type RelatedItemInputContent struct {
	_ struct{} `type:"structure"`

	// Represents the content of a comment to be returned to agents.
	Comment *CommentContent `locationName:"comment" type:"structure"`

	// Object representing a contact in Amazon Connect as an API request field.
	Contact *Contact `locationName:"contact" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemInputContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemInputContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedItemInputContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedItemInputContent"}
	if s.Comment != nil {
		if err := s.Comment.Validate(); err != nil {
			invalidParams.AddNested("Comment", err.(request.ErrInvalidParams))
		}
	}
	if s.Contact != nil {
		if err := s.Contact.Validate(); err != nil {
			invalidParams.AddNested("Contact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *RelatedItemInputContent) SetComment(v *CommentContent) *RelatedItemInputContent {
	s.Comment = v
	return s
}

// SetContact sets the Contact field's value.
func (s *RelatedItemInputContent) SetContact(v *Contact) *RelatedItemInputContent {
	s.Contact = v
	return s
}

// The list of types of related items and their parameters to use for filtering.
type RelatedItemTypeFilter struct {
	_ struct{} `type:"structure"`

	// A filter for related items of type Comment.
	Comment *CommentFilter `locationName:"comment" type:"structure"`

	// A filter for related items of type Contact.
	Contact *ContactFilter `locationName:"contact" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemTypeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemTypeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedItemTypeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedItemTypeFilter"}
	if s.Contact != nil {
		if err := s.Contact.Validate(); err != nil {
			invalidParams.AddNested("Contact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *RelatedItemTypeFilter) SetComment(v *CommentFilter) *RelatedItemTypeFilter {
	s.Comment = v
	return s
}

// SetContact sets the Contact field's value.
func (s *RelatedItemTypeFilter) SetContact(v *ContactFilter) *RelatedItemTypeFilter {
	s.Contact = v
	return s
}

// List of fields that must have a value provided to create a case.
type RequiredField struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `locationName:"fieldId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequiredField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequiredField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequiredField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequiredField"}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldId sets the FieldId field's value.
func (s *RequiredField) SetFieldId(v string) *RequiredField {
	s.FieldId = &v
	return s
}

// We couldn't find the requested resource. Check that your resources exists
// and were created in the same Amazon Web Services Region as your request,
// and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Unique identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SearchCasesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The list of field identifiers to be returned as part of the response.
	Fields []*FieldIdentifier `locationName:"fields" type:"list"`

	// A list of filter objects.
	Filter *CaseFilter `locationName:"filter" type:"structure"`

	// The maximum number of cases to return. The current maximum supported value
	// is 25. This is also the default value when no other value is provided.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A word or phrase used to perform a quick search.
	SearchTerm *string `locationName:"searchTerm" type:"string"`

	// A list of sorts where each sort specifies a field and their sort order to
	// be applied to the results.
	Sorts []*Sort `locationName:"sorts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchCasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchCasesInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.Sorts != nil {
		for i, v := range s.Sorts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sorts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *SearchCasesInput) SetDomainId(v string) *SearchCasesInput {
	s.DomainId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *SearchCasesInput) SetFields(v []*FieldIdentifier) *SearchCasesInput {
	s.Fields = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *SearchCasesInput) SetFilter(v *CaseFilter) *SearchCasesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchCasesInput) SetMaxResults(v int64) *SearchCasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchCasesInput) SetNextToken(v string) *SearchCasesInput {
	s.NextToken = &v
	return s
}

// SetSearchTerm sets the SearchTerm field's value.
func (s *SearchCasesInput) SetSearchTerm(v string) *SearchCasesInput {
	s.SearchTerm = &v
	return s
}

// SetSorts sets the Sorts field's value.
func (s *SearchCasesInput) SetSorts(v []*Sort) *SearchCasesInput {
	s.Sorts = v
	return s
}

type SearchCasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of case documents where each case contains the properties CaseId and
	// Fields where each field is a complex union structure.
	//
	// Cases is a required field
	Cases []*SearchCasesResponseItem `locationName:"cases" type:"list" required:"true"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesOutput) GoString() string {
	return s.String()
}

// SetCases sets the Cases field's value.
func (s *SearchCasesOutput) SetCases(v []*SearchCasesResponseItem) *SearchCasesOutput {
	s.Cases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchCasesOutput) SetNextToken(v string) *SearchCasesOutput {
	s.NextToken = &v
	return s
}

// A list of items that represent cases.
type SearchCasesResponseItem struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `locationName:"caseId" min:"1" type:"string" required:"true"`

	// List of case field values.
	//
	// Fields is a required field
	Fields []*FieldValue `locationName:"fields" type:"list" required:"true"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A unique identifier of a template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesResponseItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCasesResponseItem) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *SearchCasesResponseItem) SetCaseId(v string) *SearchCasesResponseItem {
	s.CaseId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *SearchCasesResponseItem) SetFields(v []*FieldValue) *SearchCasesResponseItem {
	s.Fields = v
	return s
}

// SetTags sets the Tags field's value.
func (s *SearchCasesResponseItem) SetTags(v map[string]*string) *SearchCasesResponseItem {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *SearchCasesResponseItem) SetTemplateId(v string) *SearchCasesResponseItem {
	s.TemplateId = &v
	return s
}

type SearchRelatedItemsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `location:"uri" locationName:"caseId" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The list of types of related items and their parameters to use for filtering.
	Filters []*RelatedItemTypeFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchRelatedItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchRelatedItemsInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.CaseId != nil && len(*s.CaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaseId", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseId sets the CaseId field's value.
func (s *SearchRelatedItemsInput) SetCaseId(v string) *SearchRelatedItemsInput {
	s.CaseId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *SearchRelatedItemsInput) SetDomainId(v string) *SearchRelatedItemsInput {
	s.DomainId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchRelatedItemsInput) SetFilters(v []*RelatedItemTypeFilter) *SearchRelatedItemsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchRelatedItemsInput) SetMaxResults(v int64) *SearchRelatedItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRelatedItemsInput) SetNextToken(v string) *SearchRelatedItemsInput {
	s.NextToken = &v
	return s
}

type SearchRelatedItemsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of items related to a case.
	//
	// RelatedItems is a required field
	RelatedItems []*SearchRelatedItemsResponseItem `locationName:"relatedItems" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRelatedItemsOutput) SetNextToken(v string) *SearchRelatedItemsOutput {
	s.NextToken = &v
	return s
}

// SetRelatedItems sets the RelatedItems field's value.
func (s *SearchRelatedItemsOutput) SetRelatedItems(v []*SearchRelatedItemsResponseItem) *SearchRelatedItemsOutput {
	s.RelatedItems = v
	return s
}

// A list of items that represent RelatedItems.
type SearchRelatedItemsResponseItem struct {
	_ struct{} `type:"structure"`

	// Time at which a related item was associated with a case.
	//
	// AssociationTime is a required field
	AssociationTime *time.Time `locationName:"associationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Represents the content of a particular type of related item.
	//
	// Content is a required field
	Content *RelatedItemContent `locationName:"content" type:"structure" required:"true"`

	// Unique identifier of a related item.
	//
	// RelatedItemId is a required field
	RelatedItemId *string `locationName:"relatedItemId" min:"1" type:"string" required:"true"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Type of a related item.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RelatedItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsResponseItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRelatedItemsResponseItem) GoString() string {
	return s.String()
}

// SetAssociationTime sets the AssociationTime field's value.
func (s *SearchRelatedItemsResponseItem) SetAssociationTime(v time.Time) *SearchRelatedItemsResponseItem {
	s.AssociationTime = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SearchRelatedItemsResponseItem) SetContent(v *RelatedItemContent) *SearchRelatedItemsResponseItem {
	s.Content = v
	return s
}

// SetRelatedItemId sets the RelatedItemId field's value.
func (s *SearchRelatedItemsResponseItem) SetRelatedItemId(v string) *SearchRelatedItemsResponseItem {
	s.RelatedItemId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SearchRelatedItemsResponseItem) SetTags(v map[string]*string) *SearchRelatedItemsResponseItem {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *SearchRelatedItemsResponseItem) SetType(v string) *SearchRelatedItemsResponseItem {
	s.Type = &v
	return s
}

// This represents a sections within a panel or tab of the page layout.
type Section struct {
	_ struct{} `type:"structure"`

	// Consists of a group of fields and associated properties.
	FieldGroup *FieldGroup `locationName:"fieldGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Section) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Section) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Section) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Section"}
	if s.FieldGroup != nil {
		if err := s.FieldGroup.Validate(); err != nil {
			invalidParams.AddNested("FieldGroup", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldGroup sets the FieldGroup field's value.
func (s *Section) SetFieldGroup(v *FieldGroup) *Section {
	s.FieldGroup = v
	return s
}

// The service quota has been exceeded. For a list of service quotas, see Amazon
// Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
// in the Amazon Connect Administrator Guide.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structured set of sort terms.
type Sort struct {
	_ struct{} `type:"structure"`

	// Unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `locationName:"fieldId" min:"1" type:"string" required:"true"`

	// A structured set of sort terms
	//
	// SortOrder is a required field
	SortOrder *string `locationName:"sortOrder" type:"string" required:"true" enum:"Order"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldId sets the FieldId field's value.
func (s *Sort) SetFieldId(v string) *Sort {
	s.FieldId = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Sort) SetSortOrder(v string) *Sort {
	s.SortOrder = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN)
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"1" type:"string" required:"true"`

	// A map of of key-value pairs that represent tags on a resource. Tags are used
	// to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Template summary information.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// The template name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the template.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateStatus"`

	// The Amazon Resource Name (ARN) of the template.
	//
	// TemplateArn is a required field
	TemplateArn *string `locationName:"templateArn" min:"1" type:"string" required:"true"`

	// The unique identifier for the template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TemplateSummary) SetName(v string) *TemplateSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateSummary) SetStatus(v string) *TemplateSummary {
	s.Status = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *TemplateSummary) SetTemplateArn(v string) *TemplateSummary {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *TemplateSummary) SetTemplateId(v string) *TemplateSummary {
	s.TemplateId = &v
	return s
}

// The rate has been exceeded for this API. Please try again after a few minutes.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN)
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" min:"1" type:"string" required:"true"`

	// List of tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCaseInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the case.
	//
	// CaseId is a required field
	CaseId *string `location:"uri" locationName:"caseId" min:"1" type:"string" required:"true"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// An array of objects with fieldId (matching ListFields/DescribeField) and
	// value union data, structured identical to CreateCase.
	//
	// Fields is a required field
	Fields []*FieldValue `locationName:"fields" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCaseInput"}
	if s.CaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaseId"))
	}
	if s.CaseId != nil && len(*s.CaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaseId", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaseId sets the CaseId field's value.
func (s *UpdateCaseInput) SetCaseId(v string) *UpdateCaseInput {
	s.CaseId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateCaseInput) SetDomainId(v string) *UpdateCaseInput {
	s.DomainId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *UpdateCaseInput) SetFields(v []*FieldValue) *UpdateCaseInput {
	s.Fields = v
	return s
}

type UpdateCaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCaseOutput) GoString() string {
	return s.String()
}

type UpdateFieldInput struct {
	_ struct{} `type:"structure"`

	// The description of a field.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The unique identifier of a field.
	//
	// FieldId is a required field
	FieldId *string `location:"uri" locationName:"fieldId" min:"1" type:"string" required:"true"`

	// The name of the field.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFieldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFieldInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFieldInput) SetDescription(v string) *UpdateFieldInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateFieldInput) SetDomainId(v string) *UpdateFieldInput {
	s.DomainId = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *UpdateFieldInput) SetFieldId(v string) *UpdateFieldInput {
	s.FieldId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFieldInput) SetName(v string) *UpdateFieldInput {
	s.Name = &v
	return s
}

type UpdateFieldOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFieldOutput) GoString() string {
	return s.String()
}

type UpdateLayoutInput struct {
	_ struct{} `type:"structure"`

	// Information about which fields will be present in the layout, the order of
	// the fields, and a read-only attribute of the field.
	Content *LayoutContent `locationName:"content" type:"structure"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// The unique identifier of the layout.
	//
	// LayoutId is a required field
	LayoutId *string `location:"uri" locationName:"layoutId" min:"1" type:"string" required:"true"`

	// The name of the layout. It must be unique per domain.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLayoutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLayoutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLayoutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLayoutInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.LayoutId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayoutId"))
	}
	if s.LayoutId != nil && len(*s.LayoutId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayoutId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *UpdateLayoutInput) SetContent(v *LayoutContent) *UpdateLayoutInput {
	s.Content = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateLayoutInput) SetDomainId(v string) *UpdateLayoutInput {
	s.DomainId = &v
	return s
}

// SetLayoutId sets the LayoutId field's value.
func (s *UpdateLayoutInput) SetLayoutId(v string) *UpdateLayoutInput {
	s.LayoutId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLayoutInput) SetName(v string) *UpdateLayoutInput {
	s.Name = &v
	return s
}

type UpdateLayoutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLayoutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLayoutOutput) GoString() string {
	return s.String()
}

type UpdateTemplateInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the template.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Cases domain.
	//
	// DomainId is a required field
	DomainId *string `location:"uri" locationName:"domainId" min:"1" type:"string" required:"true"`

	// Configuration of layouts associated to the template.
	LayoutConfiguration *LayoutConfiguration `locationName:"layoutConfiguration" type:"structure"`

	// The name of the template. It must be unique per domain.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of fields that must contain a value for a case to be successfully
	// created with this template.
	RequiredFields []*RequiredField `locationName:"requiredFields" type:"list"`

	// The status of the template.
	Status *string `locationName:"status" type:"string" enum:"TemplateStatus"`

	// A unique identifier for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.LayoutConfiguration != nil {
		if err := s.LayoutConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LayoutConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RequiredFields != nil {
		for i, v := range s.RequiredFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RequiredFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateTemplateInput) SetDescription(v string) *UpdateTemplateInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateTemplateInput) SetDomainId(v string) *UpdateTemplateInput {
	s.DomainId = &v
	return s
}

// SetLayoutConfiguration sets the LayoutConfiguration field's value.
func (s *UpdateTemplateInput) SetLayoutConfiguration(v *LayoutConfiguration) *UpdateTemplateInput {
	s.LayoutConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTemplateInput) SetName(v string) *UpdateTemplateInput {
	s.Name = &v
	return s
}

// SetRequiredFields sets the RequiredFields field's value.
func (s *UpdateTemplateInput) SetRequiredFields(v []*RequiredField) *UpdateTemplateInput {
	s.RequiredFields = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTemplateInput) SetStatus(v string) *UpdateTemplateInput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplateInput) SetTemplateId(v string) *UpdateTemplateInput {
	s.TemplateId = &v
	return s
}

type UpdateTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) GoString() string {
	return s.String()
}

// The request isn't valid. Check the syntax and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CommentBodyTextTypeTextPlain is a CommentBodyTextType enum value
	CommentBodyTextTypeTextPlain = "Text/Plain"
)

// CommentBodyTextType_Values returns all elements of the CommentBodyTextType enum
func CommentBodyTextType_Values() []string {
	return []string{
		CommentBodyTextTypeTextPlain,
	}
}

const (
	// DomainStatusActive is a DomainStatus enum value
	DomainStatusActive = "Active"

	// DomainStatusCreationInProgress is a DomainStatus enum value
	DomainStatusCreationInProgress = "CreationInProgress"

	// DomainStatusCreationFailed is a DomainStatus enum value
	DomainStatusCreationFailed = "CreationFailed"
)

// DomainStatus_Values returns all elements of the DomainStatus enum
func DomainStatus_Values() []string {
	return []string{
		DomainStatusActive,
		DomainStatusCreationInProgress,
		DomainStatusCreationFailed,
	}
}

const (
	// FieldNamespaceSystem is a FieldNamespace enum value
	FieldNamespaceSystem = "System"

	// FieldNamespaceCustom is a FieldNamespace enum value
	FieldNamespaceCustom = "Custom"
)

// FieldNamespace_Values returns all elements of the FieldNamespace enum
func FieldNamespace_Values() []string {
	return []string{
		FieldNamespaceSystem,
		FieldNamespaceCustom,
	}
}

const (
	// FieldTypeText is a FieldType enum value
	FieldTypeText = "Text"

	// FieldTypeNumber is a FieldType enum value
	FieldTypeNumber = "Number"

	// FieldTypeBoolean is a FieldType enum value
	FieldTypeBoolean = "Boolean"

	// FieldTypeDateTime is a FieldType enum value
	FieldTypeDateTime = "DateTime"

	// FieldTypeSingleSelect is a FieldType enum value
	FieldTypeSingleSelect = "SingleSelect"

	// FieldTypeUrl is a FieldType enum value
	FieldTypeUrl = "Url"
)

// FieldType_Values returns all elements of the FieldType enum
func FieldType_Values() []string {
	return []string{
		FieldTypeText,
		FieldTypeNumber,
		FieldTypeBoolean,
		FieldTypeDateTime,
		FieldTypeSingleSelect,
		FieldTypeUrl,
	}
}

const (
	// OrderAsc is a Order enum value
	OrderAsc = "Asc"

	// OrderDesc is a Order enum value
	OrderDesc = "Desc"
)

// Order_Values returns all elements of the Order enum
func Order_Values() []string {
	return []string{
		OrderAsc,
		OrderDesc,
	}
}

const (
	// RelatedItemTypeContact is a RelatedItemType enum value
	RelatedItemTypeContact = "Contact"

	// RelatedItemTypeComment is a RelatedItemType enum value
	RelatedItemTypeComment = "Comment"
)

// RelatedItemType_Values returns all elements of the RelatedItemType enum
func RelatedItemType_Values() []string {
	return []string{
		RelatedItemTypeContact,
		RelatedItemTypeComment,
	}
}

const (
	// TemplateStatusActive is a TemplateStatus enum value
	TemplateStatusActive = "Active"

	// TemplateStatusInactive is a TemplateStatus enum value
	TemplateStatusInactive = "Inactive"
)

// TemplateStatus_Values returns all elements of the TemplateStatus enum
func TemplateStatus_Values() []string {
	return []string{
		TemplateStatusActive,
		TemplateStatusInactive,
	}
}
