##*****************************************************************************
## $Id$
##*****************************************************************************
#  AUTHOR:
#    Al Chu <chu11@llnl.gov>
#
#  SYNOPSIS:
#    AC_STATIC_MODULE
#
#  DESCRIPTION:
#    Output #include files for static modules.
#
#  WARNINGS:
#    This macro must be placed after AC_PROG_CC or equivalent.
##*****************************************************************************

# This must be called before checks before any specific modules are done
AC_DEFUN([AC_STATIC_MODULES_INIT],
[
  rm -f static_modules.h
])

AC_DEFUN([AC_ADD_STATIC_MODULE],
[
  if test "$ac_static_modules" = "yes" ; then
     MODULES="$MODULES $1"
  fi
])

AC_DEFUN([AC_STATIC_MODULES_EXIT],
[
  # check for module conflicts 

  if test "$ac_have_libgenders" = "yes" && test "$ac_have_machines" = "yes"; then
     AC_MSG_ERROR([--with-genders conflicts with --with-machines])
  fi

  for module in $MODULES; do
     LIBMODS_OBJS="$LIBMODS_OBJS ${module}.lo"
  done
  AC_SUBST(LIBMODS_OBJS)

  # Output the static_modules.h file
  # must be in current directory, other paths may not exist yet.
  output_file="static_modules.h"

##-----------------------------------------------------------------
  cat >$output_file <<_MEOF
/* 
 *  This file is generated by autoconf and is included by mod.c.  
 *   It allows mod.c to access all statically compiled pdsh_module 
 *   structures available.
 */

#ifndef _STATIC_MODULES_H        
#define _STATic_MODULES_H       
                                
#if HAVE_CONFIG_H             
#  include "config.h"      
#endif                      
                            
#if STATIC_MODULES        
                          
 /* module information structures */ 

_MEOF 
##-----------------------------------------------------------------

  for i in $MODULES
  do
     echo "extern struct pdsh_module ${i}_module_info;" >> $output_file
     echo "extern int ${i}_module_priority;"            >> $output_file  
  done

##-----------------------------------------------------------------

  cat >>$output_file <<_MEOF

/*                                      
 * Array of all pdsh_module structures we are compiling                     
 */                                     
struct pdsh_module *static_mods[[]] = { 
_MEOF
##-----------------------------------------------------------------

  for i in $MODULES
  do
     echo "    &${i}_module_info," >> $output_file
  done

##-----------------------------------------------------------------

  cat >>$output_file <<_MEOF
    NULL                    
};                         
                          
/*                                     
 * Names of all the module structures 
 */                                  
char *static_mod_names[[]] = {    
_MEOF
##-----------------------------------------------------------------

  for i in $MODULES
  do
     echo "    \"${i}\"," >> $output_file
  done
  
##-----------------------------------------------------------------

  cat >>$output_file <<_MEOF
    NULL                            
};                                   

/*
 * Module priorities
 */
int *priority[[]] = {
_MEOF
##-----------------------------------------------------------------

  for i in $MODULES
  do
     echo "    &${i}_module_priority," >> $output_file
  done

##-----------------------------------------------------------------

  cat >>$output_file <<_MEOF
    NULL                            
};                                   

#endif /* STATIC_MODULES */            
#endif /* _STATIC_MODULES_H */          
_MEOF
##-----------------------------------------------------------------

])
