/*
 * CalcMySky - a simulator of light scattering in planetary atmospheres
 * Copyright © 2025 Ruslan Kabatsayev
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335, USA.
 */

#include "util.hpp"
#include "../common/util.hpp"
#include <QFile>

QByteArray readFullFile(QString const& filename)
{
    QFile file(filename);
    if(!file.open(QFile::ReadOnly))
        throw DataLoadError{QObject::tr("Failed to open file \"%1\": %2").arg(filename).arg(file.errorString())};
    const auto data=file.readAll();
    if(file.error())
        throw DataLoadError{QObject::tr("Failed to read file \"%1\": %2").arg(filename).arg(file.errorString())};
    return data;
}

void addShaderCode(QOpenGLShaderProgram& program, const QOpenGLShader::ShaderType type,
                   QString const& description, QByteArray sourceCode)
{
    if(!program.addShaderFromSourceCode(type, sourceCode))
        throw DataLoadError{QObject::tr("Failed to compile %1:\n%2").arg(description).arg(program.log())};
}

void link(QOpenGLShaderProgram& program, QString const& description)
{
    if(!program.link())
        throw DataLoadError{QObject::tr("Failed to link %1:\n%2").arg(description).arg(program.log())};
}
