// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/actions/sdk/v2/actions_sdk.proto

package sdk

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Streaming RPC request for WriteDraft.
type WriteDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. List of files sent to the server at a time. This is a list of config files
	// or data files.
	//  1. The first request must be a ConfigFiles.
	//  2. The first request must have a ConfigFile with 'settings'.
	//  3. The first request must have a ConfigFile with 'manifest'.
	//  4. The webhook ConfigFile corresponding to inline cloud function must be
	//     streamed before the DataFile corresponding to its source code.
	Files *Files `protobuf:"bytes,4,opt,name=files,proto3" json:"files,omitempty"`
}

func (x *WriteDraftRequest) Reset() {
	*x = WriteDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteDraftRequest) ProtoMessage() {}

func (x *WriteDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteDraftRequest.ProtoReflect.Descriptor instead.
func (*WriteDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{0}
}

func (x *WriteDraftRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *WriteDraftRequest) GetFiles() *Files {
	if x != nil {
		return x.Files
	}
	return nil
}

// Definition of draft resource.
type Draft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the draft in the following format.
	// `projects/{project}/draft`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Validation results associated with the project draft content. Note that
	// WriteDraft updates the draft despite the warnings as warnings are not draft
	// blocking.
	ValidationResults *ValidationResults `protobuf:"bytes,2,opt,name=validation_results,json=validationResults,proto3" json:"validation_results,omitempty"`
}

func (x *Draft) Reset() {
	*x = Draft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Draft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Draft) ProtoMessage() {}

func (x *Draft) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Draft.ProtoReflect.Descriptor instead.
func (*Draft) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{1}
}

func (x *Draft) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Draft) GetValidationResults() *ValidationResults {
	if x != nil {
		return x.ValidationResults
	}
	return nil
}

// Streaming RPC request for WritePreview.
type WritePreviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Data source used to created the preview.
	//
	// Types that are assignable to Source:
	//
	//	*WritePreviewRequest_Files
	//	*WritePreviewRequest_Draft
	//	*WritePreviewRequest_SubmittedVersion
	Source isWritePreviewRequest_Source `protobuf_oneof:"source"`
	// Required. The settings for updating the user's preview.
	PreviewSettings *WritePreviewRequest_PreviewSettings `protobuf:"bytes,4,opt,name=preview_settings,json=previewSettings,proto3" json:"preview_settings,omitempty"`
}

func (x *WritePreviewRequest) Reset() {
	*x = WritePreviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest) ProtoMessage() {}

func (x *WritePreviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{2}
}

func (x *WritePreviewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *WritePreviewRequest) GetSource() isWritePreviewRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *WritePreviewRequest) GetFiles() *Files {
	if x, ok := x.GetSource().(*WritePreviewRequest_Files); ok {
		return x.Files
	}
	return nil
}

func (x *WritePreviewRequest) GetDraft() *WritePreviewRequest_ContentFromDraft {
	if x, ok := x.GetSource().(*WritePreviewRequest_Draft); ok {
		return x.Draft
	}
	return nil
}

func (x *WritePreviewRequest) GetSubmittedVersion() *WritePreviewRequest_ContentFromSubmittedVersion {
	if x, ok := x.GetSource().(*WritePreviewRequest_SubmittedVersion); ok {
		return x.SubmittedVersion
	}
	return nil
}

func (x *WritePreviewRequest) GetPreviewSettings() *WritePreviewRequest_PreviewSettings {
	if x != nil {
		return x.PreviewSettings
	}
	return nil
}

type isWritePreviewRequest_Source interface {
	isWritePreviewRequest_Source()
}

type WritePreviewRequest_Files struct {
	// List of files sent to the server at a time. This is a list of config
	// files or data files.
	//  1. The first request must be a ConfigFiles.
	//  2. The first request must have a ConfigFile with 'settings'.
	//  3. The first request must have a ConfigFile with 'manifest'.
	//  4. The webhook ConfigFile corresponding to inline cloud function must be
	//     streamed before the DataFile corresponding to its source code.
	Files *Files `protobuf:"bytes,5,opt,name=files,proto3,oneof"`
}

type WritePreviewRequest_Draft struct {
	// Content sourced from the project draft.
	Draft *WritePreviewRequest_ContentFromDraft `protobuf:"bytes,6,opt,name=draft,proto3,oneof"`
}

type WritePreviewRequest_SubmittedVersion struct {
	// Content sourced from the an exiting version.
	SubmittedVersion *WritePreviewRequest_ContentFromSubmittedVersion `protobuf:"bytes,7,opt,name=submitted_version,json=submittedVersion,proto3,oneof"`
}

func (*WritePreviewRequest_Files) isWritePreviewRequest_Source() {}

func (*WritePreviewRequest_Draft) isWritePreviewRequest_Source() {}

func (*WritePreviewRequest_SubmittedVersion) isWritePreviewRequest_Source() {}

// Definition of preview resource.
type Preview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the preview.
	// Format: `projects/{project}/preview`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Validation results associated with the user project preview content.
	ValidationResults *ValidationResults `protobuf:"bytes,2,opt,name=validation_results,json=validationResults,proto3" json:"validation_results,omitempty"`
	// The simulator URL to test the user preview.
	SimulatorUrl string `protobuf:"bytes,3,opt,name=simulator_url,json=simulatorUrl,proto3" json:"simulator_url,omitempty"`
}

func (x *Preview) Reset() {
	*x = Preview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Preview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preview) ProtoMessage() {}

func (x *Preview) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preview.ProtoReflect.Descriptor instead.
func (*Preview) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{3}
}

func (x *Preview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Preview) GetValidationResults() *ValidationResults {
	if x != nil {
		return x.ValidationResults
	}
	return nil
}

func (x *Preview) GetSimulatorUrl() string {
	if x != nil {
		return x.SimulatorUrl
	}
	return ""
}

// Streaming RPC request for CreateVersion.
type CreateVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. List of files sent to the server at a time. This is a list of config files
	// or data files.
	//  1. The first request must be a ConfigFiles.
	//  2. The first request must have a ConfigFile with 'settings'.
	//  3. The first request must have a ConfigFile with 'manifest'.
	//  4. The webhook ConfigFile corresponding to inline cloud function must be
	//     streamed before the DataFile corresponding to its source code.
	Files *Files `protobuf:"bytes,5,opt,name=files,proto3" json:"files,omitempty"`
	// Optional. The release channel to deploy the version, if specified. The supported
	// built in release channels are actions.channels.Production,
	// actions.channels.ClosedBeta, actions.channels.Alpha.
	// .
	ReleaseChannel string `protobuf:"bytes,4,opt,name=release_channel,json=releaseChannel,proto3" json:"release_channel,omitempty"`
}

func (x *CreateVersionRequest) Reset() {
	*x = CreateVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVersionRequest) ProtoMessage() {}

func (x *CreateVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVersionRequest.ProtoReflect.Descriptor instead.
func (*CreateVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{4}
}

func (x *CreateVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVersionRequest) GetFiles() *Files {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *CreateVersionRequest) GetReleaseChannel() string {
	if x != nil {
		return x.ReleaseChannel
	}
	return ""
}

// RPC request for ReadDraft.
type ReadDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource in the format `projects/{project}/draft`. The
	// `{project}` is the cloud project ID associated with the project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of the crypto key used to encrypt the account linking OAuth
	// client secret. If not specified, the primary key version is used for
	// encryption. Only relevant for projects with account linking with client
	// secret.
	ClientSecretEncryptionKeyVersion string `protobuf:"bytes,2,opt,name=client_secret_encryption_key_version,json=clientSecretEncryptionKeyVersion,proto3" json:"client_secret_encryption_key_version,omitempty"`
}

func (x *ReadDraftRequest) Reset() {
	*x = ReadDraftRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDraftRequest) ProtoMessage() {}

func (x *ReadDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDraftRequest.ProtoReflect.Descriptor instead.
func (*ReadDraftRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{5}
}

func (x *ReadDraftRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReadDraftRequest) GetClientSecretEncryptionKeyVersion() string {
	if x != nil {
		return x.ClientSecretEncryptionKeyVersion
	}
	return ""
}

// Streaming RPC response for ReadDraft.
type ReadDraftResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of files sent from the server at a time.
	Files *Files `protobuf:"bytes,3,opt,name=files,proto3" json:"files,omitempty"`
}

func (x *ReadDraftResponse) Reset() {
	*x = ReadDraftResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadDraftResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDraftResponse) ProtoMessage() {}

func (x *ReadDraftResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDraftResponse.ProtoReflect.Descriptor instead.
func (*ReadDraftResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{6}
}

func (x *ReadDraftResponse) GetFiles() *Files {
	if x != nil {
		return x.Files
	}
	return nil
}

// RPC request for ReadVersion.
type ReadVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the version resource in the format
	// `projects/{project}/versions/{version}`. `{project}` is the
	// cloud project ID associated with the project, `{version}` is the
	// identifier of the version being read.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of the crypto key used to encrypt the account linking OAuth
	// client secret. If not specified, the primary key version is used for
	// encryption. Only relevant for projects with account linking with client
	// secret.
	ClientSecretEncryptionKeyVersion string `protobuf:"bytes,2,opt,name=client_secret_encryption_key_version,json=clientSecretEncryptionKeyVersion,proto3" json:"client_secret_encryption_key_version,omitempty"`
}

func (x *ReadVersionRequest) Reset() {
	*x = ReadVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadVersionRequest) ProtoMessage() {}

func (x *ReadVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadVersionRequest.ProtoReflect.Descriptor instead.
func (*ReadVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{7}
}

func (x *ReadVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReadVersionRequest) GetClientSecretEncryptionKeyVersion() string {
	if x != nil {
		return x.ClientSecretEncryptionKeyVersion
	}
	return ""
}

// Streaming RPC response for ReadVersion.
type ReadVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of files sent from the server at a time.
	Files *Files `protobuf:"bytes,1,opt,name=files,proto3" json:"files,omitempty"`
}

func (x *ReadVersionResponse) Reset() {
	*x = ReadVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadVersionResponse) ProtoMessage() {}

func (x *ReadVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadVersionResponse.ProtoReflect.Descriptor instead.
func (*ReadVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{8}
}

func (x *ReadVersionResponse) GetFiles() *Files {
	if x != nil {
		return x.Files
	}
	return nil
}

// RPC request for EncryptSecret.
type EncryptSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account linking client secret plaintext.
	ClientSecret string `protobuf:"bytes,1,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
}

func (x *EncryptSecretRequest) Reset() {
	*x = EncryptSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptSecretRequest) ProtoMessage() {}

func (x *EncryptSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptSecretRequest.ProtoReflect.Descriptor instead.
func (*EncryptSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{9}
}

func (x *EncryptSecretRequest) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

// RPC response for EncryptSecret.
type EncryptSecretResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the encrypted account linking client secret and the key version
	// used to encrypt the secret.
	AccountLinkingSecret *AccountLinkingSecret `protobuf:"bytes,1,opt,name=account_linking_secret,json=accountLinkingSecret,proto3" json:"account_linking_secret,omitempty"`
}

func (x *EncryptSecretResponse) Reset() {
	*x = EncryptSecretResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptSecretResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptSecretResponse) ProtoMessage() {}

func (x *EncryptSecretResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptSecretResponse.ProtoReflect.Descriptor instead.
func (*EncryptSecretResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{10}
}

func (x *EncryptSecretResponse) GetAccountLinkingSecret() *AccountLinkingSecret {
	if x != nil {
		return x.AccountLinkingSecret
	}
	return nil
}

// RPC request for DecryptSecret.
type DecryptSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account linking client secret ciphertext.
	EncryptedClientSecret []byte `protobuf:"bytes,1,opt,name=encrypted_client_secret,json=encryptedClientSecret,proto3" json:"encrypted_client_secret,omitempty"`
}

func (x *DecryptSecretRequest) Reset() {
	*x = DecryptSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecryptSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecryptSecretRequest) ProtoMessage() {}

func (x *DecryptSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecryptSecretRequest.ProtoReflect.Descriptor instead.
func (*DecryptSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{11}
}

func (x *DecryptSecretRequest) GetEncryptedClientSecret() []byte {
	if x != nil {
		return x.EncryptedClientSecret
	}
	return nil
}

// RPC response for DecryptSecret.
type DecryptSecretResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account linking client secret plaintext.
	ClientSecret string `protobuf:"bytes,1,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
}

func (x *DecryptSecretResponse) Reset() {
	*x = DecryptSecretResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecryptSecretResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecryptSecretResponse) ProtoMessage() {}

func (x *DecryptSecretResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecryptSecretResponse.ProtoReflect.Descriptor instead.
func (*DecryptSecretResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{12}
}

func (x *DecryptSecretResponse) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

// RPC request for ListSampleProjects.
type ListSampleProjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of sample projects to return. The service may return
	// fewer than this value.
	// If unspecified, at most 1000 sample projects will be returned. Values above
	// 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous 'ListSampleProjects' call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSampleProjectsRequest) Reset() {
	*x = ListSampleProjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSampleProjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleProjectsRequest) ProtoMessage() {}

func (x *ListSampleProjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleProjectsRequest.ProtoReflect.Descriptor instead.
func (*ListSampleProjectsRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{13}
}

func (x *ListSampleProjectsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSampleProjectsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// RPC response for ListSampleProjects.
type ListSampleProjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of sample projects supported.
	SampleProjects []*SampleProject `protobuf:"bytes,1,rep,name=sample_projects,json=sampleProjects,proto3" json:"sample_projects,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSampleProjectsResponse) Reset() {
	*x = ListSampleProjectsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSampleProjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleProjectsResponse) ProtoMessage() {}

func (x *ListSampleProjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleProjectsResponse.ProtoReflect.Descriptor instead.
func (*ListSampleProjectsResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{14}
}

func (x *ListSampleProjectsResponse) GetSampleProjects() []*SampleProject {
	if x != nil {
		return x.SampleProjects
	}
	return nil
}

func (x *ListSampleProjectsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Definition of sample project resource.
type SampleProject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the sample project.
	// Format: `sampleProjects/{sample_project}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The URL to the zip file where the sample is hosted.
	HostedUrl string `protobuf:"bytes,2,opt,name=hosted_url,json=hostedUrl,proto3" json:"hosted_url,omitempty"`
	// The description of the sample project.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *SampleProject) Reset() {
	*x = SampleProject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleProject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleProject) ProtoMessage() {}

func (x *SampleProject) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleProject.ProtoReflect.Descriptor instead.
func (*SampleProject) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{15}
}

func (x *SampleProject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SampleProject) GetHostedUrl() string {
	if x != nil {
		return x.HostedUrl
	}
	return ""
}

func (x *SampleProject) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// RPC request for listing release channels
type ListReleaseChannelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of release channels to return. The service may return
	// fewer than this value. If unspecified, at most 50 release channels will be
	// returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListReleaseChannels` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListReleaseChannels`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReleaseChannelsRequest) Reset() {
	*x = ListReleaseChannelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleaseChannelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleaseChannelsRequest) ProtoMessage() {}

func (x *ListReleaseChannelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleaseChannelsRequest.ProtoReflect.Descriptor instead.
func (*ListReleaseChannelsRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{16}
}

func (x *ListReleaseChannelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReleaseChannelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReleaseChannelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// RPC response for listing release channels
type ListReleaseChannelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the release channels for the given project id.
	ReleaseChannels []*ReleaseChannel `protobuf:"bytes,1,rep,name=release_channels,json=releaseChannels,proto3" json:"release_channels,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReleaseChannelsResponse) Reset() {
	*x = ListReleaseChannelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleaseChannelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleaseChannelsResponse) ProtoMessage() {}

func (x *ListReleaseChannelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleaseChannelsResponse.ProtoReflect.Descriptor instead.
func (*ListReleaseChannelsResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{17}
}

func (x *ListReleaseChannelsResponse) GetReleaseChannels() []*ReleaseChannel {
	if x != nil {
		return x.ReleaseChannels
	}
	return nil
}

func (x *ListReleaseChannelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// RPC request for listing versions
type ListVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource in the format `projects/{project}`. The
	// `{project}` is the cloud project ID associated with the project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of versions to return. The service may return
	// fewer than this value. If unspecified, at most 50 versions will be
	// returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListVersions` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListVersions`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVersionsRequest) Reset() {
	*x = ListVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVersionsRequest) ProtoMessage() {}

func (x *ListVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{18}
}

func (x *ListVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// RPC response for listing versions
type ListVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the versions for the given project id.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVersionsResponse) Reset() {
	*x = ListVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVersionsResponse) ProtoMessage() {}

func (x *ListVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{19}
}

func (x *ListVersionsResponse) GetVersions() []*Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *ListVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Indicates the preview content will be coming from the Draft.
type WritePreviewRequest_ContentFromDraft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WritePreviewRequest_ContentFromDraft) Reset() {
	*x = WritePreviewRequest_ContentFromDraft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_ContentFromDraft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_ContentFromDraft) ProtoMessage() {}

func (x *WritePreviewRequest_ContentFromDraft) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_ContentFromDraft.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_ContentFromDraft) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{2, 0}
}

// Indicates the preview content will be coming from an exiting version.
type WritePreviewRequest_ContentFromSubmittedVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Submitted version of the project to be used to create a preview.
	// Format: `projects/{project}/versions/{version}`
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) Reset() {
	*x = WritePreviewRequest_ContentFromSubmittedVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_ContentFromSubmittedVersion) ProtoMessage() {}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_ContentFromSubmittedVersion.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_ContentFromSubmittedVersion) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{2, 1}
}

func (x *WritePreviewRequest_ContentFromSubmittedVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Settings for updating the preview.
type WritePreviewRequest_PreviewSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether or not to run certain operations, such as transactions,
	// in sandbox mode. By default, preview requests run these operations in
	// sandbox mode. In other words, the default value for `sandbox` is `true`.
	Sandbox *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=sandbox,proto3" json:"sandbox,omitempty"`
}

func (x *WritePreviewRequest_PreviewSettings) Reset() {
	*x = WritePreviewRequest_PreviewSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePreviewRequest_PreviewSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePreviewRequest_PreviewSettings) ProtoMessage() {}

func (x *WritePreviewRequest_PreviewSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePreviewRequest_PreviewSettings.ProtoReflect.Descriptor instead.
func (*WritePreviewRequest_PreviewSettings) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP(), []int{2, 2}
}

func (x *WritePreviewRequest_PreviewSettings) GetSandbox() *wrapperspb.BoolValue {
	if x != nil {
		return x.Sandbox
	}
	return nil
}

var File_google_actions_sdk_v2_actions_sdk_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_actions_sdk_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x73, 0x64, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x01, 0x0a,
	0x11, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x12, 0x1c, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x37, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x05, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x11, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x3a, 0x3b, 0xea, 0x41, 0x38, 0x0a, 0x1c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x12, 0x18, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x22, 0x8b, 0x05,
	0x0a, 0x13, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x05, 0x64,
	0x72, 0x61, 0x66, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72,
	0x6f, 0x6d, 0x44, 0x72, 0x61, 0x66, 0x74, 0x48, 0x00, 0x52, 0x05, 0x64, 0x72, 0x61, 0x66, 0x74,
	0x12, 0x75, 0x0a, 0x11, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x1a, 0x12, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72,
	0x6f, 0x6d, 0x44, 0x72, 0x61, 0x66, 0x74, 0x1a, 0x5f, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x47, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x07, 0x73,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x07,
	0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x72, 0x6c, 0x3a, 0x4a, 0xea, 0x41, 0x47, 0x0a, 0x1e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x25,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x7d, 0x22, 0xbd, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37,
	0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x80, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x61, 0x64, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x24, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x11, 0x52, 0x65, 0x61, 0x64,
	0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x61, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x53, 0x0a, 0x24, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x64, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x22, 0x40, 0x0a, 0x14, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x22, 0x7a, 0x0a, 0x15, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x16,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x14, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22,
	0x53, 0x0a, 0x14, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x22, 0x3c, 0x0a, 0x15, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x22, 0x61, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x01, 0x0a, 0x0d,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x4a, 0xea, 0x41, 0x47, 0x0a, 0x24, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x22, 0x9f,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x97, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x50, 0x0a, 0x10, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x91, 0x01, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7a,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x85, 0x0c, 0x0a, 0x0a, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x64, 0x6b, 0x12, 0x86, 0x01, 0x0a, 0x0a, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x61, 0x66, 0x74,
	0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x22, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0x28, 0x01, 0x12, 0x8e, 0x01, 0x0a, 0x0c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22,
	0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a, 0x01,
	0x2a, 0x28, 0x01, 0x12, 0x92, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x22, 0x27, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x28, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x61,
	0x64, 0x44, 0x72, 0x61, 0x66, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x44, 0x72, 0x61, 0x66,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x25, 0x22, 0x20, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x7d, 0x3a, 0x72,
	0x65, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x30, 0x01, 0x12, 0x98, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x61,
	0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x01,
	0x2a, 0x30, 0x01, 0x12, 0x88, 0x01, 0x0a, 0x0d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x1c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x22, 0x11, 0x2f, 0x76, 0x32, 0x3a, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x88,
	0x01, 0x0a, 0x0d, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1c, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x16, 0x22, 0x11, 0x2f, 0x76, 0x32, 0x3a, 0x64, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x95, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f,
	0x76, 0x32, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x12, 0xb6, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x38, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x29, 0x12, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x9a, 0x01, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x19, 0xca, 0x41, 0x16, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x42, 0x68, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x42,
	0x0f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x64, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x3b, 0x73, 0x64, 0x6b, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescData = file_google_actions_sdk_v2_actions_sdk_proto_rawDesc
)

func file_google_actions_sdk_v2_actions_sdk_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_actions_sdk_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_actions_sdk_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_actions_sdk_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_actions_sdk_proto_rawDescData
}

var file_google_actions_sdk_v2_actions_sdk_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_actions_sdk_v2_actions_sdk_proto_goTypes = []interface{}{
	(*WriteDraftRequest)(nil),                               // 0: google.actions.sdk.v2.WriteDraftRequest
	(*Draft)(nil),                                           // 1: google.actions.sdk.v2.Draft
	(*WritePreviewRequest)(nil),                             // 2: google.actions.sdk.v2.WritePreviewRequest
	(*Preview)(nil),                                         // 3: google.actions.sdk.v2.Preview
	(*CreateVersionRequest)(nil),                            // 4: google.actions.sdk.v2.CreateVersionRequest
	(*ReadDraftRequest)(nil),                                // 5: google.actions.sdk.v2.ReadDraftRequest
	(*ReadDraftResponse)(nil),                               // 6: google.actions.sdk.v2.ReadDraftResponse
	(*ReadVersionRequest)(nil),                              // 7: google.actions.sdk.v2.ReadVersionRequest
	(*ReadVersionResponse)(nil),                             // 8: google.actions.sdk.v2.ReadVersionResponse
	(*EncryptSecretRequest)(nil),                            // 9: google.actions.sdk.v2.EncryptSecretRequest
	(*EncryptSecretResponse)(nil),                           // 10: google.actions.sdk.v2.EncryptSecretResponse
	(*DecryptSecretRequest)(nil),                            // 11: google.actions.sdk.v2.DecryptSecretRequest
	(*DecryptSecretResponse)(nil),                           // 12: google.actions.sdk.v2.DecryptSecretResponse
	(*ListSampleProjectsRequest)(nil),                       // 13: google.actions.sdk.v2.ListSampleProjectsRequest
	(*ListSampleProjectsResponse)(nil),                      // 14: google.actions.sdk.v2.ListSampleProjectsResponse
	(*SampleProject)(nil),                                   // 15: google.actions.sdk.v2.SampleProject
	(*ListReleaseChannelsRequest)(nil),                      // 16: google.actions.sdk.v2.ListReleaseChannelsRequest
	(*ListReleaseChannelsResponse)(nil),                     // 17: google.actions.sdk.v2.ListReleaseChannelsResponse
	(*ListVersionsRequest)(nil),                             // 18: google.actions.sdk.v2.ListVersionsRequest
	(*ListVersionsResponse)(nil),                            // 19: google.actions.sdk.v2.ListVersionsResponse
	(*WritePreviewRequest_ContentFromDraft)(nil),            // 20: google.actions.sdk.v2.WritePreviewRequest.ContentFromDraft
	(*WritePreviewRequest_ContentFromSubmittedVersion)(nil), // 21: google.actions.sdk.v2.WritePreviewRequest.ContentFromSubmittedVersion
	(*WritePreviewRequest_PreviewSettings)(nil),             // 22: google.actions.sdk.v2.WritePreviewRequest.PreviewSettings
	(*Files)(nil),                                           // 23: google.actions.sdk.v2.Files
	(*ValidationResults)(nil),                               // 24: google.actions.sdk.v2.ValidationResults
	(*AccountLinkingSecret)(nil),                            // 25: google.actions.sdk.v2.AccountLinkingSecret
	(*ReleaseChannel)(nil),                                  // 26: google.actions.sdk.v2.ReleaseChannel
	(*Version)(nil),                                         // 27: google.actions.sdk.v2.Version
	(*wrapperspb.BoolValue)(nil),                            // 28: google.protobuf.BoolValue
}
var file_google_actions_sdk_v2_actions_sdk_proto_depIdxs = []int32{
	23, // 0: google.actions.sdk.v2.WriteDraftRequest.files:type_name -> google.actions.sdk.v2.Files
	24, // 1: google.actions.sdk.v2.Draft.validation_results:type_name -> google.actions.sdk.v2.ValidationResults
	23, // 2: google.actions.sdk.v2.WritePreviewRequest.files:type_name -> google.actions.sdk.v2.Files
	20, // 3: google.actions.sdk.v2.WritePreviewRequest.draft:type_name -> google.actions.sdk.v2.WritePreviewRequest.ContentFromDraft
	21, // 4: google.actions.sdk.v2.WritePreviewRequest.submitted_version:type_name -> google.actions.sdk.v2.WritePreviewRequest.ContentFromSubmittedVersion
	22, // 5: google.actions.sdk.v2.WritePreviewRequest.preview_settings:type_name -> google.actions.sdk.v2.WritePreviewRequest.PreviewSettings
	24, // 6: google.actions.sdk.v2.Preview.validation_results:type_name -> google.actions.sdk.v2.ValidationResults
	23, // 7: google.actions.sdk.v2.CreateVersionRequest.files:type_name -> google.actions.sdk.v2.Files
	23, // 8: google.actions.sdk.v2.ReadDraftResponse.files:type_name -> google.actions.sdk.v2.Files
	23, // 9: google.actions.sdk.v2.ReadVersionResponse.files:type_name -> google.actions.sdk.v2.Files
	25, // 10: google.actions.sdk.v2.EncryptSecretResponse.account_linking_secret:type_name -> google.actions.sdk.v2.AccountLinkingSecret
	15, // 11: google.actions.sdk.v2.ListSampleProjectsResponse.sample_projects:type_name -> google.actions.sdk.v2.SampleProject
	26, // 12: google.actions.sdk.v2.ListReleaseChannelsResponse.release_channels:type_name -> google.actions.sdk.v2.ReleaseChannel
	27, // 13: google.actions.sdk.v2.ListVersionsResponse.versions:type_name -> google.actions.sdk.v2.Version
	28, // 14: google.actions.sdk.v2.WritePreviewRequest.PreviewSettings.sandbox:type_name -> google.protobuf.BoolValue
	0,  // 15: google.actions.sdk.v2.ActionsSdk.WriteDraft:input_type -> google.actions.sdk.v2.WriteDraftRequest
	2,  // 16: google.actions.sdk.v2.ActionsSdk.WritePreview:input_type -> google.actions.sdk.v2.WritePreviewRequest
	4,  // 17: google.actions.sdk.v2.ActionsSdk.CreateVersion:input_type -> google.actions.sdk.v2.CreateVersionRequest
	5,  // 18: google.actions.sdk.v2.ActionsSdk.ReadDraft:input_type -> google.actions.sdk.v2.ReadDraftRequest
	7,  // 19: google.actions.sdk.v2.ActionsSdk.ReadVersion:input_type -> google.actions.sdk.v2.ReadVersionRequest
	9,  // 20: google.actions.sdk.v2.ActionsSdk.EncryptSecret:input_type -> google.actions.sdk.v2.EncryptSecretRequest
	11, // 21: google.actions.sdk.v2.ActionsSdk.DecryptSecret:input_type -> google.actions.sdk.v2.DecryptSecretRequest
	13, // 22: google.actions.sdk.v2.ActionsSdk.ListSampleProjects:input_type -> google.actions.sdk.v2.ListSampleProjectsRequest
	16, // 23: google.actions.sdk.v2.ActionsSdk.ListReleaseChannels:input_type -> google.actions.sdk.v2.ListReleaseChannelsRequest
	18, // 24: google.actions.sdk.v2.ActionsSdk.ListVersions:input_type -> google.actions.sdk.v2.ListVersionsRequest
	1,  // 25: google.actions.sdk.v2.ActionsSdk.WriteDraft:output_type -> google.actions.sdk.v2.Draft
	3,  // 26: google.actions.sdk.v2.ActionsSdk.WritePreview:output_type -> google.actions.sdk.v2.Preview
	27, // 27: google.actions.sdk.v2.ActionsSdk.CreateVersion:output_type -> google.actions.sdk.v2.Version
	6,  // 28: google.actions.sdk.v2.ActionsSdk.ReadDraft:output_type -> google.actions.sdk.v2.ReadDraftResponse
	8,  // 29: google.actions.sdk.v2.ActionsSdk.ReadVersion:output_type -> google.actions.sdk.v2.ReadVersionResponse
	10, // 30: google.actions.sdk.v2.ActionsSdk.EncryptSecret:output_type -> google.actions.sdk.v2.EncryptSecretResponse
	12, // 31: google.actions.sdk.v2.ActionsSdk.DecryptSecret:output_type -> google.actions.sdk.v2.DecryptSecretResponse
	14, // 32: google.actions.sdk.v2.ActionsSdk.ListSampleProjects:output_type -> google.actions.sdk.v2.ListSampleProjectsResponse
	17, // 33: google.actions.sdk.v2.ActionsSdk.ListReleaseChannels:output_type -> google.actions.sdk.v2.ListReleaseChannelsResponse
	19, // 34: google.actions.sdk.v2.ActionsSdk.ListVersions:output_type -> google.actions.sdk.v2.ListVersionsResponse
	25, // [25:35] is the sub-list for method output_type
	15, // [15:25] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_actions_sdk_proto_init() }
func file_google_actions_sdk_v2_actions_sdk_proto_init() {
	if File_google_actions_sdk_v2_actions_sdk_proto != nil {
		return
	}
	file_google_actions_sdk_v2_account_linking_secret_proto_init()
	file_google_actions_sdk_v2_files_proto_init()
	file_google_actions_sdk_v2_release_channel_proto_init()
	file_google_actions_sdk_v2_validation_results_proto_init()
	file_google_actions_sdk_v2_version_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Draft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Preview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadDraftRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadDraftResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptSecretResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecryptSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecryptSecretResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSampleProjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSampleProjectsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleProject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleaseChannelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleaseChannelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_ContentFromDraft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_ContentFromSubmittedVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePreviewRequest_PreviewSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_actions_sdk_v2_actions_sdk_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*WritePreviewRequest_Files)(nil),
		(*WritePreviewRequest_Draft)(nil),
		(*WritePreviewRequest_SubmittedVersion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_actions_sdk_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_actions_sdk_v2_actions_sdk_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_actions_sdk_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_actions_sdk_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_actions_sdk_proto = out.File
	file_google_actions_sdk_v2_actions_sdk_proto_rawDesc = nil
	file_google_actions_sdk_v2_actions_sdk_proto_goTypes = nil
	file_google_actions_sdk_v2_actions_sdk_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ActionsSdkClient is the client API for ActionsSdk service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ActionsSdkClient interface {
	// Updates the project draft based on the model.
	WriteDraft(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WriteDraftClient, error)
	// Updates the user's project preview based on the model.
	WritePreview(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WritePreviewClient, error)
	// Creates a project version based on the model and triggers deployment to the
	// specified release channel, if specified.
	CreateVersion(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_CreateVersionClient, error)
	// Reads the entire content of the project draft.
	ReadDraft(ctx context.Context, in *ReadDraftRequest, opts ...grpc.CallOption) (ActionsSdk_ReadDraftClient, error)
	// Reads the entire content of a project version.
	ReadVersion(ctx context.Context, in *ReadVersionRequest, opts ...grpc.CallOption) (ActionsSdk_ReadVersionClient, error)
	// Encrypts the OAuth client secret used in account linking flows.
	// This can be used to encrypt the client secret for the first time (e.g.
	// before the first push or after changing the client secret) or to re-encrypt
	// a client secret using the latest primary key version (considering key
	// rotation).
	EncryptSecret(ctx context.Context, in *EncryptSecretRequest, opts ...grpc.CallOption) (*EncryptSecretResponse, error)
	// Decrypts the OAuth client secret used in account linking flows.
	// This can be used to view the client secret (e.g. after pulling a project).
	DecryptSecret(ctx context.Context, in *DecryptSecretRequest, opts ...grpc.CallOption) (*DecryptSecretResponse, error)
	// Lists all the sample projects supported by the gactions CLI.
	ListSampleProjects(ctx context.Context, in *ListSampleProjectsRequest, opts ...grpc.CallOption) (*ListSampleProjectsResponse, error)
	// Lists all release channels and corresponding versions, if any.
	ListReleaseChannels(ctx context.Context, in *ListReleaseChannelsRequest, opts ...grpc.CallOption) (*ListReleaseChannelsResponse, error)
	// Lists all versions and their current states.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
}

type actionsSdkClient struct {
	cc grpc.ClientConnInterface
}

func NewActionsSdkClient(cc grpc.ClientConnInterface) ActionsSdkClient {
	return &actionsSdkClient{cc}
}

func (c *actionsSdkClient) WriteDraft(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WriteDraftClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[0], "/google.actions.sdk.v2.ActionsSdk/WriteDraft", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkWriteDraftClient{stream}
	return x, nil
}

type ActionsSdk_WriteDraftClient interface {
	Send(*WriteDraftRequest) error
	CloseAndRecv() (*Draft, error)
	grpc.ClientStream
}

type actionsSdkWriteDraftClient struct {
	grpc.ClientStream
}

func (x *actionsSdkWriteDraftClient) Send(m *WriteDraftRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *actionsSdkWriteDraftClient) CloseAndRecv() (*Draft, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Draft)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *actionsSdkClient) WritePreview(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_WritePreviewClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[1], "/google.actions.sdk.v2.ActionsSdk/WritePreview", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkWritePreviewClient{stream}
	return x, nil
}

type ActionsSdk_WritePreviewClient interface {
	Send(*WritePreviewRequest) error
	CloseAndRecv() (*Preview, error)
	grpc.ClientStream
}

type actionsSdkWritePreviewClient struct {
	grpc.ClientStream
}

func (x *actionsSdkWritePreviewClient) Send(m *WritePreviewRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *actionsSdkWritePreviewClient) CloseAndRecv() (*Preview, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Preview)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *actionsSdkClient) CreateVersion(ctx context.Context, opts ...grpc.CallOption) (ActionsSdk_CreateVersionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[2], "/google.actions.sdk.v2.ActionsSdk/CreateVersion", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkCreateVersionClient{stream}
	return x, nil
}

type ActionsSdk_CreateVersionClient interface {
	Send(*CreateVersionRequest) error
	CloseAndRecv() (*Version, error)
	grpc.ClientStream
}

type actionsSdkCreateVersionClient struct {
	grpc.ClientStream
}

func (x *actionsSdkCreateVersionClient) Send(m *CreateVersionRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *actionsSdkCreateVersionClient) CloseAndRecv() (*Version, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Version)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *actionsSdkClient) ReadDraft(ctx context.Context, in *ReadDraftRequest, opts ...grpc.CallOption) (ActionsSdk_ReadDraftClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[3], "/google.actions.sdk.v2.ActionsSdk/ReadDraft", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkReadDraftClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ActionsSdk_ReadDraftClient interface {
	Recv() (*ReadDraftResponse, error)
	grpc.ClientStream
}

type actionsSdkReadDraftClient struct {
	grpc.ClientStream
}

func (x *actionsSdkReadDraftClient) Recv() (*ReadDraftResponse, error) {
	m := new(ReadDraftResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *actionsSdkClient) ReadVersion(ctx context.Context, in *ReadVersionRequest, opts ...grpc.CallOption) (ActionsSdk_ReadVersionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ActionsSdk_serviceDesc.Streams[4], "/google.actions.sdk.v2.ActionsSdk/ReadVersion", opts...)
	if err != nil {
		return nil, err
	}
	x := &actionsSdkReadVersionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ActionsSdk_ReadVersionClient interface {
	Recv() (*ReadVersionResponse, error)
	grpc.ClientStream
}

type actionsSdkReadVersionClient struct {
	grpc.ClientStream
}

func (x *actionsSdkReadVersionClient) Recv() (*ReadVersionResponse, error) {
	m := new(ReadVersionResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *actionsSdkClient) EncryptSecret(ctx context.Context, in *EncryptSecretRequest, opts ...grpc.CallOption) (*EncryptSecretResponse, error) {
	out := new(EncryptSecretResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsSdk/EncryptSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsSdkClient) DecryptSecret(ctx context.Context, in *DecryptSecretRequest, opts ...grpc.CallOption) (*DecryptSecretResponse, error) {
	out := new(DecryptSecretResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsSdk/DecryptSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsSdkClient) ListSampleProjects(ctx context.Context, in *ListSampleProjectsRequest, opts ...grpc.CallOption) (*ListSampleProjectsResponse, error) {
	out := new(ListSampleProjectsResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsSdk/ListSampleProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsSdkClient) ListReleaseChannels(ctx context.Context, in *ListReleaseChannelsRequest, opts ...grpc.CallOption) (*ListReleaseChannelsResponse, error) {
	out := new(ListReleaseChannelsResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsSdk/ListReleaseChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsSdkClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsSdk/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ActionsSdkServer is the server API for ActionsSdk service.
type ActionsSdkServer interface {
	// Updates the project draft based on the model.
	WriteDraft(ActionsSdk_WriteDraftServer) error
	// Updates the user's project preview based on the model.
	WritePreview(ActionsSdk_WritePreviewServer) error
	// Creates a project version based on the model and triggers deployment to the
	// specified release channel, if specified.
	CreateVersion(ActionsSdk_CreateVersionServer) error
	// Reads the entire content of the project draft.
	ReadDraft(*ReadDraftRequest, ActionsSdk_ReadDraftServer) error
	// Reads the entire content of a project version.
	ReadVersion(*ReadVersionRequest, ActionsSdk_ReadVersionServer) error
	// Encrypts the OAuth client secret used in account linking flows.
	// This can be used to encrypt the client secret for the first time (e.g.
	// before the first push or after changing the client secret) or to re-encrypt
	// a client secret using the latest primary key version (considering key
	// rotation).
	EncryptSecret(context.Context, *EncryptSecretRequest) (*EncryptSecretResponse, error)
	// Decrypts the OAuth client secret used in account linking flows.
	// This can be used to view the client secret (e.g. after pulling a project).
	DecryptSecret(context.Context, *DecryptSecretRequest) (*DecryptSecretResponse, error)
	// Lists all the sample projects supported by the gactions CLI.
	ListSampleProjects(context.Context, *ListSampleProjectsRequest) (*ListSampleProjectsResponse, error)
	// Lists all release channels and corresponding versions, if any.
	ListReleaseChannels(context.Context, *ListReleaseChannelsRequest) (*ListReleaseChannelsResponse, error)
	// Lists all versions and their current states.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
}

// UnimplementedActionsSdkServer can be embedded to have forward compatible implementations.
type UnimplementedActionsSdkServer struct {
}

func (*UnimplementedActionsSdkServer) WriteDraft(ActionsSdk_WriteDraftServer) error {
	return status.Errorf(codes.Unimplemented, "method WriteDraft not implemented")
}
func (*UnimplementedActionsSdkServer) WritePreview(ActionsSdk_WritePreviewServer) error {
	return status.Errorf(codes.Unimplemented, "method WritePreview not implemented")
}
func (*UnimplementedActionsSdkServer) CreateVersion(ActionsSdk_CreateVersionServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateVersion not implemented")
}
func (*UnimplementedActionsSdkServer) ReadDraft(*ReadDraftRequest, ActionsSdk_ReadDraftServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadDraft not implemented")
}
func (*UnimplementedActionsSdkServer) ReadVersion(*ReadVersionRequest, ActionsSdk_ReadVersionServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadVersion not implemented")
}
func (*UnimplementedActionsSdkServer) EncryptSecret(context.Context, *EncryptSecretRequest) (*EncryptSecretResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EncryptSecret not implemented")
}
func (*UnimplementedActionsSdkServer) DecryptSecret(context.Context, *DecryptSecretRequest) (*DecryptSecretResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DecryptSecret not implemented")
}
func (*UnimplementedActionsSdkServer) ListSampleProjects(context.Context, *ListSampleProjectsRequest) (*ListSampleProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSampleProjects not implemented")
}
func (*UnimplementedActionsSdkServer) ListReleaseChannels(context.Context, *ListReleaseChannelsRequest) (*ListReleaseChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleaseChannels not implemented")
}
func (*UnimplementedActionsSdkServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}

func RegisterActionsSdkServer(s *grpc.Server, srv ActionsSdkServer) {
	s.RegisterService(&_ActionsSdk_serviceDesc, srv)
}

func _ActionsSdk_WriteDraft_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ActionsSdkServer).WriteDraft(&actionsSdkWriteDraftServer{stream})
}

type ActionsSdk_WriteDraftServer interface {
	SendAndClose(*Draft) error
	Recv() (*WriteDraftRequest, error)
	grpc.ServerStream
}

type actionsSdkWriteDraftServer struct {
	grpc.ServerStream
}

func (x *actionsSdkWriteDraftServer) SendAndClose(m *Draft) error {
	return x.ServerStream.SendMsg(m)
}

func (x *actionsSdkWriteDraftServer) Recv() (*WriteDraftRequest, error) {
	m := new(WriteDraftRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ActionsSdk_WritePreview_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ActionsSdkServer).WritePreview(&actionsSdkWritePreviewServer{stream})
}

type ActionsSdk_WritePreviewServer interface {
	SendAndClose(*Preview) error
	Recv() (*WritePreviewRequest, error)
	grpc.ServerStream
}

type actionsSdkWritePreviewServer struct {
	grpc.ServerStream
}

func (x *actionsSdkWritePreviewServer) SendAndClose(m *Preview) error {
	return x.ServerStream.SendMsg(m)
}

func (x *actionsSdkWritePreviewServer) Recv() (*WritePreviewRequest, error) {
	m := new(WritePreviewRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ActionsSdk_CreateVersion_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ActionsSdkServer).CreateVersion(&actionsSdkCreateVersionServer{stream})
}

type ActionsSdk_CreateVersionServer interface {
	SendAndClose(*Version) error
	Recv() (*CreateVersionRequest, error)
	grpc.ServerStream
}

type actionsSdkCreateVersionServer struct {
	grpc.ServerStream
}

func (x *actionsSdkCreateVersionServer) SendAndClose(m *Version) error {
	return x.ServerStream.SendMsg(m)
}

func (x *actionsSdkCreateVersionServer) Recv() (*CreateVersionRequest, error) {
	m := new(CreateVersionRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ActionsSdk_ReadDraft_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadDraftRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ActionsSdkServer).ReadDraft(m, &actionsSdkReadDraftServer{stream})
}

type ActionsSdk_ReadDraftServer interface {
	Send(*ReadDraftResponse) error
	grpc.ServerStream
}

type actionsSdkReadDraftServer struct {
	grpc.ServerStream
}

func (x *actionsSdkReadDraftServer) Send(m *ReadDraftResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ActionsSdk_ReadVersion_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadVersionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ActionsSdkServer).ReadVersion(m, &actionsSdkReadVersionServer{stream})
}

type ActionsSdk_ReadVersionServer interface {
	Send(*ReadVersionResponse) error
	grpc.ServerStream
}

type actionsSdkReadVersionServer struct {
	grpc.ServerStream
}

func (x *actionsSdkReadVersionServer) Send(m *ReadVersionResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ActionsSdk_EncryptSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsSdkServer).EncryptSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsSdk/EncryptSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsSdkServer).EncryptSecret(ctx, req.(*EncryptSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsSdk_DecryptSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecryptSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsSdkServer).DecryptSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsSdk/DecryptSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsSdkServer).DecryptSecret(ctx, req.(*DecryptSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsSdk_ListSampleProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSampleProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsSdkServer).ListSampleProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsSdk/ListSampleProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsSdkServer).ListSampleProjects(ctx, req.(*ListSampleProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsSdk_ListReleaseChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleaseChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsSdkServer).ListReleaseChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsSdk/ListReleaseChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsSdkServer).ListReleaseChannels(ctx, req.(*ListReleaseChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsSdk_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsSdkServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsSdk/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsSdkServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ActionsSdk_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.actions.sdk.v2.ActionsSdk",
	HandlerType: (*ActionsSdkServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EncryptSecret",
			Handler:    _ActionsSdk_EncryptSecret_Handler,
		},
		{
			MethodName: "DecryptSecret",
			Handler:    _ActionsSdk_DecryptSecret_Handler,
		},
		{
			MethodName: "ListSampleProjects",
			Handler:    _ActionsSdk_ListSampleProjects_Handler,
		},
		{
			MethodName: "ListReleaseChannels",
			Handler:    _ActionsSdk_ListReleaseChannels_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ActionsSdk_ListVersions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WriteDraft",
			Handler:       _ActionsSdk_WriteDraft_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "WritePreview",
			Handler:       _ActionsSdk_WritePreview_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "CreateVersion",
			Handler:       _ActionsSdk_CreateVersion_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "ReadDraft",
			Handler:       _ActionsSdk_ReadDraft_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReadVersion",
			Handler:       _ActionsSdk_ReadVersion_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/actions/sdk/v2/actions_sdk.proto",
}
