// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// ProfileContainer are an experimental implementation of the OpenTelemetry Profiles Data Model.

// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewProfileContainer function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ProfileContainer struct {
	orig  *otlpprofiles.ProfileContainer
	state *internal.State
}

func newProfileContainer(orig *otlpprofiles.ProfileContainer, state *internal.State) ProfileContainer {
	return ProfileContainer{orig: orig, state: state}
}

// NewProfileContainer creates a new empty ProfileContainer.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewProfileContainer() ProfileContainer {
	state := internal.StateMutable
	return newProfileContainer(&otlpprofiles.ProfileContainer{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms ProfileContainer) MoveTo(dest ProfileContainer) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	*dest.orig = *ms.orig
	*ms.orig = otlpprofiles.ProfileContainer{}
}

// ProfileID returns the ProfileId associated with this ProfileContainer.
func (ms ProfileContainer) ProfileID() pcommon.ByteSlice {
	return pcommon.ByteSlice(internal.NewByteSlice(&ms.orig.ProfileId, ms.state))
}

// StartTime returns the starttime associated with this ProfileContainer.
func (ms ProfileContainer) StartTime() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this ProfileContainer.
func (ms ProfileContainer) SetStartTime(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.StartTimeUnixNano = uint64(v)
}

// EndTime returns the endtime associated with this ProfileContainer.
func (ms ProfileContainer) EndTime() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.EndTimeUnixNano)
}

// SetEndTime replaces the endtime associated with this ProfileContainer.
func (ms ProfileContainer) SetEndTime(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.EndTimeUnixNano = uint64(v)
}

// Attributes returns the Attributes associated with this ProfileContainer.
func (ms ProfileContainer) Attributes() pcommon.Map {
	return pcommon.Map(internal.NewMap(&ms.orig.Attributes, ms.state))
}

// DroppedAttributesCount returns the droppedattributescount associated with this ProfileContainer.
func (ms ProfileContainer) DroppedAttributesCount() uint32 {
	return ms.orig.DroppedAttributesCount
}

// SetDroppedAttributesCount replaces the droppedattributescount associated with this ProfileContainer.
func (ms ProfileContainer) SetDroppedAttributesCount(v uint32) {
	ms.state.AssertMutable()
	ms.orig.DroppedAttributesCount = v
}

// Profile returns the profile associated with this ProfileContainer.
func (ms ProfileContainer) Profile() Profile {
	return newProfile(&ms.orig.Profile, ms.state)
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms ProfileContainer) CopyTo(dest ProfileContainer) {
	dest.state.AssertMutable()
	ms.ProfileID().CopyTo(dest.ProfileID())
	dest.SetStartTime(ms.StartTime())
	dest.SetEndTime(ms.EndTime())
	ms.Attributes().CopyTo(dest.Attributes())
	dest.SetDroppedAttributesCount(ms.DroppedAttributesCount())
	ms.Profile().CopyTo(dest.Profile())
}
