/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.CompoundMode;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLUsePackage
extends StyleElement {
    private String nameAtt = null;
    private PackageVersionRanges versionRanges = null;
    private StylesheetPackage usedPackage;
    private List<XSLAccept> acceptors = null;

    public void findUsedPackage(CompilerInfo info) throws XPathException {
        if (this.usedPackage == null) {
            GlobalContextRequirement gcr;
            if (this.nameAtt == null) {
                this.nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            }
            this.usedPackage = info.getPackageLibrary().findPackage((String)this.nameAtt, (PackageVersionRanges)this.getPackageVersionRanges()).loadedPackage;
            if (this.usedPackage == null) {
                this.compileError("Package " + this.getAttributeValue("name") + " could not be found", "XTSE3000");
                this.usedPackage = this.getConfiguration().makeStylesheetPackage();
                this.usedPackage.setJustInTimeCompilation(info.isJustInTimeCompilation());
            }
            if ((gcr = this.usedPackage.getContextItemRequirements()) != null && !gcr.isMayBeOmitted()) {
                this.compileError("Package " + this.getAttributeValue("name") + " requires a global context item, so it cannot be used as a library package", "XTTE0590");
            }
            this.usedPackage.setRootPackage(false);
        }
    }

    @Override
    public StylesheetPackage getUsedPackage() {
        return this.usedPackage;
    }

    public PackageVersionRanges getPackageVersionRanges() throws XPathException {
        if (this.versionRanges == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                this.versionRanges = new PackageVersionRanges("*");
            }
        }
        return this.versionRanges;
    }

    @Override
    protected void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String ranges = "*";
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("package-version")) {
                ranges = Whitespace.trim(atts.getValue(a)).replaceAll("\\\\", "");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        this.versionRanges = new PackageVersionRanges(ranges);
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child.getNodeKind() == 3) {
                this.compileError("Character content is not allowed as a child of xsl:use-package");
                continue;
            }
            if (child instanceof XSLAccept || child instanceof XSLOverride) continue;
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:use-package", "XTSE0010");
        }
    }

    public Set<SymbolicName> getExplicitAcceptedComponentNames() throws XPathException {
        NodeInfo child;
        HashSet<SymbolicName> explicitAccepts = new HashSet<SymbolicName>();
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLAccept)) continue;
            Set<ComponentTest> explicitComponentTests = ((XSLAccept)child).getExplicitComponentTests();
            for (ComponentTest test : explicitComponentTests) {
                SymbolicName name = test.getSymbolicNameIfExplicit();
                explicitAccepts.add(name);
            }
        }
        return explicitAccepts;
    }

    @Override
    public void postValidate() throws XPathException {
        NodeInfo curr;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (!(curr instanceof XSLOverride) && !(curr instanceof XSLAccept)) continue;
            ((StyleElement)curr).postValidate();
        }
        Set<SymbolicName> accepts = this.getExplicitAcceptedComponentNames();
        Set<SymbolicName> overrides = this.getNamedOverrides();
        accepts.retainAll(overrides);
        if (!accepts.isEmpty()) {
            StringBuilder duplicates = new StringBuilder();
            boolean first = true;
            for (SymbolicName name : accepts) {
                if (first) {
                    first = false;
                } else {
                    duplicates.append(", ");
                }
                duplicates.append(name.toString());
            }
            this.compileError("Cannot accept and override the same component (" + duplicates + ")", "XTSE3051");
        }
    }

    public List<XSLAccept> getAcceptors() {
        if (this.acceptors == null) {
            NodeInfo decl;
            this.acceptors = new ArrayList<XSLAccept>();
            AxisIterator useKids = this.iterateAxis((byte)3);
            while ((decl = useKids.next()) != null) {
                if (!(decl instanceof XSLAccept)) continue;
                this.acceptors.add((XSLAccept)decl);
            }
        }
        return this.acceptors;
    }

    public void gatherNamedOverrides(PrincipalStylesheetModule module, List<ComponentDeclaration> topLevel, Set<SymbolicName> overrides) throws XPathException {
        NodeInfo override;
        if (this.usedPackage == null) {
            return;
        }
        AxisIterator kids = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((override = kids.next()) != null) {
            NodeInfo overridingDeclaration;
            if (!(override instanceof XSLOverride)) continue;
            AxisIterator overridings = override.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((overridingDeclaration = overridings.next()) != null) {
                StructuredQName[] modeNames;
                if (!(overridingDeclaration instanceof StylesheetComponent)) continue;
                ComponentDeclaration decl = new ComponentDeclaration(module, (StyleElement)overridingDeclaration);
                topLevel.add(decl);
                SymbolicName name = ((StylesheetComponent)((Object)overridingDeclaration)).getSymbolicName();
                if (name != null) {
                    overrides.add(name);
                    continue;
                }
                if (!(overridingDeclaration instanceof XSLTemplate) || overridingDeclaration.getAttributeValue("", "match") == null) continue;
                for (StructuredQName m3 : modeNames = ((XSLTemplate)overridingDeclaration).getModeNames()) {
                    overrides.add(new SymbolicName(174, m3));
                }
            }
        }
    }

    public Set<SymbolicName> getNamedOverrides() throws XPathException {
        NodeInfo override;
        HashSet<SymbolicName> overrides = new HashSet<SymbolicName>();
        AxisIterator kids = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((override = kids.next()) != null) {
            NodeInfo overridingDeclaration;
            if (!(override instanceof XSLOverride)) continue;
            AxisIterator overridings = override.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((overridingDeclaration = overridings.next()) != null) {
                SymbolicName name;
                if (!(overridingDeclaration instanceof StylesheetComponent) || (name = ((StylesheetComponent)((Object)overridingDeclaration)).getSymbolicName()) == null) continue;
                overrides.add(name);
            }
        }
        return overrides;
    }

    public void gatherRuleOverrides(PrincipalStylesheetModule module, Set<SymbolicName> overrides) throws XPathException {
        NodeInfo override;
        StylesheetPackage thisPackage = module.getStylesheetPackage();
        RuleManager ruleManager = module.getRuleManager();
        AxisIterator kids = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        HashSet<SymbolicName> overriddenModes = new HashSet<SymbolicName>();
        while ((override = kids.next()) != null) {
            NodeInfo overridingDeclaration;
            if (!(override instanceof XSLOverride)) continue;
            AxisIterator overridings = override.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((overridingDeclaration = overridings.next()) != null) {
                StructuredQName[] modeNames;
                if (!(overridingDeclaration instanceof XSLTemplate) || overridingDeclaration.getAttributeValue("", "match") == null) continue;
                for (StructuredQName modeName : modeNames = ((XSLTemplate)overridingDeclaration).getModeNames()) {
                    if (modeName.equals(Mode.OMNI_MODE)) {
                        ((StyleElement)overridingDeclaration).compileError("The mode name #all must not appear in an overriding template rule", "XTSE3440");
                        continue;
                    }
                    SymbolicName symbolicName = new SymbolicName(174, modeName);
                    overrides.add(symbolicName);
                    overriddenModes.add(symbolicName);
                    Component.M derivedComponent = (Component.M)thisPackage.getComponent(symbolicName);
                    if (derivedComponent == null) {
                        ((StyleElement)overridingDeclaration).compileError("Mode " + modeName.getDisplayName() + " is not defined in the used package", "XTSE3060");
                        continue;
                    }
                    if (derivedComponent.getBaseComponent() == null) {
                        ((StyleElement)overridingDeclaration).compileError("Mode " + modeName.getDisplayName() + " cannot be overridden because it is local to this package", "XTSE3440");
                        continue;
                    }
                    Component.M usedComponent = (Component.M)derivedComponent.getBaseComponent();
                    if (derivedComponent.getVisibility() == Visibility.FINAL || usedComponent.getVisibility() == Visibility.FINAL) {
                        ((StyleElement)overridingDeclaration).compileError("Cannot define overriding template rules in mode " + modeName.getDisplayName() + " because it has visibility=final", "XTSE3060");
                        continue;
                    }
                    Mode usedMode = usedComponent.getActor();
                    if (usedComponent.getVisibility() != Visibility.PUBLIC) {
                        ((StyleElement)overridingDeclaration).compileError("Cannot override template rules in mode " + modeName.getDisplayName() + ", because the mode is not public", "XTSE3060");
                        continue;
                    }
                    if (derivedComponent.getActor() != usedMode) continue;
                    SimpleMode overridingMode = new SimpleMode(modeName);
                    CompoundMode newCompoundMode = new CompoundMode(usedMode, overridingMode);
                    newCompoundMode.setDeclaringComponent(derivedComponent);
                    ruleManager.registerMode(newCompoundMode);
                    derivedComponent.setActor(newCompoundMode);
                }
            }
        }
        RuleManager usedPackageRuleManager = this.usedPackage.getRuleManager();
        if (usedPackageRuleManager != null) {
            for (Mode m3 : usedPackageRuleManager.getAllNamedModes()) {
                Component c;
                SymbolicName sn = m3.getSymbolicName();
                if (overriddenModes.contains(sn) || (c = thisPackage.getComponent(sn)) == null || c.getVisibility() == Visibility.PRIVATE) continue;
                ruleManager.registerMode((Mode)c.getActor());
            }
        }
    }
}

