// Copyright 2022 Paul Greenberg greenpau@outlook.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package errors

// Generic Errors
const (
	ErrEmptyACLAction                     StandardError = "empty access list action"
	ErrEmptyACLClaim                      StandardError = "empty access list claim"
	ErrEmptyMethod                        StandardError = "empty http method"
	ErrEmptyPath                          StandardError = "empty http path"
	ErrEmptyClaim                         StandardError = "empty claim value"
	ErrEmptyValue                         StandardError = "empty value"
	ErrNoValues                           StandardError = "no acl.Values"
	ErrUnsupportedACLAction               StandardError = "unsupported access list action: %s"
	ErrUnsupportedClaim                   StandardError = "access list does not support %s claim, only audiences, roles, scopes"
	ErrUnsupportedMethod                  StandardError = "unsupported http method: %s"
	ErrKeyIDNotFound                      StandardError = "key ID not found"
	ErrUnsupportedKeyType                 StandardError = "unsupported key type %T for key ID %s"
	ErrRSAKeysNotFound                    StandardError = "no RSA keys found"
	ErrECDSAKeysNotFound                  StandardError = "no ECDSA keys found"
	ErrPrivateKeysNotFound                StandardError = "no private keys found"
	ErrUnknownConfigSource                StandardError = "sig key config source is not found"
	ErrReadPEMFile                        StandardError = "(source: %s): read PEM file: %v"
	ErrWalkDir                            StandardError = "walking directory: %v"
	ErrProvisonFailed                     StandardError = "authorization provider provisioning error"
	ErrEmptyProviderName                  StandardError = "authorization provider name is empty"
	ErrNoMemberReference                  StandardError = "no member reference found"
	ErrTooManyPrimaryInstances            StandardError = "found more than one primaryInstance instance of the plugin for %s context"
	ErrUndefinedSecret                    StandardError = "%s: token keys and secrets must be defined either via environment variables or via token_ configuration element"
	ErrInvalidConfiguration               StandardError = "%s: configuration error: %v"
	ErrTokenAlreadyConfigured             StandardError = "token already configured"
	ErrLoadCryptoKeyConfig                StandardError = "%s: failed loading token in %s context: %v"
	ErrUnsupportedSignatureMethod         StandardError = "%s: unsupported token sign/verify method: %s"
	ErrUnsupportedTokenSource             StandardError = "%s: unsupported token source: %s"
	ErrInvalidBackendConfiguration        StandardError = "%s: token validator configuration error: %s"
	ErrUnknownProvider                    StandardError = "authorization provider %s not found"
	ErrInvalidProvider                    StandardError = "authorization provider %s is nil"
	ErrNoPrimaryInstanceProvider          StandardError = "no primaryInstance authorization provider found in %s context when configuring %s"
	ErrNoCryptoKeysFound                  StandardError = "no crypto keys found in %s context"
	ErrLoadingKeys                        StandardError = "loading %s keys: %v"
	ErrInvalidClaimExpiresAt              StandardError = "invalid exp type: %T"
	ErrInvalidClaimIssuedAt               StandardError = "invalid iat type: %T"
	ErrInvalidClaimNotBefore              StandardError = "invalid nbf type: %T"
	ErrInvalidSigningMethod               StandardError = "unsupported signing method"
	ErrEmptySecret                        StandardError = "empty secrets are not supported"
	ErrInvalidAudience                    StandardError = "invalid audience type %T in audience"
	ErrInvalidAudienceType                StandardError = "invalid audience type %T"
	ErrInvalidRole                        StandardError = "invalid role type %T in roles"
	ErrInvalidRoleType                    StandardError = "invalid roles type %T"
	ErrInvalidScope                       StandardError = "invalid scope type %T in scopes"
	ErrInvalidScopeType                   StandardError = "invalid scopes type %T"
	ErrInvalidOrg                         StandardError = "invalid org type %T in orgs"
	ErrInvalidOrgType                     StandardError = "invalid orgs type %T"
	ErrInvalidAppMetadataRoleType         StandardError = "invalid roles type %T in app_metadata-authorization"
	ErrInvalidAddrType                    StandardError = "invalid ip address type %T in addr"
	ErrInvalidAccessListPath              StandardError = "invalid acl path type %T in paths"
	ErrInvalidIDClaimType                 StandardError = "invalid jti claim value type %T"
	ErrInvalidIssuerClaimType             StandardError = "invalid iss claim value type %T"
	ErrInvalidSubjectClaimType            StandardError = "invalid sub claim value type %T"
	ErrInvalidEmailClaimType              StandardError = "invalid %s claim value type %T"
	ErrInvalidNameClaimType               StandardError = "invalid name claim value type %T"
	ErrInvalidOriginClaimType             StandardError = "invalid origin claim value type %T"
	ErrInvalidPictureClaimType            StandardError = "invalid picture claim value type %T"
	ErrInvalidMetadataClaimType           StandardError = "invalid metadata claim value type %T"
	ErrSigningOptionsNotFound             StandardError = "signing options not found"
	ErrSigningMethodNotFound              StandardError = "signing method not found"
	ErrSharedSigningKeyNotFound           StandardError = "shared secret for signing not found"
	ErrPrivateSigningKeyNotFound          StandardError = "private key for signing not found"
	ErrNoBackends                         StandardError = "no token backends available"
	ErrExpiredToken                       StandardError = "expired token"
	ErrNoAccessList                       StandardError = "user role is valid, but denied by default deny on empty access list"
	ErrAccessNotAllowed                   StandardError = "user role is valid, but not allowed by access list"
	ErrAccessNotAllowedByPathACL          StandardError = "user role is valid, but not allowed by path access list"
	ErrSourceAddressNotFound              StandardError = "source ip validation is enabled, but no ip address claim found"
	ErrSourceAddressMismatch              StandardError = "source ip address mismatch between the claim %q and request %q"
	ErrNoParsedClaims                     StandardError = "failed to extract claims"
	ErrNoTokenFound                       StandardError = "no token found"
	ErrInvalidParsedClaims                StandardError = "failed to extract claims: %s"
	ErrInvalidSecret                      StandardError = "secret key backend error: %s"
	ErrInvalid                            StandardError = "%v"
	ErrMixedAlgorithms                    StandardError = "mixed key algorithms found in %s: %v"
	ErrFoundDuplicateKeyID                StandardError = "duplicate kid %s for %s keys found in %s"
	ErrMixedConfigKeyType                 StandardError = "failed adding key to %s config, key type %s"
	ErrUnsupportedConfigKeyType           StandardError = "unsupported key type in token config: %T"
	ErrNotECDSAPrivatePEMEncodedKey       StandardError = "the key is not ECDSA private PEM-encoded key: %s"
	ErrNotPEMEncodedKey                   StandardError = "the key is not PEM-encoded key"
	ErrNotECDSAPrivateKey                 StandardError = "the key is not ECDSA private key"
	ErrNotECDSAPublicKey                  StandardError = "the key is not ECDSA public key"
	ErrNotECDSAPublicKeyType              StandardError = "the key is not ECDSA public key: %T"
	ErrEmptyCryptoKeyConfigOrigin         StandardError = "empty token config origin"
	ErrUnsupportedCryptoKeyConfigOrigin   StandardError = "unsupported token config origin: %s"
	ErrPrimaryRegistrationFailed          StandardError = "primary instance registration for %s context failed"
	ErrRegistrationTimeout                StandardError = "non-primary instance registration in %s context timed out"
	ErrAuthorizerFailed                   StandardError = "authorizer %s in %s context failed"
	ErrContextNotFound                    StandardError = "authorizer %s in %s context not found"
	ErrContextFailed                      StandardError = "authorizer %s in failed %s context"
	ErrPrimaryInstanceNotFound            StandardError = "authorizer %s has not primary instance in %s context"
	ErrPrimaryInstanceNotInitialized      StandardError = "authorizer %s has uninitialized primary instance in %s context"
	ErrPrimaryInstanceFailed              StandardError = "authorizer %s has failed primary instance in %s context"
	ErrInstanceValidatationTimeout        StandardError = "authorizer %s in %s context failed to due to timeout"
	ErrMultipleSigningKeys                StandardError = "multiple signing keys found"
	ErrSigningKeyNotFound                 StandardError = "signing key not found for %v"
	ErrSigningKeyNil                      StandardError = "signing key is nil"
	ErrSigningKeyTooShort                 StandardError = "signing key is too short"
	ErrDataSigningFailed                  StandardError = "data signing failed for %v: %v"
	ErrGetSignedTokenEmpty                StandardError = "token signing failed for %v: empty signed token"
	ErrSigningKeyMethodPrivateKeyConflict StandardError = "token signing failed: method and private key conflict %s vs. %s"
	ErrParsePrivateRSAKey                 StandardError = "failed to parse private RSA key: %v"
	ErrParsePrivateECDSAKey               StandardError = "failed to parse private ECDSA key: %v"
	ErrParsePublicRSAKey                  StandardError = "failed to parse public RSA key: %v"
	ErrParsePublicECDSAKey                StandardError = "failed to parse public ECDSA key: %v"
	ErrECDSAPrivateKeyCurveNotSupported   StandardError = "the private ECDSA key has unsupported curve: %s"
	ErrUnsupportedECDSACurve              StandardError = "found unsupported ECDSA curve: %s"
	ErrEmptyECDSACurve                    StandardError = "found empty ECDSA curve"
	ErrNoECDSACurveParamsFound            StandardError = "no ECDSA curve parameters found"
	ErrParseEnvVar                        StandardError = "failed to parse environment variable %s: %v"
	ErrEncryptionKeysNotFound             StandardError = "encryption keys not found"
	ErrKeyOverwriteFailed                 StandardError = "failed to overwrite used key id %s"
	ErrKeyNil                             StandardError = "key is nil"
	ErrCryptoKeyConfigNil                 StandardError = "token configuration is nil"
	ErrFailed                             StandardError = "encountered error: %v"

	// InstanceManager errors.
	ErrInstanceManagerValidate StandardError = "instance %q validation failed: %v"
	ErrInvalidLoginHint        StandardError = "login_hint query parameter is not in a valid format"
	ErrInvalidAdditionalScopes StandardError = "additional_scopes query parameter is not in a valid format"
)
