// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AccountUpdateMemberSetup account update member setup
//
// swagger:model accountUpdateMemberSetup
type AccountUpdateMemberSetup struct {

	// role
	// Enum: [Owner Developer Billing Admin Reviewer]
	Role string `json:"role,omitempty"`

	// site access
	// Enum: [all none selected]
	SiteAccess string `json:"site_access,omitempty"`

	// site ids
	SiteIds []string `json:"site_ids"`
}

// Validate validates this account update member setup
func (m *AccountUpdateMemberSetup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSiteAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var accountUpdateMemberSetupTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Owner","Developer","Billing Admin","Reviewer"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		accountUpdateMemberSetupTypeRolePropEnum = append(accountUpdateMemberSetupTypeRolePropEnum, v)
	}
}

const (

	// AccountUpdateMemberSetupRoleOwner captures enum value "Owner"
	AccountUpdateMemberSetupRoleOwner string = "Owner"

	// AccountUpdateMemberSetupRoleDeveloper captures enum value "Developer"
	AccountUpdateMemberSetupRoleDeveloper string = "Developer"

	// AccountUpdateMemberSetupRoleBillingAdmin captures enum value "Billing Admin"
	AccountUpdateMemberSetupRoleBillingAdmin string = "Billing Admin"

	// AccountUpdateMemberSetupRoleReviewer captures enum value "Reviewer"
	AccountUpdateMemberSetupRoleReviewer string = "Reviewer"
)

// prop value enum
func (m *AccountUpdateMemberSetup) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, accountUpdateMemberSetupTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AccountUpdateMemberSetup) validateRole(formats strfmt.Registry) error {

	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

var accountUpdateMemberSetupTypeSiteAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","none","selected"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		accountUpdateMemberSetupTypeSiteAccessPropEnum = append(accountUpdateMemberSetupTypeSiteAccessPropEnum, v)
	}
}

const (

	// AccountUpdateMemberSetupSiteAccessAll captures enum value "all"
	AccountUpdateMemberSetupSiteAccessAll string = "all"

	// AccountUpdateMemberSetupSiteAccessNone captures enum value "none"
	AccountUpdateMemberSetupSiteAccessNone string = "none"

	// AccountUpdateMemberSetupSiteAccessSelected captures enum value "selected"
	AccountUpdateMemberSetupSiteAccessSelected string = "selected"
)

// prop value enum
func (m *AccountUpdateMemberSetup) validateSiteAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, accountUpdateMemberSetupTypeSiteAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AccountUpdateMemberSetup) validateSiteAccess(formats strfmt.Registry) error {

	if swag.IsZero(m.SiteAccess) { // not required
		return nil
	}

	// value enum
	if err := m.validateSiteAccessEnum("site_access", "body", m.SiteAccess); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AccountUpdateMemberSetup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AccountUpdateMemberSetup) UnmarshalBinary(b []byte) error {
	var res AccountUpdateMemberSetup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
