/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.thread;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class ConnectionValidator {
    private static final ScheduledExecutorService fixedSizedScheduler = SchedulerServiceProviderHolder.getFixedSizeScheduler(1);
    private static final int MINIMUM_CHECK_DELAY_MILLIS = 100;
    private final ConcurrentLinkedQueue<Listener> queue = new ConcurrentLinkedQueue();
    private final AtomicLong currentScheduledFrequency = new AtomicLong(-1L);
    private final ListenerChecker checker = new ListenerChecker();

    public void addListener(Listener listener, long listenerCheckMillis) {
        long casFrequency;
        this.queue.add(listener);
        while ((casFrequency = this.currentScheduledFrequency.get()) != listenerCheckMillis && (casFrequency == -1L || casFrequency > 100L)) {
            BigInteger bi2;
            if (casFrequency == -1L) {
                if (!this.currentScheduledFrequency.compareAndSet(-1L, listenerCheckMillis)) continue;
                fixedSizedScheduler.schedule(this.checker, listenerCheckMillis, TimeUnit.MILLISECONDS);
                break;
            }
            BigInteger bi1 = BigInteger.valueOf(casFrequency);
            int gcd = Math.max(100, bi1.gcd(bi2 = BigInteger.valueOf(listenerCheckMillis)).intValue());
            if ((long)gcd >= casFrequency) break;
            if (!this.currentScheduledFrequency.compareAndSet(casFrequency, gcd)) continue;
            fixedSizedScheduler.schedule(this.checker, (long)gcd, TimeUnit.MILLISECONDS);
            break;
        }
    }

    public void removeListener(Listener listener) {
        long casFrequency;
        this.queue.remove(listener);
        while ((casFrequency = this.currentScheduledFrequency.get()) > 0L && this.queue.isEmpty() && !this.currentScheduledFrequency.compareAndSet(casFrequency, -1L)) {
        }
    }

    private class ListenerChecker
    implements Runnable {
        private ListenerChecker() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                long delay = ConnectionValidator.this.currentScheduledFrequency.get();
                if (delay > 0L) {
                    fixedSizedScheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            }
        }

        private void doRun() {
            Iterator tmpQueue = ConnectionValidator.this.queue.iterator();
            long now = -1L;
            while (tmpQueue.hasNext()) {
                long durationNanos;
                long durationSeconds;
                Listener listener = (Listener)tmpQueue.next();
                if (listener.isExplicitClosed() || (durationSeconds = TimeUnit.NANOSECONDS.toSeconds(durationNanos = (now == -1L ? System.nanoTime() : now) - listener.getLastQueryNanos())) < (long)listener.getUrlParser().getOptions().validConnectionTimeout || listener.isMasterHostFail()) continue;
                boolean masterFail = false;
                if (listener.isMasterConnected()) {
                    listener.checkMasterStatus(null);
                } else {
                    masterFail = true;
                }
                if (!masterFail || !listener.setMasterHostFail()) continue;
                try {
                    listener.primaryFail(null, null);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

