/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* "%code top" blocks.  */
#line 172 "parsers/mpd_parser.y"

#ifndef _GNU_SOURCE
#define _GNU_SOURCE // For asprintf
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdarg.h> // For vsnprintf
#include <string.h>
#include <time.h>
#include <assert.h>

#define INVERT_MASK 0x80000000
#define RECURSION_MAX 64
#line 189 "parsers/mpd_parser.y"

#ifndef DEBUG_PARSER_MOCK
#include "db.h"
#include "misc.h"
#else
#include "owntonefunctions.h"
#endif

#line 92 "parsers/mpd_parser.c"
/* Substitute the type names.  */
#define YYSTYPE         MPD_STYPE
/* Substitute the variable and function names.  */
#define yyparse         mpd_parse
#define yylex           mpd_lex
#define yyerror         mpd_error
#define yydebug         mpd_debug
#define yynerrs         mpd_nerrs


# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_MPD_PARSERS_MPD_PARSER_H_INCLUDED
# define YY_MPD_PARSERS_MPD_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef MPD_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define MPD_DEBUG 1
#  else
#   define MPD_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define MPD_DEBUG 1
# endif /* ! defined YYDEBUG */
#endif  /* ! defined MPD_DEBUG */
#if MPD_DEBUG
extern int mpd_debug;
#endif
/* "%code requires" blocks.  */
#line 202 "parsers/mpd_parser.y"

struct mpd_result_part {
  char str[8192];
  int offset;
};

struct mpd_result {
  struct mpd_result_part where_part;
  struct mpd_result_part order_part;
  struct mpd_result_part group_part;
  char tagtype_buf[64];
  char position_buf[64];

  // Pointers to the strings in mpd_result_part
  const char *where;
  const char *order;
  const char *group;

  const char *tagtype;
  const char *position;

  // Set to 0 if not found
  int offset;
  int limit;

  int err;
  char errmsg[128];

  int recursion_level;
};

enum mpd_type {
  MPD_TYPE_INT,
  MPD_TYPE_STRING,
  MPD_TYPE_SPECIAL,
};

struct mpd_tag_map {
  const char *name;
  const char *dbcol;
  enum mpd_type type;
  int dbmfi_offset;
};

char *mpd_parser_quoted(const char *str);
struct mpd_tag_map *mpd_parser_tag_from_dbcol(const char *dbcol);
void mpd_parser_enum_tagtypes(void (*func)(struct mpd_tag_map *, void *), void *arg);

#line 193 "parsers/mpd_parser.c"

/* Token kinds.  */
#ifndef MPD_TOKENTYPE
# define MPD_TOKENTYPE
  enum mpd_tokentype
  {
    MPD_EMPTY = -2,
    MPD_EOF = 0,                   /* "end of file"  */
    MPD_error = 256,               /* error  */
    MPD_UNDEF = 257,               /* "invalid token"  */
    MPD_T_CMDSEARCH = 258,         /* MPD_T_CMDSEARCH  */
    MPD_T_CMDSEARCHADD = 259,      /* MPD_T_CMDSEARCHADD  */
    MPD_T_CMDFIND = 260,           /* MPD_T_CMDFIND  */
    MPD_T_CMDFINDADD = 261,        /* MPD_T_CMDFINDADD  */
    MPD_T_CMDCOUNT = 262,          /* MPD_T_CMDCOUNT  */
    MPD_T_CMDSEARCHCOUNT = 263,    /* MPD_T_CMDSEARCHCOUNT  */
    MPD_T_CMDPLAYLISTFIND = 264,   /* MPD_T_CMDPLAYLISTFIND  */
    MPD_T_CMDPLAYLISTSEARCH = 265, /* MPD_T_CMDPLAYLISTSEARCH  */
    MPD_T_CMDLIST = 266,           /* MPD_T_CMDLIST  */
    MPD_T_SORT = 267,              /* MPD_T_SORT  */
    MPD_T_WINDOW = 268,            /* MPD_T_WINDOW  */
    MPD_T_POSITION = 269,          /* MPD_T_POSITION  */
    MPD_T_GROUP = 270,             /* MPD_T_GROUP  */
    MPD_T_STRING = 271,            /* MPD_T_STRING  */
    MPD_T_NUM = 272,               /* MPD_T_NUM  */
    MPD_T_TIME = 273,              /* MPD_T_TIME  */
    MPD_T_STRTAG = 274,            /* MPD_T_STRTAG  */
    MPD_T_INTTAG = 275,            /* MPD_T_INTTAG  */
    MPD_T_SINCETAG = 276,          /* MPD_T_SINCETAG  */
    MPD_T_BASETAG = 277,           /* MPD_T_BASETAG  */
    MPD_T_ANYTAG = 278,            /* MPD_T_ANYTAG  */
    MPD_T_AUDIOFORMATTAG = 279,    /* MPD_T_AUDIOFORMATTAG  */
    MPD_T_PARENS = 280,            /* MPD_T_PARENS  */
    MPD_T_OR = 281,                /* MPD_T_OR  */
    MPD_T_AND = 282,               /* MPD_T_AND  */
    MPD_T_NOT = 283,               /* MPD_T_NOT  */
    MPD_T_CONTAINS = 284,          /* MPD_T_CONTAINS  */
    MPD_T_STARTSWITH = 285,        /* MPD_T_STARTSWITH  */
    MPD_T_ENDSWITH = 286,          /* MPD_T_ENDSWITH  */
    MPD_T_EQUAL = 287,             /* MPD_T_EQUAL  */
    MPD_T_NOTEQUAL = 288,          /* MPD_T_NOTEQUAL  */
    MPD_T_LESS = 289,              /* MPD_T_LESS  */
    MPD_T_LESSEQUAL = 290,         /* MPD_T_LESSEQUAL  */
    MPD_T_GREATER = 291,           /* MPD_T_GREATER  */
    MPD_T_GREATEREQUAL = 292       /* MPD_T_GREATEREQUAL  */
  };
  typedef enum mpd_tokentype mpd_token_kind_t;
#endif

/* Value type.  */
#if ! defined MPD_STYPE && ! defined MPD_STYPE_IS_DECLARED
union MPD_STYPE
{
#line 641 "parsers/mpd_parser.y"

  unsigned int ival;
  char *str;
  struct ast *ast;

#line 253 "parsers/mpd_parser.c"

};
typedef union MPD_STYPE MPD_STYPE;
# define MPD_STYPE_IS_TRIVIAL 1
# define MPD_STYPE_IS_DECLARED 1
#endif




int mpd_parse (struct mpd_result *result, void *scanner);

/* "%code provides" blocks.  */
#line 42 "parsers/mpd_parser.y"

/* Convenience functions for caller to use instead of interfacing with lexer and
   parser directly */
int mpd_lex_cb(char *input, void (*cb)(int, const char *));
int mpd_lex_parse(struct mpd_result *result, const char *input);

#line 274 "parsers/mpd_parser.c"

#endif /* !YY_MPD_PARSERS_MPD_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_MPD_T_CMDSEARCH = 3,            /* MPD_T_CMDSEARCH  */
  YYSYMBOL_MPD_T_CMDSEARCHADD = 4,         /* MPD_T_CMDSEARCHADD  */
  YYSYMBOL_MPD_T_CMDFIND = 5,              /* MPD_T_CMDFIND  */
  YYSYMBOL_MPD_T_CMDFINDADD = 6,           /* MPD_T_CMDFINDADD  */
  YYSYMBOL_MPD_T_CMDCOUNT = 7,             /* MPD_T_CMDCOUNT  */
  YYSYMBOL_MPD_T_CMDSEARCHCOUNT = 8,       /* MPD_T_CMDSEARCHCOUNT  */
  YYSYMBOL_MPD_T_CMDPLAYLISTFIND = 9,      /* MPD_T_CMDPLAYLISTFIND  */
  YYSYMBOL_MPD_T_CMDPLAYLISTSEARCH = 10,   /* MPD_T_CMDPLAYLISTSEARCH  */
  YYSYMBOL_MPD_T_CMDLIST = 11,             /* MPD_T_CMDLIST  */
  YYSYMBOL_MPD_T_SORT = 12,                /* MPD_T_SORT  */
  YYSYMBOL_MPD_T_WINDOW = 13,              /* MPD_T_WINDOW  */
  YYSYMBOL_MPD_T_POSITION = 14,            /* MPD_T_POSITION  */
  YYSYMBOL_MPD_T_GROUP = 15,               /* MPD_T_GROUP  */
  YYSYMBOL_MPD_T_STRING = 16,              /* MPD_T_STRING  */
  YYSYMBOL_MPD_T_NUM = 17,                 /* MPD_T_NUM  */
  YYSYMBOL_MPD_T_TIME = 18,                /* MPD_T_TIME  */
  YYSYMBOL_MPD_T_STRTAG = 19,              /* MPD_T_STRTAG  */
  YYSYMBOL_MPD_T_INTTAG = 20,              /* MPD_T_INTTAG  */
  YYSYMBOL_MPD_T_SINCETAG = 21,            /* MPD_T_SINCETAG  */
  YYSYMBOL_MPD_T_BASETAG = 22,             /* MPD_T_BASETAG  */
  YYSYMBOL_MPD_T_ANYTAG = 23,              /* MPD_T_ANYTAG  */
  YYSYMBOL_MPD_T_AUDIOFORMATTAG = 24,      /* MPD_T_AUDIOFORMATTAG  */
  YYSYMBOL_MPD_T_PARENS = 25,              /* MPD_T_PARENS  */
  YYSYMBOL_MPD_T_OR = 26,                  /* MPD_T_OR  */
  YYSYMBOL_MPD_T_AND = 27,                 /* MPD_T_AND  */
  YYSYMBOL_MPD_T_NOT = 28,                 /* MPD_T_NOT  */
  YYSYMBOL_MPD_T_CONTAINS = 29,            /* MPD_T_CONTAINS  */
  YYSYMBOL_MPD_T_STARTSWITH = 30,          /* MPD_T_STARTSWITH  */
  YYSYMBOL_MPD_T_ENDSWITH = 31,            /* MPD_T_ENDSWITH  */
  YYSYMBOL_MPD_T_EQUAL = 32,               /* MPD_T_EQUAL  */
  YYSYMBOL_MPD_T_NOTEQUAL = 33,            /* MPD_T_NOTEQUAL  */
  YYSYMBOL_MPD_T_LESS = 34,                /* MPD_T_LESS  */
  YYSYMBOL_MPD_T_LESSEQUAL = 35,           /* MPD_T_LESSEQUAL  */
  YYSYMBOL_MPD_T_GREATER = 36,             /* MPD_T_GREATER  */
  YYSYMBOL_MPD_T_GREATEREQUAL = 37,        /* MPD_T_GREATEREQUAL  */
  YYSYMBOL_38_ = 38,                       /* '('  */
  YYSYMBOL_39_ = 39,                       /* ')'  */
  YYSYMBOL_40_ = 40,                       /* '-'  */
  YYSYMBOL_41_ = 41,                       /* ':'  */
  YYSYMBOL_42_ = 42,                       /* '+'  */
  YYSYMBOL_YYACCEPT = 43,                  /* $accept  */
  YYSYMBOL_command = 44,                   /* command  */
  YYSYMBOL_tagtype = 45,                   /* tagtype  */
  YYSYMBOL_filter = 46,                    /* filter  */
  YYSYMBOL_sort = 47,                      /* sort  */
  YYSYMBOL_window = 48,                    /* window  */
  YYSYMBOL_position = 49,                  /* position  */
  YYSYMBOL_groups = 50,                    /* groups  */
  YYSYMBOL_group = 51,                     /* group  */
  YYSYMBOL_predicate = 52,                 /* predicate  */
  YYSYMBOL_strbool = 53,                   /* strbool  */
  YYSYMBOL_intbool = 54,                   /* intbool  */
  YYSYMBOL_cmd_fsw = 55,                   /* cmd_fsw  */
  YYSYMBOL_cmd_fswp = 56,                  /* cmd_fswp  */
  YYSYMBOL_cmd_fg = 57,                    /* cmd_fg  */
  YYSYMBOL_cmd_tfg = 58                    /* cmd_tfg  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;



/* Unqualified %code blocks.  */
#line 51 "parsers/mpd_parser.y"

  #include "mpd_lexer.h"

  int mpd_lex_cb(char *input, void (*cb)(int, const char *))
  {
    int ret;
    yyscan_t scanner;
    YY_BUFFER_STATE buf;
    YYSTYPE val;

    if ((ret = mpd_lex_init(&scanner)) != 0)
      return ret;

    buf = mpd__scan_string(input, scanner);

    while ((ret = mpd_lex(&val, scanner)) > 0)
      cb(ret, mpd_get_text(scanner));

    mpd__delete_buffer(buf, scanner);
    mpd_lex_destroy(scanner);
    return 0;
  }

  int mpd_lex_parse(struct mpd_result *result, const char *input)
  {
    YY_BUFFER_STATE buffer;
    yyscan_t scanner;
    int retval = -1;
    int ret;

    result->errmsg[0] = '\0'; // For safety

    ret = mpd_lex_init(&scanner);
    if (ret != 0)
      goto error_init;

    buffer = mpd__scan_string(input, scanner);
    if (!buffer)
      goto error_buffer;

    ret = mpd_parse(result, scanner);
    if (ret != 0)
      goto error_parse;

    retval = 0;

   error_parse:
    mpd__delete_buffer(buffer, scanner);
   error_buffer:
    mpd_lex_destroy(scanner);
   error_init:
    return retval;
  }

  void mpd_error(struct mpd_result *result, yyscan_t scanner, const char *msg)
  {
    snprintf(result->errmsg, sizeof(result->errmsg), "%s", msg);
  }

#line 114 "parsers/mpd_parser.y"

  struct ast
  {
    int type;
    struct ast *l;
    struct ast *r;
    void *data;
    int ival;
  };

  __attribute__((unused)) static struct ast * ast_new(int type, struct ast *l, struct ast *r)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->l = l;
    a->r = r;
    return a;
  }

  /* Note *data is expected to be freeable with regular free() */
  __attribute__((unused)) static struct ast * ast_data(int type, void *data)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->data = data;
    return a;
  }

  __attribute__((unused)) static struct ast * ast_int(int type, int ival)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->ival = ival;
    return a;
  }

  __attribute__((unused)) static void ast_free(struct ast *a)
  {
    if (!a)
      return;

    ast_free(a->l);
    ast_free(a->r);
    free(a->data);
    free(a);
  }
#line 251 "parsers/mpd_parser.y"

enum sql_append_type {
  SQL_APPEND_OPERATOR,
  SQL_APPEND_OPERATOR_STR,
  SQL_APPEND_OPERATOR_LIKE,
  SQL_APPEND_FIELD,
  SQL_APPEND_STR,
  SQL_APPEND_INT,
  SQL_APPEND_TIME,
  SQL_APPEND_ORDER,
  SQL_APPEND_PARENS,
};

static struct mpd_tag_map mpd_tag_map[] =
{
  { "Artist",             "f.artist",             MPD_TYPE_STRING,     dbmfi_offsetof(artist),            },
  { "ArtistSort",         "f.artist_sort",        MPD_TYPE_STRING,     dbmfi_offsetof(artist_sort),       },
  { "AlbumArtist",        "f.album_artist",       MPD_TYPE_STRING,     dbmfi_offsetof(album_artist),      },
  { "AlbumArtistSort",    "f.album_artist_sort",  MPD_TYPE_STRING,     dbmfi_offsetof(album_artist_sort), },
  { "Album",              "f.album",              MPD_TYPE_STRING,     dbmfi_offsetof(album),             },
  { "AlbumSort",          "f.album_sort",         MPD_TYPE_STRING,     dbmfi_offsetof(album_sort),        },
  { "Title",              "f.title",              MPD_TYPE_STRING,     dbmfi_offsetof(title),             },
  { "TitleSort",          "f.title_sort",         MPD_TYPE_STRING,     dbmfi_offsetof(title_sort),        },
  { "Genre",              "f.genre",              MPD_TYPE_STRING,     dbmfi_offsetof(genre),             },
  { "Composer",           "f.composer",           MPD_TYPE_STRING,     dbmfi_offsetof(composer),          },
  { "ComposerSort",       "f.composer_sort",      MPD_TYPE_STRING,     dbmfi_offsetof(composer_sort),     },
  { "file",               "f.virtual_path",       MPD_TYPE_SPECIAL,    dbmfi_offsetof(virtual_path),      },

  { "base",               "f.virtual_path",       MPD_TYPE_SPECIAL,    dbmfi_offsetof(virtual_path),      },

  { "Track",              "f.track",              MPD_TYPE_INT,        dbmfi_offsetof(track),             },
  { "Disc",               "f.disc",               MPD_TYPE_INT,        dbmfi_offsetof(disc),              },
  { "Date",               "f.year",               MPD_TYPE_INT,        dbmfi_offsetof(year),              },

  { "modified-since",     "f.time_modified",      MPD_TYPE_SPECIAL,    dbmfi_offsetof(time_modified),     },
  { "added-since",        "f.time_added",         MPD_TYPE_SPECIAL,    dbmfi_offsetof(time_added),        },

  // AudioFormat tag
  { "samplerate",         "f.samplerate",         MPD_TYPE_INT,        dbmfi_offsetof(samplerate),        },
  { "bits_per_sample",    "f.bits_per_sample",    MPD_TYPE_INT,        dbmfi_offsetof(bits_per_sample),   },
  { "channels",           "f.channels",           MPD_TYPE_INT,        dbmfi_offsetof(channels),          },

  { NULL },
};

static const char *
tag_to_dbcol(const char *tag)
{
  struct mpd_tag_map *mapptr;

  for (mapptr = mpd_tag_map; mapptr->name; mapptr++)
    {
      if (strcasecmp(tag, mapptr->name) == 0)
        return mapptr->dbcol;
    }

  return "error"; // Should never happen, means tag_to_db_map is out of sync with lexer
}

struct mpd_tag_map *
mpd_parser_tag_from_dbcol(const char *dbcol)
{
  struct mpd_tag_map *mapptr;

  if (!dbcol)
    return NULL;

  for (mapptr = mpd_tag_map; mapptr->name; mapptr++)
    {
      if (strcasecmp(dbcol, mapptr->dbcol) == 0)
        return mapptr;
    }

  return NULL;
}

void
mpd_parser_enum_tagtypes(void (*func)(struct mpd_tag_map *, void *), void *arg)
{
  struct mpd_tag_map *mapptr;

  for (mapptr = mpd_tag_map; mapptr->name; mapptr++)
    {
      func(mapptr, arg);
    }
}

// Remove any backslash that was used to escape single or double quotes
char *
mpd_parser_quoted(const char *str)
{
  char *out = strdup(str + 1); // Copy from after the first quote
  size_t len = strlen(out);
  const char *src;
  char *dst;

  out[len - 1] = '\0'; // Remove terminating quote

  // Remove escaping backslashes
  for (src = dst = out; *src != '\0'; src++, dst++)
    {
      if (*src == '\\')
	src++;
      if (*src == '\0')
	break;

      *dst = *src;
    }

  *dst = '\0';

  return out;
}

static void sql_from_ast(struct mpd_result *, struct mpd_result_part *, struct ast *);

// Escapes any '%' or '_' that might be in the string
static void sql_like_escape(char **value, char *escape_char)
{
  char *s = *value;
  size_t len = strlen(s);
  char *new;

  *escape_char = 0;

  // Fast path, nothing to escape
  if (!strpbrk(s, "_%"))
    return;

  len = 2 * len; // Enough for every char to be escaped
  new = realloc(s, len);
  safe_snreplace(new, len, "%", "\\%");
  safe_snreplace(new, len, "_", "\\_");
  *escape_char = '\\';
  *value = new;
}

static void sql_str_escape(char **value)
{
  char *old = *value;
  *value = db_escape_string(old);
  free(old);
}

static void sql_append(struct mpd_result *result, struct mpd_result_part *part, const char *fmt, ...)
{
  va_list ap;
  int remaining = sizeof(part->str) - part->offset;
  int ret;

  if (remaining <= 0)
    goto nospace;

  va_start(ap, fmt);
  ret = vsnprintf(part->str + part->offset, remaining, fmt, ap);
  va_end(ap);
  if (ret < 0 || ret >= remaining)
    goto nospace;

  part->offset += ret;
  return;

 nospace:
  snprintf(result->errmsg, sizeof(result->errmsg), "Parser output buffer too small (%zu bytes)", sizeof(part->str));
  result->err = -2;
}

static void sql_append_recursive(struct mpd_result *result, struct mpd_result_part *part, struct ast *a, const char *op, const char *op_not, bool is_not, enum sql_append_type append_type)
{
  char escape_char;

  if (result->recursion_level > RECURSION_MAX)
  {
    snprintf(result->errmsg, sizeof(result->errmsg), "Recursion maximum exceeded");
    result->err = -2;
    return;
  }

  result->recursion_level++;

  switch (append_type)
  {
    case SQL_APPEND_OPERATOR:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s ", is_not ? op_not : op);
      sql_from_ast(result, part, a->r);
      break;
    case SQL_APPEND_OPERATOR_STR:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s '", is_not ? op_not : op);
      sql_from_ast(result, part, a->r);
      sql_append(result, part, "'");
      break;
    case SQL_APPEND_OPERATOR_LIKE:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s '%s", is_not ? op_not : op, a->type == MPD_T_STARTSWITH ? "" : "%");
      sql_like_escape((char **)(&a->r->data), &escape_char);
      sql_from_ast(result, part, a->r);
      sql_append(result, part, "%s'", a->type == MPD_T_ENDSWITH ? "" : "%");
      if (escape_char)
        sql_append(result, part, " ESCAPE '%c'", escape_char);
      break;
    case SQL_APPEND_FIELD:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "%s", tag_to_dbcol((char *)a->data));
      break;
    case SQL_APPEND_STR:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_str_escape((char **)&a->data);
      sql_append(result, part, "%s", (char *)a->data);
      break;
    case SQL_APPEND_INT:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "%d", a->ival);
      break;
    case SQL_APPEND_TIME:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_str_escape((char **)&a->data);
      // MPD docs say the value can be a unix timestamp or ISO 8601
      sql_append(result, part, "strftime('%%s', datetime('%s', '%s'))", (char *)a->data, strchr((char *)a->data, '-') ? "utc" : "unixepoch");
      break;
    case SQL_APPEND_ORDER:
      assert(a->l == NULL);
      assert(a->r == NULL);
      if (a->data)
        sql_append(result, part, "%s ", tag_to_dbcol((char *)a->data));
      sql_append(result, part, "%s", is_not ? op_not : op);
      break;
    case SQL_APPEND_PARENS:
      assert(a->r == NULL);
      if (is_not ? op_not : op)
        sql_append(result, part, "%s ", is_not ? op_not : op);
      sql_append(result, part, "(");
      sql_from_ast(result, part, a->l);
      sql_append(result, part, ")");
      break;
  }

  result->recursion_level--;
}

/* Creates the parsing result from the AST. Errors are set via result->err. */
static void sql_from_ast(struct mpd_result *result, struct mpd_result_part *part, struct ast *a) {
  if (!a || result->err < 0)
    return;

  bool is_not = (a->type & INVERT_MASK);
  a->type &= ~INVERT_MASK;

  switch (a->type)
  {
    case MPD_T_LESS:
      sql_append_recursive(result, part, a, "<", ">=", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_LESSEQUAL:
      sql_append_recursive(result, part, a, "<=", ">", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_GREATER:
      sql_append_recursive(result, part, a, ">", ">=", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_GREATEREQUAL:
      sql_append_recursive(result, part, a, ">=", "<", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_EQUAL:
      sql_append_recursive(result, part, a, "=", "!=", is_not, SQL_APPEND_OPERATOR_STR); break;
    case MPD_T_NOTEQUAL:
      sql_append_recursive(result, part, a, "!=", "=", is_not, SQL_APPEND_OPERATOR_STR); break;
    case MPD_T_CONTAINS:
    case MPD_T_STARTSWITH:
    case MPD_T_ENDSWITH:
      sql_append_recursive(result, part, a, "LIKE", "NOT LIKE", is_not, SQL_APPEND_OPERATOR_LIKE); break;
    case MPD_T_AND:
      sql_append_recursive(result, part, a, "AND", "AND NOT", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_OR:
      sql_append_recursive(result, part, a, "OR", "OR NOT", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_STRING:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_STR); break;
    case MPD_T_STRTAG:
    case MPD_T_INTTAG:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_FIELD); break;
    case MPD_T_NUM:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_INT); break;
    case MPD_T_TIME:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_TIME); break;
    case MPD_T_SORT:
      sql_append_recursive(result, part, a, "ASC", "DESC", is_not, SQL_APPEND_ORDER); break;
    case MPD_T_GROUP:
      sql_append_recursive(result, part, a, ",", ",", is_not, SQL_APPEND_OPERATOR); break;
    case MPD_T_PARENS:
      sql_append_recursive(result, part, a, NULL, "NOT", is_not, SQL_APPEND_PARENS); break;
    default:
      snprintf(result->errmsg, sizeof(result->errmsg), "Parser produced unrecognized AST type %d", a->type);
      result->err = -1;
  }
}

static int result_set(struct mpd_result *result, char *tagtype, struct ast *filter, struct ast *sort, struct ast *window, char *position, struct ast *group)
{
  memset(result, 0, sizeof(struct mpd_result));

  if (tagtype)
    {
      snprintf(result->tagtype_buf, sizeof(result->tagtype_buf), "%s", tag_to_dbcol(tagtype));
      result->tagtype = result->tagtype_buf;
    }

  sql_from_ast(result, &result->where_part, filter);
  if (result->where_part.offset)
    result->where = result->where_part.str;

  sql_from_ast(result, &result->order_part, sort);
  if (result->order_part.offset)
    result->order = result->order_part.str;

  sql_from_ast(result, &result->group_part, group);
  if (tagtype)
    sql_append(result, &result->group_part, result->group_part.offset ? " , %s" : "%s", tag_to_dbcol(tagtype));
  if (result->group_part.offset)
    result->group = result->group_part.str;

  if (position)
    {
      snprintf(result->position_buf, sizeof(result->position_buf), "%s", position);
      result->position = result->position_buf;
    }

  if (window && window->l->ival <= window->r->ival)
    {
      result->offset = window->l->ival;
      result->limit = window->r->ival - window->l->ival + 1;
    }

  free(tagtype);
  free(position);
  ast_free(filter);
  ast_free(sort);
  ast_free(group);
  ast_free(window);

  return result->err;
}

static struct ast * ast_new_strnode(int type, const char *tag, const char *value)
{
  return ast_new(type, ast_data(MPD_T_STRTAG, strdup(tag)), ast_data(MPD_T_STRING, strdup(value))); 
}

/* This creates an OR ast tree with each tag in the tags array */
static struct ast * ast_new_any(int type, const char *value)
{
  const char *tags[] = { "albumartist", "artist", "album", "title", NULL, };
  const char **tagptr = tags;
  struct ast *a;
  int op = (type == MPD_T_NOTEQUAL) ? MPD_T_AND : MPD_T_OR;

  a = ast_new_strnode(type, *tagptr, value);
  for (tagptr++; *tagptr; tagptr++)
    a = ast_new(op, a, ast_new_strnode(type, *tagptr, value));

  // In case the expression will be negated, e.g. !(any contains 'cat'), we must
  // group the result
  return ast_new(MPD_T_PARENS, a, NULL);
}

static struct ast * ast_new_audioformat(int type, const char *value)
{
  const char *tags[] = { "samplerate", "bits_per_sample", "channels", NULL, };
  const char **tagptr = tags;
  char *value_copy = strdup(value);
  char *saveptr;
  char *token;
  struct ast *a;

  token = strtok_r(value_copy, ":", &saveptr);

  a = ast_new_strnode(type, "samplerate", value_copy);
  if (!token)
    goto end; // If there was no ':' we assume we just have a samplerate

  for (tagptr++, token = strtok_r(NULL, ":", &saveptr); *tagptr && token; tagptr++, token = strtok_r(NULL, ":", &saveptr))
    a = ast_new(MPD_T_AND, a, ast_new_strnode(type, *tagptr, token));

 end:
  free(value_copy);

  // In case the expression will be negated we group the result
  return ast_new(MPD_T_PARENS, a, NULL);
}

#line 846 "parsers/mpd_parser.c"

#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined MPD_STYPE_IS_TRIVIAL && MPD_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  15
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   91

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  43
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  16
/* YYNRULES -- Number of rules.  */
#define YYNRULES  51
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  93

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   292


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      38,    39,     2,    42,     2,    40,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    41,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37
};

#if MPD_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   738,   738,   739,   740,   741,   742,   743,   746,   749,
     750,   751,   752,   753,   756,   757,   758,   761,   762,   765,
     766,   767,   768,   771,   772,   775,   776,   780,   781,   782,
     783,   784,   785,   786,   789,   790,   791,   792,   793,   796,
     797,   798,   799,   802,   803,   804,   805,   808,   809,   812,
     813,   816
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "MPD_T_CMDSEARCH",
  "MPD_T_CMDSEARCHADD", "MPD_T_CMDFIND", "MPD_T_CMDFINDADD",
  "MPD_T_CMDCOUNT", "MPD_T_CMDSEARCHCOUNT", "MPD_T_CMDPLAYLISTFIND",
  "MPD_T_CMDPLAYLISTSEARCH", "MPD_T_CMDLIST", "MPD_T_SORT", "MPD_T_WINDOW",
  "MPD_T_POSITION", "MPD_T_GROUP", "MPD_T_STRING", "MPD_T_NUM",
  "MPD_T_TIME", "MPD_T_STRTAG", "MPD_T_INTTAG", "MPD_T_SINCETAG",
  "MPD_T_BASETAG", "MPD_T_ANYTAG", "MPD_T_AUDIOFORMATTAG", "MPD_T_PARENS",
  "MPD_T_OR", "MPD_T_AND", "MPD_T_NOT", "MPD_T_CONTAINS",
  "MPD_T_STARTSWITH", "MPD_T_ENDSWITH", "MPD_T_EQUAL", "MPD_T_NOTEQUAL",
  "MPD_T_LESS", "MPD_T_LESSEQUAL", "MPD_T_GREATER", "MPD_T_GREATEREQUAL",
  "'('", "')'", "'-'", "':'", "'+'", "$accept", "command", "tagtype",
  "filter", "sort", "window", "position", "groups", "group", "predicate",
  "strbool", "intbool", "cmd_fsw", "cmd_fswp", "cmd_fg", "cmd_tfg", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-27)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      38,   -27,   -27,   -27,   -27,   -27,   -27,   -27,   -27,   -27,
      24,   -26,   -26,   -26,    18,   -27,   -26,    12,    -9,   -27,
      -9,    -6,    23,   -27,   -26,   -27,    31,    22,    49,    50,
      31,    31,   -20,   -18,   -26,   -26,    26,    26,    23,     9,
     -27,    -6,    23,   -27,   -27,   -27,   -27,   -27,    51,   -27,
     -27,   -27,   -27,    52,    53,    30,    32,    56,    57,   -27,
     -27,    55,    48,   -27,    59,   -27,    63,   -27,   -27,    23,
      39,    40,    41,   -27,   -27,    42,    43,   -27,    44,   -17,
     -27,   -27,   -27,   -27,   -27,   -27,    66,   -27,    67,    69,
     -27,   -27,   -27
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,    45,    48,    46,    47,    49,    50,    43,    44,    51,
       0,     0,     0,    24,     0,     1,     0,     0,    16,    13,
      16,    24,     5,     8,    24,    12,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,    18,     4,     0,
      23,    24,     7,    36,    37,    38,    34,    35,     0,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,    11,
      14,     0,    10,     9,     0,     2,    22,    25,    26,     6,
       0,     0,     0,    32,    33,     0,     0,    15,     0,     0,
       3,    27,    28,    29,    30,    31,     0,    19,     0,     0,
      17,    21,    20
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -27,   -27,   -27,    -8,    68,    54,   -27,   -11,   -27,   -27,
     -16,   -27,   -27,   -27,   -27,   -27
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,    10,    24,    18,    36,    65,    80,    22,    40,    19,
      48,    54,    11,    12,    13,    14
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      87,    60,    16,    33,    20,    21,    34,    35,    25,    32,
      38,    53,    17,    42,    57,    58,    41,    34,    35,    59,
      34,    35,    61,    88,    15,    89,    62,    63,    67,    68,
      69,    26,    27,    28,    29,    30,    31,    23,    39,    64,
      16,     1,     2,     3,     4,     5,     6,     7,     8,     9,
      17,    43,    44,    45,    46,    47,    49,    50,    51,    52,
      43,    44,    45,    46,    47,    55,    56,    70,    71,    73,
      72,    74,    75,    76,    77,    35,    78,    79,    81,    82,
      83,    84,    85,    90,    91,    86,    92,     0,    37,     0,
       0,    66
};

static const yytype_int8 yycheck[] =
{
      17,    19,    28,    12,    12,    13,    26,    27,    16,    17,
      21,    27,    38,    24,    30,    31,    24,    26,    27,    39,
      26,    27,    40,    40,     0,    42,    34,    35,    19,    20,
      41,    19,    20,    21,    22,    23,    24,    19,    15,    13,
      28,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      38,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      29,    30,    31,    32,    33,    16,    16,    16,    16,    39,
      17,    39,    16,    16,    19,    27,    17,    14,    39,    39,
      39,    39,    39,    17,    17,    41,    17,    -1,    20,    -1,
      -1,    37
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      44,    55,    56,    57,    58,     0,    28,    38,    46,    52,
      46,    46,    50,    19,    45,    46,    19,    20,    21,    22,
      23,    24,    46,    12,    26,    27,    47,    47,    50,    15,
      51,    46,    50,    29,    30,    31,    32,    33,    53,    34,
      35,    36,    37,    53,    54,    16,    16,    53,    53,    39,
      19,    40,    46,    46,    13,    48,    48,    19,    20,    50,
      16,    16,    17,    39,    39,    16,    16,    19,    17,    14,
      49,    39,    39,    39,    39,    39,    41,    17,    40,    42,
      17,    17,    17
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    43,    44,    44,    44,    44,    44,    44,    45,    46,
      46,    46,    46,    46,    47,    47,    47,    48,    48,    49,
      49,    49,    49,    50,    50,    51,    51,    52,    52,    52,
      52,    52,    52,    52,    53,    53,    53,    53,    53,    54,
      54,    54,    54,    55,    55,    55,    55,    56,    56,    57,
      57,    58
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     4,     5,     3,     2,     4,     3,     1,     3,
       3,     3,     2,     1,     2,     3,     0,     4,     0,     2,
       3,     3,     0,     2,     0,     2,     2,     5,     5,     5,
       5,     5,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = MPD_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == MPD_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (result, scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use MPD_error or MPD_UNDEF. */
#define YYERRCODE MPD_UNDEF


/* Enable debugging if requested.  */
#if MPD_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, result, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct mpd_result *result, void *scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (result);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct mpd_result *result, void *scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, result, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, struct mpd_result *result, void *scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], result, scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, result, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !MPD_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !MPD_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, struct mpd_result *result, void *scanner)
{
  YY_USE (yyvaluep);
  YY_USE (result);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_MPD_T_STRING: /* MPD_T_STRING  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1874 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_MPD_T_STRTAG: /* MPD_T_STRTAG  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1880 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_MPD_T_INTTAG: /* MPD_T_INTTAG  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1886 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_MPD_T_SINCETAG: /* MPD_T_SINCETAG  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1892 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_MPD_T_BASETAG: /* MPD_T_BASETAG  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1898 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_tagtype: /* tagtype  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1904 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_filter: /* filter  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1910 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_sort: /* sort  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1916 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_window: /* window  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1922 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_position: /* position  */
#line 165 "parsers/mpd_parser.y"
            { free(((*yyvaluep).str)); }
#line 1928 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_groups: /* groups  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1934 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_group: /* group  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1940 "parsers/mpd_parser.c"
        break;

    case YYSYMBOL_predicate: /* predicate  */
#line 166 "parsers/mpd_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1946 "parsers/mpd_parser.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct mpd_result *result, void *scanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = MPD_EMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == MPD_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= MPD_EOF)
    {
      yychar = MPD_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == MPD_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = MPD_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = MPD_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* command: cmd_fsw filter sort window  */
#line 738 "parsers/mpd_parser.y"
                                                           { if (result_set(result, NULL, (yyvsp[-2].ast), (yyvsp[-1].ast), (yyvsp[0].ast), NULL, NULL) < 0) YYABORT; }
#line 2225 "parsers/mpd_parser.c"
    break;

  case 3: /* command: cmd_fswp filter sort window position  */
#line 739 "parsers/mpd_parser.y"
                                                           { if (result_set(result, NULL, (yyvsp[-3].ast), (yyvsp[-2].ast), (yyvsp[-1].ast), (yyvsp[0].str), NULL) < 0) YYABORT; }
#line 2231 "parsers/mpd_parser.c"
    break;

  case 4: /* command: cmd_fg filter groups  */
#line 740 "parsers/mpd_parser.y"
                                                           { if (result_set(result, NULL, (yyvsp[-1].ast), NULL, NULL, NULL, (yyvsp[0].ast)) < 0) YYABORT; }
#line 2237 "parsers/mpd_parser.c"
    break;

  case 5: /* command: cmd_fg groups  */
#line 741 "parsers/mpd_parser.y"
                                                           { if (result_set(result, NULL, NULL, NULL, NULL, NULL, (yyvsp[0].ast)) < 0) YYABORT; }
#line 2243 "parsers/mpd_parser.c"
    break;

  case 6: /* command: cmd_tfg tagtype filter groups  */
#line 742 "parsers/mpd_parser.y"
                                                           { if (result_set(result, (yyvsp[-2].str), (yyvsp[-1].ast), NULL, NULL, NULL, (yyvsp[0].ast)) < 0) YYABORT; }
#line 2249 "parsers/mpd_parser.c"
    break;

  case 7: /* command: cmd_tfg tagtype groups  */
#line 743 "parsers/mpd_parser.y"
                                                           { if (result_set(result, (yyvsp[-1].str), NULL, NULL, NULL, NULL, (yyvsp[0].ast)) < 0) YYABORT; }
#line 2255 "parsers/mpd_parser.c"
    break;

  case 8: /* tagtype: MPD_T_STRTAG  */
#line 746 "parsers/mpd_parser.y"
                                                           { if (asprintf(&((yyval.str)), "%s", (yyvsp[0].str)) < 0) YYABORT; }
#line 2261 "parsers/mpd_parser.c"
    break;

  case 9: /* filter: filter MPD_T_AND filter  */
#line 749 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_AND, (yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 2267 "parsers/mpd_parser.c"
    break;

  case 10: /* filter: filter MPD_T_OR filter  */
#line 750 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_OR, (yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 2273 "parsers/mpd_parser.c"
    break;

  case 11: /* filter: '(' filter ')'  */
#line 751 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_PARENS, (yyvsp[-1].ast), NULL); }
#line 2279 "parsers/mpd_parser.c"
    break;

  case 12: /* filter: MPD_T_NOT filter  */
#line 752 "parsers/mpd_parser.y"
                                                           { struct ast *a = (yyvsp[0].ast); a->type |= INVERT_MASK; (yyval.ast) = (yyvsp[0].ast); }
#line 2285 "parsers/mpd_parser.c"
    break;

  case 14: /* sort: MPD_T_SORT MPD_T_STRTAG  */
#line 756 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_data(MPD_T_SORT, (yyvsp[0].str)); }
#line 2291 "parsers/mpd_parser.c"
    break;

  case 15: /* sort: MPD_T_SORT '-' MPD_T_STRTAG  */
#line 757 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_data(MPD_T_SORT | INVERT_MASK, (yyvsp[0].str)); }
#line 2297 "parsers/mpd_parser.c"
    break;

  case 16: /* sort: %empty  */
#line 758 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = NULL; }
#line 2303 "parsers/mpd_parser.c"
    break;

  case 17: /* window: MPD_T_WINDOW MPD_T_NUM ':' MPD_T_NUM  */
#line 761 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_WINDOW, ast_int(MPD_T_NUM, (yyvsp[-2].ival)), ast_int(MPD_T_NUM, (yyvsp[0].ival))); }
#line 2309 "parsers/mpd_parser.c"
    break;

  case 18: /* window: %empty  */
#line 762 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = NULL; }
#line 2315 "parsers/mpd_parser.c"
    break;

  case 19: /* position: MPD_T_POSITION MPD_T_NUM  */
#line 765 "parsers/mpd_parser.y"
                                                           { if (asprintf(&((yyval.str)), "%d", (yyvsp[0].ival)) < 0) YYABORT; }
#line 2321 "parsers/mpd_parser.c"
    break;

  case 20: /* position: MPD_T_POSITION '+' MPD_T_NUM  */
#line 766 "parsers/mpd_parser.y"
                                                           { if (asprintf(&((yyval.str)), "+%d", (yyvsp[0].ival)) < 0) YYABORT; }
#line 2327 "parsers/mpd_parser.c"
    break;

  case 21: /* position: MPD_T_POSITION '-' MPD_T_NUM  */
#line 767 "parsers/mpd_parser.y"
                                                           { if (asprintf(&((yyval.str)), "-%d", (yyvsp[0].ival)) < 0) YYABORT; }
#line 2333 "parsers/mpd_parser.c"
    break;

  case 22: /* position: %empty  */
#line 768 "parsers/mpd_parser.y"
                                                           { (yyval.str) = NULL; }
#line 2339 "parsers/mpd_parser.c"
    break;

  case 23: /* groups: groups group  */
#line 771 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = (yyvsp[-1].ast) ? ast_new(MPD_T_GROUP, (yyvsp[0].ast), (yyvsp[-1].ast)) : (yyvsp[0].ast); }
#line 2345 "parsers/mpd_parser.c"
    break;

  case 24: /* groups: %empty  */
#line 772 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = NULL; }
#line 2351 "parsers/mpd_parser.c"
    break;

  case 25: /* group: MPD_T_GROUP MPD_T_STRTAG  */
#line 775 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_data(MPD_T_STRTAG, (yyvsp[0].str)); }
#line 2357 "parsers/mpd_parser.c"
    break;

  case 26: /* group: MPD_T_GROUP MPD_T_INTTAG  */
#line 776 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_data(MPD_T_INTTAG, (yyvsp[0].str)); }
#line 2363 "parsers/mpd_parser.c"
    break;

  case 27: /* predicate: '(' MPD_T_STRTAG strbool MPD_T_STRING ')'  */
#line 780 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new((yyvsp[-2].ival), ast_data(MPD_T_STRTAG, (yyvsp[-3].str)), ast_data(MPD_T_STRING, (yyvsp[-1].str))); }
#line 2369 "parsers/mpd_parser.c"
    break;

  case 28: /* predicate: '(' MPD_T_INTTAG strbool MPD_T_STRING ')'  */
#line 781 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new((yyvsp[-2].ival), ast_data(MPD_T_STRTAG, (yyvsp[-3].str)), ast_data(MPD_T_STRING, (yyvsp[-1].str))); }
#line 2375 "parsers/mpd_parser.c"
    break;

  case 29: /* predicate: '(' MPD_T_INTTAG intbool MPD_T_NUM ')'  */
#line 782 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new((yyvsp[-2].ival), ast_data(MPD_T_INTTAG, (yyvsp[-3].str)), ast_int(MPD_T_NUM, (yyvsp[-1].ival))); }
#line 2381 "parsers/mpd_parser.c"
    break;

  case 30: /* predicate: '(' MPD_T_ANYTAG strbool MPD_T_STRING ')'  */
#line 783 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new_any((yyvsp[-2].ival), (yyvsp[-1].str)); }
#line 2387 "parsers/mpd_parser.c"
    break;

  case 31: /* predicate: '(' MPD_T_AUDIOFORMATTAG strbool MPD_T_STRING ')'  */
#line 784 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new_audioformat((yyvsp[-2].ival), (yyvsp[-1].str)); }
#line 2393 "parsers/mpd_parser.c"
    break;

  case 32: /* predicate: '(' MPD_T_SINCETAG MPD_T_STRING ')'  */
#line 785 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_GREATEREQUAL, ast_data(MPD_T_STRTAG, (yyvsp[-2].str)), ast_data(MPD_T_TIME, (yyvsp[-1].str))); }
#line 2399 "parsers/mpd_parser.c"
    break;

  case 33: /* predicate: '(' MPD_T_BASETAG MPD_T_STRING ')'  */
#line 786 "parsers/mpd_parser.y"
                                                           { (yyval.ast) = ast_new(MPD_T_STARTSWITH, ast_data(MPD_T_STRTAG, (yyvsp[-2].str)), ast_data(MPD_T_STRING, (yyvsp[-1].str))); }
#line 2405 "parsers/mpd_parser.c"
    break;


#line 2409 "parsers/mpd_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == MPD_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (result, scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= MPD_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == MPD_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, result, scanner);
          yychar = MPD_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, result, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (result, scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != MPD_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, result, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, result, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 819 "parsers/mpd_parser.y"


