/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder;

import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;

public class Base64 {
    private static Encoder base64encoder;

    public static void setEncoder(Encoder encoder) {
        Objects.requireNonNull(encoder, "encoder must no be null");
        base64encoder = encoder;
    }

    public static final String encode(String string2) {
        return Base64.encodeToString(string2.getBytes(StandardCharsets.UTF_8));
    }

    public static final String encodeToString(byte[] input) {
        return base64encoder.encodeToString(input);
    }

    public static final String encodeToString(byte[] input, int offset, int len) {
        return Base64.encodeToString(Base64.slice(input, offset, len));
    }

    public static final String encodeToStringWithoutPadding(byte[] input) {
        return base64encoder.encodeToStringWithoutPadding(input);
    }

    public static final byte[] encode(byte[] input) {
        return base64encoder.encode(input);
    }

    public static final String decodeToString(String string2) {
        byte[] bytes = Base64.decode(string2);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static final byte[] decode(String string2) {
        string2 = StringUtils.deleteXmlWhitespace(string2);
        try {
            return base64encoder.decode(string2);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final byte[] decode(byte[] input) {
        String string2 = new String(input, StandardCharsets.US_ASCII);
        return Base64.decode(string2);
    }

    private static byte[] slice(byte[] input, int offset, int len) {
        if (offset == 0 && len == input.length) {
            return input;
        }
        byte[] res = new byte[len];
        System.arraycopy(input, offset, res, 0, len);
        return res;
    }

    public static interface Encoder {
        public byte[] decode(String var1);

        public String encodeToString(byte[] var1);

        public String encodeToStringWithoutPadding(byte[] var1);

        public byte[] encode(byte[] var1);
    }
}

