/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.AdHocCommandResult;
import org.jivesoftware.smackx.commands.SpecificErrorCondition;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;

public abstract class AbstractAdHocCommand {
    private final List<AdHocCommandData> requests = new ArrayList<AdHocCommandData>();
    private final List<AdHocCommandResult> results = new ArrayList<AdHocCommandResult>();
    private final String node;
    private final String name;
    private String sessionId;

    protected AbstractAdHocCommand(String node, String name) {
        this.node = StringUtils.requireNotNullNorEmpty(node, "Ad-Hoc command node must be given");
        this.name = name;
    }

    protected AbstractAdHocCommand(String node) {
        this(node, null);
    }

    void addRequest(AdHocCommandData request) {
        this.requests.add(request);
    }

    void addResult(AdHocCommandResult result) {
        this.results.add(result);
    }

    public static SpecificErrorCondition getSpecificErrorCondition(StanzaError error) {
        for (SpecificErrorCondition condition : SpecificErrorCondition.values()) {
            if (error.getExtension(condition.toString(), "http://jabber.org/protocol/commands") == null) continue;
            return condition;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(String sessionId) {
        assert (this.sessionId == null || this.sessionId.equals(sessionId));
        this.sessionId = StringUtils.requireNotNullNorEmpty(sessionId, "Must provide a session ID");
    }

    public AdHocCommandData getLastRequest() {
        if (this.requests.isEmpty()) {
            return null;
        }
        return this.requests.get(this.requests.size() - 1);
    }

    public AdHocCommandResult getLastResult() {
        if (this.results.isEmpty()) {
            return null;
        }
        return this.results.get(this.results.size() - 1);
    }

    public List<AdHocCommandNote> getNotes() {
        AdHocCommandResult result = this.getLastResult();
        if (result == null) {
            return null;
        }
        return result.getResponse().getNotes();
    }

    public abstract void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public final Set<AdHocCommandData.AllowedAction> getActions() {
        AdHocCommandResult result = this.getLastResult();
        if (result == null) {
            return null;
        }
        return result.getResponse().getActions();
    }

    protected AdHocCommandData.AllowedAction getExecuteAction() {
        AdHocCommandResult result = this.getLastResult();
        if (result == null) {
            return null;
        }
        return result.getResponse().getExecuteAction();
    }

    public AdHocCommandData.Status getStatus() {
        AdHocCommandResult result = this.getLastResult();
        if (result == null) {
            return null;
        }
        return result.getResponse().getStatus();
    }

    public boolean isCompleted() {
        return this.getStatus() == AdHocCommandData.Status.completed;
    }

    public final boolean isValidAction(AdHocCommandData.Action action) {
        Set<AdHocCommandData.AllowedAction> actions;
        AdHocCommandData.AllowedAction executeAction;
        if (action == AdHocCommandData.Action.cancel) {
            return true;
        }
        if (action == AdHocCommandData.Action.execute) {
            AdHocCommandResult result = this.getLastResult();
            executeAction = result.getResponse().getExecuteAction();
            if (executeAction == null) {
                return false;
            }
        } else {
            executeAction = action.allowedAction;
            assert (executeAction != null);
        }
        return (actions = this.getActions()) != null && actions.contains((Object)executeAction);
    }
}

