/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jid_prep;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jid_prep.element.JidPrepIq;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;

public class JidPrepManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:jidprep:0";
    private static final Map<XMPPConnection, JidPrepManager> INSTANCES = new WeakHashMap<XMPPConnection, JidPrepManager>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized JidPrepManager getInstanceFor(XMPPConnection connection) {
        JidPrepManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new JidPrepManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public JidPrepManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
    }

    public String requestJidPrep(String jidToBePrepped) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DomainBareJid serviceAddress = this.serviceDiscoveryManager.findService(NAMESPACE, true);
        return this.requestJidPrep(serviceAddress, jidToBePrepped);
    }

    public String requestJidPrep(Jid jidPrepService, String jidToBePrepped) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        JidPrepIq jidPrepResponse;
        JidPrepIq jidPrepRequest = new JidPrepIq(jidToBePrepped);
        jidPrepRequest.setTo(jidPrepService);
        try {
            jidPrepResponse = (JidPrepIq)this.connection().sendIqRequestAndWaitForResponse(jidPrepRequest);
        }
        catch (XMPPException.XMPPErrorException e) {
            StanzaError stanzaError = e.getStanzaError();
            if (stanzaError.getCondition() == StanzaError.Condition.jid_malformed) {
                return null;
            }
            throw e;
        }
        return jidPrepResponse.getJid();
    }

    public boolean isSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serviceDiscoveryManager.supportsFeature(jid, NAMESPACE);
    }
}

