/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood.element;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;

public class MoodElement
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/mood";
    public static final String ELEMENT = "mood";
    public static final QName QNAME = new QName("http://jabber.org/protocol/mood", "mood");
    public static final String ELEM_TEXT = "text";
    private final MoodSubjectElement mood;
    private final String text;

    public MoodElement(MoodSubjectElement mood, String text) {
        if (mood == null && text != null) {
            throw new IllegalArgumentException("If <mood/> is null, text MUST be null too.");
        }
        this.mood = mood;
        this.text = text;
    }

    public Mood getMood() {
        return this.mood != null ? this.mood.getMood() : null;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public MoodConcretisation getMoodConcretisation() {
        return this.mood != null ? this.mood.getConcretisation() : null;
    }

    public boolean hasConcretisation() {
        return this.getMoodConcretisation() != null;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
        if (this.mood == null && this.text == null) {
            return xml.closeEmptyElement();
        }
        xml.rightAngleBracket();
        xml.optAppend(this.mood);
        if (this.text != null) {
            xml.openElement(ELEM_TEXT).append(this.text).closeElement(ELEM_TEXT);
        }
        return xml.closeElement(this.getElementName());
    }

    public static MoodElement fromMessage(Message message) {
        return message.getExtension(MoodElement.class);
    }

    public static boolean hasMoodElement(Message message) {
        return message.hasExtension(ELEMENT, NAMESPACE);
    }

    public static class MoodSubjectElement
    implements XmlElement {
        private final Mood mood;
        private final MoodConcretisation concretisation;

        public MoodSubjectElement(Mood mood, MoodConcretisation concretisation) {
            this.mood = Objects.requireNonNull(mood);
            this.concretisation = concretisation;
        }

        @Override
        public String getElementName() {
            return this.mood.toString();
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            if (this.concretisation == null) {
                return xml.closeEmptyElement();
            }
            xml.rightAngleBracket().append(this.concretisation).closeElement(this);
            return xml;
        }

        public Mood getMood() {
            return this.mood;
        }

        public MoodConcretisation getConcretisation() {
            return this.concretisation;
        }

        @Override
        public String getNamespace() {
            return MoodElement.NAMESPACE;
        }
    }
}

