/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class MUCParserUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static MUCItem parseItem(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        MUCAffiliation affiliation = MUCAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
        Resourcepart nick = ParserUtils.getResourcepartAttribute(parser, "nick", jxmppContext);
        MUCRole role = MUCRole.fromString(parser.getAttributeValue("", "role"));
        Jid jid = ParserUtils.getJidAttribute(parser, jxmppContext);
        Jid actor = null;
        Resourcepart actorNick = null;
        String reason = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "actor": {
                            actor = ParserUtils.getJidAttribute(parser, jxmppContext);
                            String actorNickString = parser.getAttributeValue("", "nick");
                            if (actorNickString != null) {
                                actorNick = Resourcepart.from(actorNickString);
                                break;
                            }
                            break block0;
                        }
                        case "reason": {
                            reason = parser.nextText();
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new MUCItem(affiliation, role, actor, reason, jid, nick, actorNick);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Destroy parseDestroy(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        EntityBareJid jid = ParserUtils.getBareJidAttribute(parser, jxmppContext);
        String reason = null;
        String password = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "reason": {
                            reason = parser.nextText();
                            break block0;
                        }
                        case "password": {
                            password = parser.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (initialDepth != parser.getDepth()) break;
                    return new Destroy(jid, password, reason);
                }
            }
        }
    }
}

