/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.muc.provider.MUCParserUtils;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;

public class MUCUserProvider
extends ExtensionElementProvider<MUCUser> {
    @Override
    public MUCUser parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        MUCUser mucUser = new MUCUser();
        block20: while (true) {
            switch (parser.next()) {
                case START_ELEMENT: {
                    switch (parser.getName()) {
                        case "invite": {
                            MUCUser.Invite invite = MUCUserProvider.parseInvite(parser, jxmppContext);
                            mucUser.setInvite(invite);
                            break;
                        }
                        case "item": {
                            MUCItem item = MUCParserUtils.parseItem(parser, jxmppContext);
                            mucUser.setItem(item);
                            break;
                        }
                        case "password": {
                            mucUser.setPassword(parser.nextText());
                            break;
                        }
                        case "status": {
                            String statusString = parser.getAttributeValue("", "code");
                            mucUser.addStatusCode(MUCUser.Status.create(statusString));
                            break;
                        }
                        case "decline": {
                            MUCUser.Decline decline = MUCUserProvider.parseDecline(parser, jxmppContext);
                            mucUser.setDecline(decline);
                            break;
                        }
                        case "destroy": {
                            Destroy destroy = MUCParserUtils.parseDestroy(parser, jxmppContext);
                            mucUser.setDestroy(destroy);
                        }
                    }
                    continue block20;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) continue block20;
                    break block20;
                }
                default: {
                    continue block20;
                }
            }
            break;
        }
        return mucUser;
    }

    private static MUCUser.Invite parseInvite(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String reason = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser, "to", jxmppContext);
        EntityJid from = ParserUtils.getEntityJidAttribute(parser, "from", jxmppContext);
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("reason")) continue;
                reason = parser.nextText();
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getName().equals("invite")) break;
        }
        return new MUCUser.Invite(reason, from, to);
    }

    private static MUCUser.Decline parseDecline(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String reason = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser, "to", jxmppContext);
        EntityBareJid from = ParserUtils.getBareJidAttribute(parser, "from", jxmppContext);
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("reason")) continue;
                reason = parser.nextText();
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getName().equals("decline")) break;
        }
        return new MUCUser.Decline(reason, from, to);
    }
}

