/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.si.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jxmpp.JxmppContext;
import org.jxmpp.util.XmppDateTime;

public class StreamInitiationProvider
extends IqProvider<StreamInitiation> {
    private static final Logger LOGGER = Logger.getLogger(StreamInitiationProvider.class.getName());

    @Override
    public StreamInitiation parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        String id = parser.getAttributeValue("", "id");
        String mimeType = parser.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size2 = null;
        String hash = null;
        String date = null;
        String desc = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("file")) {
                    name = parser.getAttributeValue("", "name");
                    size2 = parser.getAttributeValue("", "size");
                    hash = parser.getAttributeValue("", "hash");
                    date = parser.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (!elementName.equals("x") || !namespace.equals("jabber:x:data")) continue;
                form = (DataForm)dataFormProvider.parse(parser);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT) continue;
            if (parser.getDepth() == initialDepth) break;
            if (!parser.getName().equals("file")) continue;
            long fileSize = 0L;
            if (size2 != null && size2.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size2);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse file size from " + fileSize, e);
                }
            }
            Date fileDate = new Date();
            if (date != null) {
                try {
                    fileDate = XmppDateTime.parseDate(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            StreamInitiation.File file = new StreamInitiation.File(name, fileSize);
            file.setHash(hash);
            file.setDate(fileDate);
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile(file);
        }
        initiation.setSessionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }
}

