/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.io.IOException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.jxmpp.JxmppContext;

public class Macros
extends IQ {
    public static final String ELEMENT_NAME = "macros";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private MacroGroup rootGroup;
    private boolean personal;
    private MacroGroup personalMacroGroup;

    public Macros() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public MacroGroup getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(MacroGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public MacroGroup getPersonalMacroGroup() {
        return this.personalMacroGroup;
    }

    public void setPersonalMacroGroup(MacroGroup personalMacroGroup) {
        this.personalMacroGroup = personalMacroGroup;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        if (this.isPersonal()) {
            buf.append("<personal>true</personal>");
        }
        if (this.getPersonalMacroGroup() != null) {
            buf.append("<personalMacro>");
            buf.append(StringUtils.escapeForXmlText(this.getPersonalMacroGroup().toXML()));
            buf.append("</personalMacro>");
        }
        return buf;
    }

    public static class InternalProvider
    extends IqProvider<Macros> {
        @Override
        public Macros parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            Macros macroGroup = new Macros();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if (!parser.getName().equals("model")) continue;
                    String macros2 = parser.nextText();
                    MacroGroup group2 = this.parseMacroGroups(macros2);
                    macroGroup.setRootGroup(group2);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(Macros.ELEMENT_NAME)) continue;
                done = true;
            }
            return macroGroup;
        }

        public Macro parseMacro(XmlPullParser parser) throws XmlPullParserException, IOException {
            Macro macro = new Macro();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if (parser.getName().equals("title")) {
                        parser.next();
                        macro.setTitle(parser.getText());
                        continue;
                    }
                    if (parser.getName().equals("description")) {
                        macro.setDescription(parser.nextText());
                        continue;
                    }
                    if (parser.getName().equals("response")) {
                        macro.setResponse(parser.nextText());
                        continue;
                    }
                    if (!parser.getName().equals("type")) continue;
                    macro.setType(Integer.valueOf(parser.nextText()));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("macro")) continue;
                done = true;
            }
            return macro;
        }

        public MacroGroup parseMacroGroup(XmlPullParser parser) throws XmlPullParserException, IOException {
            MacroGroup group2 = new MacroGroup();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if (parser.getName().equals("macrogroup")) {
                        group2.addMacroGroup(this.parseMacroGroup(parser));
                    }
                    if (parser.getName().equals("title")) {
                        group2.setTitle(parser.nextText());
                    }
                    if (!parser.getName().equals("macro")) continue;
                    group2.addMacro(this.parseMacro(parser));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("macrogroup")) continue;
                done = true;
            }
            return group2;
        }

        public MacroGroup parseMacroGroups(String macros2) throws XmlPullParserException, IOException {
            MacroGroup group2 = null;
            XmlPullParser parser = PacketParserUtils.getParserFor(macros2);
            XmlPullParser.Event eventType = parser.getEventType();
            while (eventType != XmlPullParser.Event.END_DOCUMENT) {
                eventType = parser.next();
                if (eventType != XmlPullParser.Event.START_ELEMENT || !parser.getName().equals("macrogroup")) continue;
                group2 = this.parseMacroGroup(parser);
            }
            return group2;
        }
    }
}

