/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.agent.InvitationRequest;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;
import org.jivesoftware.smackx.workgroup.agent.TransferRequest;
import org.jivesoftware.smackx.workgroup.agent.UserRequest;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.util.MetaDataUtils;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;

public class OfferRequestProvider
extends IqProvider<IQ> {
    @Override
    public OfferRequestPacket parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        Jid userJID;
        XmlPullParser.Event eventType = parser.getEventType();
        String sessionID = null;
        int timeout = -1;
        OfferContent content = null;
        boolean done = false;
        Map<String, List<String>> metaData = new HashMap<String, List<String>>();
        if (eventType != XmlPullParser.Event.START_ELEMENT) {
            // empty if block
        }
        Jid userID = userJID = ParserUtils.getJidAttribute(parser, jxmppContext);
        while (!done) {
            eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String elemName = parser.getName();
                if ("timeout".equals(elemName)) {
                    timeout = Integer.parseInt(parser.nextText());
                    continue;
                }
                if ("metadata".equals(elemName)) {
                    metaData = MetaDataUtils.parseMetaData(parser);
                    continue;
                }
                if ("session".equals(elemName)) {
                    sessionID = parser.getAttributeValue("", "id");
                    continue;
                }
                if ("user".equals(elemName)) {
                    userID = ParserUtils.getJidAttribute(parser, "id", jxmppContext);
                    continue;
                }
                if ("user-request".equals(elemName)) {
                    content = UserRequest.getInstance();
                    continue;
                }
                if ("invite".equals(elemName)) {
                    RoomInvitation invitation = (RoomInvitation)PacketParserUtils.parseExtensionElement("invite", "http://jabber.org/protocol/workgroup", parser, xmlEnvironment, jxmppContext);
                    content = new InvitationRequest(invitation.getInviter(), invitation.getRoom(), invitation.getReason());
                    continue;
                }
                if (!"transfer".equals(elemName)) continue;
                RoomTransfer transfer = (RoomTransfer)PacketParserUtils.parseExtensionElement("transfer", "http://jabber.org/protocol/workgroup", parser, xmlEnvironment, jxmppContext);
                content = new TransferRequest(transfer.getInviter(), transfer.getRoom(), transfer.getReason());
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !"offer".equals(parser.getName())) continue;
            done = true;
        }
        OfferRequestPacket offerRequest = new OfferRequestPacket(userJID, userID, timeout, metaData, sessionID, content);
        offerRequest.setType(IQ.Type.set);
        return offerRequest;
    }

    public static class OfferRequestPacket
    extends IQ {
        public static final String ELEMENT = "offer";
        public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
        private final int timeout;
        private final Jid userID;
        private final Jid userJID;
        private final Map<String, List<String>> metaData;
        private final String sessionID;
        private final OfferContent content;

        public OfferRequestPacket(Jid userJID, Jid userID, int timeout, Map<String, List<String>> metaData, String sessionID, OfferContent content) {
            super(ELEMENT, NAMESPACE);
            this.userJID = userJID;
            this.userID = userID;
            this.timeout = timeout;
            this.metaData = metaData;
            this.sessionID = sessionID;
            this.content = content;
        }

        public Jid getUserID() {
            return this.userID;
        }

        public Jid getUserJID() {
            return this.userJID;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public OfferContent getContent() {
            return this.content;
        }

        public Map<String, List<String>> getMetaData() {
            return this.metaData;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
            buf.append(" jid=\"").append(this.userJID).append("\">");
            buf.append("<timeout>").append(Integer.toString(this.timeout)).append("</timeout>");
            if (this.sessionID != null) {
                buf.append('<').append("session");
                buf.append(" session=\"");
                buf.append(this.getSessionID()).append("\" xmlns=\"");
                buf.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            if (this.metaData != null) {
                buf.append(MetaDataUtils.serializeMetaData(this.metaData));
            }
            if (this.userID != null) {
                buf.append('<').append("user");
                buf.append(" id=\"");
                buf.append(this.userID).append("\" xmlns=\"");
                buf.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            return buf;
        }
    }
}

