/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class RoomInvitation
implements ExtensionElement {
    public static final String ELEMENT_NAME = "invite";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    public static final QName QNAME = new QName("http://jabber.org/protocol/workgroup", "invite");
    private Type type;
    private Jid invitee;
    private EntityJid inviter;
    private String sessionID;
    private EntityBareJid room;
    private String reason;

    public RoomInvitation(Type type, Jid invitee, String sessionID, String reason) {
        this.type = type;
        this.invitee = invitee;
        this.sessionID = sessionID;
        this.reason = reason;
    }

    private RoomInvitation() {
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public EntityJid getInviter() {
        return this.inviter;
    }

    public EntityBareJid getRoom() {
        return this.room;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        IQ.IQChildElementXmlStringBuilder xml = this.getIQChildElementBuilder(new IQ.IQChildElementXmlStringBuilder(this, enclosingNamespace));
        xml.closeElement(this);
        return xml;
    }

    public IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append(" type=\"").append(this.type.name()).append("\">");
        buf.append("<session xmlns=\"http://jivesoftware.com/protocol/workgroup\" id=\"").append(this.sessionID).append("\"></session>");
        if (this.invitee != null) {
            buf.append("<invitee>").append(this.invitee).append("</invitee>");
        }
        if (this.inviter != null) {
            buf.append("<inviter>").append(this.inviter).append("</inviter>");
        }
        if (this.reason != null) {
            buf.append("<reason>").append(this.reason).append("</reason>");
        }
        return buf;
    }

    public static enum Type {
        user,
        queue,
        workgroup;

    }

    public static class Provider
    extends ExtensionElementProvider<RoomInvitation> {
        @Override
        public RoomInvitation parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            RoomInvitation invitation = new RoomInvitation();
            invitation.type = Type.valueOf(parser.getAttributeValue("", "type"));
            while (true) {
                parser.next();
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT) {
                    String elementName = parser.getName();
                    if ("session".equals(elementName)) {
                        invitation.sessionID = parser.getAttributeValue("", "id");
                        continue;
                    }
                    if ("invitee".equals(elementName)) {
                        String inviteeString = parser.nextText();
                        invitation.invitee = JidCreate.from(inviteeString);
                        continue;
                    }
                    if ("inviter".equals(elementName)) {
                        String inviterString = parser.nextText();
                        invitation.inviter = JidCreate.entityFrom(inviterString);
                        continue;
                    }
                    if ("reason".equals(elementName)) {
                        invitation.reason = parser.nextText();
                        continue;
                    }
                    if (!"room".equals(elementName)) continue;
                    String roomString = parser.nextText();
                    invitation.room = JidCreate.entityBareFrom(roomString);
                    continue;
                }
                if (parser.getEventType() == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
            }
            return invitation;
        }
    }

    public static class RoomInvitationIQ
    extends IQ {
        private final RoomInvitation roomInvitation;

        public RoomInvitationIQ(RoomInvitation roomInvitation) {
            super(RoomInvitation.ELEMENT_NAME, RoomInvitation.NAMESPACE);
            this.roomInvitation = roomInvitation;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            return this.roomInvitation.getIQChildElementBuilder(xml);
        }
    }
}

