/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.io.IOException;
import java.util.Set;
import org.minidns.DnsCache;
import org.minidns.MiniDnsException;
import org.minidns.cache.LruCache;
import org.minidns.cache.MiniDnsCacheFactory;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DnssecClient;
import org.minidns.dnssec.DnssecQueryResult;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.hla.ResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class DnssecResolverApi
extends ResolverApi {
    public static final DnssecResolverApi INSTANCE = new DnssecResolverApi();
    private final DnssecClient dnssecClient;
    private final DnssecClient iterativeOnlyDnssecClient;
    private final DnssecClient recursiveOnlyDnssecClient;

    public DnssecResolverApi() {
        this(new MiniDnsCacheFactory(){

            @Override
            public DnsCache newCache() {
                return new LruCache();
            }
        });
    }

    public DnssecResolverApi(MiniDnsCacheFactory cacheFactory) {
        this(new DnssecClient(cacheFactory.newCache()), cacheFactory);
    }

    private DnssecResolverApi(DnssecClient dnssecClient, MiniDnsCacheFactory cacheFactory) {
        super(dnssecClient);
        this.dnssecClient = dnssecClient;
        this.iterativeOnlyDnssecClient = new DnssecClient(cacheFactory.newCache());
        this.iterativeOnlyDnssecClient.setMode(ReliableDnsClient.Mode.iterativeOnly);
        this.recursiveOnlyDnssecClient = new DnssecClient(cacheFactory.newCache());
        this.recursiveOnlyDnssecClient.setMode(ReliableDnsClient.Mode.recursiveOnly);
    }

    @Override
    public <D extends Data> ResolverResult<D> resolve(Question question) throws IOException {
        DnssecQueryResult dnssecMessage = this.dnssecClient.queryDnssec(question);
        return DnssecResolverApi.toResolverResult(question, dnssecMessage);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(String name, Class<D> type) throws IOException {
        return this.resolveDnssecReliable(DnsName.from(name), type);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(DnsName name, Class<D> type) throws IOException {
        Record.TYPE t = Record.TYPE.getType(type);
        Question q = new Question(name, t);
        return this.resolveDnssecReliable(q);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(Question question) throws IOException {
        DnssecQueryResult dnssecMessage = this.recursiveOnlyDnssecClient.queryDnssec(question);
        if (dnssecMessage == null || !dnssecMessage.isAuthenticData()) {
            dnssecMessage = this.iterativeOnlyDnssecClient.queryDnssec(question);
        }
        return DnssecResolverApi.toResolverResult(question, dnssecMessage);
    }

    public DnssecClient getDnssecClient() {
        return this.dnssecClient;
    }

    private static <D extends Data> ResolverResult<D> toResolverResult(Question question, DnssecQueryResult dnssecMessage) throws MiniDnsException.NullResultException {
        Set<DnssecUnverifiedReason> unverifiedReasons = dnssecMessage.getUnverifiedReasons();
        return new ResolverResult(question, dnssecMessage.dnsQueryResult, unverifiedReasons);
    }
}

