/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.util;

public final class Base32 {
    private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    private static final String PADDING = "======";

    private Base32() {
    }

    public static String encodeToString(byte[] bytes) {
        int paddingCount = (int)(8.0 - (double)(bytes.length % 5) * 1.6) % 8;
        byte[] padded = new byte[bytes.length + paddingCount];
        System.arraycopy(bytes, 0, padded, 0, bytes.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i += 5) {
            long j = ((long)(padded[i] & 0xFF) << 32) + ((long)(padded[i + 1] & 0xFF) << 24) + (long)((padded[i + 2] & 0xFF) << 16) + (long)((padded[i + 3] & 0xFF) << 8) + (long)(padded[i + 4] & 0xFF);
            sb.append(ALPHABET.charAt((int)(j >> 35 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 30 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 25 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 20 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 15 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 10 & 0x1FL))).append(ALPHABET.charAt((int)(j >> 5 & 0x1FL))).append(ALPHABET.charAt((int)(j & 0x1FL)));
        }
        return sb.substring(0, sb.length() - paddingCount) + PADDING.substring(0, paddingCount);
    }
}

