/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.certification.CertifyCertificate;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeyRingTemplates;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.ArmorUtils;

public final class PGPainless {
    private PGPainless() {
    }

    @Nonnull
    public static KeyRingTemplates generateKeyRing() {
        return new KeyRingTemplates();
    }

    @Nonnull
    public static KeyRingBuilder buildKeyRing() {
        return new KeyRingBuilder();
    }

    @Nonnull
    public static KeyRingReader readKeyRing() {
        return new KeyRingReader();
    }

    @Nonnull
    public static PGPPublicKeyRing extractCertificate(@Nonnull PGPSecretKeyRing secretKey) {
        return KeyRingUtils.publicKeyRingFrom(secretKey);
    }

    @Nonnull
    public static PGPPublicKeyRing mergeCertificate(@Nonnull PGPPublicKeyRing originalCopy, @Nonnull PGPPublicKeyRing updatedCopy) throws PGPException {
        return PGPPublicKeyRing.join(originalCopy, updatedCopy);
    }

    @Nonnull
    public static String asciiArmor(@Nonnull PGPKeyRing key) throws IOException {
        if (key instanceof PGPSecretKeyRing) {
            return ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)key);
        }
        return ArmorUtils.toAsciiArmoredString((PGPPublicKeyRing)key);
    }

    @Nonnull
    public static String asciiArmor(@Nonnull PGPSignature signature) throws IOException {
        return ArmorUtils.toAsciiArmoredString(signature);
    }

    public static void asciiArmor(@Nonnull PGPKeyRing key, @Nonnull OutputStream outputStream) throws IOException {
        ArmoredOutputStream armorOut = ArmorUtils.toAsciiArmoredStream(key, outputStream);
        key.encode(armorOut);
        armorOut.close();
    }

    @Nonnull
    public static EncryptionBuilder encryptAndOrSign() {
        return new EncryptionBuilder();
    }

    @Nonnull
    public static DecryptionBuilder decryptAndOrVerify() {
        return new DecryptionBuilder();
    }

    @Nonnull
    public static SecretKeyRingEditorInterface modifyKeyRing(@Nonnull PGPSecretKeyRing secretKeys) {
        return PGPainless.modifyKeyRing(secretKeys, new Date());
    }

    @Nonnull
    public static SecretKeyRingEditorInterface modifyKeyRing(@Nonnull PGPSecretKeyRing secretKeys, @Nonnull Date referenceTime) {
        return new SecretKeyRingEditor(secretKeys, referenceTime);
    }

    @Nonnull
    public static KeyRingInfo inspectKeyRing(@Nonnull PGPKeyRing keyRing) {
        return new KeyRingInfo(keyRing);
    }

    @Nonnull
    public static KeyRingInfo inspectKeyRing(@Nonnull PGPKeyRing keyRing, @Nonnull Date referenceTime) {
        return new KeyRingInfo(keyRing, referenceTime);
    }

    @Nonnull
    public static Policy getPolicy() {
        return Policy.getInstance();
    }

    @Nonnull
    public static CertifyCertificate certify() {
        return new CertifyCertificate();
    }
}

