/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.SigningOptions;

public final class ProducerOptions {
    private final EncryptionOptions encryptionOptions;
    private final SigningOptions signingOptions;
    private String fileName = "";
    private Date modificationDate = PGPLiteralData.NOW;
    private StreamEncoding encodingField = StreamEncoding.BINARY;
    private boolean applyCRLFEncoding = false;
    private boolean cleartextSigned = false;
    private boolean hideArmorHeaders = false;
    private CompressionAlgorithm compressionAlgorithmOverride = PGPainless.getPolicy().getCompressionAlgorithmPolicy().defaultCompressionAlgorithm();
    private boolean asciiArmor = true;
    private String comment = null;
    private String version = null;

    private ProducerOptions(EncryptionOptions encryptionOptions, SigningOptions signingOptions) {
        this.encryptionOptions = encryptionOptions;
        this.signingOptions = signingOptions;
    }

    public static ProducerOptions signAndEncrypt(EncryptionOptions encryptionOptions, SigningOptions signingOptions) {
        ProducerOptions.throwIfNull(encryptionOptions);
        ProducerOptions.throwIfNull(signingOptions);
        return new ProducerOptions(encryptionOptions, signingOptions);
    }

    public static ProducerOptions sign(SigningOptions signingOptions) {
        ProducerOptions.throwIfNull(signingOptions);
        return new ProducerOptions(null, signingOptions);
    }

    public static ProducerOptions encrypt(EncryptionOptions encryptionOptions) {
        ProducerOptions.throwIfNull(encryptionOptions);
        return new ProducerOptions(encryptionOptions, null);
    }

    public static ProducerOptions noEncryptionNoSigning() {
        return new ProducerOptions(null, null);
    }

    private static void throwIfNull(EncryptionOptions encryptionOptions) {
        if (encryptionOptions == null) {
            throw new NullPointerException("EncryptionOptions cannot be null.");
        }
    }

    private static void throwIfNull(SigningOptions signingOptions) {
        if (signingOptions == null) {
            throw new NullPointerException("SigningOptions cannot be null.");
        }
    }

    public ProducerOptions setAsciiArmor(boolean asciiArmor) {
        if (this.cleartextSigned && !asciiArmor) {
            throw new IllegalArgumentException("Cleartext signing is enabled. Cannot disable ASCII armoring.");
        }
        this.asciiArmor = asciiArmor;
        return this;
    }

    public boolean isAsciiArmor() {
        return this.asciiArmor;
    }

    public ProducerOptions setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ProducerOptions setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public ProducerOptions setCleartextSigned() {
        if (this.signingOptions == null) {
            throw new IllegalArgumentException("Signing Options cannot be null if cleartext signing is enabled.");
        }
        if (this.encryptionOptions != null) {
            throw new IllegalArgumentException("Cannot encode encrypted message as Cleartext Signed.");
        }
        for (SigningOptions.SigningMethod method : this.signingOptions.getSigningMethods().values()) {
            if (method.isDetached()) continue;
            throw new IllegalArgumentException("For cleartext signed message, all signatures must be added as detached signatures.");
        }
        this.cleartextSigned = true;
        this.asciiArmor = true;
        this.compressionAlgorithmOverride = CompressionAlgorithm.UNCOMPRESSED;
        return this;
    }

    public boolean isCleartextSigned() {
        return this.cleartextSigned;
    }

    public ProducerOptions setFileName(@Nonnull String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Deprecated
    public ProducerOptions setForYourEyesOnly() {
        this.fileName = "_CONSOLE";
        return this;
    }

    public ProducerOptions setModificationDate(@Nonnull Date modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Deprecated
    public ProducerOptions setEncoding(@Nonnull StreamEncoding encoding) {
        this.encodingField = encoding;
        return this;
    }

    public StreamEncoding getEncoding() {
        return this.encodingField;
    }

    public ProducerOptions applyCRLFEncoding() {
        this.applyCRLFEncoding = true;
        return this;
    }

    public boolean isApplyCRLFEncoding() {
        return this.applyCRLFEncoding;
    }

    public ProducerOptions overrideCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        if (compressionAlgorithm == null) {
            throw new NullPointerException("Compression algorithm cannot be null.");
        }
        this.compressionAlgorithmOverride = compressionAlgorithm;
        return this;
    }

    public CompressionAlgorithm getCompressionAlgorithmOverride() {
        return this.compressionAlgorithmOverride;
    }

    @Nullable
    public EncryptionOptions getEncryptionOptions() {
        return this.encryptionOptions;
    }

    @Nullable
    public SigningOptions getSigningOptions() {
        return this.signingOptions;
    }

    public boolean isHideArmorHeaders() {
        return this.hideArmorHeaders;
    }

    public ProducerOptions setHideArmorHeaders(boolean hideArmorHeaders) {
        this.hideArmorHeaders = hideArmorHeaders;
        return this;
    }
}

