/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

public class SignatureSubpacketsHelper {
    public static SignatureSubpackets applyFrom(PGPSignatureSubpacketVector vector, SignatureSubpackets subpackets) {
        block24: for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : vector.toArray()) {
            SignatureSubpacket type = SignatureSubpacket.requireFromCode(subpacket.getType());
            switch (type) {
                case signatureCreationTime: 
                case issuerKeyId: 
                case issuerFingerprint: {
                    continue block24;
                }
                case signatureExpirationTime: {
                    SignatureExpirationTime sigExpTime = (SignatureExpirationTime)subpacket;
                    subpackets.setSignatureExpirationTime(sigExpTime.isCritical(), sigExpTime.getTime());
                    continue block24;
                }
                case exportableCertification: {
                    Exportable exp = (Exportable)subpacket;
                    subpackets.setExportable(exp.isCritical(), exp.isExportable());
                    continue block24;
                }
                case trustSignature: {
                    TrustSignature trustSignature = (TrustSignature)subpacket;
                    subpackets.setTrust(trustSignature.isCritical(), trustSignature.getDepth(), trustSignature.getTrustAmount());
                    continue block24;
                }
                case revocable: {
                    Revocable rev = (Revocable)subpacket;
                    subpackets.setRevocable(rev.isCritical(), rev.isRevocable());
                    continue block24;
                }
                case keyExpirationTime: {
                    KeyExpirationTime keyExpTime = (KeyExpirationTime)subpacket;
                    subpackets.setKeyExpirationTime(keyExpTime.isCritical(), keyExpTime.getTime());
                    continue block24;
                }
                case preferredSymmetricAlgorithms: {
                    subpackets.setPreferredSymmetricKeyAlgorithms((PreferredAlgorithms)subpacket);
                    continue block24;
                }
                case revocationKey: {
                    RevocationKey revocationKey = (RevocationKey)subpacket;
                    subpackets.addRevocationKey(revocationKey);
                    continue block24;
                }
                case notationData: {
                    NotationData notationData = (NotationData)subpacket;
                    subpackets.addNotationData(notationData.isCritical(), notationData.getNotationName(), notationData.getNotationValue());
                    continue block24;
                }
                case preferredHashAlgorithms: {
                    subpackets.setPreferredHashAlgorithms((PreferredAlgorithms)subpacket);
                    continue block24;
                }
                case preferredCompressionAlgorithms: {
                    subpackets.setPreferredCompressionAlgorithms((PreferredAlgorithms)subpacket);
                    continue block24;
                }
                case primaryUserId: {
                    PrimaryUserID primaryUserID = (PrimaryUserID)subpacket;
                    subpackets.setPrimaryUserId(primaryUserID);
                    continue block24;
                }
                case keyFlags: {
                    KeyFlags flags = (KeyFlags)subpacket;
                    subpackets.setKeyFlags(flags.isCritical(), KeyFlag.fromBitmask(flags.getFlags()).toArray(new KeyFlag[0]));
                    continue block24;
                }
                case signerUserId: {
                    SignerUserID signerUserID = (SignerUserID)subpacket;
                    subpackets.setSignerUserId(signerUserID.isCritical(), signerUserID.getID());
                    continue block24;
                }
                case revocationReason: {
                    RevocationReason reason = (RevocationReason)subpacket;
                    subpackets.setRevocationReason(reason.isCritical(), RevocationAttributes.Reason.fromCode(reason.getRevocationReason()), reason.getRevocationDescription());
                    continue block24;
                }
                case features: {
                    Features f = (Features)subpacket;
                    subpackets.setFeatures(f.isCritical(), Feature.fromBitmask(f.getData()[0]).toArray(new Feature[0]));
                    continue block24;
                }
                case signatureTarget: {
                    SignatureTarget target = (SignatureTarget)subpacket;
                    subpackets.setSignatureTarget(target.isCritical(), PublicKeyAlgorithm.requireFromId(target.getPublicKeyAlgorithm()), HashAlgorithm.requireFromId(target.getHashAlgorithm()), target.getHashData());
                    continue block24;
                }
                case embeddedSignature: {
                    EmbeddedSignature embeddedSignature = (EmbeddedSignature)subpacket;
                    subpackets.addEmbeddedSignature(embeddedSignature);
                    continue block24;
                }
                case intendedRecipientFingerprint: {
                    IntendedRecipientFingerprint intendedRecipientFingerprint = (IntendedRecipientFingerprint)subpacket;
                    subpackets.addIntendedRecipientFingerprint(intendedRecipientFingerprint);
                    continue block24;
                }
                case policyUrl: {
                    PolicyURI policyURI = (PolicyURI)subpacket;
                    subpackets.setPolicyUrl(policyURI);
                    continue block24;
                }
                case regularExpression: {
                    RegularExpression regex = (RegularExpression)subpacket;
                    subpackets.setRegularExpression(regex);
                    continue block24;
                }
                case keyServerPreferences: 
                case preferredKeyServers: 
                case placeholder: 
                case preferredAEADAlgorithms: 
                case attestedCertification: {
                    subpackets.addResidualSubpacket(subpacket);
                }
            }
        }
        return subpackets;
    }

    public static PGPSignatureSubpacketGenerator applyTo(SignatureSubpackets subpackets, PGPSignatureSubpacketGenerator generator) {
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getIssuerKeyIdSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getIssuerFingerprintSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getSignatureCreationTimeSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getSignatureExpirationTimeSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getExportableSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getPolicyURI());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getRegularExpression());
        for (NotationData notationData : subpackets.getNotationDataSubpackets()) {
            SignatureSubpacketsHelper.addSubpacket(generator, notationData);
        }
        for (IntendedRecipientFingerprint intendedRecipientFingerprint : subpackets.getIntendedRecipientFingerprintSubpackets()) {
            SignatureSubpacketsHelper.addSubpacket(generator, intendedRecipientFingerprint);
        }
        for (RevocationKey revocationKey : subpackets.getRevocationKeySubpackets()) {
            SignatureSubpacketsHelper.addSubpacket(generator, revocationKey);
        }
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getSignatureTargetSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getFeaturesSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getKeyFlagsSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getTrustSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getPreferredCompressionAlgorithmsSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getPreferredSymmetricKeyAlgorithmsSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getPreferredHashAlgorithmsSubpacket());
        for (EmbeddedSignature embeddedSignature : subpackets.getEmbeddedSignatureSubpackets()) {
            SignatureSubpacketsHelper.addSubpacket(generator, embeddedSignature);
        }
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getSignerUserIdSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getKeyExpirationTimeSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getPrimaryUserIdSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getRevocableSubpacket());
        SignatureSubpacketsHelper.addSubpacket(generator, subpackets.getRevocationReasonSubpacket());
        for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : subpackets.getResidualSubpackets()) {
            SignatureSubpacketsHelper.addSubpacket(generator, subpacket);
        }
        return generator;
    }

    private static void addSubpacket(PGPSignatureSubpacketGenerator generator, org.bouncycastle.bcpg.SignatureSubpacket subpacket) {
        if (subpacket != null) {
            generator.addCustomSubpacket(subpacket);
        }
    }

    public static PGPSignatureSubpacketVector toVector(SignatureSubpackets subpackets) {
        PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
        SignatureSubpacketsHelper.applyTo(subpackets, generator);
        return generator.generate();
    }

    public static PGPSignatureSubpacketVector toVector(RevocationSignatureSubpackets subpackets) {
        PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
        SignatureSubpacketsHelper.applyTo((SignatureSubpackets)subpackets, generator);
        return generator.generate();
    }
}

