/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

import java.io.Serializable;
import org.rogach.scallop.tokenize.EOF;
import org.rogach.scallop.tokenize.EOF$;
import org.rogach.scallop.tokenize.Failed$;
import org.rogach.scallop.tokenize.Matched;
import org.rogach.scallop.tokenize.Matched$;
import org.rogach.scallop.tokenize.StringView;
import org.rogach.scallop.tokenize.TokenizationResult;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class ArgumentTokenizer$
implements Serializable {
    private static final Function1<StringView, TokenizationResult> argumentsParser;
    public static final ArgumentTokenizer$ MODULE$;

    private ArgumentTokenizer$() {
    }

    static {
        MODULE$ = new ArgumentTokenizer$();
        Function1<StringView, TokenizationResult> & Serializable inputEnd = (Function1<StringView, TokenizationResult> & Serializable)input -> input.length() == 0 ? Matched$.MODULE$.apply(package$.MODULE$.Nil(), (StringView)input) : Failed$.MODULE$;
        Function1<StringView, TokenizationResult> & Serializable whitespace = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            int i;
            int l = input.length();
            for (i = 0; i < l && Character.isWhitespace(input.charAt(i)); ++i) {
            }
            return i == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply(package$.MODULE$.Nil(), input.substring(i));
        };
        Function1<StringView, TokenizationResult> & Serializable singleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\'') {
                return Failed$.MODULE$;
            }
            int stringEnd = input.indexOf(39, 1);
            return stringEnd == -1 ? EOF$.MODULE$.apply("'") : Matched$.MODULE$.apply((Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)input.extract(1, stringEnd)), Nil$.MODULE$)), input.substring(stringEnd + 1));
        };
        Function1<StringView, TokenizationResult> & Serializable doubleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\"') {
                return Failed$.MODULE$;
            }
            int i = 1;
            int s = 1;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            boolean stringClosed = false;
            while (!bl && i < l) {
                while (i < l && input.charAt(i) != '\\' && input.charAt(i) != '\"') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        StringBuilder stringBuilder = input.charAt(i + 1) == '\\' || input.charAt(i + 1) == '\"' ? b.append(input.charAt(i + 1)) : b.append(input.extract(i, i + 2));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\"') {
                    stringClosed = true;
                    bl = true;
                    continue;
                }
                b.append(input.charAt(i));
                s = ++i;
            }
            if (eofEscaped) {
                return EOF$.MODULE$.apply("escaped char");
            }
            return !stringClosed ? EOF$.MODULE$.apply("\"") : Matched$.MODULE$.apply((Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)b.toString()), Nil$.MODULE$)), input.substring(i + 1));
        };
        Function1<StringView, TokenizationResult> & Serializable plainArgument = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            int i = 0;
            int s = 0;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            while (!bl && i < l) {
                while (i < l && !Character.isWhitespace(input.charAt(i)) && input.charAt(i) != '\\' && input.charAt(i) != '\"' && input.charAt(i) != '\'') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (Character.isWhitespace(input.charAt(i))) {
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        b.append(input.charAt(i + 1));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                bl = true;
            }
            if (eofEscaped) {
                return EOF$.MODULE$.apply("escaped char");
            }
            return b.length() == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)b.toString()), Nil$.MODULE$)), input.substring(i));
        };
        Function1<StringView, TokenizationResult> token = MODULE$.mapResult(MODULE$.repeat(MODULE$.alternatives((List)((Object)new $colon$colon<Nothing$>((Nothing$)singleQuotedString, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)doubleQuotedString, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)plainArgument, Nil$.MODULE$)))))), (Function1<Seq<String>, Seq<String>>)(Function1<Seq, Seq> & Serializable)tokens -> (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)tokens.mkString("")), Nil$.MODULE$)));
        argumentsParser = MODULE$.alternatives((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.seq(MODULE$.seq(MODULE$.repeat(MODULE$.seq(MODULE$.optional(whitespace), token)), MODULE$.optional(whitespace)), inputEnd)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.seq(MODULE$.optional(whitespace), inputEnd)), Nil$.MODULE$))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArgumentTokenizer$.class);
    }

    public TokenizationResult tokenize(String input) {
        return argumentsParser.apply(new StringView(input, 0));
    }

    private Function1<StringView, TokenizationResult> optional(Function1<StringView, TokenizationResult> parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply((StringView)input);
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return Matched$.MODULE$.apply(package$.MODULE$.Nil(), (StringView)input);
            }
            TokenizationResult other = tokenizationResult;
            return other;
        };
    }

    private Function1<StringView, TokenizationResult> seq(Function1<StringView, TokenizationResult> parser1, Function1<StringView, TokenizationResult> parser2) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser1.apply((StringView)input);
            if (tokenizationResult instanceof EOF) {
                EOF eof = (EOF)tokenizationResult;
                return eof;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return Failed$.MODULE$;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens1 = seq;
                StringView rest1 = stringView;
                TokenizationResult tokenizationResult2 = (TokenizationResult)parser2.apply(rest1);
                if (tokenizationResult2 instanceof Matched) {
                    Matched matched2 = Matched$.MODULE$.unapply((Matched)tokenizationResult2);
                    Seq<String> seq2 = matched2._1();
                    StringView stringView2 = matched2._2();
                    Seq<String> tokens2 = seq2;
                    StringView rest2 = stringView2;
                    return Matched$.MODULE$.apply((Seq)tokens1.$plus$plus(tokens2), rest2);
                }
                TokenizationResult other = tokenizationResult2;
                return other;
            }
            throw new MatchError(tokenizationResult);
        };
    }

    private Function1<StringView, TokenizationResult> repeat(Function1<StringView, TokenizationResult> parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> MODULE$.repeatImpl(parser, (StringView)input, package$.MODULE$.Nil());
    }

    private TokenizationResult repeatImpl(Function1<StringView, TokenizationResult> parser, StringView input, List<Seq<String>> acc) {
        TokenizationResult tokenizationResult;
        while (true) {
            StringView remainingInput;
            if ((tokenizationResult = parser.apply(input)) instanceof EOF) {
                EOF eof = (EOF)tokenizationResult;
                return eof;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return acc.isEmpty() ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq)((List)acc.reverse()).flatten(Predef$.MODULE$.$conforms()), input);
            }
            if (!(tokenizationResult instanceof Matched)) break;
            Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
            Seq<String> seq = matched._1();
            StringView stringView = matched._2();
            Seq<String> tokens = seq;
            StringView stringView2 = remainingInput = stringView;
            List<Seq<String>> list2 = acc.$colon$colon(tokens);
            input = stringView2;
            acc = list2;
        }
        throw new MatchError(tokenizationResult);
    }

    private Function1<StringView, TokenizationResult> alternatives(List<Function1<StringView, TokenizationResult>> parsers) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> MODULE$.alternativesImpl(parsers, (StringView)input);
    }

    private TokenizationResult alternativesImpl(List<Function1<StringView, TokenizationResult>> parsers, StringView input) {
        List<Function1<StringView, TokenizationResult>> list2;
        block4: {
            TokenizationResult tokenizationResult;
            while (true) {
                list2 = parsers;
                Nil$ nil$ = package$.MODULE$.Nil();
                List<Function1<StringView, TokenizationResult>> list3 = list2;
                if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
                    return Failed$.MODULE$;
                }
                if (!(list2 instanceof $colon$colon)) break block4;
                $colon$colon $colon$colon = ($colon$colon)list2;
                List list4 = $colon$colon.next$access$1();
                Function1 parser = (Function1)$colon$colon.head();
                List remainingParsers = list4;
                tokenizationResult = (TokenizationResult)parser.apply(input);
                if (tokenizationResult instanceof EOF) {
                    EOF eof = (EOF)tokenizationResult;
                    return eof;
                }
                if (!Failed$.MODULE$.equals(tokenizationResult)) break;
                parsers = remainingParsers;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = (Matched)tokenizationResult;
                return matched;
            }
            throw new MatchError(tokenizationResult);
        }
        throw new MatchError(list2);
    }

    private Function1<StringView, TokenizationResult> mapResult(Function1<StringView, TokenizationResult> parser, Function1<Seq<String>, Seq<String>> fn) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply((StringView)input);
            if (tokenizationResult instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens = seq;
                StringView rest = stringView;
                return Matched$.MODULE$.apply((Seq)fn.apply(tokens), rest);
            }
            TokenizationResult other = tokenizationResult;
            return other;
        };
    }
}

