/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "араб";
        final String metaValue_bn = "бенгал";
        final String metaValue_ka = "гүрж";
        final String metaValue_el = "грек";
        final String metaValue_gu = "гужарати";
        final String metaValue_he = "еврей";
        final String metaValue_ja = "япон";
        final String metaValue_km = "кхмер";
        final String metaValue_kn = "каннада";
        final String metaValue_ko = "солонгос";
        final String metaValue_lo = "лаос";
        final String metaValue_la = "латин";
        final String metaValue_ml = "малаялам";
        final String metaValue_or = "ория";
        final String metaValue_si = "синхала";
        final String metaValue_ta = "тамил";
        final String metaValue_te = "тэлүгү";
        final String metaValue_th = "тай";
        final String metaValue_bo = "төвд";
        final String metaValue_type_ca_ethiopic = "этиоп цаглавар";
        final Object[][] data = new Object[][] {
            { "001", "Дэлхий" },
            { "002", "Африк" },
            { "003", "Хойд Америк" },
            { "005", "Өмнөд Америк" },
            { "009", "Номхон далайн орнууд" },
            { "011", "Баруун Африк" },
            { "013", "Төв Америк" },
            { "014", "Зүүн Африк" },
            { "015", "Хойд Африк" },
            { "017", "Төв Африк" },
            { "018", "Өмнөд Африк тив" },
            { "019", "Америк" },
            { "021", "Хойд Америк тив" },
            { "029", "Карибын тэнгис" },
            { "030", "Зүүн Ази" },
            { "034", "Өмнөд Ази" },
            { "035", "Зүүн өмнөд Ази" },
            { "039", "Өмнөд Европ" },
            { "053", "Австрали-Ази" },
            { "054", "Меланези" },
            { "057", "Микронезийн бүс" },
            { "061", "Полинези" },
            { "142", "Ази" },
            { "143", "Төв Ази" },
            { "145", "Баруун Ази" },
            { "150", "Европ" },
            { "151", "Зүүн Европ" },
            { "154", "Хойд Европ" },
            { "155", "Баруун Европ" },
            { "202", "Сахарын цөлийн урд хэсгийн Африк" },
            { "419", "Латин Америк" },
            { "AC", "Асенсион арал" },
            { "AD", "Андорра" },
            { "AE", "Арабын Нэгдсэн Эмират Улс" },
            { "AF", "Афганистан" },
            { "AG", "Антигуа ба Барбуда" },
            { "AI", "Ангилья" },
            { "AL", "Албани" },
            { "AM", "Армени" },
            { "AO", "Ангол" },
            { "AQ", "Антарктид" },
            { "AR", "Аргентин" },
            { "AS", "Америкийн Самоа" },
            { "AT", "Австри" },
            { "AU", "Австрали" },
            { "AW", "Аруба" },
            { "AX", "Аландын арлууд" },
            { "AZ", "Азербайжан" },
            { "BA", "Босни-Херцеговин" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельги" },
            { "BF", "Буркина Фасо" },
            { "BG", "Болгар" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сент-Бартельми" },
            { "BM", "Бермуда" },
            { "BN", "Бруней" },
            { "BO", "Боливи" },
            { "BQ", "Карибын Нидерланд" },
            { "BR", "Бразил" },
            { "BS", "Багамын арлууд" },
            { "BT", "Бутан" },
            { "BV", "Буве арал" },
            { "BW", "Ботсван" },
            { "BY", "Беларусь" },
            { "BZ", "Белизе" },
            { "CA", "Канад" },
            { "CC", "Кокос (Кийлинг) арлууд" },
            { "CD", "Конго-Киншаса" },
            { "CF", "Төв Африкийн Бүгд Найрамдах Улс" },
            { "CG", "Конго-Браззавиль" },
            { "CH", "Швейцар" },
            { "CI", "Кот-д’Ивуар" },
            { "CK", "Күүкийн арлууд" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Хятад" },
            { "CO", "Колумби" },
            { "CP", "Клиппертон арал" },
            { "CQ", "Сарк" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "Зул сарын арал" },
            { "CY", "Кипр" },
            { "CZ", "Чех" },
            { "DE", "Герман" },
            { "DG", "Диего Гарсиа" },
            { "DJ", "Джибути" },
            { "DK", "Дани" },
            { "DM", "Доминика" },
            { "DO", "Бүгд Найрамдах Доминикан Улс" },
            { "DZ", "Алжир" },
            { "EA", "Сеута ба Мелилья" },
            { "EC", "Эквадор" },
            { "EE", "Эстони" },
            { "EG", "Египет" },
            { "EH", "Баруун Сахар" },
            { "ER", "Эритрей" },
            { "ES", "Испани" },
            { "ET", "Этиоп" },
            { "EU", "Европын Холбоо" },
            { "EZ", "Евро бүс" },
            { "FI", "Финланд" },
            { "FJ", "Фижи" },
            { "FK", "Фолклендийн арлууд" },
            { "FM", "Микронези" },
            { "FO", "Фарерын арлууд" },
            { "FR", "Франц" },
            { "GA", "Габон" },
            { "GB", "Их Британи" },
            { "GD", "Гренада" },
            { "GE", "Гүрж" },
            { "GF", "Францын Гвиана" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренланд" },
            { "GM", "Гамби" },
            { "GN", "Гвиней" },
            { "GP", "Гваделуп" },
            { "GQ", "Экваторын Гвиней" },
            { "GR", "Грек" },
            { "GS", "Өмнөд Жоржиа ба Өмнөд Сэндвичийн арлууд" },
            { "GT", "Гватемал" },
            { "GU", "Гуам" },
            { "GW", "Гвиней-Бисау" },
            { "GY", "Гайана" },
            { "HK", "БНХАУ-ын Тусгай захиргааны бүс Хонг-Конг" },
            { "HM", "Херд ба Макдональдийн арлууд" },
            { "HN", "Гондурас" },
            { "HR", "Хорват" },
            { "HT", "Гаити" },
            { "HU", "Унгар" },
            { "IC", "Канарын арлууд" },
            { "ID", "Индонез" },
            { "IE", "Ирланд" },
            { "IL", "Израил" },
            { "IM", "Мэн Арал" },
            { "IN", "Энэтхэг" },
            { "IO", "Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэр" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исланд" },
            { "IT", "Итали" },
            { "JE", "Жерси" },
            { "JM", "Ямайка" },
            { "JO", "Йордан" },
            { "JP", "Япон" },
            { "KE", "Кени" },
            { "KG", "Киргиз" },
            { "KH", "Камбож" },
            { "KI", "Кирибати" },
            { "KM", "Коморын арлууд" },
            { "KN", "Сент-Киттс ба Невис" },
            { "KP", "Хойд Солонгос" },
            { "KR", "Өмнөд Солонгос" },
            { "KW", "Кувейт" },
            { "KY", "Кайманы арлууд" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент Люсиа" },
            { "LI", "Лихтенштайн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либери" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латви" },
            { "LY", "Ливи" },
            { "MA", "Морокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Монтенегро" },
            { "MF", "Сент-Мартин" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршаллын арлууд" },
            { "MK", "Хойд Македон" },
            { "ML", "Мали" },
            { "MM", "Мьянмар" },
            { "MN", "Монгол" },
            { "MO", "БНХАУ-ын Тусгай захиргааны бүс Макао" },
            { "MP", "Хойд Марианы арлууд" },
            { "MQ", "Мартиник" },
            { "MR", "Мавритани" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикий" },
            { "MV", "Мальдив" },
            { "MW", "Малави" },
            { "MX", "Мексик" },
            { "MY", "Малайз" },
            { "MZ", "Мозамбик" },
            { "NA", "Намиби" },
            { "NC", "Шинэ Каледони" },
            { "NE", "Нигер" },
            { "NF", "Норфолк арал" },
            { "NG", "Нигери" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерланд" },
            { "NO", "Норвег" },
            { "NP", "Балба" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Шинэ Зеланд" },
            { "OM", "Оман" },
            { "PA", "Панам" },
            { "PE", "Перу" },
            { "PF", "Францын Полинез" },
            { "PG", "Папуа Шинэ Гвиней" },
            { "PH", "Филиппин" },
            { "PK", "Пакистан" },
            { "PL", "Польш" },
            { "PM", "Сент-Пьер ба Микело" },
            { "PN", "Питкэрн арлууд" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "Палестины нутаг дэвсгэр" },
            { "PT", "Португал" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Номхон далайг тойрсон улс орнууд" },
            { "RE", "Реюнион" },
            { "RO", "Румын" },
            { "RS", "Серби" },
            { "RU", "Орос" },
            { "RW", "Руанда" },
            { "SA", "Саудын Араб" },
            { "SB", "Соломоны арлууд" },
            { "SC", "Сейшелийн арлууд" },
            { "SD", "Судан" },
            { "SE", "Швед" },
            { "SG", "Сингапур" },
            { "SH", "Сент Хелена" },
            { "SI", "Словени" },
            { "SJ", "Свалбард ба Ян Майен" },
            { "SK", "Словак" },
            { "SL", "Сьерра-Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Өмнөд Судан" },
            { "ST", "Сан-Томе ба Принсипи" },
            { "SV", "Эль Сальвадор" },
            { "SX", "Синт Мартен" },
            { "SY", "Сири" },
            { "SZ", "Эсватини" },
            { "TA", "Тристан да Кунъя" },
            { "TC", "Турк ба Кайкосын Арлууд" },
            { "TD", "Чад" },
            { "TF", "Францын өмнөд газар нутаг" },
            { "TG", "Того" },
            { "TH", "Тайланд" },
            { "TJ", "Тажикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турк" },
            { "TT", "Тринидад ба Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзани" },
            { "UA", "Украин" },
            { "UG", "Уганда" },
            { "UM", "Америкийн Нэгдсэн Улсын бага арлууд" },
            { "UN", "Нэгдсэн Үндэстний Байгууллага" },
            { "US", "Америкийн Нэгдсэн Улс" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан хот улс" },
            { "VC", "Сент-Винсент ба Гренадин" },
            { "VE", "Венесуэл" },
            { "VG", "Британийн Виржиний арлууд" },
            { "VI", "АНУ-ын Виржиний арлууд" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис ба Футуна" },
            { "WS", "Самоа" },
            { "XA", "хуурмаг аялга" },
            { "XB", "хуурмаг хоёр чиглэлт" },
            { "XK", "Косово" },
            { "YE", "Йемен" },
            { "YT", "Майотта" },
            { "ZA", "Өмнөд Африк" },
            { "ZM", "Замби" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Тодорхойгүй бүс" },
            { "aa", "афар" },
            { "ab", "абхаз" },
            { "af", "африкаанс" },
            { "ak", "акан" },
            { "am", "амхар" },
            { "an", "арагон" },
            { "ar", metaValue_ar },
            { "as", "ассам" },
            { "av", "авар" },
            { "ay", "аймара" },
            { "az", "азербайжан" },
            { "ba", "башкир" },
            { "be", "беларусь" },
            { "bg", "болгар" },
            { "bi", "бислам" },
            { "bm", "бамбара" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "бретон" },
            { "bs", "босни" },
            { "ca", "каталан" },
            { "ce", "чечень" },
            { "ch", "чаморро" },
            { "co", "корсик" },
            { "cs", "чех" },
            { "cu", "сүмийн славян" },
            { "cv", "чуваш" },
            { "cy", "уэльс" },
            { "da", "дани" },
            { "de", "герман" },
            { "dv", "дивехи" },
            { "dz", "зонха" },
            { "ee", "эвэ" },
            { "el", metaValue_el },
            { "en", "англи" },
            { "eo", "эсперанто" },
            { "es", "испани" },
            { "et", "эстони" },
            { "eu", "баск" },
            { "fa", "перс" },
            { "ff", "фула" },
            { "fi", "фин" },
            { "fj", "фижи" },
            { "fo", "фарер" },
            { "fr", "франц" },
            { "fy", "баруун фриз" },
            { "ga", "ирланд" },
            { "gd", "шотландын гел" },
            { "gl", "галего" },
            { "gn", "гуарани" },
            { "gu", metaValue_gu },
            { "gv", "манкс" },
            { "ha", "хауса" },
            { "he", metaValue_he },
            { "hi", "хинди" },
            { "hr", "хорват" },
            { "ht", "Гаитийн креол" },
            { "hu", "мажар" },
            { "hy", "армен" },
            { "hz", "хереро" },
            { "ia", "интерлингво" },
            { "id", "индонези" },
            { "ie", "нэгдмэл хэл" },
            { "ig", "игбо" },
            { "ii", "сычуань и" },
            { "io", "идо" },
            { "is", "исланд" },
            { "it", "итали" },
            { "iu", "инуктитут" },
            { "ja", metaValue_ja },
            { "jv", "ява" },
            { "ka", metaValue_ka },
            { "ki", "кикуюү" },
            { "kj", "куаньяма" },
            { "kk", "казах" },
            { "kl", "калалисут" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "канури" },
            { "ks", "кашмир" },
            { "ku", "курманжи" },
            { "kv", "коми" },
            { "kw", "корн" },
            { "ky", "киргиз" },
            { "la", metaValue_la },
            { "lb", "люксембург" },
            { "lg", "ганда" },
            { "li", "лимбург" },
            { "ln", "лингала" },
            { "lo", metaValue_lo },
            { "lt", "литва" },
            { "lu", "луба-катанга" },
            { "lv", "латви" },
            { "mg", "малагаси" },
            { "mh", "маршалл" },
            { "mi", "маори" },
            { "mk", "македон" },
            { "ml", metaValue_ml },
            { "mn", "монгол" },
            { "mr", "марати" },
            { "ms", "малай" },
            { "mt", "малта" },
            { "my", "бирм" },
            { "na", "науру" },
            { "nb", "норвегийн букмол" },
            { "nd", "хойд ндебеле" },
            { "ne", "балба" },
            { "ng", "ндонга" },
            { "nl", "нидерланд" },
            { "nn", "норвегийн нинорск" },
            { "no", "норвег" },
            { "nr", "өмнөд ндебеле" },
            { "nv", "навахо" },
            { "ny", "нянжа" },
            { "oc", "окситан" },
            { "om", "оромо" },
            { "or", metaValue_or },
            { "os", "оссетин" },
            { "pa", "панжаби" },
            { "pl", "польш" },
            { "ps", "пушту" },
            { "pt", "португал" },
            { "qu", "кечуа" },
            { "rm", "романш" },
            { "rn", "рунди" },
            { "ro", "румын" },
            { "ru", "орос" },
            { "rw", "киньяруанда" },
            { "sa", "санскрит" },
            { "sc", "сардин" },
            { "sd", "синдхи" },
            { "se", "хойд сами" },
            { "sg", "санго" },
            { "sh", "хорватын серб" },
            { "si", metaValue_si },
            { "sk", "словак" },
            { "sl", "словени" },
            { "sm", "самоа" },
            { "sn", "шона" },
            { "so", "сомали" },
            { "sq", "албани" },
            { "sr", "серб" },
            { "ss", "свати" },
            { "st", "сесото" },
            { "su", "сундан" },
            { "sv", "швед" },
            { "sw", "свахили" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "тажик" },
            { "th", metaValue_th },
            { "ti", "тигринья" },
            { "tk", "туркмен" },
            { "tn", "цвана" },
            { "to", "тонга" },
            { "tr", "турк" },
            { "ts", "цонга" },
            { "tt", "татар" },
            { "tw", "тви" },
            { "ty", "таити" },
            { "ug", "уйгур" },
            { "uk", "украин" },
            { "ur", "урду" },
            { "uz", "узбек" },
            { "ve", "венда" },
            { "vi", "вьетнам" },
            { "vo", "волапюк" },
            { "wa", "уоллун" },
            { "wo", "волоф" },
            { "xh", "хоса" },
            { "yi", "иддиш" },
            { "yo", "ёруба" },
            { "za", "чжуанг" },
            { "zh", "хятад" },
            { "zu", "зулу" },
            { "ace", "ачин" },
            { "ada", "адангмэ" },
            { "ady", "адигэ" },
            { "agq", "агем" },
            { "ain", "айну" },
            { "ale", "алют" },
            { "alt", "өмнөд алтай" },
            { "ann", "оболо" },
            { "anp", "ангик" },
            { "arn", "мапүчи" },
            { "arp", "арапаго" },
            { "ars", "наджи араб" },
            { "asa", "асу" },
            { "ast", "астури" },
            { "atj", "атикамек" },
            { "awa", "авадхи" },
            { "bal", "балучи" },
            { "ban", "бали" },
            { "bas", "басаа" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bgc", "харьянви" },
            { "bho", "божпури" },
            { "bin", "бини" },
            { "bla", "сиксика" },
            { "blo", "Ани" },
            { "brx", "бодо" },
            { "bug", "буги" },
            { "byn", "блин" },
            { "cay", "кайюга хэл" },
            { "ccp", "чакма" },
            { "ceb", "себуано" },
            { "cgg", "чига" },
            { "chk", "чуук" },
            { "chm", "мари хэл" },
            { "cho", "чоктау" },
            { "chp", "чипевайан" },
            { "chr", "чероки" },
            { "chy", "чэенн" },
            { "ckb", "төв курд" },
            { "clc", "чилкотин" },
            { "crg", "мичиф" },
            { "crj", "зүүн өмнөд кри" },
            { "crk", "плэйн кри" },
            { "crl", "зүүн хойд кри" },
            { "crm", "мүүс кри" },
            { "crr", "каролина алгонкинск хэл" },
            { "crs", "сеселва креол франц" },
            { "csw", "свампи кри" },
            { "dak", "дакота" },
            { "dar", "даргва" },
            { "dav", "тайта" },
            { "dgr", "догриб" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "доод сорби" },
            { "dua", "дуала" },
            { "dyo", "жола-фони" },
            { "dzg", "дазага" },
            { "ebu", "эмбу" },
            { "efi", "эфик" },
            { "eka", "экажук" },
            { "ewo", "эвондо" },
            { "fil", "филипино" },
            { "fon", "фон" },
            { "frc", "франц, кажун" },
            { "frr", "хойд фриз" },
            { "fur", "фриулан" },
            { "gaa", "га" },
            { "gag", "гагуз" },
            { "gez", "гийз" },
            { "gil", "гилберт" },
            { "gor", "горонтало" },
            { "gsw", "швейцари-герман" },
            { "guz", "гузы" },
            { "gwi", "гвичин" },
            { "hai", "хайда" },
            { "haw", "хавай" },
            { "hax", "өмнөд хайда" },
            { "hil", "хилигайнон" },
            { "hmn", "хмонг" },
            { "hsb", "дээд сорби" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибан" },
            { "ibb", "ибибио" },
            { "ikt", "баруун канадын инуктитут" },
            { "ilo", "илоко" },
            { "inh", "ингуш" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачамэ" },
            { "kab", "кабиле" },
            { "kac", "качин" },
            { "kaj", "жжу" },
            { "kam", "камба" },
            { "kbd", "кабардин" },
            { "kcg", "тяп" },
            { "kde", "маконде" },
            { "kea", "кабүвердиану" },
            { "kfo", "коро" },
            { "kgp", "кайнганг" },
            { "kha", "каси" },
            { "khq", "койра чини" },
            { "kkj", "како" },
            { "kln", "каленжин" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермяк" },
            { "kok", "конкани" },
            { "kpe", "кпелле" },
            { "krc", "карачай-балкар" },
            { "krl", "карель" },
            { "kru", "курук" },
            { "ksb", "шамбал" },
            { "ksf", "бафиа" },
            { "ksh", "кёльш" },
            { "kum", "кумук" },
            { "kwk", "квак вала" },
            { "kxv", "куви" },
            { "lad", "ладин" },
            { "lag", "ланги" },
            { "lez", "лезги" },
            { "lij", "лигури" },
            { "lil", "лиллуэт" },
            { "lkt", "лакота" },
            { "lmo", "ломбард" },
            { "lou", "луизиана креоле" },
            { "loz", "лози" },
            { "lrc", "хойд лури" },
            { "lsm", "самиа" },
            { "lua", "луба-лулуа" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мизо" },
            { "luy", "луяа" },
            { "mad", "мадури хэл" },
            { "mag", "магахи" },
            { "mai", "май" },
            { "mak", "макасар" },
            { "mas", "масай" },
            { "mdf", "мокша" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "морисен" },
            { "mgh", "макува-мито" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mni", "манипури" },
            { "moe", "инну-аймун" },
            { "moh", "мохаук" },
            { "mos", "мосси" },
            { "mua", "мунданг" },
            { "mul", "олон хэл" },
            { "mus", "крик" },
            { "mwl", "меранди" },
            { "myv", "эрзя" },
            { "mzn", "мазандерани" },
            { "nap", "неаполитан" },
            { "naq", "нама" },
            { "nds", "доод герман" },
            { "new", "невари" },
            { "nia", "ниас хэл" },
            { "niu", "ниуэ" },
            { "nmg", "квазио" },
            { "nnh", "нгиембүүн" },
            { "nog", "ногаи" },
            { "nqo", "нко" },
            { "nso", "хойд сото" },
            { "nus", "нуер" },
            { "nyn", "нянколе" },
            { "ojb", "баруун хойд ожибва" },
            { "ojc", "төв ожибва" },
            { "ojs", "ожи кри" },
            { "ojw", "баруун ожибва" },
            { "oka", "оканаган" },
            { "pag", "пангасин" },
            { "pam", "пампанга" },
            { "pap", "папьяменто" },
            { "pau", "палау" },
            { "pcm", "нигерийн пиджин" },
            { "pis", "пижин" },
            { "pqm", "малесит-пассамакводди" },
            { "prg", "прусс" },
            { "quc", "киче" },
            { "raj", "ражастани" },
            { "rap", "рапануи" },
            { "rar", "раротонг" },
            { "rhg", "рохинжа" },
            { "rof", "ромбо" },
            { "rup", "ароманы" },
            { "rwk", "рва" },
            { "sad", "сандавэ" },
            { "sah", "саха" },
            { "saq", "самбүрү" },
            { "sat", "сантали" },
            { "sba", "нгамбай" },
            { "sbp", "сангү" },
            { "scn", "сицил" },
            { "sco", "шотланд" },
            { "seh", "сена" },
            { "ses", "кёраборо сени" },
            { "shi", "тачелхит" },
            { "shn", "шань" },
            { "slh", "өмнөд лушуцид" },
            { "sma", "өмнөд сами" },
            { "smj", "люле сами" },
            { "smn", "инари сами" },
            { "sms", "сколт сами" },
            { "snk", "сонинке" },
            { "srn", "сранан тонго" },
            { "ssy", "сахо" },
            { "str", "стрейтс салиш" },
            { "suk", "сукума" },
            { "swb", "комори" },
            { "syr", "сири" },
            { "szl", "силез" },
            { "tce", "өмнөд тутчоне" },
            { "tem", "тимн" },
            { "teo", "тэсо" },
            { "tet", "тетум" },
            { "tgx", "тагиш" },
            { "tht", "талтан" },
            { "tig", "тигр" },
            { "tlh", "клингон" },
            { "tli", "тлингит" },
            { "tok", "токипона" },
            { "tpi", "ток писин" },
            { "trv", "тароко" },
            { "ttm", "хойд тутчоне" },
            { "tum", "тумбула" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тува" },
            { "tzm", "Төв Атласын тамазигхт" },
            { "udm", "удмурт" },
            { "umb", "умбунду" },
            { "und", "үл мэдэгдэх хэл" },
            { "vai", "вай" },
            { "vec", "венец" },
            { "vmw", "макуа" },
            { "vun", "вунжо" },
            { "wae", "уолсэр" },
            { "wal", "уоллайтта" },
            { "war", "варай" },
            { "wuu", "хятад, ву хэл" },
            { "xal", "халимаг" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yav", "янгбен" },
            { "ybb", "емба" },
            { "yrl", "ньенгату" },
            { "yue", "кантон" },
            { "zgh", "стандарт тамазайт (Морокко)" },
            { "zun", "зуни" },
            { "zxx", "хэл зүйн агуулгагүй" },
            { "zza", "заза" },
            { "Adlm", "Адлам бичиг" },
            { "Aghb", "Кавказийн албани" },
            { "Ahom", "Ахом" },
            { "Arab", metaValue_ar },
            { "Aran", "Насталик бичиг" },
            { "Armi", "Арамайк" },
            { "Armn", "армени" },
            { "Avst", "Авестан" },
            { "Bali", "Бали" },
            { "Bamu", "Баму" },
            { "Bass", "Басс" },
            { "Batk", "Батк" },
            { "Beng", metaValue_bn },
            { "Bhks", "Байксуки" },
            { "Bopo", "вопомофо" },
            { "Brah", "Брахми" },
            { "Brai", "брайл" },
            { "Bugi", "Бугинез" },
            { "Buhd", "Бухид" },
            { "Cakm", "Чакма бичиг" },
            { "Cans", "Канадын уугуул иргэдийн тэмдэгт бичиг" },
            { "Cari", "Кари" },
            { "Cham", "Чам" },
            { "Cher", "Чероки бичиг" },
            { "Chrs", "Корасми" },
            { "Copt", "Коптик" },
            { "Cpmn", "Кипр-Миноан" },
            { "Cprt", "Киприот" },
            { "Cyrl", "кирилл" },
            { "Deva", "деванагари" },
            { "Diak", "Диак" },
            { "Dogr", "Догра" },
            { "Dsrt", "Дезерет" },
            { "Dupl", "Дуплоян" },
            { "Egyp", "Египетийн дүрс бичиг" },
            { "Elba", "Элбасан" },
            { "Elym", "Элимайк" },
            { "Ethi", "этиоп" },
            { "Geor", metaValue_ka },
            { "Glag", "Глаголитик" },
            { "Gong", "Гонг" },
            { "Gonm", "Масарам Гонди" },
            { "Goth", "Готик" },
            { "Gran", "Гранта" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "гүрмүх" },
            { "Hanb", "Бопомофотой ханз" },
            { "Hang", "хангыль" },
            { "Hani", "ханз" },
            { "Hano", "Хануноо" },
            { "Hans", "хялбаршуулсан" },
            { "Hant", "уламжлалт" },
            { "Hatr", "Хатран" },
            { "Hebr", metaValue_he },
            { "Hira", "хирагана" },
            { "Hluw", "Анатолийн дүрс бичиг" },
            { "Hmng", "Пахав Хмонг" },
            { "Hmnp", "Хмнп" },
            { "Hrkt", "япон хэлний үеийн цагаан толгой" },
            { "Hung", "Хуучин Унгар" },
            { "Ital", "Хуучин итали" },
            { "Jamo", "жамо" },
            { "Java", "Жава" },
            { "Jpan", metaValue_ja },
            { "Kali", "Кали" },
            { "Kana", "катакана" },
            { "Kawi", "Кави" },
            { "Khar", "Карошти" },
            { "Khmr", metaValue_km },
            { "Khoj", "Кожки" },
            { "Kits", "Китан бага бичвэр" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "Кайти" },
            { "Lana", "Лана" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "Лепк" },
            { "Limb", "Лимб" },
            { "Lina", "Зураасан A" },
            { "Linb", "Зураасан B" },
            { "Lisu", "Лису" },
            { "Lyci", "Лиси" },
            { "Lydi", "Лиди" },
            { "Mahj", "Махажани" },
            { "Maka", "Макасар" },
            { "Mand", "Манд" },
            { "Mani", "Манич" },
            { "Marc", "Марк" },
            { "Medf", "Медефайдрин" },
            { "Mend", "Менди" },
            { "Merc", "Меройтик Курсив" },
            { "Mero", "Меройтик" },
            { "Mlym", metaValue_ml },
            { "Modi", "Моди" },
            { "Mong", "монгол бичиг" },
            { "Mroo", "Мру" },
            { "Mtei", "Мейтей маек бичиг" },
            { "Mult", "Мултани" },
            { "Mymr", "мьянмар" },
            { "Nagm", "Наг Мундари" },
            { "Nand", "Нандинагари" },
            { "Narb", "Хуучин Хойд Араб бичиг" },
            { "Nbat", "Набата" },
            { "Newa", "Нева" },
            { "Nkoo", "Нко бичиг" },
            { "Nshu", "Нүшү" },
            { "Ogam", "Огам" },
            { "Olck", "Ол чики бичиг" },
            { "Orkh", "Орхон" },
            { "Orya", metaValue_or },
            { "Osge", "Осге" },
            { "Osma", "Османи" },
            { "Ougr", "Хуучин уйгар" },
            { "Palm", "Палмирен" },
            { "Pauc", "Пай Чин Хау" },
            { "Perm", "Хуучин Пермик" },
            { "Phag", "Фагс-па" },
            { "Phli", "Пахлави" },
            { "Phlp", "Псалтер Пахлави" },
            { "Phnx", "Финик" },
            { "Plrd", "Пирд" },
            { "Prti", "Партиан" },
            { "Qaag", "Каак" },
            { "Rjng", "Режанг" },
            { "Rohg", "Ханафи бичиг" },
            { "Runr", "Руни" },
            { "Samr", "Самаритан" },
            { "Sarb", "Хуучин Өмнөд Араб" },
            { "Saur", "Саураштра" },
            { "Sgnw", "Тэмдэгт бичиг" },
            { "Shaw", "Шави" },
            { "Shrd", "Шарада" },
            { "Sidd", "Сиддхам" },
            { "Sind", "Кудавади" },
            { "Sinh", metaValue_si },
            { "Sogd", "Согди" },
            { "Sogo", "Хуучин согди" },
            { "Sora", "Сора сомпенг" },
            { "Soyo", "Соёмбо" },
            { "Sund", "Сундан бичиг" },
            { "Sylo", "Сило" },
            { "Syrc", "Сирийк бичиг" },
            { "Tagb", "Тагбанва" },
            { "Takr", "Такри" },
            { "Tale", "Тале" },
            { "Talu", "Талу" },
            { "Taml", metaValue_ta },
            { "Tang", "Тангут" },
            { "Tavt", "Тай Вьетнам" },
            { "Telu", metaValue_te },
            { "Tfng", "Тифинаг бичиг" },
            { "Tglg", "Тагалог" },
            { "Thaa", "тана" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Тирхута" },
            { "Tnsa", "Тангса" },
            { "Toto", "Тото" },
            { "Ugar", "Угаритик" },
            { "Vaii", "Ваи бичиг" },
            { "Vith", "Виткуки" },
            { "Wara", "Варанг Кшити" },
            { "Wcho", "Ванчу" },
            { "Xpeo", "Хуучин перс" },
            { "Xsux", "Сумеро-Аккадиан шаантаг бичиг" },
            { "Yezi", "Езиди" },
            { "Yiii", "И бичиг" },
            { "Zanb", "Занабазарын дөрвөлжин бичиг" },
            { "Zinh", "Зинх" },
            { "Zmth", "математик тооллын систем" },
            { "Zsye", "эможи" },
            { "Zsym", "тэмдэг" },
            { "Zxxx", "бичигдээгүй" },
            { "Zyyy", "нийтлэг" },
            { "Zzzz", "тодорхойгүй бичиг" },
            { "en_AU", "австрали-англи" },
            { "en_CA", "канад-англи" },
            { "en_GB", "британи-англи" },
            { "en_US", "америк-англи" },
            { "es_ES", "испани хэл (Европ)" },
            { "es_MX", "испани хэл (Мексик)" },
            { "nl_BE", "фламанд" },
            { "pt_BR", "португал хэл (Бразил)" },
            { "pt_PT", "португал хэл (Европ)" },
            { "ro_MD", "молдав" },
            { "sw_CD", "конгогийн свахили" },
            { "ar_001", "стандарт араб" },
            { "es_419", "испани хэл (Латин Америк)" },
            { "key.ca", "цаглавар" },
            { "key.cf", "мөнгөн тэмдэгтийн хэлбэр" },
            { "key.co", "эрэмбэлэх дараалал" },
            { "key.cu", "мөнгөн тэмдэгт" },
            { "key.em", "Эможи үзүүлэн" },
            { "key.hc", "цагийн мөчлөг (12 эсвэл 24)" },
            { "key.lb", "мөрийн зайн загвар" },
            { "key.lw", "үг хоорондын мөрийн зай" },
            { "key.ms", "нэгжийн систем" },
            { "key.nu", "тоо" },
            { "key.ss", "Товчилсон үгийн дараа өгүүлбэр таслах" },
            { "zh_Hans", "хялбаршуулсан хятад" },
            { "zh_Hant", "уламжлалт хятад" },
            { "type.ca.roc", "минго цаглавар" },
            { "type.co.eor", "Европийн эрэмбэлэх дүрэм" },
            { "type.hc.h11", "12 цагийн систем (0–11)" },
            { "type.hc.h12", "12 цагийн систем (1–12)" },
            { "type.hc.h23", "24 цагийн систем (0–23)" },
            { "type.hc.h24", "24 цагийн систем (1–24)" },
            { "type.nu.ahom", "Ахом тоо" },
            { "type.nu.arab", "араб-энэтхэг тоо" },
            { "type.nu.armn", "армен тоо" },
            { "type.nu.bali", "Бали тоо" },
            { "type.nu.beng", "бенгал тоо" },
            { "type.nu.brah", "Брахми тоо" },
            { "type.nu.cakm", "чакма тоо" },
            { "type.nu.cham", "Чам тоо" },
            { "type.nu.cyrl", "Кирилл тоо" },
            { "type.nu.deva", "деванагари тоо" },
            { "type.nu.diak", "Дивэс Акүрү Тоо" },
            { "type.nu.ethi", "этиоп тоо" },
            { "type.nu.geor", "гүрж тоо" },
            { "type.nu.gong", "Гунжала Гонди тоо" },
            { "type.nu.gonm", "Масарам Гонди тоо" },
            { "type.nu.grek", "грек тоо" },
            { "type.nu.gujr", "гүжарати тоо" },
            { "type.nu.guru", "гүрмүхи тоо" },
            { "type.nu.hans", "хялбаршуулсан хятад тоо" },
            { "type.nu.hant", "уламжлалт хятад тоо" },
            { "type.nu.hebr", "еврей тоо" },
            { "type.nu.hmng", "Пахав Хмонг тоо" },
            { "type.nu.hmnp", "Няакенг Пуачэ Хмонг тоо" },
            { "type.nu.java", "жава тоо" },
            { "type.nu.jpan", "япон тоо" },
            { "type.nu.kali", "Каяа Ли тоо" },
            { "type.nu.kawi", "Кави тоо" },
            { "type.nu.khmr", "кхмер тоо" },
            { "type.nu.knda", "каннада тоо" },
            { "type.nu.lana", "Тай Там Хора тоо" },
            { "type.nu.laoo", "лаос тоо" },
            { "type.nu.latn", "араб тоо" },
            { "type.nu.lepc", "Лепча тоо" },
            { "type.nu.limb", "Лимбу тоо" },
            { "type.nu.mlym", "малаялам тоо" },
            { "type.nu.modi", "Моди тоо" },
            { "type.nu.mong", "монгол тоо" },
            { "type.nu.mroo", "Мро тоо" },
            { "type.nu.mtei", "мейтей маек тоо" },
            { "type.nu.mymr", "мьянмар тоо" },
            { "type.nu.nagm", "Наг Мундари тоо" },
            { "type.nu.nkoo", "N’Ko тоо" },
            { "type.nu.olck", "ол чики тоо" },
            { "type.nu.orya", "ория тоо" },
            { "type.nu.osma", "Османи тоо" },
            { "type.nu.rohg", "Ханифи Рохинж тоо" },
            { "type.nu.saur", "Саураштра тоо" },
            { "type.nu.shrd", "Шарада тоо" },
            { "type.nu.sind", "Күдавади тоо" },
            { "type.nu.sinh", "Синхала Лит тоо" },
            { "type.nu.sora", "Сора Сомпенг тоо" },
            { "type.nu.sund", "Сундан тоо" },
            { "type.nu.takr", "Такри тоо" },
            { "type.nu.talu", "Шинэ тай луэ тоо" },
            { "type.nu.taml", "уламжлалт тамил тоо" },
            { "type.nu.telu", "тэлүгү тоо" },
            { "type.nu.thai", "тай тоо" },
            { "type.nu.tibt", "төвд тоо" },
            { "type.nu.tirh", "Тирхута тоо" },
            { "type.nu.tnsa", "Тангса тоо" },
            { "type.nu.vaii", "вай тоо" },
            { "type.nu.wara", "Варанг сити тоо" },
            { "type.nu.wcho", "Ванчо тоо" },
            { "type.ca.dangi", "данги цаглавар" },
            { "type.co.ducet", "юникодын үндсэн эрэмбэлэх дараалал" },
            { "type.co.emoji", "Эможи эрэмбэлэх дараалал" },
            { "type.lb.loose", "урт мөрийн зайн загвар" },
            { "type.nu.roman", "ром тоо" },
            { "type.ca.coptic", "коптик цаглавар" },
            { "type.ca.hebrew", "еврей цаглавар" },
            { "type.ca.indian", "энэтхэгийн үндэсний цаглавар" },
            { "type.co.compat", "Нийцлийн үүднээс өмнөх эрэмбэлэх дараалал" },
            { "type.co.pinyin", "Пиньян эрэмбэлэх дараалал" },
            { "type.co.search", "ерөнхий хайлт" },
            { "type.co.unihan", "Язгуурын зураасны эрэмбэлэх дараалал" },
            { "type.co.zhuyin", "Жүяин эрэмбэлэх дараалал" },
            { "type.lb.normal", "энгийн мөрийн зайн загвар" },
            { "type.lb.strict", "шулуун мөрийн зайн загвар" },
            { "type.ms.metric", "метрийн систем" },
            { "type.ca.chinese", "хятад цаглавар" },
            { "type.ca.islamic", "исламын цаглавар" },
            { "type.ca.iso8601", "ISO-8601 цаглавар" },
            { "type.ca.persian", "перс цаглавар" },
            { "type.cf.account", "мөнгөн тэмдэгтийн нягтлан бодох бүртгэлийн хэлбэр" },
            { "type.nu.arabext", "өргөтгөсөн араб-энэтхэг тоо" },
            { "type.nu.armnlow", "жижиг армен тоо" },
            { "type.nu.greklow", "жижиг грек тоо" },
            { "type.nu.hanidec", "хятад аравтын тоо" },
            { "type.nu.hansfin", "хялбаршуулсан хятад санхүүгийн тоо" },
            { "type.nu.hantfin", "уламжлалт хятад санхүүгийн тоо" },
            { "type.nu.jpanfin", "япон санхүүгийн тоо" },
            { "type.nu.mathdbl", "Математикийн хос зурлагат тоо" },
            { "type.nu.tamldec", "тамил тоо" },
            { "type.ca.buddhist", "буддын цаглавар" },
            { "type.ca.ethiopic", metaValue_type_ca_ethiopic },
            { "type.ca.japanese", "япон цаглавар" },
            { "type.cf.standard", "мөнгөн тэмдэгтийн стандарт хэлбэр" },
            { "type.co.searchjl", "Хангүлээр эхний гийгүүлэгчээр хайх" },
            { "type.co.standard", "стандарт эрэмбэлэх дараалал" },
            { "type.ms.uksystem", "Англи нэгжийн систем" },
            { "type.ms.ussystem", "Америк нэгжийн систем" },
            { "type.nu.fullwide", "бүтэн-өргөнтэй тоо" },
            { "type.nu.lanatham", "Тай Там Там тоо" },
            { "type.nu.mathbold", "Математикийн бүдүүн тоо" },
            { "type.nu.mathmono", "Математикийн Monospace тоо" },
            { "type.nu.mathsanb", "Математикийн Sans-Serif Бүдүүн тоо" },
            { "type.nu.mathsans", "Математикийн Sans-Serif тоо" },
            { "type.nu.mymrshan", "Мьянмар Шан тоо" },
            { "type.nu.mymrtlng", "Мьянмар Тай Лайнг тоо" },
            { "type.nu.romanlow", "жижиг ром тоо" },
            { "type.ca.gregorian", "грегорийн цаглавар" },
            { "type.co.phonebook", "Утасны дэвтрийн эрэмбэлэх дараалал" },
            { "type.co.dictionary", "Тольны эрэмбэлэх дараалал" },
            { "type.co.traditional", "Хуучин эрэмбэлэх дараалал" },
            { "type.ca.islamic-rgsa", "исламийн цаглавар (саудын араб, газарзүйн)" },
            { "type.ca.islamic-tbla", "исламийн цаглавар (хүснэгтэн, одон орны эрин)" },
            { "type.ca.islamic-civil", "исламын цаглавар (хүснэгт, иргэний эрин үе)" },
            { "type.ca.islamic-umalqura", "исламын цаглавар (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", metaValue_type_ca_ethiopic },
        };
        return data;
    }
}
