package confidentialledger

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LedgerClient is the microsoft Azure Confidential Compute Ledger Control Plane REST API version 2020-12-01-preview.
type LedgerClient struct {
	BaseClient
}

// NewLedgerClient creates an instance of the LedgerClient client.
func NewLedgerClient(subscriptionID string) LedgerClient {
	return NewLedgerClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLedgerClientWithBaseURI creates an instance of the LedgerClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewLedgerClientWithBaseURI(baseURI string, subscriptionID string) LedgerClient {
	return LedgerClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create creates a  Confidential Ledger with the specified ledger parameters.
// Parameters:
// resourceGroupName - the name of the resource group.
// ledgerName - name of the Confidential Ledger
// confidentialLedger - confidential Ledger Create Request Body
func (client LedgerClient) Create(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger Model) (result LedgerCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.Create")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: ledgerName,
			Constraints: []validation.Constraint{{Target: "ledgerName", Name: validation.Pattern, Rule: `^[a-zA-Z0-9]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("confidentialledger.LedgerClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, ledgerName, confidentialLedger)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client LedgerClient) CreatePreparer(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger Model) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ledgerName":        autorest.Encode("path", ledgerName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	confidentialLedger.Name = nil
	confidentialLedger.ID = nil
	confidentialLedger.Type = nil
	confidentialLedger.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}", pathParameters),
		autorest.WithJSON(confidentialLedger),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) CreateSender(req *http.Request) (future LedgerCreateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client LedgerClient) CreateResponder(resp *http.Response) (result Model, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an existing Confidential Ledger.
// Parameters:
// resourceGroupName - the name of the resource group.
// ledgerName - name of the Confidential Ledger
func (client LedgerClient) Delete(ctx context.Context, resourceGroupName string, ledgerName string) (result LedgerDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: ledgerName,
			Constraints: []validation.Constraint{{Target: "ledgerName", Name: validation.Pattern, Rule: `^[a-zA-Z0-9]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("confidentialledger.LedgerClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, ledgerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client LedgerClient) DeletePreparer(ctx context.Context, resourceGroupName string, ledgerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ledgerName":        autorest.Encode("path", ledgerName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) DeleteSender(req *http.Request) (future LedgerDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client LedgerClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get retrieves the properties of a Confidential Ledger.
// Parameters:
// resourceGroupName - the name of the resource group.
// ledgerName - name of the Confidential Ledger
func (client LedgerClient) Get(ctx context.Context, resourceGroupName string, ledgerName string) (result Model, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: ledgerName,
			Constraints: []validation.Constraint{{Target: "ledgerName", Name: validation.Pattern, Rule: `^[a-zA-Z0-9]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("confidentialledger.LedgerClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, ledgerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client LedgerClient) GetPreparer(ctx context.Context, resourceGroupName string, ledgerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ledgerName":        autorest.Encode("path", ledgerName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client LedgerClient) GetResponder(resp *http.Response) (result Model, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup retrieves the properties of all Confidential Ledgers.
// Parameters:
// resourceGroupName - the name of the resource group.
// filter - the filter to apply on the list operation. eg. $filter=ledgerType eq 'Public'
func (client LedgerClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string) (result ListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.l.Response.Response != nil {
				sc = result.l.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 3, Chain: nil}}}}); err != nil {
		return result, validation.NewError("confidentialledger.LedgerClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.l.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.l, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.l.hasNextLink() && result.l.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client LedgerClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client LedgerClient) ListByResourceGroupResponder(resp *http.Response) (result List, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client LedgerClient) listByResourceGroupNextResults(ctx context.Context, lastResults List) (result List, err error) {
	req, err := lastResults.listPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client LedgerClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, filter string) (result ListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, filter)
	return
}

// ListBySubscription retrieves the properties of all Confidential Ledgers.
// Parameters:
// filter - the filter to apply on the list operation. eg. $filter=ledgerType eq 'Public'
func (client LedgerClient) ListBySubscription(ctx context.Context, filter string) (result ListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.l.Response.Response != nil {
				sc = result.l.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySubscriptionNextResults
	req, err := client.ListBySubscriptionPreparer(ctx, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.l.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result.l, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "ListBySubscription", resp, "Failure responding to request")
		return
	}
	if result.l.hasNextLink() && result.l.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client LedgerClient) ListBySubscriptionPreparer(ctx context.Context, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.ConfidentialLedger/ledgers/", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client LedgerClient) ListBySubscriptionResponder(resp *http.Response) (result List, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionNextResults retrieves the next set of results, if any.
func (client LedgerClient) listBySubscriptionNextResults(ctx context.Context, lastResults List) (result List, err error) {
	req, err := lastResults.listPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "listBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client LedgerClient) ListBySubscriptionComplete(ctx context.Context, filter string) (result ListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySubscription(ctx, filter)
	return
}

// Update updates properties of Confidential Ledger
// Parameters:
// resourceGroupName - the name of the resource group.
// ledgerName - name of the Confidential Ledger
// confidentialLedger - confidential Ledger request body for Updating Ledger
func (client LedgerClient) Update(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger Model) (result LedgerUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerClient.Update")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: ledgerName,
			Constraints: []validation.Constraint{{Target: "ledgerName", Name: validation.Pattern, Rule: `^[a-zA-Z0-9]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("confidentialledger.LedgerClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, ledgerName, confidentialLedger)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confidentialledger.LedgerClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client LedgerClient) UpdatePreparer(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger Model) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ledgerName":        autorest.Encode("path", ledgerName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	confidentialLedger.Name = nil
	confidentialLedger.ID = nil
	confidentialLedger.Type = nil
	confidentialLedger.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}", pathParameters),
		autorest.WithJSON(confidentialLedger),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client LedgerClient) UpdateSender(req *http.Request) (future LedgerUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client LedgerClient) UpdateResponder(resp *http.Response) (result Model, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
