package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAnalysisStatistics invokes the aegis.DescribeAnalysisStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisstatistics.html
func (client *Client) DescribeAnalysisStatistics(request *DescribeAnalysisStatisticsRequest) (response *DescribeAnalysisStatisticsResponse, err error) {
	response = CreateDescribeAnalysisStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAnalysisStatisticsWithChan invokes the aegis.DescribeAnalysisStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAnalysisStatisticsWithChan(request *DescribeAnalysisStatisticsRequest) (<-chan *DescribeAnalysisStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeAnalysisStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAnalysisStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAnalysisStatisticsWithCallback invokes the aegis.DescribeAnalysisStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAnalysisStatisticsWithCallback(request *DescribeAnalysisStatisticsRequest, callback func(response *DescribeAnalysisStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAnalysisStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAnalysisStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAnalysisStatisticsRequest is the request struct for api DescribeAnalysisStatistics
type DescribeAnalysisStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeAnalysisStatisticsResponse is the response struct for api DescribeAnalysisStatistics
type DescribeAnalysisStatisticsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Statistics Statistics `json:"Statistics" xml:"Statistics"`
}

// CreateDescribeAnalysisStatisticsRequest creates a request to invoke DescribeAnalysisStatistics API
func CreateDescribeAnalysisStatisticsRequest() (request *DescribeAnalysisStatisticsRequest) {
	request = &DescribeAnalysisStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeAnalysisStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeAnalysisStatisticsResponse creates a response to parse from DescribeAnalysisStatistics response
func CreateDescribeAnalysisStatisticsResponse() (response *DescribeAnalysisStatisticsResponse) {
	response = &DescribeAnalysisStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
