package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportZoneHour invokes the cloudwf.ReportZoneHour API synchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzonehour.html
func (client *Client) ReportZoneHour(request *ReportZoneHourRequest) (response *ReportZoneHourResponse, err error) {
	response = CreateReportZoneHourResponse()
	err = client.DoAction(request, response)
	return
}

// ReportZoneHourWithChan invokes the cloudwf.ReportZoneHour API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzonehour.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportZoneHourWithChan(request *ReportZoneHourRequest) (<-chan *ReportZoneHourResponse, <-chan error) {
	responseChan := make(chan *ReportZoneHourResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportZoneHour(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportZoneHourWithCallback invokes the cloudwf.ReportZoneHour API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzonehour.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportZoneHourWithCallback(request *ReportZoneHourRequest, callback func(response *ReportZoneHourResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportZoneHourResponse
		var err error
		defer close(result)
		response, err = client.ReportZoneHour(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportZoneHourRequest is the request struct for api ReportZoneHour
type ReportZoneHourRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Query" name:"BeginDate"`
	EndDate   string           `position:"Query" name:"EndDate"`
	Agsid     requests.Integer `position:"Query" name:"Agsid"`
}

// ReportZoneHourResponse is the response struct for api ReportZoneHour
type ReportZoneHourResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateReportZoneHourRequest creates a request to invoke ReportZoneHour API
func CreateReportZoneHourRequest() (request *ReportZoneHourRequest) {
	request = &ReportZoneHourRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ReportZoneHour", "cloudwf", "openAPI")
	return
}

// CreateReportZoneHourResponse creates a response to parse from ReportZoneHour response
func CreateReportZoneHourResponse() (response *ReportZoneHourResponse) {
	response = &ReportZoneHourResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
