package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConfigRule invokes the config.CreateConfigRule API synchronously
func (client *Client) CreateConfigRule(request *CreateConfigRuleRequest) (response *CreateConfigRuleResponse, err error) {
	response = CreateCreateConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConfigRuleWithChan invokes the config.CreateConfigRule API asynchronously
func (client *Client) CreateConfigRuleWithChan(request *CreateConfigRuleRequest) (<-chan *CreateConfigRuleResponse, <-chan error) {
	responseChan := make(chan *CreateConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConfigRuleWithCallback invokes the config.CreateConfigRule API asynchronously
func (client *Client) CreateConfigRuleWithCallback(request *CreateConfigRuleRequest, callback func(response *CreateConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConfigRuleRequest is the request struct for api CreateConfigRule
type CreateConfigRuleRequest struct {
	*requests.RpcRequest
	TagKeyScope               string           `position:"Body" name:"TagKeyScope"`
	ClientToken               string           `position:"Body" name:"ClientToken"`
	ResourceTypesScope        *[]string        `position:"Body" name:"ResourceTypesScope"  type:"Repeated"`
	Description               string           `position:"Body" name:"Description"`
	ConfigRuleTriggerTypes    string           `position:"Body" name:"ConfigRuleTriggerTypes"`
	SourceIdentifier          string           `position:"Body" name:"SourceIdentifier"`
	TagValueScope             string           `position:"Body" name:"TagValueScope"`
	RegionIdsScope            string           `position:"Body" name:"RegionIdsScope"`
	RiskLevel                 requests.Integer `position:"Body" name:"RiskLevel"`
	SourceOwner               string           `position:"Body" name:"SourceOwner"`
	ResourceGroupIdsScope     string           `position:"Body" name:"ResourceGroupIdsScope"`
	InputParameters           string           `position:"Body" name:"InputParameters"`
	ConfigRuleName            string           `position:"Body" name:"ConfigRuleName"`
	TagKeyLogicScope          string           `position:"Body" name:"TagKeyLogicScope"`
	MaximumExecutionFrequency string           `position:"Body" name:"MaximumExecutionFrequency"`
	ExcludeResourceIdsScope   string           `position:"Body" name:"ExcludeResourceIdsScope"`
}

// CreateConfigRuleResponse is the response struct for api CreateConfigRule
type CreateConfigRuleResponse struct {
	*responses.BaseResponse
	ConfigRuleId string `json:"ConfigRuleId" xml:"ConfigRuleId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateConfigRuleRequest creates a request to invoke CreateConfigRule API
func CreateCreateConfigRuleRequest() (request *CreateConfigRuleRequest) {
	request = &CreateConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CreateConfigRule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateConfigRuleResponse creates a response to parse from CreateConfigRule response
func CreateCreateConfigRuleResponse() (response *CreateConfigRuleResponse) {
	response = &CreateConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
