package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnRealTimeLogProject invokes the dcdn.DeleteDcdnRealTimeLogProject API synchronously
func (client *Client) DeleteDcdnRealTimeLogProject(request *DeleteDcdnRealTimeLogProjectRequest) (response *DeleteDcdnRealTimeLogProjectResponse, err error) {
	response = CreateDeleteDcdnRealTimeLogProjectResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnRealTimeLogProjectWithChan invokes the dcdn.DeleteDcdnRealTimeLogProject API asynchronously
func (client *Client) DeleteDcdnRealTimeLogProjectWithChan(request *DeleteDcdnRealTimeLogProjectRequest) (<-chan *DeleteDcdnRealTimeLogProjectResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnRealTimeLogProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnRealTimeLogProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnRealTimeLogProjectWithCallback invokes the dcdn.DeleteDcdnRealTimeLogProject API asynchronously
func (client *Client) DeleteDcdnRealTimeLogProjectWithCallback(request *DeleteDcdnRealTimeLogProjectRequest, callback func(response *DeleteDcdnRealTimeLogProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnRealTimeLogProjectResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnRealTimeLogProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnRealTimeLogProjectRequest is the request struct for api DeleteDcdnRealTimeLogProject
type DeleteDcdnRealTimeLogProjectRequest struct {
	*requests.RpcRequest
	BusinessType string           `position:"Query" name:"BusinessType"`
	ProjectName  string           `position:"Query" name:"ProjectName"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteDcdnRealTimeLogProjectResponse is the response struct for api DeleteDcdnRealTimeLogProject
type DeleteDcdnRealTimeLogProjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnRealTimeLogProjectRequest creates a request to invoke DeleteDcdnRealTimeLogProject API
func CreateDeleteDcdnRealTimeLogProjectRequest() (request *DeleteDcdnRealTimeLogProjectRequest) {
	request = &DeleteDcdnRealTimeLogProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnRealTimeLogProject", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnRealTimeLogProjectResponse creates a response to parse from DeleteDcdnRealTimeLogProject response
func CreateDeleteDcdnRealTimeLogProjectResponse() (response *DeleteDcdnRealTimeLogProjectResponse) {
	response = &DeleteDcdnRealTimeLogProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
