package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppInstanceList invokes the edas.DescribeAppInstanceList API synchronously
func (client *Client) DescribeAppInstanceList(request *DescribeAppInstanceListRequest) (response *DescribeAppInstanceListResponse, err error) {
	response = CreateDescribeAppInstanceListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppInstanceListWithChan invokes the edas.DescribeAppInstanceList API asynchronously
func (client *Client) DescribeAppInstanceListWithChan(request *DescribeAppInstanceListRequest) (<-chan *DescribeAppInstanceListResponse, <-chan error) {
	responseChan := make(chan *DescribeAppInstanceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppInstanceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppInstanceListWithCallback invokes the edas.DescribeAppInstanceList API asynchronously
func (client *Client) DescribeAppInstanceListWithCallback(request *DescribeAppInstanceListRequest, callback func(response *DescribeAppInstanceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppInstanceListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppInstanceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppInstanceListRequest is the request struct for api DescribeAppInstanceList
type DescribeAppInstanceListRequest struct {
	*requests.RoaRequest
	AppId        string           `position:"Query" name:"AppId"`
	WithNodeInfo requests.Boolean `position:"Query" name:"WithNodeInfo"`
}

// DescribeAppInstanceListResponse is the response struct for api DescribeAppInstanceList
type DescribeAppInstanceListResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Code         int        `json:"Code" xml:"Code"`
	Message      string     `json:"Message" xml:"Message"`
	InstanceList []Instance `json:"InstanceList" xml:"InstanceList"`
}

// CreateDescribeAppInstanceListRequest creates a request to invoke DescribeAppInstanceList API
func CreateDescribeAppInstanceListRequest() (request *DescribeAppInstanceListRequest) {
	request = &DescribeAppInstanceListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DescribeAppInstanceList", "/pop/v5/oam/app_instance_list", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeAppInstanceListResponse creates a response to parse from DescribeAppInstanceList response
func CreateDescribeAppInstanceListResponse() (response *DescribeAppInstanceListResponse) {
	response = &DescribeAppInstanceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
