package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteOTAFirmware invokes the iot.DeleteOTAFirmware API synchronously
func (client *Client) DeleteOTAFirmware(request *DeleteOTAFirmwareRequest) (response *DeleteOTAFirmwareResponse, err error) {
	response = CreateDeleteOTAFirmwareResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteOTAFirmwareWithChan invokes the iot.DeleteOTAFirmware API asynchronously
func (client *Client) DeleteOTAFirmwareWithChan(request *DeleteOTAFirmwareRequest) (<-chan *DeleteOTAFirmwareResponse, <-chan error) {
	responseChan := make(chan *DeleteOTAFirmwareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteOTAFirmware(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteOTAFirmwareWithCallback invokes the iot.DeleteOTAFirmware API asynchronously
func (client *Client) DeleteOTAFirmwareWithCallback(request *DeleteOTAFirmwareRequest, callback func(response *DeleteOTAFirmwareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteOTAFirmwareResponse
		var err error
		defer close(result)
		response, err = client.DeleteOTAFirmware(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteOTAFirmwareRequest is the request struct for api DeleteOTAFirmware
type DeleteOTAFirmwareRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	FirmwareId    string `position:"Query" name:"FirmwareId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteOTAFirmwareResponse is the response struct for api DeleteOTAFirmware
type DeleteOTAFirmwareResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteOTAFirmwareRequest creates a request to invoke DeleteOTAFirmware API
func CreateDeleteOTAFirmwareRequest() (request *DeleteOTAFirmwareRequest) {
	request = &DeleteOTAFirmwareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteOTAFirmware", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteOTAFirmwareResponse creates a response to parse from DeleteOTAFirmware response
func CreateDeleteOTAFirmwareResponse() (response *DeleteOTAFirmwareResponse) {
	response = &DeleteOTAFirmwareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
