package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportThingModelTsl invokes the iot.ImportThingModelTsl API synchronously
func (client *Client) ImportThingModelTsl(request *ImportThingModelTslRequest) (response *ImportThingModelTslResponse, err error) {
	response = CreateImportThingModelTslResponse()
	err = client.DoAction(request, response)
	return
}

// ImportThingModelTslWithChan invokes the iot.ImportThingModelTsl API asynchronously
func (client *Client) ImportThingModelTslWithChan(request *ImportThingModelTslRequest) (<-chan *ImportThingModelTslResponse, <-chan error) {
	responseChan := make(chan *ImportThingModelTslResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportThingModelTsl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportThingModelTslWithCallback invokes the iot.ImportThingModelTsl API asynchronously
func (client *Client) ImportThingModelTslWithCallback(request *ImportThingModelTslRequest, callback func(response *ImportThingModelTslResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportThingModelTslResponse
		var err error
		defer close(result)
		response, err = client.ImportThingModelTsl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportThingModelTslRequest is the request struct for api ImportThingModelTsl
type ImportThingModelTslRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	ResourceGroupId   string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	FunctionBlockName string `position:"Query" name:"FunctionBlockName"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	TslUrl            string `position:"Query" name:"TslUrl"`
	TslStr            string `position:"Query" name:"TslStr"`
	FunctionBlockId   string `position:"Query" name:"FunctionBlockId"`
}

// ImportThingModelTslResponse is the response struct for api ImportThingModelTsl
type ImportThingModelTslResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateImportThingModelTslRequest creates a request to invoke ImportThingModelTsl API
func CreateImportThingModelTslRequest() (request *ImportThingModelTslRequest) {
	request = &ImportThingModelTslRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ImportThingModelTsl", "", "")
	request.Method = requests.POST
	return
}

// CreateImportThingModelTslResponse creates a response to parse from ImportThingModelTsl response
func CreateImportThingModelTslResponse() (response *ImportThingModelTslResponse) {
	response = &ImportThingModelTslResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
