package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllowedRoleCells invokes the oam.ListAllowedRoleCells API synchronously
// api document: https://help.aliyun.com/api/oam/listallowedrolecells.html
func (client *Client) ListAllowedRoleCells(request *ListAllowedRoleCellsRequest) (response *ListAllowedRoleCellsResponse, err error) {
	response = CreateListAllowedRoleCellsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllowedRoleCellsWithChan invokes the oam.ListAllowedRoleCells API asynchronously
// api document: https://help.aliyun.com/api/oam/listallowedrolecells.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAllowedRoleCellsWithChan(request *ListAllowedRoleCellsRequest) (<-chan *ListAllowedRoleCellsResponse, <-chan error) {
	responseChan := make(chan *ListAllowedRoleCellsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllowedRoleCells(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllowedRoleCellsWithCallback invokes the oam.ListAllowedRoleCells API asynchronously
// api document: https://help.aliyun.com/api/oam/listallowedrolecells.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAllowedRoleCellsWithCallback(request *ListAllowedRoleCellsRequest, callback func(response *ListAllowedRoleCellsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllowedRoleCellsResponse
		var err error
		defer close(result)
		response, err = client.ListAllowedRoleCells(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllowedRoleCellsRequest is the request struct for api ListAllowedRoleCells
type ListAllowedRoleCellsRequest struct {
	*requests.RpcRequest
	UserName string `position:"Query" name:"UserName"`
}

// ListAllowedRoleCellsResponse is the response struct for api ListAllowedRoleCells
type ListAllowedRoleCellsResponse struct {
	*responses.BaseResponse
	Code    string                     `json:"Code" xml:"Code"`
	Message string                     `json:"Message" xml:"Message"`
	Data    DataInListAllowedRoleCells `json:"Data" xml:"Data"`
}

// CreateListAllowedRoleCellsRequest creates a request to invoke ListAllowedRoleCells API
func CreateListAllowedRoleCellsRequest() (request *ListAllowedRoleCellsRequest) {
	request = &ListAllowedRoleCellsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListAllowedRoleCells", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllowedRoleCellsResponse creates a response to parse from ListAllowedRoleCells response
func CreateListAllowedRoleCellsResponse() (response *ListAllowedRoleCellsResponse) {
	response = &ListAllowedRoleCellsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
