/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;

public class LocalHistory {
    protected JSVGViewerFrame svgFrame;
    protected JMenu menu;
    protected int index;
    protected List visitedURIs = new ArrayList();
    protected int currentURI = -1;
    protected ButtonGroup group = new ButtonGroup();
    protected ActionListener actionListener = new RadioListener();
    protected int state;
    protected static final int STABLE_STATE = 0;
    protected static final int BACK_PENDING_STATE = 1;
    protected static final int FORWARD_PENDING_STATE = 2;
    protected static final int RELOAD_PENDING_STATE = 3;

    public LocalHistory(JMenuBar jMenuBar, JSVGViewerFrame jSVGViewerFrame) {
        this.svgFrame = jSVGViewerFrame;
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            int n2 = jMenu.getItemCount();
            for (int j = 0; j < n2; ++j) {
                String string;
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || !"@@@".equals(string = jMenuItem.getText())) continue;
                this.menu = jMenu;
                this.index = j;
                jMenu.remove(j);
                return;
            }
        }
        throw new IllegalArgumentException("No '@@@' marker found");
    }

    public void back() {
        this.update();
        this.state = 1;
        this.currentURI -= 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoBack() {
        return this.currentURI > 0;
    }

    public void forward() {
        this.update();
        this.state = 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoForward() {
        return this.currentURI < this.visitedURIs.size() - 1;
    }

    public void reload() {
        this.update();
        this.state = 3;
        --this.currentURI;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public void update(String string) {
        Object object;
        JMenuItem jMenuItem;
        int n;
        if (this.currentURI < -1) {
            throw new IllegalStateException("Unexpected currentURI:" + this.currentURI);
        }
        this.state = 0;
        if (++this.currentURI < this.visitedURIs.size()) {
            if (!this.visitedURIs.get(this.currentURI).equals(string)) {
                int n2 = this.menu.getItemCount();
                for (n = n2 - 1; n >= this.index + this.currentURI + 1; --n) {
                    jMenuItem = this.menu.getItem(n);
                    this.group.remove(jMenuItem);
                    this.menu.remove(n);
                }
                this.visitedURIs = this.visitedURIs.subList(0, this.currentURI + 1);
            }
            object = this.menu.getItem(this.index + this.currentURI);
            this.group.remove((AbstractButton)object);
            this.menu.remove(this.index + this.currentURI);
            this.visitedURIs.set(this.currentURI, string);
        } else {
            if (this.visitedURIs.size() >= 15) {
                this.visitedURIs.remove(0);
                object = this.menu.getItem(this.index);
                this.group.remove((AbstractButton)object);
                this.menu.remove(this.index);
                --this.currentURI;
            }
            this.visitedURIs.add(string);
        }
        object = string;
        n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n != -1) {
            object = string.substring(n + 1);
        }
        jMenuItem = new JRadioButtonMenuItem((String)object);
        jMenuItem.setToolTipText(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this.actionListener);
        this.group.add(jMenuItem);
        jMenuItem.setSelected(true);
        this.menu.insert(jMenuItem, this.index + this.currentURI);
    }

    protected void update() {
        switch (this.state) {
            case 1: {
                this.currentURI += 2;
                break;
            }
            case 3: {
                ++this.currentURI;
                break;
            }
        }
    }

    protected class RadioListener
    implements ActionListener {
        protected RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            LocalHistory.this.currentURI = this.getItemIndex((JMenuItem)actionEvent.getSource()) - 1;
            LocalHistory.this.svgFrame.showSVGDocument(string);
        }

        public int getItemIndex(JMenuItem jMenuItem) {
            int n = LocalHistory.this.menu.getItemCount();
            for (int i = LocalHistory.this.index; i < n; ++i) {
                if (LocalHistory.this.menu.getItem(i) != jMenuItem) continue;
                return i - LocalHistory.this.index;
            }
            throw new IllegalArgumentException("MenuItem is not from my menu!");
        }
    }
}

