/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

final class JComboBoxSelectionValueQuery {
    static final Object NO_SELECTION_VALUE = new Object();

    @RunsInEDT
    static Object selection(final JComboBox comboBox, final JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            protected Object executeInEDT() {
                int selectedIndex = comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    return JComboBoxSelectionValueQuery.valueForNoSelection(comboBox);
                }
                return cellReader.valueAt(comboBox, selectedIndex);
            }
        });
    }

    private static Object valueForNoSelection(JComboBox comboBox) {
        if (!comboBox.isEditable()) {
            return NO_SELECTION_VALUE;
        }
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem instanceof String) {
            return selectedItem;
        }
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return NO_SELECTION_VALUE;
    }

    private JComboBoxSelectionValueQuery() {
    }
}

