/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pcm extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "Tọ́ki";
        final String metaValue_GE = "Jọ́jia";
        final String metaValue_MN = "Mọngólia";
        final String metaValue_nqo = "N’Ko Lángwej";
        final String metaValue_syr = "Síriák Lángwej";
        final String metaValue_th = "Taí";
        final Object[][] data = new Object[][] {
            { "001", "Wọld" },
            { "002", "Áfríka" },
            { "003", "Nọ́t Amẹ́ríka" },
            { "005", "Saút Amẹ́ríka" },
            { "009", "Oshẹnia" },
            { "011", "Wẹ́stán Áfríka" },
            { "013", "Mídúl Amẹ́ríka" },
            { "014", "Ístán Áfríká" },
            { "015", "Nọ́tán Áfríka" },
            { "017", "Mídúl Áfríka" },
            { "018", "Saútán Áfríka" },
            { "019", "Amẹ́ríkas" },
            { "021", "Nọ́tán Amẹ́ríka" },
            { "029", "Karíbián" },
            { "030", "Ístán Éshia" },
            { "034", "Saútán Éshia" },
            { "035", "Saútíst Éshiá" },
            { "039", "Saútán Yúrop" },
            { "053", "Ọstraléshia" },
            { "054", "Mẹlanẹíshia" },
            { "057", "Maikroníshia Ríjọn" },
            { "061", "Poliníshiá" },
            { "142", "Éshia" },
            { "143", "Mídúl Éshia" },
            { "145", "Wẹ́stán Éshia" },
            { "150", "Yúrop" },
            { "151", "Ístán Yúrop" },
            { "154", "Nọ́tán Yúrop" },
            { "155", "Wẹ́stán Yúrop" },
            { "202", "Áfríka Éria Biló Sahára" },
            { "419", "Látín Amẹ́ríka" },
            { "AC", "Asẹ́nshọ́n Aíland" },
            { "AD", "Andọ́ra" },
            { "AE", "Yunaítẹ́d Áráb Ẹ́mírets" },
            { "AF", "Afgánístan" },
            { "AG", "Antígwua & Barbúda" },
            { "AI", "Angwíla" },
            { "AL", "Albénia" },
            { "AM", "Armẹ́niá" },
            { "AO", "Angóla" },
            { "AQ", "Antáktíka" },
            { "AR", "Ajẹntína" },
            { "AS", "Amẹ́ríká Samoa" },
            { "AT", "Ọ́stria" },
            { "AU", "Ọstrélia" },
            { "AW", "Arúba" },
            { "AX", "Ọ́lánd Aílands" },
            { "AZ", "Azẹrbaijan" },
            { "BA", "Bọ́zniá & Hẹzẹgovína" },
            { "BB", "Barbédọs" },
            { "BD", "Bangladẹsh" },
            { "BE", "Bẹ́ljọm" },
            { "BF", "Burkína Fáso" },
            { "BG", "Bọlgéria" },
            { "BH", "Barein" },
            { "BI", "Burúndi" },
            { "BJ", "Binin" },
            { "BL", "Sént Batẹlẹ́mi" },
            { "BM", "Bẹmiúda" },
            { "BN", "Brunẹi" },
            { "BO", "Bolívia" },
            { "BQ", "Karíbián Nẹ́dalands" },
            { "BR", "Brázil" },
            { "BS", "Bahámas" },
            { "BT", "Butan" },
            { "BV", "Buvẹ́ Aíland" },
            { "BW", "Botswána" },
            { "BY", "Bẹ́larus" },
            { "BZ", "Bẹliz" },
            { "CA", "Kánáda" },
            { "CC", "Kókós Aílands" },
            { "CD", "Kóngó – Kinshása" },
            { "CF", "Sẹ́ntrál Áfríkán Ripọ́blik" },
            { "CG", "Kóngo – Brázavil" },
            { "CH", "Swítsaland" },
            { "CI", "Aívri Kost" },
            { "CK", "Kúk Aílands" },
            { "CL", "Chílẹ" },
            { "CM", "Kamẹrun" },
            { "CN", "Chaína" },
            { "CO", "Kolómbia" },
            { "CP", "Klipatọ́n Aíland" },
            { "CQ", "Sák" },
            { "CR", "Kósta Ríka" },
            { "CU", "Kiúbá" },
            { "CV", "Kép Vẹ́d" },
            { "CW", "Kiurásao" },
            { "CX", "Krísmás Aíland" },
            { "CY", "Saíprọs" },
            { "CZ", "Chẹ́kia" },
            { "DE", "Jámáni" },
            { "DG", "Diẹ́gó Garsia" },
            { "DJ", "Jibúti" },
            { "DK", "Dẹ́nmak" },
            { "DM", "Dọmíníka" },
            { "DO", "Dọmíníka Ripọ́blik" },
            { "DZ", "Aljíria" },
            { "EA", "Sẹúta & Mẹ́líla" },
            { "EC", "Ẹ́kwuádọ" },
            { "EE", "Ẹstónia" },
            { "EG", "Íjipt" },
            { "EH", "Wẹ́stán Sahára" },
            { "ER", "Ẹritrẹ́a" },
            { "ES", "Spen" },
            { "ET", "Ẹtiópia" },
            { "EU", "Yurópián Yúniọ́n" },
            { "EZ", "Yúróéria" },
            { "FI", "Fínland" },
            { "FJ", "Fíji" },
            { "FK", "Fọ́klánd Aílands" },
            { "FM", "Maikroníshia" },
            { "FO", "Fáro Aílands" },
            { "FR", "Frans" },
            { "GA", "Gabọn" },
            { "GB", "Yunáítẹ́d Kíndọm" },
            { "GD", "Grẹnéda" },
            { "GE", metaValue_GE },
            { "GF", "Frẹ́nch Giána" },
            { "GG", "Guẹnzi" },
            { "GH", "Gána" },
            { "GI", "Jibrọ́lta" },
            { "GL", "Grínland" },
            { "GM", "Gámbia" },
            { "GN", "Gíni" },
            { "GP", "Guadalúpẹ" },
            { "GQ", "Ikwétóriál Gíni" },
            { "GR", "Gris" },
            { "GS", "Saút Jọ́jia an Saút Sándwích Aílands" },
            { "GT", "Guátẹmála" },
            { "GU", "Guám" },
            { "GW", "Gíní-Bisáu" },
            { "GY", "Gayána" },
            { "HK", "Họng Kọng SAR" },
            { "HM", "Hiád & MakDónáld Aílands" },
            { "HN", "Họndúras" },
            { "HR", "Kroéshia" },
            { "HT", "Haíti" },
            { "HU", "Họ́ngári" },
            { "IC", "Kenerí Aílands" },
            { "ID", "Indoníshia" },
            { "IE", "Ayaland" },
            { "IL", "Ízrẹl" },
            { "IM", "Aíl ọf Man" },
            { "IN", "Índia" },
            { "IO", "Brítísh Índián Óshen Tẹ́rẹ́tri" },
            { "IQ", "Irak" },
            { "IR", "Irán" },
            { "IS", "Aísland" },
            { "IT", "Ítáli" },
            { "JE", "Jẹ́si" },
            { "JM", "Jamaíka" },
            { "JO", "Jọ́dan" },
            { "JP", "Japán" },
            { "KE", "Kẹ́nya" },
            { "KG", "Kẹjístan" },
            { "KH", "Kambódia" },
            { "KI", "Kiribáti" },
            { "KM", "Kọ́mọ́ros" },
            { "KN", "Sent Kits & Nẹ́vis" },
            { "KP", "Nọ́t Koria" },
            { "KR", "Saút Koria" },
            { "KW", "Kuwét" },
            { "KY", "Kéman Aílands" },
            { "KZ", "Kazakstan" },
            { "LA", "Láos" },
            { "LB", "Lẹ́bánọn" },
            { "LC", "Sent Lúshia" },
            { "LI", "Líktẹ́nstain" },
            { "LK", "Sri Lánka" },
            { "LR", "Laibẹ́ria" },
            { "LS", "Lẹsóto" },
            { "LT", "Lituénia" },
            { "LU", "Lọ́ksẹ́mbọg" },
            { "LV", "Látvia" },
            { "LY", "Líbia" },
            { "MA", "Morọko" },
            { "MC", "Mọ́náko" },
            { "MD", "Mọldóva" },
            { "ME", "Mọntinígro" },
            { "MF", "Sent Mátin" },
            { "MG", "Madagáska" },
            { "MH", "Máshál Aílands" },
            { "MK", "Nọ́t Masidónia" },
            { "ML", "Máli" },
            { "MM", "Miánma (Bọ́ma)" },
            { "MN", metaValue_MN },
            { "MO", "Makáo SAR Chaína" },
            { "MP", "Nọ́tán Mariána Aílands" },
            { "MQ", "Matínik" },
            { "MR", "Mọriténia" },
            { "MS", "Mọntsẹrat" },
            { "MT", "Mọ́lta" },
            { "MU", "Mọríshọs" },
            { "MV", "Mọ́ldivs" },
            { "MW", "Maláwi" },
            { "MX", "Mẹ́ksíko" },
            { "MY", "Maléshia" },
            { "MZ", "Mozámbik" },
            { "NA", "Namíbia" },
            { "NC", "Niú Kalẹdónia" },
            { "NE", "Nizhẹr" },
            { "NF", "Nọ́fọlk Aíland" },
            { "NG", "Naijíria" },
            { "NI", "Nikarágwua" },
            { "NL", "Nẹ́dalands" },
            { "NO", "Nọ́we" },
            { "NP", "Nẹ́pal" },
            { "NR", "Náuru" },
            { "NU", "Niúẹ" },
            { "NZ", "Niú Zíland" },
            { "OM", "Omán" },
            { "PA", "Pánáma" },
            { "PE", "Pẹ́ru" },
            { "PF", "Frẹ́nch Poliníshia" },
            { "PG", "Pápuá Niú Gíni" },
            { "PH", "Fílípins" },
            { "PK", "Pakístan" },
            { "PL", "Póland" },
            { "PM", "Sent Piẹr & Míkẹlọn" },
            { "PN", "Pítkén Aílands" },
            { "PR", "Puẹ́rto Ríkọ" },
            { "PS", "Pálẹ́staín Éria-dẹm" },
            { "PT", "Pọ́túgal" },
            { "PW", "Paláu" },
            { "PY", "Párágwue" },
            { "QA", "Kata" },
            { "QO", "Rimót Pát ọf Oshẹ́nia" },
            { "RE", "Réyúniọn" },
            { "RO", "Ruménia" },
            { "RS", "Sẹ́bia" },
            { "RU", "Rọ́shia" },
            { "RW", "Ruwánda" },
            { "SA", "Saúdí Arébia" },
            { "SB", "Sólómọ́n Aílands" },
            { "SC", "Sẹ́chẹls" },
            { "SD", "Sudán" },
            { "SE", "Swídẹn" },
            { "SG", "Singapọ" },
            { "SH", "Sent Hẹlẹ́na" },
            { "SI", "Slovẹ́nia" },
            { "SJ", "Sválbad & Jén Meyẹn" },
            { "SK", "Slovékia" },
            { "SL", "Siẹ́ra Líon" },
            { "SM", "San Maríno" },
            { "SN", "Sẹ́nẹ́gal" },
            { "SO", "Sọmália" },
            { "SR", "Súrínam" },
            { "SS", "Saút Sudan" },
            { "ST", "Sao Tómé & Prínsípẹ" },
            { "SV", "El Sálvádọ" },
            { "SX", "Sint Mátin" },
            { "SY", "Síria" },
            { "SZ", "Ẹswatíni" },
            { "TA", "Trístán da Kúna" },
            { "TC", "Tọks an Kaíkọ́s Aílands" },
            { "TD", "Chád" },
            { "TF", "Frẹ́nch Saútán Tẹ́rẹ́tris" },
            { "TG", "Tógo" },
            { "TH", "Taíland" },
            { "TJ", "Tajíkstan" },
            { "TK", "Tókẹ́lau" },
            { "TL", "Íst Tímọ" },
            { "TM", "Tọkmẹ́nístan" },
            { "TN", "Tuníshia" },
            { "TO", "Tónga" },
            { "TR", metaValue_TR },
            { "TT", "Trínídad & Tobágo" },
            { "TV", "Tuválu" },
            { "TW", "Taíwán" },
            { "TZ", "Tanzánia" },
            { "UA", "Yukrein" },
            { "UG", "Yugánda" },
            { "UM", "U.S. Faá Faá Aílands" },
            { "UN", "Yunaítẹd Néshọns" },
            { "US", "Yunaítẹ́d Stets" },
            { "UY", "Yúrugwue" },
            { "UZ", "Uzbẹ́kistan" },
            { "VA", "Vátíkán Síti" },
            { "VC", "Sent Vínsẹnt & Grẹ́nádians" },
            { "VE", "Vẹnẹzuẹ́la" },
            { "VG", "Brítísh Vájín Aílands" },
            { "VI", "U.S. Vájín Aílands" },
            { "VN", "Viẹ́tnam" },
            { "VU", "Vanuátu" },
            { "WF", "Wọ́lis & Fiutúna" },
            { "WS", "Samóa" },
            { "XA", "To yúz atifíshál vọis wẹ́n yu de tọk" },
            { "XB", "Atífíshál Tú-Wé Dairẹ́kshọn" },
            { "XK", "Kósóvo" },
            { "YE", "Yẹ́mẹn" },
            { "YT", "Meyọt" },
            { "ZA", "Saút Áfríka" },
            { "ZM", "Zámbia" },
            { "ZW", "Zimbábwẹ" },
            { "ZZ", "Ríjọn Wé Nóbọ́di Sabí" },
            { "ab", "Abkházian" },
            { "af", "Áfríkaans Lángwej" },
            { "ak", "Akan Lángwej" },
            { "am", "Amhárík Lángwej" },
            { "an", "Aragónẹ́sẹ Lángwej" },
            { "ar", "Arábík Lángwej" },
            { "as", "Asamíz Lángwej" },
            { "av", "Afarík Lángwej" },
            { "ay", "Aymára" },
            { "az", "Azẹrbaijáni Lángwej" },
            { "ba", "Bashkír" },
            { "be", "Bẹlarúsiá Lángwej" },
            { "bg", "Bọlgériá Lángwej" },
            { "bi", "Bisláma" },
            { "bm", "Bambára Lángwej" },
            { "bn", "Bángla Lángwej" },
            { "bo", "Tibẹ́tan" },
            { "br", "Brẹ́tọn Lángwej" },
            { "bs", "Bọ́sniá Lángwej" },
            { "ca", "Kátála Lángwej" },
            { "ce", "Chẹ́chẹn Lángwej" },
            { "ch", "Chamóro Lángwej" },
            { "co", "Kọsíkan Lángwej" },
            { "cs", "Chẹ́k Lángwej" },
            { "cu", "Chọ́ch Slávik" },
            { "cv", "Chúvash" },
            { "cy", "Wẹlsh" },
            { "da", "Dénísh Lángwej" },
            { "de", "Jámán Lángwej" },
            { "dv", "Divẹhí" },
            { "dz", "Zọ́ngka Lángwej" },
            { "ee", "Ẹ́wẹ́ Lángwej" },
            { "el", "Grík Lángwej" },
            { "en", "Ínglish" },
            { "eo", "Ẹsperánto Lángwej" },
            { "es", "Spánish Lángwej" },
            { "et", "Ẹstóniá Lángwej" },
            { "eu", "Básk Lángwej" },
            { "fa", "Pẹ́shiá Lángwej" },
            { "ff", "Fúlaní Lángwej" },
            { "fi", "Fínísh Lángwej" },
            { "fj", "Fíján Lángwej" },
            { "fo", "Fáróís Lángwej" },
            { "fr", "Frẹ́nch Lángwej" },
            { "fy", "Wẹ́stán Frísiá Lángwej" },
            { "ga", "Aírísh Lángwej" },
            { "gd", "Gaelík Lángwej ọf Gael Pípol fọ Skọ́tland" },
            { "gl", "Galísiá Lángwej" },
            { "gn", "Guáráni Lángwej" },
            { "gu", "Gujarátí Lángwej" },
            { "gv", "Mánks Lángwej" },
            { "ha", "Háusá Lángwej" },
            { "he", "Híbru Lángwej" },
            { "hi", "Híndi Lángwej" },
            { "hr", "Kroéshia Lángwej" },
            { "ht", "Haítí Kriol" },
            { "hu", "Họngári Lángwej" },
            { "hy", "Armẹ́niá Lángwej" },
            { "hz", "Hẹrẹ́ro" },
            { "ia", "Intalíngwuá Lángwej" },
            { "id", "Indoníshia Lángwej" },
            { "ie", "Intalíngwe Lángwej" },
            { "ig", "Igbo Lángwej" },
            { "ii", "Síchuan Yi" },
            { "io", "Idó Lángwej" },
            { "is", "Aíslánd Lángwej" },
            { "it", "Ítáli Lángwej" },
            { "iu", "Inuktítut" },
            { "ja", "Japan Lángwej" },
            { "jv", "Javáníz Lángwej" },
            { "ka", "Jọ́jiá Lángwej" },
            { "ki", "Kikúyú Lángwej" },
            { "kj", "Kuanyáma Lángwej" },
            { "kk", "Kazák Lángwej" },
            { "kl", "Kalálísút Lángwej" },
            { "km", "Kmaí Lángwej" },
            { "kn", "Kánnáda Lángwej" },
            { "ko", "Koriá Lángwej" },
            { "kr", "Kánurí Lángwej" },
            { "ks", "Kashmírí Lángwej" },
            { "ku", "Kọ́manjí Lángwej" },
            { "kv", "Komi Lángwej" },
            { "kw", "Kọ́nish Lángwej" },
            { "ky", "Kiẹ́gíz Lángwej" },
            { "la", "Látín Lángwej" },
            { "lb", "Lọ́ksémbọ́g Lángwej" },
            { "lg", "Gánda Lángwej" },
            { "li", "Limbógísh Lángwej" },
            { "ln", "Lingálá Lángwej" },
            { "lo", "Láo Lángwej" },
            { "lt", "Lituéniá Lángwej" },
            { "lu", "Lúbá-Katángá Lángwej" },
            { "lv", "Látvián Lángwej" },
            { "mg", "Malagásí Lángwej" },
            { "mh", "Máshállís Lángwej" },
            { "mi", "Maórí Lángwej" },
            { "mk", "Masẹdóniá Lángwej" },
            { "ml", "Maléyálám Lángwej" },
            { "mn", "Mọngóliá Lángwej" },
            { "mr", "Marátí Lángwej" },
            { "ms", "Malé Lángwej" },
            { "mt", "Mọ́ltá Lángwej" },
            { "my", "Bọ́ma Lángwej" },
            { "na", "Naúru Lángwej" },
            { "nb", "Nọwẹ́jiá Bokmál Lángwej" },
            { "nd", "Nọ́tán Ndẹbẹlẹ Lángwej" },
            { "ne", "Nẹpálí Lángwej" },
            { "ng", "Ndónga Lángwej" },
            { "nl", "Dọch Lángwej" },
            { "nn", "Nọwẹ́jiá Niúnọsk" },
            { "no", "Nọ́wẹ́jiá Lángwej" },
            { "nr", "Sáút Ndẹbẹlẹ Lángwej" },
            { "nv", "Navájo Lángwej" },
            { "ny", "Nyánja" },
            { "oc", "Oksitán Lángwej" },
            { "om", "Orómó" },
            { "or", "Ódiá" },
            { "os", "Osẹ́tik" },
            { "pa", "Punjábi" },
            { "pl", "Pólánd Lángwej" },
            { "ps", "Páshto" },
            { "pt", "Pọtiugiz" },
            { "qu", "Kẹchuá" },
            { "rm", "Románsh" },
            { "rn", "Rúndi" },
            { "ro", "Romániá Lángwej" },
            { "ru", "Rọshiá Lángwej" },
            { "rw", "Kinyarwánda Lángwej" },
            { "sa", "Sánskrit" },
            { "sc", "Sadínián Lángwej" },
            { "sd", "Síndí" },
            { "se", "Nọ́tán Sámí Lángwej" },
            { "sg", "sàngo" },
            { "si", "Sínhala" },
            { "sk", "Slóvak" },
            { "sl", "Slovẹ́niá Lángwej" },
            { "sm", "Samóá Lángwej" },
            { "sn", "Shóna" },
            { "so", "Sọmáli" },
            { "sq", "Albéniá Lángwej" },
            { "sr", "Sẹrbiá Lángwej" },
            { "ss", "Swáti Lángwej" },
            { "st", "Saútán Sóto" },
            { "su", "Sọ́ndaniz" },
            { "sv", "Suwídẹ́n Lángwej" },
            { "sw", "Swahíli" },
            { "ta", "tàmil" },
            { "te", "Tẹlugu" },
            { "tg", "Tájik" },
            { "th", metaValue_th },
            { "ti", "Tigrínyá" },
            { "tk", "Tọ́kmẹn" },
            { "tn", "Tswána Lángwej" },
            { "to", "Tóngan" },
            { "tr", metaValue_TR },
            { "ts", "Tsónga Lángwej" },
            { "tt", "Tatá" },
            { "ty", "Tahítián Lángwej" },
            { "ug", "Wiúgọ" },
            { "uk", "Yukrénia" },
            { "ur", "Úrdú" },
            { "uz", "Úzbẹk" },
            { "ve", "Vẹ́nda Lángwej" },
            { "vi", "Viẹ́tnám Lángwej" },
            { "vo", "Vólapiuk" },
            { "wa", "Wálun Lángwej" },
            { "wo", "Wólof" },
            { "xh", "Kọ́sa" },
            { "yi", "Yídish" },
            { "yo", "Yorubá" },
            { "za", "Zhuáng Lángwej" },
            { "zh", "Mandarín Chainíz Lángwej" },
            { "zu", "Zúlu" },
            { "ace", "Achínẹ́sẹ" },
            { "ada", "Adángme" },
            { "ady", "Adyghẹ́" },
            { "agq", "Aghẹ́m Lángwej" },
            { "ain", "Ainú" },
            { "ale", "Alẹut" },
            { "alt", "Saútán Altai Lángwej" },
            { "ann", "Óbóló Lángwej" },
            { "anp", "Angíka" },
            { "arn", "Mapúchẹ́ Lángwej" },
            { "arp", "Arapahó" },
            { "ars", "Nájdí Arábík Lángwej" },
            { "asa", "Asu Lángwej" },
            { "ast", "Astúriá Lángwej" },
            { "atj", "Atíkamẹ́kw" },
            { "awa", "Awadhí" },
            { "bal", "Báluchí" },
            { "ban", "Balinẹẹ́s" },
            { "bas", "Básaa Lángwej" },
            { "bem", "Bẹ́mba Lángwej" },
            { "bez", "Bẹ́na Lángwej" },
            { "bgc", "Haryanvi Lángwej" },
            { "bho", "Bhojpúri" },
            { "bin", "Biní" },
            { "bla", "Siksíká Lángwej" },
            { "blo", "Anii Lángwej" },
            { "brx", "Bódo Lángwej" },
            { "bug", "Buginiís" },
            { "byn", "Bliní" },
            { "cay", "Kayúga" },
            { "ccp", "Chákma Lángwej" },
            { "ceb", "Sẹbuáno Lángwej" },
            { "cgg", "Chíga Lángwej" },
            { "chk", "Chuukís Lángwej" },
            { "chm", "Mari Lángwej" },
            { "cho", "Shọ́ktau Lángwej" },
            { "chp", "Shípẹwián Lángwej" },
            { "chr", "Chẹ́rókii Lángwej" },
            { "chy", "Shẹínn Lángwej" },
            { "ckb", "Mídúl Kọ́dish Lángwej" },
            { "clc", "Chílkotín Lángwej" },
            { "crg", "Michíf Lángwej" },
            { "crj", "Saútán Íst Krii Lángwej" },
            { "crk", "Krii fọ Plén Lángwej" },
            { "crl", "Nọ́tán Íst Krií Lángwej" },
            { "crm", "Muse Krií Lángwej" },
            { "crr", "Karolína Algónkwían" },
            { "csw", "Swampi Krií Lángwej" },
            { "dak", "Dakótá Lángwej" },
            { "dar", "Dargwá Lángwej" },
            { "dav", "Taíta" },
            { "dgr", "Dọgríb Lángwej" },
            { "dje", "Zármá" },
            { "doi", "Dọgri" },
            { "dsb", "Lówá Sorbiá" },
            { "dua", "Duála Lángwej" },
            { "dyo", "Jóla-Fónyi Lángwej" },
            { "dzg", "Dazágá Lángwej" },
            { "ebu", "Ẹmbu Lángwej" },
            { "efi", "Ẹ́fík Lángwej" },
            { "eka", "Ẹkajúk Lángwej" },
            { "ewo", "Ẹwondo Lángwej" },
            { "fil", "Filipínó Lángwej" },
            { "fon", "Fọn Lángwej" },
            { "frc", "Kájun Frẹnchi" },
            { "frr", "Nọ́tán Frísian" },
            { "fur", "Friúlián Lángwej" },
            { "gaa", "Ga Lángwej" },
            { "gez", "Giiz Lángwej" },
            { "gil", "Gílbátís Lángwej" },
            { "gor", "Gorontáló Lángwej" },
            { "gsw", "Jámán Swis" },
            { "guz", "Gusí Lángwej" },
            { "gwi", "Gwichín Lángwej" },
            { "hai", "Haída Lángwej" },
            { "haw", "Hawaii Lángwej" },
            { "hax", "Saútán Haida" },
            { "hil", "Híligaínọn" },
            { "hmn", "Mọ́ng Lángwej" },
            { "hsb", "Sóbiá Lángwej di ọ́p-ọ́p wan" },
            { "hup", "Húpá Lángwej" },
            { "hur", "Halkomẹ́lẹ́m Lángwej" },
            { "iba", "Iban Lángwej" },
            { "ibb", "Ibibio Lángwej" },
            { "ikt", "Wẹ́stán Kánádá Inuktítut" },
            { "ilo", "Ilokó" },
            { "inh", "Inguísh Lángwej" },
            { "jbo", "Lojban Lángwej" },
            { "jgo", "Ngómbá Lángwej" },
            { "jmc", "Machámẹ́ Lángwej" },
            { "kab", "Kabail Lángwej" },
            { "kac", "Kachín Lángwej" },
            { "kaj", "Jju Lángwej" },
            { "kam", "Kámbá Lángwej" },
            { "kbd", "Kabárdian" },
            { "kcg", "Tyap Lángwej" },
            { "kde", "Makọ́ndẹ́ Lángwej" },
            { "kea", "Kábúvẹrdiánu Lángwej" },
            { "kfo", "Koro Lángwej" },
            { "kgp", "Kaingáng Lángwej" },
            { "kha", "Khási Lángwej" },
            { "khq", "Koyra Chíní Lángwej" },
            { "kkj", "Kákó Lángwej" },
            { "kln", "Kálẹ́njín Lángwej" },
            { "kmb", "Kimbúndú Lángwej" },
            { "kok", "Kónkéní Lángwej" },
            { "kpe", "Kpẹllẹ Lángwej" },
            { "krc", "Karáchei-Bálkar" },
            { "krl", "Karẹ́lian" },
            { "kru", "Kurúkh Lángwej" },
            { "ksb", "Shámbala" },
            { "ksf", "Bafiá Lángwej" },
            { "ksh", "Kọlónián Lángwej" },
            { "kum", "Kumyík Lángwej" },
            { "kwk", "Kwakwála Lángwej" },
            { "kxv", "Kuvi Lángwej" },
            { "lad", "Ladíno Lángwej" },
            { "lag", "Langi Lángwej" },
            { "lez", "Lẹzghián Lángwej" },
            { "lij", "Ligurián Lángwej" },
            { "lil", "Lillooẹ́t Lángwej" },
            { "lkt", "Lakótá Lángwej" },
            { "lmo", "Lombárd Lángwej" },
            { "lou", "Kriol fọ Luisiána" },
            { "loz", "Lózí Lángwej" },
            { "lrc", "Nọ́tán Lúrí Lángwej" },
            { "lsm", "Saamiá Lángwej" },
            { "lua", "Luba-Lúlua" },
            { "lun", "Lunda Lángwej" },
            { "luo", "Luó Lángwej" },
            { "lus", "Mizo Lángwej" },
            { "luy", "Luyia Lángwej" },
            { "mad", "Madurẹ́sẹ" },
            { "mag", "Magahí Lángwej" },
            { "mai", "Maítíli" },
            { "mak", "Mákásá Lángwej" },
            { "mas", "Masaí Lángwej" },
            { "mdf", "Móksha Lángwej" },
            { "men", "Mẹndẹ́ Lángwej" },
            { "mer", "Mẹ́rú Lángwej" },
            { "mfe", "Morísiẹ́n Lángwej" },
            { "mgh", "Makúwá-Mító" },
            { "mgo", "Mẹta’ Lángwej" },
            { "mic", "Mikmák Lángwej" },
            { "min", "Minangkabáu" },
            { "mni", "Manípuri" },
            { "moe", "Innu-aímun Lángwej" },
            { "moh", "Móhọ́k Lángwej" },
            { "mos", "Mósí Lángwej" },
            { "mua", "Mundáng Lángwej" },
            { "mul", "Plẹ́ntí Lángwej-dẹm" },
            { "mus", "Múskójii Lángwej" },
            { "mwl", "Mirándẹ́sẹ Lángwej" },
            { "myv", "Ẹrziá Lángwej" },
            { "mzn", "Mazandẹrání Lángwej" },
            { "nap", "Niapolítán Lángwej" },
            { "naq", "Naámá Lángwej" },
            { "nds", "Ló Jámán Lángwej" },
            { "new", "Nẹwarí Lángwej" },
            { "nia", "Nias Lángwej" },
            { "niu", "Niúeán Lángwej" },
            { "nmg", "Kwasió Lángwej" },
            { "nnh", "Ngiẹ́mbọn Lángwej" },
            { "nog", "Nogái Lángwej" },
            { "nqo", metaValue_nqo },
            { "nso", "Nọ́tán Sótho Lángwej" },
            { "nus", "Núa" },
            { "nyn", "Nyankólẹ" },
            { "ojb", "Nọ́tán Ojibwa" },
            { "ojc", "Sẹ́ntrál Ojíbwa" },
            { "ojs", "Ojí-Krii Lángwej" },
            { "ojw", "Wẹ́stán Ojibua" },
            { "oka", "Okanagan Langwej" },
            { "pag", "Pangasínán Lángwej" },
            { "pam", "Pampánga Lángwej" },
            { "pap", "Papiaménto Lángwej" },
            { "pau", "Palaúán Lángwej" },
            { "pcm", "Naijíriá Píjin" },
            { "pis", "Píjín Lángwej" },
            { "pqm", "Malisiít Pasamákódí Lángwej" },
            { "prg", "Prúshia" },
            { "raj", "Rajástháni Lángwej" },
            { "rap", "Rapánui Lángwej" },
            { "rar", "Rarotóngan" },
            { "rhg", "Rohínjia" },
            { "rof", "Rómbo" },
            { "rup", "Arómánian" },
            { "rwk", "Rwá" },
            { "sad", "Sandáwẹ́ Lángwej" },
            { "sah", "Sakhá" },
            { "saq", "Sambúru" },
            { "sat", "Sántáli" },
            { "sba", "Ngambai Lángwej" },
            { "sbp", "Sangu" },
            { "scn", "Sisílián Lángwej" },
            { "sco", "Skọ́t Lángwej" },
            { "seh", "Sẹ́ná" },
            { "ses", "Kóiraboró Sẹ́nní Lángwej" },
            { "shi", "Táchẹ́lit" },
            { "shn", "Shán Lángwej" },
            { "slh", "Saútan Lushútsid" },
            { "smn", "Ínárí Sámí Lángwej" },
            { "sms", "Skolt Sámí Lángwej" },
            { "snk", "Sonínkẹ́ Lángwej" },
            { "srn", "Sranán Tóngo" },
            { "str", "Streti Salísh Lángwej" },
            { "suk", "Sukúma Lángwej" },
            { "swb", "Komória Lángwej" },
            { "syr", metaValue_syr },
            { "szl", "Silesián Lángwej" },
            { "tce", "Saútán Tutchónẹ Lángwej" },
            { "tem", "Tímnẹ Lángwej" },
            { "teo", "Tẹ́so" },
            { "tet", "Tẹ́tum Lángwej" },
            { "tgx", "Tágísh Lángwej" },
            { "tht", "Tahltán Lángwej" },
            { "tig", "Tígrẹ Lángwej" },
            { "tlh", "Klíngon" },
            { "tli", "Tlingit Lángwej" },
            { "tok", "Tongán Lángwej" },
            { "tpi", "Tọk Písin" },
            { "trv", "Tarókó Lángwej" },
            { "ttm", "Nótán Tuchónẹ Lángwej" },
            { "tum", "Tumbúka Lángwej" },
            { "tvl", "Tuválu Lángwej" },
            { "twq", "Tasawak" },
            { "tyv", "Tuvínián Lángwej" },
            { "tzm", "Mídúl Atlás Támazígt Lángwej" },
            { "udm", "Údmurt Lángwej" },
            { "umb", "Umbúndu Lángwej" },
            { "und", "Lángwej wé nóbọ́di sabi" },
            { "vai", "Vaí" },
            { "vec", "Venetián Lángwej" },
            { "vmw", "Mákhuwá Lángwej" },
            { "vun", "Vúnjo" },
            { "wae", "Wọ́lsa" },
            { "wal", "Wolaítá Lángwej" },
            { "war", "Warai Lángwej" },
            { "wuu", "Wu Chainiz" },
            { "xal", "Kalmik" },
            { "xnr", "Kangri Lángwej" },
            { "xog", "sóga" },
            { "yav", "Yangbẹn" },
            { "ybb", "Yẹmba Lángwej" },
            { "yrl", "Nhiingátu Lángwej" },
            { "yue", "Kántọn Lángwej" },
            { "zgh", "Gẹ́nárál Morókó Támazígt Lángwej" },
            { "zun", "Zúní Lángwej" },
            { "zxx", "Nó Lángwéj Kọ́ntẹnt" },
            { "zza", "Zázá Lángwej" },
            { "Adlm", "Ádlam" },
            { "Arab", "Arábík" },
            { "Aran", "Aran Lángwej" },
            { "Armn", "Armẹ́nia" },
            { "Beng", "Bángla" },
            { "Bopo", "Bopomófo" },
            { "Brai", "Blaínd Pípol Raítín Sístẹm" },
            { "Cakm", "Chákmá Lángwej" },
            { "Cans", "Nétív Kánádá Pípul Sílebul-dẹm Wé Dẹm Jọín Togẹ́da" },
            { "Cher", "Chíróki Lángwej" },
            { "Cyrl", "Sírílik" },
            { "Deva", "Dẹvanágári" },
            { "Ethi", "Ẹtiópik" },
            { "Geor", metaValue_GE },
            { "Grek", "Grík" },
            { "Gujr", "Gujaráti" },
            { "Guru", "Gúrmukhi" },
            { "Hanb", "Han Wit Bopomófo" },
            { "Hang", "Hángul" },
            { "Hani", "Chainiz" },
            { "Hans", "Ízí Chainíz Lángwej" },
            { "Hant", "Nọ́mal" },
            { "Hebr", "Híbrú" },
            { "Hira", "Hiagána" },
            { "Hrkt", "Pát ọf Japán Raítín Sístẹm" },
            { "Jamo", "Jámo" },
            { "Jpan", "Japan" },
            { "Kana", "Katákána" },
            { "Khmr", "Kemẹẹ" },
            { "Knda", "Kánnad Raítín Sístẹm" },
            { "Kore", "Koria" },
            { "Laoo", "Láo" },
            { "Latn", "Látin" },
            { "Mlym", "Maléyálam" },
            { "Mong", metaValue_MN },
            { "Mtei", "Mẹitẹí Mayẹk Lángwej" },
            { "Mymr", "Miánmar" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chíkí" },
            { "Orya", "Ódia" },
            { "Rohg", "Hanífi Lángwej" },
            { "Sinh", "Sinhála" },
            { "Sund", "Súndaníz Lángwej" },
            { "Syrc", metaValue_syr },
            { "Taml", "Támil" },
            { "Telu", "Tẹ́lúgu" },
            { "Tfng", "Tífínag Lángwej" },
            { "Thaa", "Tána" },
            { "Thai", metaValue_th },
            { "Tibt", "Tíbẹt" },
            { "Vaii", "Vaí Lángwej" },
            { "Yiii", "Yi Lángwej" },
            { "Zmth", "Matimátiks Sains" },
            { "Zsye", "Ẹ́móji" },
            { "Zsym", "Símbuls" },
            { "Zxxx", "Wétín Dẹm Nó Rait" },
            { "Zyyy", "Jẹ́náral" },
            { "Zzzz", "Raítín Sístẹm Wé Nóbọ́di Sabí" },
            { "de_AT", "Ọ́stria Jámán" },
            { "de_CH", "Swítzaland Haí Jámán" },
            { "en_AU", "Ọstréliá Ínglish" },
            { "en_CA", "Kánáda Ínglish" },
            { "en_GB", "Brítísh Ínglish" },
            { "en_US", "Amẹ́ríka Ínglish" },
            { "es_ES", "Yúrop Spánish" },
            { "es_MX", "Mẹ́ksiko Spánish" },
            { "fa_AF", "Dári" },
            { "fr_CA", "Kánádá Frẹnch" },
            { "fr_CH", "Swízalánd Frẹnch" },
            { "nl_BE", "Flẹ́mish Lángwej" },
            { "pt_BR", "Brazíl Pọtiugíz" },
            { "pt_PT", "Yúróp Pọtiugíz" },
            { "es_419", "Látín Amẹ́ríka Spánish" },
            { "key.ca", "Kalẹ́nda" },
            { "key.cf", "Haú To Arénj Mọní" },
            { "key.co", "Arénj Tins Wẹl" },
            { "key.cu", "Mọní" },
            { "key.em", "Imọ́ji presentáshọn" },
            { "key.hc", "Awá Saíkul (12 vs 24)" },
            { "key.lb", "Laín Brẹk Staíl" },
            { "key.lw", "Laín Brẹks wídin wọds" },
            { "key.ms", "Sístẹm fọ Mẹ́zhọ́mẹnt" },
            { "key.nu", "Nọ́mba-dẹm" },
            { "key.ss", "Sẹntẹns Brẹk Aftá Abbr" },
            { "hi_Latn", "Híndi (Látin)" },
            { "type.ca.roc", "Ripọ́blík ọf Chaíná Kalẹ́nda" },
            { "type.hc.h11", "12 Áwa Sístẹm (0–11)" },
            { "type.hc.h12", "12 Áwa Sístẹm (1–12)" },
            { "type.hc.h23", "24 Áwa Sístẹm (0–23)" },
            { "type.hc.h24", "24 Áwa Sístẹm (1–24)" },
            { "type.nu.arab", "Arábík Nọ́mba-dẹm" },
            { "type.nu.armn", "Armẹ́niá Nọ́mba-dẹm" },
            { "type.nu.beng", "Bánglá Nọ́mba-dẹm" },
            { "type.nu.cakm", "Chakmá Nọ́mba-dẹm" },
            { "type.nu.deva", "Dẹvanágári Nọ́mba-dẹm" },
            { "type.nu.ethi", "Ẹtiópiá Nọ́mba-dẹm" },
            { "type.nu.geor", "Jọ́jiá Nọ́mba-dẹm" },
            { "type.nu.grek", "Grík Nọ́mba-dẹm" },
            { "type.nu.gujr", "Gujarátí Nọ́mba-dẹm" },
            { "type.nu.guru", "Gúrmukhi Nọ́mba-dẹm" },
            { "type.nu.hans", "Ízí Chainíz Nọ́mba-dẹm" },
            { "type.nu.hant", "Nọ́mál Chainíz Nọ́mba-dẹm" },
            { "type.nu.hebr", "Híbru Nọ́mba-dẹm" },
            { "type.nu.java", "Jává Nọ́mba-dẹm" },
            { "type.nu.jpan", "Japán Nọ́mba-dẹm" },
            { "type.nu.khmr", "Kmai Nọ́mba-dẹm" },
            { "type.nu.knda", "Kánnád Nọ́mba-dẹm" },
            { "type.nu.laoo", "Lao Nọ́mba-dẹm" },
            { "type.nu.latn", "Wẹ́stán Nọ́mba-dẹm" },
            { "type.nu.mlym", "Maléyálam Nọ́mba-dẹm" },
            { "type.nu.mtei", "Miitẹí Mayẹ́k Nọ́mba-dẹm" },
            { "type.nu.mymr", "Miánma Nọ́mba-dẹm" },
            { "type.nu.olck", "Ol Chiki Nọ́mba-dẹm" },
            { "type.nu.orya", "Ódia Nọ́mba-dẹm" },
            { "type.nu.taml", "Nọ́mál Támíl Nọ́mba-dẹm" },
            { "type.nu.telu", "Tẹ́lúgu Nọ́mba-dẹm" },
            { "type.nu.thai", "Taí Nọ́mba-dẹm" },
            { "type.nu.tibt", "Tíbẹt Nọ́mba-dẹm" },
            { "type.nu.vaii", "Vaí Nọ́mba-dẹm" },
            { "type.ca.dangi", "Dangi Kalẹ́nda" },
            { "type.co.ducet", "Yúníkód Mén Wè To Arénj Tins Wẹl" },
            { "type.lb.loose", "Lúz Laín Brẹk Staíl" },
            { "type.nu.roman", "Rómán Nọ́mba-dẹm" },
            { "type.ca.coptic", "Kọ́ptík Kalẹ́nda" },
            { "type.ca.hebrew", "Híbrú Kalẹ́nda" },
            { "type.co.search", "Jẹ́nárál Sachin" },
            { "type.lb.normal", "Nọ́mál Laín Brẹk Staíl" },
            { "type.lb.strict", "Fíksd Laín Brẹk Staíl" },
            { "type.ms.metric", "Mẹ́trík Sístẹm" },
            { "type.ca.chinese", "Chaíníz Kalẹ́nda" },
            { "type.ca.islamic", "Íslám Kalẹ́nda" },
            { "type.ca.iso8601", "ISO-8601 Kalẹ́nda" },
            { "type.ca.persian", "Pẹ́shia Kalẹ́nda" },
            { "type.cf.account", "Akáunt To Ték Arénj Mọní" },
            { "type.nu.arabext", "Ẹstrá Arábík Nọ́mba-dẹm" },
            { "type.nu.armnlow", "Smọ́l Taíp Armẹ́niá Nọ́mba-dẹm" },
            { "type.nu.greklow", "Smọ́l Taíp Grík Nọ́mba-dẹm" },
            { "type.nu.hanidec", "Chainíz Nọ́mba-dẹm" },
            { "type.nu.hansfin", "Ízí Chainíz Mọní Nọ́mba-dẹm" },
            { "type.nu.hantfin", "Nọ́mál Chainíz Mọní Nọ́mba-dẹm" },
            { "type.nu.jpanfin", "Japán Mọní Nọ́mba-dẹm" },
            { "type.nu.tamldec", "Támíl Nọ́mba-dẹm" },
            { "type.ca.buddhist", "Búdíst Kalẹ́nda" },
            { "type.ca.ethiopic", "Ẹtiópiá Kalẹ́nda" },
            { "type.ca.japanese", "Japán Kalẹ́nda" },
            { "type.cf.standard", "Nọ́mál Wè To Arénj Mọní" },
            { "type.co.standard", "Nọ́mál Wè To Arénj Tins Wẹl" },
            { "type.ms.uksystem", "Impẹ́riál Sístẹm fọ Mẹ́zhọ́mẹnt" },
            { "type.ms.ussystem", "US Sístẹm fọ Mẹ́zhọ́mẹnt" },
            { "type.nu.fullwide", "Fúl-Waid Nọ́mba-dẹm" },
            { "type.nu.romanlow", "Smọ́l Taíp Rómán Nọ́mba-dẹm" },
            { "type.ca.gregorian", "Grẹ́górí Kalẹ́nda" },
            { "type.ca.islamic-civil", "Íslám Kalẹ́nda (Tébúlá Taip an Sívúl Taip)" },
            { "type.ca.islamic-umalqura", "Íslám Kalẹ́nda (Úmm al-Kúrá)" },
            { "type.ca.ethiopic-amete-alem", "Ẹtiópiá Amẹtẹ́ Álẹ́m Kalénda" },
        };
        return data;
    }
}
