//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// This operation will fetch changes to record zones within a database
    ///
    ///
    /// If a change anchor from a previous
    /// `CKFetchDatabaseChangesOperation`is passed in, only the zones that have changed since that anchor will be returned.
    /// This per-database
    /// `serverChangeToken`is not to be confused with the per-recordZone
    /// `serverChangeToken`from
    /// `CKFetchRecordZoneChangesOperation.`If this is your first fetch or if you wish to re-fetch all zones, pass nil for the change token.
    /// Change token are opaque tokens and clients should not infer any behavior based on their content.
    /// `CKFetchDatabaseChangesOperation`is supported in a
    /// `privateCloudDatabase`and
    /// `sharedCloudDatabase`
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckfetchdatabasechangesoperation?language=objc)
    #[unsafe(super(CKDatabaseOperation, CKOperation, NSOperation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
    pub struct CKFetchDatabaseChangesOperation;
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for CKFetchDatabaseChangesOperation {}
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKFetchDatabaseChangesOperation {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "CKServerChangeToken")]
        #[unsafe(method(initWithPreviousServerChangeToken:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPreviousServerChangeToken(
            this: Allocated<Self>,
            previous_server_change_token: Option<&CKServerChangeToken>,
        ) -> Retained<Self>;

        #[cfg(feature = "CKServerChangeToken")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(previousServerChangeToken))]
        #[unsafe(method_family = none)]
        pub unsafe fn previousServerChangeToken(&self) -> Option<Retained<CKServerChangeToken>>;

        #[cfg(feature = "CKServerChangeToken")]
        /// Setter for [`previousServerChangeToken`][Self::previousServerChangeToken].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setPreviousServerChangeToken:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviousServerChangeToken(
            &self,
            previous_server_change_token: Option<&CKServerChangeToken>,
        );

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(resultsLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn resultsLimit(&self) -> NSUInteger;

        /// Setter for [`resultsLimit`][Self::resultsLimit].
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setResultsLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResultsLimit(&self, results_limit: NSUInteger);

        /// When set to YES, this operation will send repeated requests to the server until all record zone changes have been fetched.
        ///
        /// `changeTokenUpdatedBlock`will be invoked periodically, to give clients an updated change token so that already-fetched record zone changes don't need to be re-fetched on a subsequent operation.
        /// When set to NO, it is the responsibility of the caller to issue subsequent fetch-changes operations when moreComing is YES in a
        /// `fetchDatabaseChangesCompletionBlock`invocation.
        /// `fetchAllChanges`is
        /// `YES`by default
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations
        /// Blocks assigned to this operation may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(fetchAllChanges))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllChanges(&self) -> bool;

        /// Setter for [`fetchAllChanges`][Self::fetchAllChanges].
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setFetchAllChanges:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFetchAllChanges(&self, fetch_all_changes: bool);

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneWithIDChangedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneWithIDChangedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>;

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Setter for [`recordZoneWithIDChangedBlock`][Self::recordZoneWithIDChangedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneWithIDChangedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneWithIDChangedBlock(
            &self,
            record_zone_with_id_changed_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>,
            >,
        );

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneWithIDWasDeletedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneWithIDWasDeletedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>;

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Setter for [`recordZoneWithIDWasDeletedBlock`][Self::recordZoneWithIDWasDeletedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneWithIDWasDeletedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneWithIDWasDeletedBlock(
            &self,
            record_zone_with_id_was_deleted_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>,
            >,
        );

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// If this block is set it will be called instead of
        /// `recordZoneWithIDWasDeletedBlock`if the user deleted this zone via the iCloud storage UI.
        ///
        ///
        /// This is an indication that the user wanted all data deleted, so local cached data should be wiped and not re-uploaded to the server.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneWithIDWasPurgedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneWithIDWasPurgedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>;

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Setter for [`recordZoneWithIDWasPurgedBlock`][Self::recordZoneWithIDWasPurgedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneWithIDWasPurgedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneWithIDWasPurgedBlock(
            &self,
            record_zone_with_id_was_purged_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>,
            >,
        );

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// If this block is set it will be called instead of
        /// `recordZoneWithIDWasDeletedBlock`if the user chose to reset all encrypted data for their account.
        ///
        ///
        /// This is an indication that the user had to reset encrypted data during account recovery, so local cached data should be re-uploaded to the server to minimize data loss.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>;

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// Setter for [`recordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock`][Self::recordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneWithIDWasDeletedDueToUserEncryptedDataResetBlock(
            &self,
            record_zone_with_id_was_deleted_due_to_user_encrypted_data_reset_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordZoneID>)>,
            >,
        );

        #[cfg(all(feature = "CKServerChangeToken", feature = "block2"))]
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(changeTokenUpdatedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeTokenUpdatedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKServerChangeToken>)>;

        #[cfg(all(feature = "CKServerChangeToken", feature = "block2"))]
        /// Setter for [`changeTokenUpdatedBlock`][Self::changeTokenUpdatedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setChangeTokenUpdatedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setChangeTokenUpdatedBlock(
            &self,
            change_token_updated_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKServerChangeToken>)>,
            >,
        );

        #[cfg(all(feature = "CKServerChangeToken", feature = "block2"))]
        /// This block is called when the operation completes.
        ///
        ///
        /// Clients are responsible for saving the change token at the end of the operation and passing it in to the next call to
        /// `CKFetchDatabaseChangesOperation.`If the server returns a
        /// `CKErrorChangeTokenExpired`error, the
        /// `previousServerChangeToken`value was too old and the client should toss its local cache and re-fetch the changes in this record zone starting with a nil
        /// `previousServerChangeToken.`If
        /// `moreComing`is true then the server wasn't able to return all the changes in this response. Another
        /// `CKFetchDatabaseChangesOperation`operation should be run with the
        /// `previousServerChangeToken`token from this operation.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(fetchDatabaseChangesCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchDatabaseChangesCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut CKServerChangeToken, Bool, *mut NSError)>;

        #[cfg(all(feature = "CKServerChangeToken", feature = "block2"))]
        /// Setter for [`fetchDatabaseChangesCompletionBlock`][Self::fetchDatabaseChangesCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setFetchDatabaseChangesCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFetchDatabaseChangesCompletionBlock(
            &self,
            fetch_database_changes_completion_block: Option<
                &block2::DynBlock<dyn Fn(*mut CKServerChangeToken, Bool, *mut NSError)>,
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKFetchDatabaseChangesOperation {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
