#include <osgVolume/Property>
#include <osgDB/ObjectWrapper>
#include <osgDB/InputStream>
#include <osgDB/OutputStream>

static bool checkProperties( const osgVolume::CompositeProperty& prop )
{
    return prop.getNumProperties()>0;
}

static bool readProperties( osgDB::InputStream& is, osgVolume::CompositeProperty& prop )
{
    unsigned int size = 0; is >> size >> is.BEGIN_BRACKET;
    for ( unsigned int i=0; i<size; ++i )
    {
        osg::ref_ptr<osgVolume::Property> child = is.readObjectOfType<osgVolume::Property>();
        if ( child ) prop.addProperty( child );
    }
    is >> is.END_BRACKET;
    return true;
}

static bool writeProperties( osgDB::OutputStream& os, const osgVolume::CompositeProperty& prop )
{
    unsigned int size = prop.getNumProperties();
    os << size << os.BEGIN_BRACKET << osgDB::OutputStream::Endl{};
    for ( unsigned int i=0; i<size; ++i )
    {
        os << prop.getProperty(i);
    }
    os << os.END_BRACKET << osgDB::OutputStream::Endl{};
    return true;
}

REGISTER_OBJECT_WRAPPER( osgVolume_CompositeProperty,
                         new osgVolume::CompositeProperty,
                         osgVolume::CompositeProperty,
                         "osg::Object osgVolume::Property osgVolume::CompositeProperty" )
{
    ADD_USER_SERIALIZER( Properties );  // _properties
}
