/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;

public class HoldButton
extends JButton {
    private static final long DEFAULT_REPEAT_INTERVAL = 50L;
    private static final long serialVersionUID = 7176946053407595449L;
    private final ArrayList<HoldListener> callbacks = new ArrayList();
    private final Timer timer = new Timer();
    private int clickssofar = 0;
    volatile boolean running = false;
    private TimerTask task = null;
    private final long repeat_interval;

    public HoldButton(String string) {
        this(50L, string);
    }

    public void doHold() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.running) {
            return;
        }
        this.running = true;
        this.clickssofar = 0;
        this.task = new TimerTask(){

            @Override
            public void run() {
                HoldButton.this.clickssofar++;
                HoldButton.this.notifyHoldListeners(HoldButton.this.clickssofar);
            }
        };
        this.timer.scheduleAtFixedRate(this.task, 0L, this.repeat_interval);
    }

    public void doRelease() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.running = false;
    }

    public HoldButton(long l, String string) {
        super(string);
        this.repeat_interval = l;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                HoldButton.this.doRelease();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HoldButton.this.doHold();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HoldButton.this.notifyHoldListeners(1);
            }
        });
    }

    private void notifyHoldListeners(int n) {
        for (HoldListener holdListener : this.callbacks) {
            holdListener.onHold(n);
        }
    }

    public void addHoldListener(HoldListener holdListener) {
        if (!this.callbacks.contains(holdListener)) {
            this.callbacks.add(holdListener);
        }
    }

    public void removeHoldListener(HoldListener holdListener) {
        this.callbacks.remove(holdListener);
    }

    public static interface HoldListener {
        public void onHold(int var1);
    }
}

